/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.slicer;

import com.intellij.analysis.AnalysisScope;
import com.intellij.codeInspection.dataFlow.types.DfTypes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.impl.source.DummyHolder;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.util.PsiUtil;
import com.intellij.slicer.JavaSliceUsage;
import com.intellij.slicer.JavaValueFilter;
import com.intellij.slicer.SliceAnalysisParams;
import com.intellij.slicer.SliceUsage;
import com.intellij.slicer.SliceValueFilter;
import com.intellij.util.Processor;
import gnu.trove.THashMap;
import java.util.Map;
import java.util.function.UnaryOperator;
import org.intellij.lang.annotations.Flow;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Range;

final class JavaSliceBuilder {
    @NotNull
    private final SliceUsage myParent;
    @NotNull
    private final PsiSubstitutor mySubstitutor;
    private final @Range(from=0L, to=0x7FFFFFFFL) int myIndexNesting;
    @NotNull
    private final String mySyntheticField;
    @NotNull
    private final JavaValueFilter myFilter;

    private JavaSliceBuilder(@NotNull SliceUsage parent, @NotNull PsiSubstitutor substitutor, @Range(from=0L, to=0x7FFFFFFFL) int indexNesting, @NotNull String syntheticField, @Nullable SliceValueFilter filter) {
        if (parent == null) {
            JavaSliceBuilder.$$$reportNull$$$0(0);
        }
        if (substitutor == null) {
            JavaSliceBuilder.$$$reportNull$$$0(1);
        }
        if (syntheticField == null) {
            JavaSliceBuilder.$$$reportNull$$$0(2);
        }
        assert (indexNesting >= 0) : indexNesting;
        this.myParent = parent;
        this.mySubstitutor = substitutor;
        this.myIndexNesting = indexNesting;
        this.mySyntheticField = syntheticField;
        this.myFilter = filter instanceof JavaValueFilter ? (JavaValueFilter)filter : JavaValueFilter.ALLOW_EVERYTHING;
    }

    @Contract(pure=true)
    @NotNull
    JavaSliceBuilder withSubstitutor(@NotNull PsiSubstitutor substitutor) {
        if (substitutor == null) {
            JavaSliceBuilder.$$$reportNull$$$0(3);
        }
        return new JavaSliceBuilder(this.myParent, substitutor, this.myIndexNesting, this.mySyntheticField, this.myFilter);
    }

    @Contract(pure=true)
    @NotNull
    JavaSliceBuilder withSyntheticField(@NotNull String syntheticField) {
        if (syntheticField == null) {
            JavaSliceBuilder.$$$reportNull$$$0(4);
        }
        if (syntheticField.equals(this.mySyntheticField)) {
            JavaSliceBuilder javaSliceBuilder = this;
            if (javaSliceBuilder == null) {
                JavaSliceBuilder.$$$reportNull$$$0(5);
            }
            return javaSliceBuilder;
        }
        return new JavaSliceBuilder(this.myParent, this.mySubstitutor, this.myIndexNesting, syntheticField, this.myFilter);
    }

    @Contract(pure=true)
    @NotNull
    JavaSliceBuilder dropSyntheticField() {
        JavaSliceBuilder javaSliceBuilder = this.withSyntheticField("");
        if (javaSliceBuilder == null) {
            JavaSliceBuilder.$$$reportNull$$$0(6);
        }
        return javaSliceBuilder;
    }

    @Contract(pure=true)
    @NotNull
    JavaSliceBuilder dropNesting() {
        if (this.myIndexNesting == 0) {
            JavaSliceBuilder javaSliceBuilder = this;
            if (javaSliceBuilder == null) {
                JavaSliceBuilder.$$$reportNull$$$0(7);
            }
            return javaSliceBuilder;
        }
        return new JavaSliceBuilder(this.myParent, this.mySubstitutor, 0, this.mySyntheticField, this.myFilter.withType(DfTypes.TOP));
    }

    boolean process(PsiElement element, Processor<? super SliceUsage> processor2) {
        PsiElement realExpression;
        PsiElement psiElement = realExpression = element.getParent() instanceof DummyHolder ? element.getParent().getContext() : element;
        assert (realExpression != null);
        if (!(realExpression instanceof PsiCompiledElement)) {
            JavaValueFilter filter = this.myFilter.mergeFilter(realExpression);
            SliceAnalysisParams params = this.myParent.params;
            if (filter != params.valueFilter) {
                params = new SliceAnalysisParams(params);
                params.valueFilter = filter;
            }
            return processor2.process((Object)new JavaSliceUsage(realExpression, this.myParent, params, this.mySubstitutor, this.myIndexNesting, this.mySyntheticField));
        }
        return true;
    }

    @Contract(pure=true)
    @NotNull
    JavaSliceBuilder updateNesting(@NotNull Flow anno) {
        if (anno == null) {
            JavaSliceBuilder.$$$reportNull$$$0(8);
        }
        if (anno.targetIsContainer() && anno.sourceIsContainer()) {
            return new JavaSliceBuilder(this.myParent, this.mySubstitutor, this.myIndexNesting, this.mySyntheticField, this.myFilter.unwrap().wrap());
        }
        if (anno.targetIsContainer()) {
            JavaSliceBuilder javaSliceBuilder = this.decrementNesting();
            if (javaSliceBuilder == null) {
                JavaSliceBuilder.$$$reportNull$$$0(9);
            }
            return javaSliceBuilder;
        }
        if (anno.sourceIsContainer()) {
            JavaSliceBuilder javaSliceBuilder = this.incrementNesting();
            if (javaSliceBuilder == null) {
                JavaSliceBuilder.$$$reportNull$$$0(10);
            }
            return javaSliceBuilder;
        }
        JavaSliceBuilder javaSliceBuilder = this;
        if (javaSliceBuilder == null) {
            JavaSliceBuilder.$$$reportNull$$$0(11);
        }
        return javaSliceBuilder;
    }

    @Contract(pure=true)
    @NotNull
    JavaSliceBuilder withFilter(UnaryOperator<JavaValueFilter> filterTransformer) {
        JavaValueFilter filter = (JavaValueFilter)filterTransformer.apply(this.myFilter);
        if (filter == this.myFilter) {
            JavaSliceBuilder javaSliceBuilder = this;
            if (javaSliceBuilder == null) {
                JavaSliceBuilder.$$$reportNull$$$0(12);
            }
            return javaSliceBuilder;
        }
        return new JavaSliceBuilder(this.myParent, this.mySubstitutor, this.myIndexNesting, this.mySyntheticField, filter);
    }

    @NotNull
    SearchScope getSearchScope() {
        AnalysisScope scope = this.myParent.getScope();
        SearchScope searchScope = this.myFilter.correctScope(scope.toSearchScope());
        if (searchScope == null) {
            JavaSliceBuilder.$$$reportNull$$$0(13);
        }
        return searchScope;
    }

    @Contract(pure=true)
    @NotNull
    JavaSliceBuilder incrementNesting() {
        return new JavaSliceBuilder(this.myParent, this.mySubstitutor, this.myIndexNesting + 1, this.mySyntheticField, this.myFilter.wrap());
    }

    @Contract(pure=true)
    @NotNull
    JavaSliceBuilder decrementNesting() {
        return new JavaSliceBuilder(this.myParent, this.mySubstitutor, this.myIndexNesting - 1, this.mySyntheticField, this.myFilter.unwrap());
    }

    boolean hasNesting() {
        return this.myIndexNesting > 0;
    }

    @Contract(pure=true)
    @NotNull
    SliceUsage getParent() {
        SliceUsage sliceUsage = this.myParent;
        if (sliceUsage == null) {
            JavaSliceBuilder.$$$reportNull$$$0(14);
        }
        return sliceUsage;
    }

    @Contract(pure=true)
    @NotNull
    PsiSubstitutor getSubstitutor() {
        PsiSubstitutor psiSubstitutor = this.mySubstitutor;
        if (psiSubstitutor == null) {
            JavaSliceBuilder.$$$reportNull$$$0(15);
        }
        return psiSubstitutor;
    }

    @Contract(pure=true)
    PsiType substitute(@Nullable PsiType type2) {
        return this.mySubstitutor.substitute(type2);
    }

    @Contract(pure=true)
    @NotNull
    String getSyntheticField() {
        String string = this.mySyntheticField;
        if (string == null) {
            JavaSliceBuilder.$$$reportNull$$$0(16);
        }
        return string;
    }

    @Contract(pure=true)
    @NotNull
    JavaValueFilter getFilter() {
        JavaValueFilter javaValueFilter = this.myFilter;
        if (javaValueFilter == null) {
            JavaSliceBuilder.$$$reportNull$$$0(17);
        }
        return javaValueFilter;
    }

    @Contract(pure=true)
    @NotNull
    static JavaSliceBuilder create(@NotNull SliceUsage parent) {
        if (parent == null) {
            JavaSliceBuilder.$$$reportNull$$$0(18);
        }
        SliceValueFilter filter = parent.params.valueFilter;
        if (parent instanceof JavaSliceUsage) {
            JavaSliceUsage javaParent = (JavaSliceUsage)parent;
            return new JavaSliceBuilder(parent, javaParent.getSubstitutor(), javaParent.indexNesting, javaParent.syntheticField, filter);
        }
        return new JavaSliceBuilder(parent, PsiSubstitutor.EMPTY, 0, "", filter);
    }

    @Nullable
    JavaSliceBuilder combineSubstitutor(@NotNull PsiSubstitutor substitutor, @NotNull Project project) {
        if (substitutor == null) {
            JavaSliceBuilder.$$$reportNull$$$0(19);
        }
        if (project == null) {
            JavaSliceBuilder.$$$reportNull$$$0(20);
        }
        PsiSubstitutor parentSubstitutor = this.mySubstitutor;
        THashMap newMap = new THashMap(substitutor.getSubstitutionMap());
        for (Map.Entry entry : substitutor.getSubstitutionMap().entrySet()) {
            PsiTypeParameter typeParameter = (PsiTypeParameter)entry.getKey();
            PsiType type2 = (PsiType)entry.getValue();
            PsiClass resolved = PsiUtil.resolveClassInType((PsiType)type2);
            if (!parentSubstitutor.getSubstitutionMap().containsKey(typeParameter)) continue;
            PsiType parentType = parentSubstitutor.substitute(parentSubstitutor.substitute(typeParameter));
            if (resolved instanceof PsiTypeParameter) {
                PsiTypeParameter res = (PsiTypeParameter)resolved;
                newMap.put(res, parentType);
                continue;
            }
            if (Comparing.equal((Object)type2, (Object)parentType)) continue;
            return null;
        }
        PsiSubstitutor combined = JavaPsiFacade.getElementFactory((Project)project).createSubstitutor((Map)newMap);
        return this.withSubstitutor(combined);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 1: 
            case 3: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "substitutor";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "syntheticField";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/slicer/JavaSliceBuilder";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "anno";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/slicer/JavaSliceBuilder";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "withSyntheticField";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "dropSyntheticField";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "dropNesting";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "updateNesting";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "withFilter";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getSearchScope";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getParent";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getSubstitutor";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getSyntheticField";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getFilter";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "withSubstitutor";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "withSyntheticField";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "updateNesting";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "create";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "combineSubstitutor";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

