/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.util;

import com.intellij.java.refactoring.JavaRefactoringBundle;
import com.intellij.lang.findUsages.DescriptiveNameUtil;
import com.intellij.psi.ElementDescriptionLocation;
import com.intellij.psi.ElementDescriptionProvider;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassInitializer;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiForeachStatement;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.util.PsiFormatUtil;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.refactoring.util.RefactoringDescriptionLocation;
import org.jetbrains.annotations.NotNull;

public class JavaRefactoringElementDescriptionProvider
implements ElementDescriptionProvider {
    public String getElementDescription(@NotNull PsiElement element, @NotNull ElementDescriptionLocation location) {
        if (element == null) {
            JavaRefactoringElementDescriptionProvider.$$$reportNull$$$0(0);
        }
        if (location == null) {
            JavaRefactoringElementDescriptionProvider.$$$reportNull$$$0(1);
        }
        if (!(location instanceof RefactoringDescriptionLocation)) {
            return null;
        }
        RefactoringDescriptionLocation rdLocation = (RefactoringDescriptionLocation)location;
        if (element instanceof PsiField) {
            int options = 1;
            if (rdLocation.includeParent()) {
                options |= 0x1000;
            }
            return JavaRefactoringBundle.message((String)"field.description", (Object[])new Object[]{CommonRefactoringUtil.htmlEmphasize((String)PsiFormatUtil.formatVariable((PsiVariable)((PsiVariable)element), (int)options, (PsiSubstitutor)PsiSubstitutor.EMPTY))});
        }
        if (element instanceof PsiMethod) {
            PsiMethod method;
            int options = 257;
            if (rdLocation.includeParent()) {
                options |= 0x1000;
            }
            return (method = (PsiMethod)element).isConstructor() ? JavaRefactoringBundle.message((String)"constructor.description", (Object[])new Object[]{CommonRefactoringUtil.htmlEmphasize((String)PsiFormatUtil.formatMethod((PsiMethod)method, (PsiSubstitutor)PsiSubstitutor.EMPTY, (int)options, (int)2))}) : JavaRefactoringBundle.message((String)"method.description", (Object[])new Object[]{CommonRefactoringUtil.htmlEmphasize((String)PsiFormatUtil.formatMethod((PsiMethod)method, (PsiSubstitutor)PsiSubstitutor.EMPTY, (int)options, (int)2))});
        }
        if (element instanceof PsiClassInitializer) {
            PsiClassInitializer initializer = (PsiClassInitializer)element;
            boolean isStatic = initializer.hasModifierProperty("static");
            return isStatic ? JavaRefactoringBundle.message((String)"static.initializer.description", (Object[])new Object[]{this.getElementDescription((PsiElement)initializer.getContainingClass(), (ElementDescriptionLocation)RefactoringDescriptionLocation.WITHOUT_PARENT)}) : JavaRefactoringBundle.message((String)"instance.initializer.description", (Object[])new Object[]{this.getElementDescription((PsiElement)initializer.getContainingClass(), (ElementDescriptionLocation)RefactoringDescriptionLocation.WITHOUT_PARENT)});
        }
        if (element instanceof PsiParameter) {
            if (((PsiParameter)element).getDeclarationScope() instanceof PsiForeachStatement) {
                return JavaRefactoringBundle.message((String)"local.variable.description", (Object[])new Object[]{CommonRefactoringUtil.htmlEmphasize((String)((PsiVariable)element).getName())});
            }
            return JavaRefactoringBundle.message((String)"parameter.description", (Object[])new Object[]{CommonRefactoringUtil.htmlEmphasize((String)((PsiParameter)element).getName())});
        }
        if (element instanceof PsiLocalVariable) {
            return JavaRefactoringBundle.message((String)"local.variable.description", (Object[])new Object[]{CommonRefactoringUtil.htmlEmphasize((String)((PsiVariable)element).getName())});
        }
        if (element instanceof PsiPackage) {
            return JavaRefactoringBundle.message((String)"package.description", (Object[])new Object[]{CommonRefactoringUtil.htmlEmphasize((String)((PsiPackage)element).getName())});
        }
        if (element instanceof PsiClass) {
            PsiClass psiClass = (PsiClass)element;
            if (psiClass.isInterface()) {
                return JavaRefactoringBundle.message((String)"interface.description", (Object[])new Object[]{CommonRefactoringUtil.htmlEmphasize((String)DescriptiveNameUtil.getDescriptiveName((PsiElement)psiClass))});
            }
            if (psiClass.isEnum()) {
                return JavaRefactoringBundle.message((String)"enum.description", (Object[])new Object[]{CommonRefactoringUtil.htmlEmphasize((String)DescriptiveNameUtil.getDescriptiveName((PsiElement)psiClass))});
            }
            return JavaRefactoringBundle.message((String)"class.description", (Object[])new Object[]{CommonRefactoringUtil.htmlEmphasize((String)DescriptiveNameUtil.getDescriptiveName((PsiElement)psiClass))});
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "element";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "location";
                break;
            }
        }
        objectArray[1] = "com/intellij/refactoring/util/JavaRefactoringElementDescriptionProvider";
        objectArray[2] = "getElementDescription";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

