/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.typeMigration;

import com.intellij.codeInsight.generation.GetterSetterPrototypeProvider;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.GenericsUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaRecursiveElementVisitor;
import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.NavigatablePsiElement;
import com.intellij.psi.PsiArrayAccessExpression;
import com.intellij.psi.PsiArrayInitializerExpression;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiEllipsisType;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiForeachStatement;
import com.intellij.psi.PsiIfStatement;
import com.intellij.psi.PsiInstanceOfExpression;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiPolyadicExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiSwitchLabelStatement;
import com.intellij.psi.PsiSwitchStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeCastExpression;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiUnaryExpression;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.PsiWildcardType;
import com.intellij.psi.controlFlow.DefUseUtil;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PropertyUtilBase;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.refactoring.typeMigration.TypeConversionDescriptorBase;
import com.intellij.refactoring.typeMigration.TypeEvaluator;
import com.intellij.refactoring.typeMigration.TypeMigrationLabeler;
import com.intellij.refactoring.typeMigration.Util;
import com.intellij.refactoring.typeMigration.usageInfo.TypeMigrationUsageInfo;
import com.intellij.util.CommonProcessors;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.Processor;
import com.siyeh.ig.psiutils.ExpressionUtils;
import java.util.Collections;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

class TypeMigrationStatementProcessor
extends JavaRecursiveElementVisitor {
    private final PsiElement myStatement;
    private final TypeMigrationLabeler myLabeler;
    private static final Logger LOG = Logger.getInstance(TypeMigrationStatementProcessor.class);
    private final TypeEvaluator myTypeEvaluator;

    TypeMigrationStatementProcessor(PsiElement expression2, TypeMigrationLabeler labeler) {
        this.myStatement = expression2;
        this.myLabeler = labeler;
        this.myTypeEvaluator = this.myLabeler.getTypeEvaluator();
    }

    public void visitAssignmentExpression(PsiAssignmentExpression expression2) {
        IElementType binaryOperator;
        super.visitAssignmentExpression(expression2);
        PsiExpression lExpression = expression2.getLExpression();
        TypeView left = new TypeView(lExpression);
        PsiExpression rExpression = expression2.getRExpression();
        if (rExpression == null) {
            return;
        }
        TypeView right = new TypeView(rExpression);
        IElementType sign = expression2.getOperationTokenType();
        PsiType ltype = left.getType();
        PsiType rtype = right.getType();
        if (ltype == null || rtype == null) {
            return;
        }
        if (sign != JavaTokenType.EQ && !TypeConversionUtil.isBinaryOperatorApplicable((IElementType)(binaryOperator = TypeConversionUtil.convertEQtoOperation((IElementType)sign)), (PsiType)ltype, (PsiType)rtype, (boolean)false)) {
            if (left.isChanged()) {
                this.findConversionOrFail((PsiExpression)expression2, lExpression, left.getTypePair());
            }
            if (right.isChanged()) {
                this.findConversionOrFail((PsiExpression)expression2, rExpression, right.getTypePair());
            }
            return;
        }
        switch (TypeInfection.getInfection(left, right)) {
            case 0: {
                break;
            }
            case 1: {
                this.myLabeler.migrateExpressionType(rExpression, ltype, this.myStatement, TypeConversionUtil.isAssignable((PsiType)ltype, (PsiType)rtype) && !TypeMigrationStatementProcessor.isSetter(expression2), true);
                break;
            }
            case 2: {
                if (lExpression instanceof PsiReferenceExpression && ((PsiReferenceExpression)lExpression).resolve() instanceof PsiLocalVariable && !TypeMigrationStatementProcessor.canBeVariableType(rtype)) {
                    this.tryToRemoveLocalVariableAssignment((PsiLocalVariable)((PsiReferenceExpression)lExpression).resolve(), rExpression, rtype);
                    break;
                }
                this.myLabeler.migrateExpressionType(lExpression, rtype, this.myStatement, TypeConversionUtil.isAssignable((PsiType)ltype, (PsiType)rtype), false);
                break;
            }
            case 3: {
                this.addTypeUsage((PsiElement)lExpression);
                this.addTypeUsage((PsiElement)rExpression);
                break;
            }
            default: {
                LOG.error("Must not happen.");
            }
        }
    }

    public void visitArrayAccessExpression(PsiArrayAccessExpression expression2) {
        TypeView typeView;
        super.visitArrayAccessExpression(expression2);
        PsiExpression indexExpression = expression2.getIndexExpression();
        if (indexExpression != null) {
            this.checkIndexExpression(indexExpression);
        }
        if ((typeView = new TypeView(expression2.getArrayExpression())).isChanged() && typeView.getType() instanceof PsiClassType) {
            TypeConversionDescriptorBase conversion = this.myLabeler.getRules().findConversion((PsiType)typeView.getTypePair().first, typeView.getType(), null, (PsiExpression)expression2, false, this.myLabeler);
            if (conversion == null) {
                this.myLabeler.markFailedConversion(typeView.getTypePair(), (PsiExpression)expression2);
            } else {
                this.myLabeler.setConversionMapping((PsiExpression)expression2, conversion);
                this.myTypeEvaluator.setType(new TypeMigrationUsageInfo((PsiElement)expression2), this.myTypeEvaluator.evaluateType((PsiExpression)expression2));
            }
        }
    }

    public void visitSwitchLabelStatement(PsiSwitchLabelStatement statement) {
        PsiSwitchStatement switchStatement;
        TypeView typeView;
        super.visitSwitchLabelStatement(statement);
        PsiExpression caseValue = statement.getCaseValue();
        if (caseValue != null && (typeView = new TypeView(caseValue)).isChanged() && (switchStatement = statement.getEnclosingSwitchStatement()) != null) {
            PsiExpression expression2 = switchStatement.getExpression();
            this.myLabeler.migrateExpressionType(expression2, typeView.getType(), this.myStatement, false, false);
        }
    }

    public void visitInstanceOfExpression(PsiInstanceOfExpression expression2) {
        super.visitInstanceOfExpression(expression2);
        PsiTypeElement typeElement = expression2.getCheckType();
        if (typeElement != null) {
            PsiExpression consideredExpression = expression2.getOperand();
            PsiType migrationType = this.myTypeEvaluator.evaluateType(consideredExpression);
            PsiType fixedType = typeElement.getType();
            if (migrationType != null && !TypeConversionUtil.isAssignable((PsiType)migrationType, (PsiType)fixedType)) {
                this.myLabeler.markFailedConversion((Pair<PsiType, PsiType>)Pair.create((Object)fixedType, (Object)migrationType), consideredExpression);
            }
        }
    }

    public void visitTypeCastExpression(PsiTypeCastExpression expression2) {
        super.visitTypeCastExpression(expression2);
        PsiTypeElement typeElement = expression2.getCastType();
        if (typeElement != null) {
            PsiType fixedType = typeElement.getType();
            PsiType migrationType = this.myTypeEvaluator.evaluateType(expression2.getOperand());
            if (migrationType != null && !TypeConversionUtil.areTypesConvertible((PsiType)migrationType, (PsiType)fixedType)) {
                this.myLabeler.markFailedConversion((Pair<PsiType, PsiType>)Pair.create((Object)fixedType, (Object)migrationType), (PsiExpression)expression2);
            }
        }
    }

    public void visitVariable(PsiVariable variable) {
        super.visitVariable(variable);
        PsiExpression initializer = variable.getInitializer();
        if (initializer != null && initializer.getType() != null) {
            this.processVariable(variable, initializer, null, null, null, false);
        }
    }

    public void visitReturnStatement(PsiReturnStatement statement) {
        super.visitReturnStatement(statement);
        PsiElement method = PsiTreeUtil.getParentOfType((PsiElement)statement, (Class[])new Class[]{PsiMethod.class, PsiLambdaExpression.class});
        PsiExpression value2 = statement.getReturnValue();
        if (method != null && value2 != null) {
            if (method instanceof PsiLambdaExpression) {
                return;
            }
            PsiType returnType = ((PsiMethod)method).getReturnType();
            PsiType valueType = this.myTypeEvaluator.evaluateType(value2);
            if (returnType != null && valueType != null && (TypeMigrationStatementProcessor.isGetter(value2, method) || !TypeConversionUtil.isAssignable((PsiType)returnType, (PsiType)valueType)) && returnType.equals(this.myTypeEvaluator.getType(method)) && !this.myLabeler.addMigrationRoot(method, valueType, this.myStatement, false, true)) {
                this.myLabeler.convertExpression(value2, valueType, returnType, false);
            }
        }
    }

    public void visitReferenceExpression(PsiReferenceExpression expression2) {
        TypeView view;
        PsiExpression qualifierExpression2 = expression2.getQualifierExpression();
        if (qualifierExpression2 != null && qualifierExpression2.isPhysical()) {
            qualifierExpression2.accept((PsiElementVisitor)this);
            TypeView qualifierView = new TypeView(qualifierExpression2);
            if (qualifierView.isChanged()) {
                PsiMember member = (PsiMember)expression2.advancedResolve(false).getElement();
                if (member == null) {
                    return;
                }
                Pair<PsiType, PsiType> typePair = qualifierView.getTypePair();
                TypeConversionDescriptorBase conversion = this.myLabeler.getRules().findConversion((PsiType)typePair.getFirst(), (PsiType)typePair.getSecond(), member, (PsiExpression)expression2, false, this.myLabeler);
                if (conversion == null) {
                    this.myLabeler.markFailedConversion(typePair, qualifierExpression2);
                } else {
                    PsiElement parent = Util.getEssentialParent((PsiElement)expression2);
                    PsiType type2 = conversion.conversionType();
                    if (parent instanceof PsiMethodCallExpression) {
                        this.myLabeler.setConversionMapping((PsiExpression)((PsiMethodCallExpression)parent), conversion);
                        this.myTypeEvaluator.setType(new TypeMigrationUsageInfo(parent), type2 != null ? type2 : this.myTypeEvaluator.evaluateType((PsiExpression)parent));
                    } else {
                        this.myLabeler.setConversionMapping((PsiExpression)expression2, conversion);
                        this.myTypeEvaluator.setType(new TypeMigrationUsageInfo((PsiElement)expression2), type2 != null ? type2 : this.myTypeEvaluator.evaluateType((PsiExpression)expression2));
                    }
                }
            }
        } else if (PsiUtil.isCondition((PsiElement)expression2, (PsiElement)expression2.getParent()) && (view = new TypeView((PsiExpression)expression2)).isChanged()) {
            this.findConversionOrFail((PsiExpression)expression2, (PsiExpression)expression2, view.getTypePair());
        }
    }

    public void visitIfStatement(PsiIfStatement statement) {
        TypeView view;
        super.visitIfStatement(statement);
        PsiExpression condition2 = statement.getCondition();
        if (condition2 != null && (view = new TypeView(condition2)).isChanged()) {
            this.findConversionOrFail(condition2, condition2, view.getTypePair());
        }
    }

    public void visitForeachStatement(PsiForeachStatement statement) {
        super.visitForeachStatement(statement);
        PsiExpression value2 = statement.getIteratedValue();
        PsiParameter psiParameter = statement.getIterationParameter();
        if (value2 != null) {
            TypeView typeView = new TypeView(value2);
            PsiType psiType = typeView.getType();
            if (psiType instanceof PsiArrayType) {
                psiType = ((PsiArrayType)psiType).getComponentType();
            } else if (psiType instanceof PsiClassType) {
                PsiClassType.ClassResolveResult resolveResult = ((PsiClassType)psiType).resolveGenerics();
                PsiClass psiClass = resolveResult.getElement();
                PsiType targetTypeParameter = this.getTargetTypeParameter(psiClass, value2, typeView);
                if (targetTypeParameter == null) {
                    return;
                }
                psiType = resolveResult.getSubstitutor().substitute(targetTypeParameter);
                if (psiType instanceof PsiWildcardType) {
                    psiType = ((PsiWildcardType)psiType).getExtendsBound();
                }
            } else {
                return;
            }
            TypeView left = new TypeView((PsiVariable)psiParameter, null, null);
            if (TypeInfection.getInfection(left, typeView) == 1) {
                PsiArrayType iterableType;
                PsiType typeViewType = typeView.getType();
                if (typeViewType instanceof PsiArrayType) {
                    iterableType = left.getType().createArrayType();
                } else {
                    PsiClass iterableClass = PsiUtil.resolveClassInType((PsiType)typeViewType);
                    LOG.assertTrue(iterableClass != null);
                    PsiType targetType = this.getTargetTypeParameter(iterableClass, value2, typeView);
                    PsiClass typeParam = PsiUtil.resolveClassInClassTypeOnly((PsiType)targetType);
                    if (!(typeParam instanceof PsiTypeParameter)) {
                        return;
                    }
                    Map<PsiTypeParameter, PsiType> substMap = Collections.singletonMap((PsiTypeParameter)typeParam, left.getType());
                    PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)iterableClass.getProject());
                    iterableType = factory.createType(iterableClass, factory.createSubstitutor(substMap));
                }
                this.myLabeler.migrateExpressionType(value2, (PsiType)iterableType, this.myStatement, TypeConversionUtil.isAssignable((PsiType)iterableType, (PsiType)typeViewType), true);
            } else {
                this.processVariable((PsiVariable)psiParameter, value2, psiType, null, null, false);
            }
        }
    }

    private PsiType getTargetTypeParameter(PsiClass iterableClass, PsiExpression value2, TypeView typeView) {
        Project project = iterableClass.getProject();
        PsiClass itClass = JavaPsiFacade.getInstance((Project)project).findClass("java.lang.Iterable", GlobalSearchScope.allScope((Project)project));
        if (itClass == null) {
            return null;
        }
        if (!InheritanceUtil.isInheritorOrSelf((PsiClass)iterableClass, (PsiClass)itClass, (boolean)true)) {
            this.findConversionOrFail(value2, value2, typeView.getTypePair());
            return null;
        }
        PsiSubstitutor aSubstitutor = TypeConversionUtil.getSuperClassSubstitutor((PsiClass)itClass, (PsiClass)iterableClass, (PsiSubstitutor)PsiSubstitutor.EMPTY);
        return aSubstitutor.substitute(itClass.getTypeParameters()[0]);
    }

    public void visitNewExpression(PsiNewExpression expression2) {
        PsiExpression[] dimensions;
        super.visitNewExpression(expression2);
        for (PsiExpression dimension : dimensions = expression2.getArrayDimensions()) {
            this.checkIndexExpression(dimension);
        }
        PsiArrayInitializerExpression arrayInitializer = expression2.getArrayInitializer();
        if (arrayInitializer != null) {
            this.processArrayInitializer(arrayInitializer, (PsiExpression)expression2);
        }
    }

    public void visitArrayInitializerExpression(PsiArrayInitializerExpression expression2) {
        super.visitArrayInitializerExpression(expression2);
        this.processArrayInitializer(expression2, (PsiExpression)expression2);
    }

    public void visitUnaryExpression(PsiUnaryExpression expression2) {
        super.visitUnaryExpression(expression2);
        TypeView typeView = new TypeView((PsiExpression)expression2);
        if (typeView.isChanged() && !TypeConversionUtil.isUnaryOperatorApplicable((PsiJavaToken)expression2.getOperationSign(), (PsiType)typeView.getType())) {
            this.findConversionOrFail((PsiExpression)expression2, (PsiExpression)expression2, typeView.getTypePair());
        }
    }

    private void findConversionOrFail(PsiExpression expression2, PsiExpression toFail, Pair<PsiType, PsiType> typePair) {
        TypeConversionDescriptorBase conversion = this.myLabeler.getRules().findConversion((PsiType)typePair.getFirst(), (PsiType)typePair.getSecond(), null, expression2, this.myLabeler);
        if (conversion == null) {
            this.myLabeler.markFailedConversion(typePair, toFail);
        } else {
            this.myLabeler.setConversionMapping(expression2, conversion);
            PsiType psiType = this.myTypeEvaluator.evaluateType(expression2);
            LOG.assertTrue(psiType != null, (Object)expression2);
            this.myTypeEvaluator.setType(new TypeMigrationUsageInfo((PsiElement)expression2), psiType);
        }
    }

    public void visitPolyadicExpression(PsiPolyadicExpression expression2) {
        super.visitPolyadicExpression(expression2);
        PsiExpression[] operands2 = expression2.getOperands();
        if (operands2.length == 0) {
            return;
        }
        IElementType operationTokenType = expression2.getOperationTokenType();
        PsiExpression lOperand = operands2[0];
        TypeView left = new TypeView(lOperand);
        for (int i = 1; i < operands2.length; ++i) {
            PsiExpression rOperand = operands2[i];
            if (rOperand == null) {
                return;
            }
            TypeView right = new TypeView(rOperand);
            if (this.tryFindConversionIfOperandIsNull(left, right, rOperand) || this.tryFindConversionIfOperandIsNull(right, left, lOperand)) continue;
            if (!TypeConversionUtil.isBinaryOperatorApplicable((IElementType)operationTokenType, (PsiType)left.getType(), (PsiType)right.getType(), (boolean)false)) {
                if (left.isChanged()) {
                    this.findConversionOrFail(lOperand, lOperand, left.getTypePair());
                }
                if (right.isChanged()) {
                    this.findConversionOrFail(rOperand, rOperand, right.getTypePair());
                }
            }
            lOperand = rOperand;
            left = right;
        }
    }

    protected boolean tryFindConversionIfOperandIsNull(TypeView nullCandidate, TypeView comparingType, PsiExpression comparingExpr) {
        if (nullCandidate.getType() == PsiType.NULL && comparingType.isChanged()) {
            Pair<PsiType, PsiType> typePair = comparingType.getTypePair();
            TypeConversionDescriptorBase conversion = this.myLabeler.getRules().findConversion((PsiType)typePair.getFirst(), (PsiType)typePair.getSecond(), null, comparingExpr, false, this.myLabeler);
            if (conversion != null) {
                this.myLabeler.setConversionMapping(comparingExpr, conversion);
            }
            return true;
        }
        return false;
    }

    private void processArrayInitializer(PsiArrayInitializerExpression expression2, PsiExpression parentExpression) {
        PsiExpression[] initializers = expression2.getInitializers();
        PsiType migrationType = null;
        for (PsiExpression initializer : initializers) {
            TypeView typeView = new TypeView(initializer);
            if (!typeView.isChanged()) continue;
            PsiType type2 = typeView.getType();
            if (migrationType != null && TypeConversionUtil.isAssignable(migrationType, (PsiType)type2)) continue;
            if (migrationType != null && !TypeConversionUtil.isAssignable((PsiType)type2, (PsiType)migrationType)) {
                this.myLabeler.markFailedConversion((Pair<PsiType, PsiType>)Pair.create((Object)parentExpression.getType(), (Object)type2), parentExpression);
                return;
            }
            migrationType = type2;
        }
        PsiType exprType = expression2.getType();
        if (migrationType != null && exprType instanceof PsiArrayType) {
            boolean alreadyProcessed = TypeConversionUtil.isAssignable((PsiType)((PsiArrayType)exprType).getComponentType(), migrationType);
            this.myLabeler.migrateExpressionType(parentExpression, (PsiType)(alreadyProcessed ? exprType : migrationType.createArrayType()), (PsiElement)expression2, alreadyProcessed, true);
        }
    }

    private void checkIndexExpression(PsiExpression indexExpression) {
        PsiType indexType = this.myTypeEvaluator.evaluateType(indexExpression);
        if (indexType != null && !TypeConversionUtil.isAssignable((PsiType)PsiType.INT, (PsiType)indexType)) {
            this.myLabeler.markFailedConversion((Pair<PsiType, PsiType>)Pair.create((Object)indexExpression.getType(), (Object)indexType), indexExpression);
        }
    }

    public void visitMethodCallExpression(PsiMethodCallExpression methodCallExpression) {
        super.visitMethodCallExpression(methodCallExpression);
        JavaResolveResult resolveResult = methodCallExpression.resolveMethodGenerics();
        PsiElement method = resolveResult.getElement();
        if (method instanceof PsiMethod) {
            PsiType qualifierType;
            if (this.migrateEqualsMethod(methodCallExpression, (PsiMethod)method)) {
                return;
            }
            PsiExpression[] psiExpressions = methodCallExpression.getArgumentList().getExpressions();
            PsiParameter[] originalParams = ((PsiMethod)method).getParameterList().getParameters();
            PsiSubstitutor evalSubstitutor = this.myTypeEvaluator.createMethodSubstitution(originalParams, psiExpressions, (PsiMethod)method, (PsiExpression)methodCallExpression);
            for (int i = 0; i < psiExpressions.length; ++i) {
                PsiParameter originalParameter;
                if (originalParams.length <= i) {
                    if (originalParams.length <= 0 || !originalParams[originalParams.length - 1].isVarArgs()) continue;
                    originalParameter = originalParams[originalParams.length - 1];
                } else {
                    originalParameter = originalParams[i];
                }
                this.processVariable((PsiVariable)originalParameter, psiExpressions[i], null, resolveResult.getSubstitutor(), evalSubstitutor, true);
            }
            PsiExpression qualifier = methodCallExpression.getMethodExpression().getQualifierExpression();
            if (qualifier != null && qualifier.isPhysical() && !new TypeView(qualifier).isChanged() && (qualifierType = qualifier.getType()) instanceof PsiClassType) {
                PsiClassType.ClassResolveResult classResolveResult = ((PsiClassType)qualifierType).resolveGenerics();
                PsiElementFactory elementFactory = JavaPsiFacade.getElementFactory((Project)this.myStatement.getProject());
                PsiClassType migrationType = elementFactory.createType(classResolveResult.getElement(), TypeMigrationStatementProcessor.composeIfNotAssignable(classResolveResult.getSubstitutor(), evalSubstitutor));
                this.myLabeler.migrateExpressionType(qualifier, (PsiType)migrationType, this.myStatement, migrationType.equals(qualifierType), true);
            }
        }
    }

    private boolean migrateEqualsMethod(PsiMethodCallExpression methodCallExpression, PsiMethod method) {
        PsiParameter parameter2;
        PsiExpression qualifier = methodCallExpression.getMethodExpression().getQualifierExpression();
        if (qualifier == null) {
            return false;
        }
        TypeView qualifierTypeView = new TypeView(qualifier);
        if (!qualifierTypeView.isChanged()) {
            return false;
        }
        if (method.getName().equals("equals") && method.getParameterList().getParametersCount() == 1 && (parameter2 = method.getParameterList().getParameters()[0]).getType().equals(PsiType.getJavaLangObject((PsiManager)methodCallExpression.getManager(), (GlobalSearchScope)methodCallExpression.getResolveScope()))) {
            PsiExpression[] expressions2 = methodCallExpression.getArgumentList().getExpressions();
            if (expressions2.length != 1) {
                return false;
            }
            TypeView argumentTypeView = new TypeView(expressions2[0]);
            PsiType argumentType = argumentTypeView.getType();
            if (!argumentTypeView.isChanged() && ((PsiType)qualifierTypeView.getTypePair().getFirst()).equals(argumentType)) {
                PsiType migrationType = qualifierTypeView.getType();
                this.myLabeler.migrateExpressionType(expressions2[0], migrationType, (PsiElement)methodCallExpression, TypeConversionUtil.isAssignable((PsiType)migrationType, (PsiType)argumentType), true);
                return true;
            }
        }
        return false;
    }

    private void processVariable(PsiVariable variable, PsiExpression value2, PsiType migrationType, PsiSubstitutor varSubstitutor, PsiSubstitutor evalSubstitutor, boolean isCovariantPosition) {
        TypeView right = new TypeView(value2);
        TypeView left = new TypeView(variable, varSubstitutor, evalSubstitutor);
        PsiType declarationType = left.getType();
        switch (TypeInfection.getInfection(left, right)) {
            case 0: {
                break;
            }
            case 1: {
                PsiType valueType = right.getType();
                if (valueType == null || declarationType == null) break;
                this.myLabeler.migrateExpressionType(value2, TypeMigrationStatementProcessor.adjustMigrationTypeIfGenericArrayCreation(declarationType, value2), this.myStatement, left.isVarArgs() ? TypeMigrationStatementProcessor.isVarargAssignable(left, right) : TypeConversionUtil.isAssignable((PsiType)declarationType, (PsiType)valueType), true);
                break;
            }
            case 2: {
                PsiDeclarationStatement decl;
                PsiType psiType;
                PsiType psiType2 = psiType = migrationType != null ? migrationType : right.getType();
                if (psiType == null) break;
                if (TypeMigrationStatementProcessor.canBeVariableType(psiType)) {
                    if (declarationType == null || this.myLabeler.addMigrationRoot((PsiElement)variable, psiType, this.myStatement, TypeConversionUtil.isAssignable((PsiType)declarationType, (PsiType)psiType), true) || TypeConversionUtil.isAssignable((PsiType)left.getType(), (PsiType)psiType)) break;
                    PsiType initialType = left.getType();
                    if (initialType instanceof PsiEllipsisType) {
                        initialType = ((PsiEllipsisType)initialType).getComponentType();
                    }
                    this.myLabeler.convertExpression(value2, psiType, initialType, isCovariantPosition);
                    break;
                }
                if (!(variable instanceof PsiLocalVariable) || (decl = (PsiDeclarationStatement)PsiTreeUtil.getParentOfType((PsiElement)variable, PsiDeclarationStatement.class)) == null || decl.getDeclaredElements().length != 1) break;
                this.tryToRemoveLocalVariableAssignment((PsiLocalVariable)variable, value2, psiType);
                break;
            }
            case 3: {
                this.addTypeUsage((PsiElement)variable);
                break;
            }
            default: {
                LOG.error("Must not happen.");
            }
        }
    }

    private void tryToRemoveLocalVariableAssignment(@NotNull PsiLocalVariable variable, @NotNull PsiExpression valueExpression, @NotNull PsiType migrationType) {
        PsiCodeBlock codeBlock;
        PsiElement[] refs;
        if (variable == null) {
            TypeMigrationStatementProcessor.$$$reportNull$$$0(0);
        }
        if (valueExpression == null) {
            TypeMigrationStatementProcessor.$$$reportNull$$$0(1);
        }
        if (migrationType == null) {
            TypeMigrationStatementProcessor.$$$reportNull$$$0(2);
        }
        if ((refs = DefUseUtil.getRefs(codeBlock = (PsiCodeBlock)PsiTreeUtil.getParentOfType((PsiElement)variable, PsiCodeBlock.class), (PsiVariable)variable, (PsiElement)valueExpression)).length == 0) {
            this.myLabeler.setConversionMapping(valueExpression, new TypeConversionDescriptorBase(){

                @Override
                public PsiExpression replace(PsiExpression expression2, @NotNull TypeEvaluator evaluator) throws IncorrectOperationException {
                    PsiElement parent;
                    if (evaluator == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    if ((parent = expression2.getParent()) instanceof PsiLocalVariable) {
                        PsiLocalVariable var = (PsiLocalVariable)parent;
                        PsiDeclarationStatement decl = (PsiDeclarationStatement)PsiTreeUtil.getParentOfType((PsiElement)var, PsiDeclarationStatement.class);
                        if (decl == null) {
                            return null;
                        }
                        Project project = var.getProject();
                        PsiAssignmentExpression assignment = ExpressionUtils.splitDeclaration(decl, project);
                        PsiExpression rExpression = assignment.getRExpression();
                        if (rExpression == null) {
                            return null;
                        }
                        assignment.replace((PsiElement)rExpression);
                        if (ReferencesSearch.search((PsiElement)var).forEach((Processor)new CommonProcessors.FindFirstProcessor())) {
                            var.delete();
                        }
                    } else if (parent instanceof PsiAssignmentExpression) {
                        PsiExpression rExpression = ((PsiAssignmentExpression)parent).getRExpression();
                        return rExpression == null ? null : (PsiExpression)parent.replace((PsiElement)rExpression);
                    }
                    return null;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "evaluator", "com/intellij/refactoring/typeMigration/TypeMigrationStatementProcessor$1", "replace"));
                }
            });
        } else {
            this.myLabeler.markFailedConversion((Pair<PsiType, PsiType>)Pair.pair(null, (Object)migrationType), valueExpression);
        }
    }

    private static boolean canBeVariableType(@NotNull PsiType type2) {
        if (type2 == null) {
            TypeMigrationStatementProcessor.$$$reportNull$$$0(3);
        }
        return !type2.getDeepComponentType().equals(PsiType.VOID);
    }

    private static PsiType adjustMigrationTypeIfGenericArrayCreation(PsiType migrationType, PsiExpression expression2) {
        PsiClassType rawType;
        PsiType componentType;
        if (expression2 instanceof PsiNewExpression && migrationType instanceof PsiArrayType && (componentType = migrationType.getDeepComponentType()) instanceof PsiClassType && !(rawType = ((PsiClassType)componentType).rawType()).equals((Object)componentType)) {
            return com.intellij.refactoring.typeCook.Util.createArrayType((PsiType)rawType, migrationType.getArrayDimensions());
        }
        return migrationType;
    }

    private void addTypeUsage(PsiElement typedElement) {
        if (typedElement instanceof PsiReferenceExpression) {
            this.myLabeler.setTypeUsage(((PsiReferenceExpression)typedElement).resolve(), this.myStatement);
        } else if (typedElement instanceof PsiMethodCallExpression) {
            this.myLabeler.setTypeUsage((PsiElement)((PsiMethodCallExpression)typedElement).resolveMethod(), this.myStatement);
        } else {
            this.myLabeler.setTypeUsage(typedElement, this.myStatement);
        }
    }

    private static boolean isSetter(PsiAssignmentExpression expression2) {
        PsiElement resolved;
        PsiExpression lExpression = expression2.getLExpression();
        if (lExpression instanceof PsiReferenceExpression && (resolved = ((PsiReferenceExpression)lExpression).resolve()) instanceof PsiField) {
            PsiMethod setter;
            PsiField field = (PsiField)resolved;
            NavigatablePsiElement containingMethod = (NavigatablePsiElement)PsiTreeUtil.getParentOfType((PsiElement)expression2, (Class[])new Class[]{PsiMethod.class, PsiLambdaExpression.class});
            if (containingMethod instanceof PsiMethod && containingMethod.isEquivalentTo((PsiElement)(setter = PropertyUtilBase.findPropertySetter((PsiClass)field.getContainingClass(), (String)field.getName(), (boolean)field.hasModifierProperty("static"), (boolean)false)))) {
                return true;
            }
        }
        return false;
    }

    private static boolean isGetter(PsiExpression returnValue, PsiElement containingMethod) {
        PsiElement resolved;
        if (returnValue instanceof PsiReferenceExpression && (resolved = ((PsiReferenceExpression)returnValue).resolve()) instanceof PsiField) {
            PsiField field = (PsiField)resolved;
            boolean isStatic = field.hasModifierProperty("static");
            PsiMethod[] getters = GetterSetterPrototypeProvider.findGetters(field.getContainingClass(), field.getName(), isStatic);
            if (getters != null) {
                for (PsiMethod getter : getters) {
                    if (!containingMethod.isEquivalentTo((PsiElement)getter)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    private static PsiSubstitutor composeIfNotAssignable(PsiSubstitutor actual, PsiSubstitutor required) {
        if (actual == PsiSubstitutor.EMPTY) {
            return required;
        }
        if (required == PsiSubstitutor.EMPTY) {
            return actual;
        }
        PsiSubstitutor result = PsiSubstitutor.createSubstitutor((Map)actual.getSubstitutionMap());
        for (Map.Entry e : required.getSubstitutionMap().entrySet()) {
            PsiTypeParameter typeParameter = (PsiTypeParameter)e.getKey();
            PsiType requiredType = (PsiType)e.getValue();
            PsiType actualType = (PsiType)result.getSubstitutionMap().get(typeParameter);
            if (requiredType == null || actualType != null && TypeConversionUtil.isAssignable((PsiType)actualType, (PsiType)requiredType)) continue;
            result = result.put(typeParameter, requiredType);
        }
        return result;
    }

    private static boolean isVarargAssignable(TypeView left, TypeView right) {
        PsiType rightOrigin;
        Pair<PsiType, PsiType> leftPair = left.getTypePair();
        Pair<PsiType, PsiType> rightPair = right.getTypePair();
        PsiType leftOrigin = (PsiType)leftPair.getFirst();
        boolean isDirectlyAssignable = TypeConversionUtil.isAssignable((PsiType)leftOrigin, (PsiType)(rightOrigin = (PsiType)rightPair.getFirst()));
        return TypeConversionUtil.isAssignable((PsiType)(isDirectlyAssignable ? (PsiType)leftPair.getSecond() : ((PsiEllipsisType)leftPair.getSecond()).getComponentType()), (PsiType)((PsiType)rightPair.getSecond()));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "variable";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "valueExpression";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "migrationType";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
        }
        objectArray2[1] = "com/intellij/refactoring/typeMigration/TypeMigrationStatementProcessor";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "tryToRemoveLocalVariableAssignment";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "canBeVariableType";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class TypeInfection {
        static final int NONE_INFECTED = 0;
        static final int LEFT_INFECTED = 1;
        static final int RIGHT_INFECTED = 2;
        static final int BOTH_INFECTED = 3;

        private TypeInfection() {
        }

        static int getInfection(TypeView left, TypeView right) {
            return (left.isChanged() ? 1 : 0) + (right.isChanged() ? 2 : 0);
        }
    }

    private class TypeView {
        final PsiType myOriginType;
        final PsiType myType;
        final boolean myChanged;

        TypeView(PsiExpression expr2) {
            if (expr2 == null) {
                TypeView.$$$reportNull$$$0(0);
            }
            PsiType exprType = expr2.getType();
            this.myOriginType = GenericsUtil.getVariableTypeByExpressionType((PsiType)exprType);
            PsiType type2 = TypeMigrationStatementProcessor.this.myTypeEvaluator.evaluateType(expr2);
            this.myType = GenericsUtil.getVariableTypeByExpressionType((PsiType)type2);
            this.myChanged = this.myOriginType != null && this.myType != null && !this.myType.equals(this.myOriginType);
        }

        TypeView(PsiVariable var, PsiSubstitutor varSubstitutor, PsiSubstitutor evalSubstitutor) {
            this.myOriginType = varSubstitutor != null ? varSubstitutor.substitute(var.getType()) : var.getType();
            PsiSubstitutor substitutor = PsiSubstitutor.EMPTY;
            if (varSubstitutor != null) {
                substitutor = substitutor.putAll(varSubstitutor);
            }
            if (evalSubstitutor != null) {
                substitutor = substitutor.putAll(evalSubstitutor);
            }
            this.myType = substitutor.substitute(TypeMigrationStatementProcessor.this.myTypeEvaluator.getType((PsiElement)var));
            this.myChanged = this.myOriginType != null && this.myType != null && !this.myType.equals(this.myOriginType);
        }

        public PsiType getType() {
            return this.myType;
        }

        public boolean isChanged() {
            return this.myChanged;
        }

        public Pair<PsiType, PsiType> getTypePair() {
            return Pair.create((Object)this.myOriginType, (Object)this.myType);
        }

        public boolean isVarArgs() {
            return this.myType instanceof PsiEllipsisType && this.myOriginType instanceof PsiEllipsisType;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expr", "com/intellij/refactoring/typeMigration/TypeMigrationStatementProcessor$TypeView", "<init>"));
        }
    }
}

