/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.rename;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.psi.ImplicitVariable;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.refactoring.rename.LocalHidesRenamedLocalUsageInfo;
import com.intellij.refactoring.util.RefactoringUtil;
import com.intellij.usageView.UsageInfo;
import java.util.List;

public class JavaUnresolvableLocalCollisionDetector {
    private static final Logger LOG = Logger.getInstance(JavaUnresolvableLocalCollisionDetector.class);

    private JavaUnresolvableLocalCollisionDetector() {
    }

    public static void findCollisions(final PsiElement element, String newName, final List<? super UsageInfo> result) {
        PsiElement scope;
        if (!PsiUtil.isJvmLocalVariable((PsiElement)element)) {
            return;
        }
        PsiElement anchor = null;
        if (element instanceof PsiLocalVariable) {
            scope = RefactoringUtil.getVariableScope((PsiLocalVariable)element);
            if (!(element instanceof ImplicitVariable)) {
                anchor = element.getParent();
            }
        } else {
            scope = ((PsiParameter)element).getDeclarationScope();
        }
        LOG.assertTrue(scope != null, (Object)element.getClass().getName());
        CollidingVariableVisitor collidingNameVisitor = new CollidingVariableVisitor(){

            @Override
            public void visitCollidingElement(PsiVariable collidingVariable) {
                if (collidingVariable.equals(element)) {
                    return;
                }
                LocalHidesRenamedLocalUsageInfo collision = new LocalHidesRenamedLocalUsageInfo(element, (PsiElement)collidingVariable);
                result.add(collision);
            }
        };
        JavaUnresolvableLocalCollisionDetector.visitLocalsCollisions(element, newName, scope, anchor, collidingNameVisitor);
    }

    public static void visitLocalsCollisions(PsiElement element, String newName, PsiElement scope, PsiElement place, CollidingVariableVisitor collidingNameVisitor) {
        if (scope == null) {
            return;
        }
        JavaUnresolvableLocalCollisionDetector.visitDownstreamCollisions(scope, place, newName, collidingNameVisitor);
        JavaUnresolvableLocalCollisionDetector.visitUpstreamLocalCollisions(element, scope, newName, collidingNameVisitor);
    }

    private static void visitDownstreamCollisions(PsiElement scope, PsiElement place, String newName, CollidingVariableVisitor collidingNameVisitor) {
        ConflictingLocalVariablesVisitor collector = new ConflictingLocalVariablesVisitor(newName, collidingNameVisitor);
        if (place == null) {
            scope.accept((PsiElementVisitor)collector);
        } else {
            LOG.assertTrue(place.getParent() == scope);
            for (PsiElement sibling = place; sibling != null; sibling = sibling.getNextSibling()) {
                sibling.accept((PsiElementVisitor)collector);
            }
        }
    }

    private static void visitUpstreamLocalCollisions(PsiElement element, PsiElement scope, String newName, CollidingVariableVisitor collidingNameVisitor) {
        PsiVariable collidingVariable = JavaPsiFacade.getInstance((Project)scope.getProject()).getResolveHelper().resolveAccessibleReferencedVariable(newName, scope);
        if (collidingVariable instanceof PsiLocalVariable || collidingVariable instanceof PsiParameter) {
            PsiElement commonParent = PsiTreeUtil.findCommonParent((PsiElement)element, (PsiElement)collidingVariable);
            if (commonParent != null) {
                for (PsiElement current = element; current != null && current != commonParent; current = current.getParent()) {
                    if (!(current instanceof PsiMethod) && !(current instanceof PsiClass)) continue;
                    return;
                }
            }
            collidingNameVisitor.visitCollidingElement(collidingVariable);
        }
    }

    public static class ConflictingLocalVariablesVisitor
    extends JavaRecursiveElementWalkingVisitor {
        protected final String myName;
        protected CollidingVariableVisitor myCollidingNameVisitor;

        public ConflictingLocalVariablesVisitor(String newName, CollidingVariableVisitor collidingNameVisitor) {
            this.myName = newName;
            this.myCollidingNameVisitor = collidingNameVisitor;
        }

        public void visitReferenceExpression(PsiReferenceExpression expression2) {
            this.visitElement((PsiElement)expression2);
        }

        public void visitField(PsiField field) {
            if (this.myName.equals(field.getName())) {
                this.myCollidingNameVisitor.visitCollidingElement((PsiVariable)field);
            }
        }

        public void visitVariable(PsiVariable variable) {
            if (this.myName.equals(variable.getName())) {
                this.myCollidingNameVisitor.visitCollidingElement(variable);
            }
        }
    }

    public static interface CollidingVariableVisitor {
        public void visitCollidingElement(PsiVariable var1);
    }
}

