/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.move.moveInstanceMethod;

import com.intellij.java.refactoring.JavaRefactoringBundle;
import com.intellij.lang.Language;
import com.intellij.lang.java.JavaLanguage;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiReference;
import com.intellij.psi.SyntheticElement;
import com.intellij.refactoring.move.MoveCallback;
import com.intellij.refactoring.move.MoveHandlerDelegate;
import com.intellij.refactoring.move.moveClassesOrPackages.JavaMoveClassesOrPackagesHandler;
import com.intellij.refactoring.move.moveInstanceMethod.MoveInstanceMethodHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MoveInstanceMethodHandlerDelegate
extends MoveHandlerDelegate {
    public boolean canMove(PsiElement[] elements, @Nullable PsiElement targetContainer, @Nullable PsiReference reference) {
        if (elements.length != 1) {
            return false;
        }
        PsiElement element = elements[0];
        if (!(element instanceof PsiMethod)) {
            return false;
        }
        if (element instanceof SyntheticElement) {
            return false;
        }
        PsiMethod method = (PsiMethod)element;
        if (method.hasModifierProperty("static")) {
            return false;
        }
        return targetContainer == null || super.canMove(elements, targetContainer, reference);
    }

    public boolean isValidTarget(PsiElement targetElement, PsiElement[] sources) {
        for (PsiElement source : sources) {
            if (!JavaMoveClassesOrPackagesHandler.invalid4Move(source)) continue;
            return false;
        }
        return targetElement instanceof PsiClass && !(targetElement instanceof PsiAnonymousClass);
    }

    public boolean tryToMove(PsiElement element, Project project, DataContext dataContext, PsiReference reference, Editor editor) {
        PsiMethod method;
        if (element instanceof PsiMethod && !(method = (PsiMethod)element).hasModifierProperty("static")) {
            new MoveInstanceMethodHandler().invoke(project, new PsiElement[]{method}, dataContext);
            return true;
        }
        return false;
    }

    public void doMove(Project project, PsiElement[] elements, PsiElement targetContainer, MoveCallback callback) {
        new MoveInstanceMethodHandler().invoke(project, elements, null);
    }

    @Nullable
    public String getActionName(PsiElement @NotNull [] elements) {
        if (elements == null) {
            MoveInstanceMethodHandlerDelegate.$$$reportNull$$$0(0);
        }
        return JavaRefactoringBundle.message((String)"move.instance.method.delegate.title", (Object[])new Object[0]);
    }

    public boolean supportsLanguage(@NotNull Language language) {
        if (language == null) {
            MoveInstanceMethodHandlerDelegate.$$$reportNull$$$0(1);
        }
        return language == JavaLanguage.INSTANCE;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "language";
                break;
            }
        }
        objectArray2[1] = "com/intellij/refactoring/move/moveInstanceMethod/MoveInstanceMethodHandlerDelegate";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getActionName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "supportsLanguage";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

