/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.move.moveInner;

import com.intellij.DynamicBundle;
import com.intellij.java.refactoring.JavaRefactoringBundle;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.JavaProjectRootsUtil;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.NullableComputable;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaDirectoryService;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiNameHelper;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiType;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.codeStyle.SuggestedNameInfo;
import com.intellij.psi.codeStyle.VariableKind;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.refactoring.PackageWrapper;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.move.MoveDialogBase;
import com.intellij.refactoring.move.MoveInstanceMembersUtil;
import com.intellij.refactoring.move.moveClassesOrPackages.MoveClassesOrPackagesUtil;
import com.intellij.refactoring.move.moveInner.MoveInnerImpl;
import com.intellij.refactoring.move.moveInner.MoveInnerProcessor;
import com.intellij.refactoring.ui.NameSuggestionsField;
import com.intellij.refactoring.ui.PackageNameReferenceEditorCombo;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.refactoring.util.RefactoringMessageUtil;
import com.intellij.refactoring.util.RefactoringUtil;
import com.intellij.ui.EditorTextField;
import com.intellij.ui.NonFocusableCheckBox;
import com.intellij.ui.RecentsManager;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.IncorrectOperationException;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.swing.AbstractButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MoveInnerDialog
extends MoveDialogBase {
    private final Project myProject;
    private final PsiClass myInnerClass;
    private final PsiElement myTargetContainer;
    private final MoveInnerProcessor myProcessor;
    private EditorTextField myClassNameField;
    private NameSuggestionsField myParameterField;
    private JCheckBox myCbPassOuterClass;
    private JPanel myPanel;
    private JCheckBox myCbSearchInComments;
    private JCheckBox myCbSearchForTextOccurences;
    private PackageNameReferenceEditorCombo myPackageNameField;
    private JLabel myPackageNameLabel;
    private JLabel myClassNameLabel;
    private JLabel myParameterNameLabel;
    private SuggestedNameInfo mySuggestedNameInfo;
    private final PsiClass myOuterClass;
    @NonNls
    private static final String RECENTS_KEY = "MoveInnerDialog.RECENTS_KEY";

    @Override
    @NotNull
    protected String getRefactoringId() {
        return "MoveInner";
    }

    public MoveInnerDialog(Project project, PsiClass innerClass, MoveInnerProcessor processor2, PsiElement targetContainer) {
        super(project, true, true);
        this.myProject = project;
        this.myInnerClass = innerClass;
        this.myTargetContainer = targetContainer;
        this.$$$setupUI$$$();
        this.myOuterClass = this.myInnerClass.getContainingClass();
        this.myProcessor = processor2;
        this.setTitle(MoveInnerImpl.getRefactoringName());
        this.init();
        this.myPackageNameLabel.setLabelFor(this.myPackageNameField.getChildComponent());
        this.myClassNameLabel.setLabelFor((Component)this.myClassNameField);
        this.myParameterNameLabel.setLabelFor((Component)this.myParameterField);
    }

    public boolean isSearchInComments() {
        return this.myCbSearchInComments.isSelected();
    }

    public boolean isSearchInNonJavaFiles() {
        return this.myCbSearchForTextOccurences.isSelected();
    }

    @NotNull
    public String getClassName() {
        String string = this.myClassNameField.getText().trim();
        if (string == null) {
            MoveInnerDialog.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Nullable
    public String getParameterName() {
        if (this.myParameterField != null) {
            return this.myParameterField.getEnteredName();
        }
        return null;
    }

    public boolean isPassOuterClass() {
        return this.myCbPassOuterClass.isSelected();
    }

    @NotNull
    public PsiClass getInnerClass() {
        PsiClass psiClass = this.myInnerClass;
        if (psiClass == null) {
            MoveInnerDialog.$$$reportNull$$$0(1);
        }
        return psiClass;
    }

    protected void init() {
        this.myClassNameField.setText(this.myInnerClass.getName());
        this.myClassNameField.selectAll();
        if (!this.myInnerClass.hasModifierProperty("static")) {
            this.myCbPassOuterClass.setSelected(true);
            this.myCbPassOuterClass.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    MoveInnerDialog.this.myParameterField.setEnabled(MoveInnerDialog.this.myCbPassOuterClass.isSelected());
                }
            });
        } else {
            this.myCbPassOuterClass.setSelected(false);
            this.myCbPassOuterClass.setEnabled(false);
            this.myParameterField.setEnabled(false);
        }
        if (this.myCbPassOuterClass.isEnabled()) {
            boolean thisNeeded = MoveInnerDialog.isThisNeeded(this.myInnerClass, this.myOuterClass);
            this.myCbPassOuterClass.setSelected(thisNeeded);
            this.myParameterField.setEnabled(thisNeeded);
        }
        this.myCbPassOuterClass.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                boolean selected = MoveInnerDialog.this.myCbPassOuterClass.isSelected();
                MoveInnerDialog.this.myParameterField.getComponent().setEnabled(selected);
            }
        });
        if (!(this.myTargetContainer instanceof PsiDirectory)) {
            this.myPackageNameField.setVisible(false);
            this.myPackageNameLabel.setVisible(false);
        }
        super.init();
    }

    public static boolean isThisNeeded(PsiClass innerClass, PsiClass outerClass) {
        Map<PsiClass, Set<PsiMember>> classesToMembers = MoveInstanceMembersUtil.getThisClassesToMembers((PsiMember)innerClass);
        for (PsiClass psiClass : classesToMembers.keySet()) {
            if (!InheritanceUtil.isInheritorOrSelf((PsiClass)outerClass, (PsiClass)psiClass, (boolean)true)) continue;
            return true;
        }
        return false;
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myClassNameField;
    }

    protected String getDimensionServiceKey() {
        return "#com.intellij.refactoring.move.moveInner.MoveInnerDialog";
    }

    protected JComponent createNorthPanel() {
        return this.myPanel;
    }

    protected JComponent createCenterPanel() {
        return null;
    }

    @Nullable
    private PsiElement getTargetContainer() {
        if (this.myTargetContainer instanceof PsiDirectory) {
            String targetName;
            PsiDirectory psiDirectory = (PsiDirectory)this.myTargetContainer;
            PsiPackage oldPackage = this.getTargetPackage();
            String name2 = oldPackage == null ? "" : oldPackage.getQualifiedName();
            if (!Objects.equals(name2, targetName = this.getPackageName())) {
                VirtualFile targetSourceRoot;
                ProjectRootManager projectRootManager = ProjectRootManager.getInstance((Project)this.myProject);
                List<VirtualFile> contentSourceRoots = JavaProjectRootsUtil.getSuitableDestinationSourceRoots(this.myProject);
                PackageWrapper newPackage = new PackageWrapper(PsiManager.getInstance((Project)this.myProject), targetName);
                if (contentSourceRoots.size() > 1) {
                    VirtualFile sourceRoot;
                    PsiPackage targetPackage = JavaPsiFacade.getInstance((Project)this.myProject).findPackage(targetName);
                    PsiDirectory initialDir = null;
                    if (targetPackage != null) {
                        PsiDirectory[] directories = targetPackage.getDirectories();
                        VirtualFile root = projectRootManager.getFileIndex().getSourceRootForFile(psiDirectory.getVirtualFile());
                        for (PsiDirectory dir : directories) {
                            if (!Comparing.equal((Object)projectRootManager.getFileIndex().getSourceRootForFile(dir.getVirtualFile()), (Object)root)) continue;
                            initialDir = dir;
                            break;
                        }
                    }
                    if ((sourceRoot = MoveClassesOrPackagesUtil.chooseSourceRoot(newPackage, contentSourceRoots, initialDir)) == null) {
                        return null;
                    }
                    targetSourceRoot = sourceRoot;
                } else {
                    targetSourceRoot = contentSourceRoots.get(0);
                }
                PsiDirectory dir = RefactoringUtil.findPackageDirectoryInSourceRoot(newPackage, targetSourceRoot);
                if (dir == null) {
                    dir = (PsiDirectory)ApplicationManager.getApplication().runWriteAction((Computable)((NullableComputable)() -> {
                        try {
                            return RefactoringUtil.createPackageDirectoryInSourceRoot(newPackage, targetSourceRoot);
                        }
                        catch (IncorrectOperationException e) {
                            return null;
                        }
                    }));
                }
                return dir;
            }
        }
        return this.myTargetContainer;
    }

    protected void doAction() {
        String message2 = null;
        String className2 = this.getClassName();
        String parameterName = this.getParameterName();
        PsiManager manager = PsiManager.getInstance((Project)this.myProject);
        if (className2.isEmpty()) {
            message2 = JavaRefactoringBundle.message((String)"no.class.name.specified", (Object[])new Object[0]);
        } else if (!PsiNameHelper.getInstance((Project)manager.getProject()).isIdentifier(className2)) {
            message2 = RefactoringMessageUtil.getIncorrectIdentifierMessage(className2);
        } else {
            if (this.myCbPassOuterClass.isSelected()) {
                if (parameterName != null && parameterName.isEmpty()) {
                    message2 = JavaRefactoringBundle.message((String)"no.parameter.name.specified", (Object[])new Object[0]);
                } else if (!PsiNameHelper.getInstance((Project)manager.getProject()).isIdentifier(parameterName)) {
                    message2 = RefactoringMessageUtil.getIncorrectIdentifierMessage(parameterName);
                }
            }
            if (message2 == null && this.myTargetContainer instanceof PsiClass) {
                PsiClass[] classes2;
                PsiClass targetClass = (PsiClass)this.myTargetContainer;
                for (PsiClass aClass : classes2 = targetClass.getInnerClasses()) {
                    if (!className2.equals(aClass.getName())) continue;
                    message2 = JavaRefactoringBundle.message((String)"inner.class.exists", (Object[])new Object[]{className2, targetClass.getName()});
                    break;
                }
            }
        }
        PsiElement target = null;
        if (message2 == null) {
            String packageName;
            if (this.myCbPassOuterClass.isSelected() && this.mySuggestedNameInfo != null) {
                this.mySuggestedNameInfo.nameChosen(this.getParameterName());
            }
            if ((target = this.getTargetContainer()) == null) {
                return;
            }
            if (target instanceof PsiDirectory && (message2 = RefactoringMessageUtil.checkCanCreateClass((PsiDirectory)target, className2)) == null && (packageName = this.getPackageName()).length() > 0 && !PsiNameHelper.getInstance((Project)this.myProject).isQualifiedName(packageName)) {
                message2 = RefactoringMessageUtil.getIncorrectIdentifierMessage(packageName);
            }
        }
        if (message2 != null) {
            CommonRefactoringUtil.showErrorMessage((String)MoveInnerImpl.getRefactoringName(), (String)message2, (String)"refactoring.moveInner", (Project)this.myProject);
            return;
        }
        RecentsManager.getInstance((Project)this.myProject).registerRecentEntry(RECENTS_KEY, this.getPackageName());
        this.myProcessor.setup(this.getInnerClass(), className2, this.isPassOuterClass(), parameterName, this.isSearchInComments(), this.isSearchInNonJavaFiles(), target);
        boolean openInEditor = this.isOpenInEditor();
        this.myProcessor.setOpenInEditor(openInEditor);
        this.invokeRefactoring(this.myProcessor);
    }

    private String getPackageName() {
        return this.myPackageNameField.getText().trim();
    }

    protected String getHelpId() {
        return "refactoring.moveInner";
    }

    private void createUIComponents() {
        if (!this.myInnerClass.hasModifierProperty("static")) {
            PsiManager manager = this.myInnerClass.getManager();
            PsiClassType outerType = JavaPsiFacade.getElementFactory((Project)manager.getProject()).createType(this.myInnerClass.getContainingClass());
            this.mySuggestedNameInfo = JavaCodeStyleManager.getInstance((Project)this.myProject).suggestVariableName(VariableKind.PARAMETER, null, null, (PsiType)outerType);
            String[] variants = this.mySuggestedNameInfo.names;
            this.myParameterField = new NameSuggestionsField(variants, this.myProject);
        } else {
            this.myParameterField = new NameSuggestionsField(new String[]{""}, this.myProject);
            this.myParameterField.getComponent().setEnabled(false);
        }
        PsiPackage psiPackage = this.getTargetPackage();
        this.myPackageNameField = new PackageNameReferenceEditorCombo(psiPackage != null ? psiPackage.getQualifiedName() : "", this.myProject, RECENTS_KEY, RefactoringBundle.message((String)"choose.destination.package"));
    }

    @Nullable
    private PsiPackage getTargetPackage() {
        if (this.myTargetContainer instanceof PsiDirectory) {
            PsiDirectory directory = (PsiDirectory)this.myTargetContainer;
            return JavaDirectoryService.getInstance().getPackage(directory);
        }
        return null;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JLabel jLabel;
        JLabel jLabel2;
        EditorTextField editorTextField;
        JLabel jLabel3;
        JPanel jPanel;
        this.createUIComponents();
        this.myPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(9, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        this.myClassNameLabel = jLabel3 = new JLabel();
        this.$$$loadLabelText$$$(jLabel3, DynamicBundle.getBundle((String)"messages/JavaRefactoringBundle", MoveInnerDialog.class).getString("class.name.prompt"));
        jPanel.add((Component)jLabel3, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(0, 1, 1, 1, 0, 1, 6, 1, null, null, null));
        Spacer spacer2 = new Spacer();
        jPanel.add((Component)spacer2, new GridConstraints(8, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        this.myClassNameField = editorTextField = new EditorTextField();
        jPanel.add((Component)editorTextField, new GridConstraints(1, 0, 1, 2, 0, 1, 3, 3, null, null, null));
        NonFocusableCheckBox nonFocusableCheckBox = new NonFocusableCheckBox();
        this.myCbPassOuterClass = nonFocusableCheckBox;
        this.$$$loadButtonText$$$((AbstractButton)nonFocusableCheckBox, DynamicBundle.getBundle((String)"messages/JavaRefactoringBundle", MoveInnerDialog.class).getString("pass.outer.class.instance.as.parameter"));
        jPanel.add((Component)nonFocusableCheckBox, new GridConstraints(4, 0, 1, 2, 8, 0, 3, 3, null, null, null));
        this.myParameterNameLabel = jLabel2 = new JLabel();
        this.$$$loadLabelText$$$(jLabel2, DynamicBundle.getBundle((String)"messages/JavaRefactoringBundle", MoveInnerDialog.class).getString("parameter.name.prompt"));
        jPanel.add((Component)jLabel2, new GridConstraints(5, 0, 1, 1, 8, 0, 0, 0, null, null, null, 1));
        NameSuggestionsField nameSuggestionsField = this.myParameterField;
        jPanel.add((Component)nameSuggestionsField, new GridConstraints(6, 0, 1, 2, 0, 3, 3, 3, null, null, null, 1));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new FlowLayout(0, 5, 5));
        jPanel.add((Component)jPanel2, new GridConstraints(7, 0, 1, 2, 0, 3, 3, 3, null, null, null));
        NonFocusableCheckBox nonFocusableCheckBox2 = new NonFocusableCheckBox();
        this.myCbSearchInComments = nonFocusableCheckBox2;
        this.$$$loadButtonText$$$((AbstractButton)nonFocusableCheckBox2, DynamicBundle.getBundle((String)"messages/RefactoringBundle", MoveInnerDialog.class).getString("search.in.comments.and.strings"));
        Component component = jPanel2.add((Component)nonFocusableCheckBox2);
        NonFocusableCheckBox nonFocusableCheckBox3 = new NonFocusableCheckBox();
        this.myCbSearchForTextOccurences = nonFocusableCheckBox3;
        this.$$$loadButtonText$$$((AbstractButton)nonFocusableCheckBox3, DynamicBundle.getBundle((String)"messages/RefactoringBundle", MoveInnerDialog.class).getString("search.for.text.occurrences"));
        Component component2 = jPanel2.add((Component)nonFocusableCheckBox3);
        this.myPackageNameLabel = jLabel = new JLabel();
        this.$$$loadLabelText$$$(jLabel, DynamicBundle.getBundle((String)"messages/JavaRefactoringBundle", MoveInnerDialog.class).getString("package.name.prompt"));
        jPanel.add((Component)jLabel, new GridConstraints(2, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        PackageNameReferenceEditorCombo packageNameReferenceEditorCombo = this.myPackageNameField;
        jPanel.add((Component)((Object)packageNameReferenceEditorCombo), new GridConstraints(3, 0, 1, 2, 0, 3, 3, 3, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/intellij/refactoring/move/moveInner/MoveInnerDialog";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getClassName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getInnerClass";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

