/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.inline;

import com.intellij.codeInsight.ExceptionUtil;
import com.intellij.codeInsight.TargetElementUtil;
import com.intellij.codeInsight.highlighting.HighlightManager;
import com.intellij.codeInsight.hint.HintManagerImpl;
import com.intellij.codeInsight.intention.QuickFixFactory;
import com.intellij.find.FindBundle;
import com.intellij.java.refactoring.JavaRefactoringBundle;
import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.ex.EditorSettingsExternalizable;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiArrayAccessExpression;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiPatternVariable;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiResourceExpression;
import com.intellij.psi.PsiTryStatement;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.controlFlow.AnalysisCanceledException;
import com.intellij.psi.controlFlow.DefUseUtil;
import com.intellij.psi.impl.source.PostprocessReformattingAspect;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.JavaPsiPatternUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.refactoring.BaseRefactoringProcessor;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.inline.InlineLocalDialog;
import com.intellij.refactoring.inline.JavaInlineActionHandler;
import com.intellij.refactoring.listeners.RefactoringEventData;
import com.intellij.refactoring.listeners.RefactoringEventListener;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.refactoring.util.InlineUtil;
import com.intellij.refactoring.util.RefactoringUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class InlineLocalHandler
extends JavaInlineActionHandler {
    private static final Logger LOG = Logger.getInstance(InlineLocalHandler.class);

    public boolean canInlineElement(PsiElement element) {
        return element instanceof PsiLocalVariable || element instanceof PsiPatternVariable;
    }

    public void inlineElement(Project project, Editor editor, PsiElement element) {
        PsiReference psiReference = TargetElementUtil.findReference((Editor)editor);
        PsiReferenceExpression refExpr = psiReference instanceof PsiReferenceExpression ? (PsiReferenceExpression)psiReference : null;
        InlineLocalHandler.doInline(project, editor, (PsiVariable)element, refExpr);
    }

    public static void invoke(@NotNull Project project, @NotNull Editor editor, @NotNull PsiLocalVariable local, PsiReferenceExpression refExpr) {
        if (project == null) {
            InlineLocalHandler.$$$reportNull$$$0(0);
        }
        if (editor == null) {
            InlineLocalHandler.$$$reportNull$$$0(1);
        }
        if (local == null) {
            InlineLocalHandler.$$$reportNull$$$0(2);
        }
        InlineLocalHandler.doInline(project, editor, (PsiVariable)local, refExpr);
    }

    public static void inlineVariable(@NotNull Project project, @NotNull Editor editor, @NotNull PsiVariable var, PsiReferenceExpression refExpr) {
        if (project == null) {
            InlineLocalHandler.$$$reportNull$$$0(3);
        }
        if (editor == null) {
            InlineLocalHandler.$$$reportNull$$$0(4);
        }
        if (var == null) {
            InlineLocalHandler.$$$reportNull$$$0(5);
        }
        InlineLocalHandler.doInline(project, editor, var, refExpr);
    }

    private static void doInline(@NotNull Project project, @NotNull Editor editor, @NotNull PsiVariable var, PsiReferenceExpression refExpr) {
        if (project == null) {
            InlineLocalHandler.$$$reportNull$$$0(6);
        }
        if (editor == null) {
            InlineLocalHandler.$$$reportNull$$$0(7);
        }
        if (var == null) {
            InlineLocalHandler.$$$reportNull$$$0(8);
        }
        if (!CommonRefactoringUtil.checkReadOnlyStatus((Project)project, (PsiElement)var)) {
            return;
        }
        Collection allRefs = (Collection)ProgressManager.getInstance().runProcessWithProgressSynchronously(() -> ReferencesSearch.search((PsiElement)var).mapping(PsiReference::getElement).findAll(), FindBundle.message((String)"find.usages.progress.title", (Object[])new Object[0]), true, project);
        if (allRefs == null) {
            return;
        }
        if (allRefs.isEmpty()) {
            ApplicationManager.getApplication().invokeLater(() -> {
                String message2 = RefactoringBundle.message((String)"variable.is.never.used", (Object[])new Object[]{var.getName()});
                CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)message2, (String)InlineLocalHandler.getRefactoringName((PsiElement)var), (String)"refactoring.inlineVariable");
            }, ModalityState.NON_MODAL);
            return;
        }
        Runnable runnable = var instanceof PsiLocalVariable ? InlineLocalHandler.prepareLocalInline(project, editor, (PsiLocalVariable)var, refExpr, allRefs) : InlineLocalHandler.preparePatternInline(project, editor, (PsiPatternVariable)var, refExpr, allRefs);
        if (runnable == null) {
            return;
        }
        CommandProcessor.getInstance().executeCommand(project, () -> PostprocessReformattingAspect.getInstance((Project)project).postponeFormattingInside(runnable), RefactoringBundle.message((String)"inline.command", (Object[])new Object[]{var.getName()}), null);
    }

    @Nullable
    private static Runnable preparePatternInline(@NotNull Project project, @NotNull Editor editor, @NotNull PsiPatternVariable pattern, @Nullable PsiReferenceExpression refExpr, @NotNull Collection<PsiElement> allRefs) {
        String initializerText;
        if (project == null) {
            InlineLocalHandler.$$$reportNull$$$0(9);
        }
        if (editor == null) {
            InlineLocalHandler.$$$reportNull$$$0(10);
        }
        if (pattern == null) {
            InlineLocalHandler.$$$reportNull$$$0(11);
        }
        if (allRefs == null) {
            InlineLocalHandler.$$$reportNull$$$0(12);
        }
        if ((initializerText = JavaPsiPatternUtil.getEffectiveInitializerText(pattern)) == null) {
            ApplicationManager.getApplication().invokeLater(() -> {
                String message2 = RefactoringBundle.message((String)"cannot.perform.refactoring");
                CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)message2, (String)InlineLocalHandler.getRefactoringName((PsiElement)pattern), (String)"refactoring.inlineVariable");
            }, ModalityState.NON_MODAL);
            return null;
        }
        ArrayList<PsiElement> refsToInlineList = new ArrayList<PsiElement>(allRefs);
        boolean inlineAll = InlineLocalHandler.askInlineAll(project, (PsiVariable)pattern, refExpr, refsToInlineList);
        if (refsToInlineList.isEmpty()) {
            return null;
        }
        PsiElement[] refsToInline = PsiUtilCore.toPsiElementArray(refsToInlineList);
        PsiExpression defToInline = JavaPsiFacade.getElementFactory((Project)project).createExpressionFromText(initializerText, (PsiElement)pattern);
        if (!ApplicationManager.getApplication().isUnitTestMode()) {
            HighlightManager.getInstance((Project)project).addOccurrenceHighlights(editor, refsToInline, EditorColors.SEARCH_RESULT_ATTRIBUTES, true, null);
        }
        return () -> {
            String refactoringId = "refactoring.inline.pattern.variable";
            PsiElement scope = pattern.getDeclarationScope();
            try {
                RefactoringEventData beforeData = new RefactoringEventData();
                beforeData.addElements(refsToInline);
                ((RefactoringEventListener)project.getMessageBus().syncPublisher(RefactoringEventListener.REFACTORING_EVENT_TOPIC)).refactoringStarted("refactoring.inline.pattern.variable", beforeData);
                List exprs = (List)WriteAction.compute(() -> InlineLocalHandler.inlineOccurrences(project, (PsiVariable)pattern, defToInline, refsToInline));
                if (inlineAll && ReferencesSearch.search((PsiElement)pattern).findFirst() == null) {
                    QuickFixFactory.getInstance().createRemoveUnusedVariableFix((PsiVariable)pattern).invoke(project, editor, pattern.getContainingFile());
                }
                InlineLocalHandler.highlightOccurrences(project, editor, exprs);
            }
            finally {
                RefactoringEventData afterData = new RefactoringEventData();
                afterData.addElement(scope);
                ((RefactoringEventListener)project.getMessageBus().syncPublisher(RefactoringEventListener.REFACTORING_EVENT_TOPIC)).refactoringDone("refactoring.inline.pattern.variable", afterData);
            }
        };
    }

    private static Runnable prepareLocalInline(@NotNull Project project, @NotNull Editor editor, @NotNull PsiLocalVariable local, @Nullable PsiReferenceExpression refExpr, @NotNull Collection<PsiElement> allRefs) {
        String message2;
        PsiExpression defToInline;
        if (project == null) {
            InlineLocalHandler.$$$reportNull$$$0(13);
        }
        if (editor == null) {
            InlineLocalHandler.$$$reportNull$$$0(14);
        }
        if (local == null) {
            InlineLocalHandler.$$$reportNull$$$0(15);
        }
        if (allRefs == null) {
            InlineLocalHandler.$$$reportNull$$$0(16);
        }
        HighlightManager highlightManager = HighlightManager.getInstance((Project)project);
        String localName = local.getName();
        List<PsiElement> innerClassesWithUsages = Collections.synchronizedList(new ArrayList());
        List<PsiElement> innerClassUsages = Collections.synchronizedList(new ArrayList());
        PsiElement containingClass = PsiTreeUtil.getParentOfType((PsiElement)local, (Class[])new Class[]{PsiClass.class, PsiLambdaExpression.class});
        for (PsiElement element : allRefs) {
            PsiElement innerClass = PsiTreeUtil.getParentOfType((PsiElement)element, (Class[])new Class[]{PsiClass.class, PsiLambdaExpression.class});
            while (innerClass != containingClass && innerClass != null) {
                PsiElement parentPsiClass = PsiTreeUtil.getParentOfType((PsiElement)innerClass.getParent(), (Class[])new Class[]{PsiClass.class, PsiLambdaExpression.class});
                if (parentPsiClass == containingClass) {
                    if (innerClass instanceof PsiLambdaExpression && PsiTreeUtil.isAncestor((PsiElement)innerClass, (PsiElement)local, (boolean)false)) {
                        innerClassesWithUsages.add(element);
                        innerClass = parentPsiClass;
                        continue;
                    }
                    innerClassesWithUsages.add(innerClass);
                    innerClassUsages.add(element);
                }
                innerClass = parentPsiClass;
            }
        }
        PsiCodeBlock containerBlock = (PsiCodeBlock)PsiTreeUtil.getParentOfType((PsiElement)local, PsiCodeBlock.class);
        if (containerBlock == null) {
            String message3 = RefactoringBundle.getCannotRefactorMessage((String)JavaRefactoringBundle.message((String)"inline.local.variable.declared.outside.cannot.refactor.message", (Object[])new Object[0]));
            CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)message3, (String)InlineLocalHandler.getRefactoringName((PsiElement)local), (String)"refactoring.inlineVariable");
            return null;
        }
        try {
            defToInline = InlineLocalHandler.getDefToInline((PsiVariable)local, (PsiElement)(innerClassesWithUsages.isEmpty() ? refExpr : (PsiElement)innerClassesWithUsages.get(0)), containerBlock, true);
            if (defToInline == null) {
                String key2 = refExpr == null ? "variable.has.no.initializer" : "variable.has.no.dominating.definition";
                message2 = RefactoringBundle.getCannotRefactorMessage((String)RefactoringBundle.message((String)key2, (Object[])new Object[]{localName}));
                CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)message2, (String)InlineLocalHandler.getRefactoringName((PsiElement)local), (String)"refactoring.inlineVariable");
                return null;
            }
        }
        catch (RuntimeException e) {
            InlineLocalHandler.processWrappedAnalysisCanceledException(project, editor, e);
            return null;
        }
        ArrayList<PsiElement> refsToInlineList = new ArrayList<PsiElement>();
        try {
            Collections.addAll(refsToInlineList, DefUseUtil.getRefs(containerBlock, (PsiVariable)local, (PsiElement)defToInline));
        }
        catch (RuntimeException e) {
            InlineLocalHandler.processWrappedAnalysisCanceledException(project, editor, e);
            return null;
        }
        for (PsiElement innerClassUsage : innerClassUsages) {
            if (refsToInlineList.contains(innerClassUsage)) continue;
            refsToInlineList.add(innerClassUsage);
        }
        if (refsToInlineList.isEmpty()) {
            message2 = JavaRefactoringBundle.message((String)"variable.is.never.used.before.modification", (Object[])new Object[]{localName});
            CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)message2, (String)InlineLocalHandler.getRefactoringName((PsiElement)local), (String)"refactoring.inlineVariable");
            return null;
        }
        MultiMap conflicts = new MultiMap();
        InlineUtil.checkChangedBeforeLastAccessConflicts((MultiMap<PsiElement, String>)conflicts, defToInline, (PsiVariable)local);
        if (!BaseRefactoringProcessor.processConflicts((Project)project, (MultiMap)conflicts)) {
            return null;
        }
        boolean inlineAll = InlineLocalHandler.askInlineAll(project, (PsiVariable)local, refExpr, refsToInlineList);
        if (refsToInlineList.isEmpty()) {
            return null;
        }
        Object[] refsToInline = PsiUtilCore.toPsiElementArray(refsToInlineList);
        if (!ApplicationManager.getApplication().isUnitTestMode()) {
            highlightManager.addOccurrenceHighlights(editor, (PsiElement[])refsToInline, EditorColors.SEARCH_RESULT_ATTRIBUTES, true, null);
        }
        if (refExpr != null && PsiUtil.isAccessedForReading((PsiExpression)refExpr) && ArrayUtil.find((Object[])refsToInline, (Object)refExpr) < 0) {
            PsiElement[] defs = DefUseUtil.getDefs(containerBlock, (PsiVariable)local, (PsiElement)refExpr);
            LOG.assertTrue(defs.length > 0);
            highlightManager.addOccurrenceHighlights(editor, defs, EditorColors.SEARCH_RESULT_ATTRIBUTES, true, null);
            String message4 = RefactoringBundle.getCannotRefactorMessage((String)JavaRefactoringBundle.message((String)"variable.is.accessed.for.writing", (Object[])new Object[]{localName}));
            CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)message4, (String)InlineLocalHandler.getRefactoringName((PsiElement)local), (String)"refactoring.inlineVariable");
            WindowManager.getInstance().getStatusBar(project).setInfo(RefactoringBundle.message((String)"press.escape.to.remove.the.highlighting"));
            return null;
        }
        PsiTryStatement tryStatement = (PsiTryStatement)PsiTreeUtil.getParentOfType((PsiElement)defToInline, PsiTryStatement.class);
        if (tryStatement != null && ExceptionUtil.getThrownExceptions((PsiElement)defToInline).isEmpty()) {
            tryStatement = null;
        }
        PsiFile workingFile = local.getContainingFile();
        for (Object ref2 : refsToInline) {
            PsiFile otherFile = ref2.getContainingFile();
            if (!otherFile.equals(workingFile)) {
                String message5 = RefactoringBundle.message((String)"variable.is.referenced.in.multiple.files", (Object[])new Object[]{localName});
                CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)message5, (String)InlineLocalHandler.getRefactoringName((PsiElement)local), (String)"refactoring.inlineVariable");
                return null;
            }
            if (tryStatement == null || PsiTreeUtil.isAncestor((PsiElement)tryStatement, (PsiElement)ref2, (boolean)false)) continue;
            CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)JavaRefactoringBundle.message((String)"inline.local.unable.try.catch.warning.message", (Object[])new Object[0]), (String)InlineLocalHandler.getRefactoringName((PsiElement)local), (String)"refactoring.inlineVariable");
            return null;
        }
        for (Object ref2 : refsToInline) {
            PsiElement[] defs = DefUseUtil.getDefs(containerBlock, (PsiVariable)local, (PsiElement)ref2);
            boolean isSameDefinition = true;
            for (PsiElement def : defs) {
                isSameDefinition &= InlineLocalHandler.isSameDefinition(def, defToInline);
            }
            if (isSameDefinition) continue;
            highlightManager.addOccurrenceHighlights(editor, defs, EditorColors.WRITE_SEARCH_RESULT_ATTRIBUTES, true, null);
            highlightManager.addOccurrenceHighlights(editor, new PsiElement[]{ref2}, EditorColors.SEARCH_RESULT_ATTRIBUTES, true, null);
            String message6 = RefactoringBundle.getCannotRefactorMessage((String)RefactoringBundle.message((String)"variable.is.accessed.for.writing.and.used.with.inlined", (Object[])new Object[]{localName}));
            CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)message6, (String)InlineLocalHandler.getRefactoringName((PsiElement)local), (String)"refactoring.inlineVariable");
            WindowManager.getInstance().getStatusBar(project).setInfo(RefactoringBundle.message((String)"press.escape.to.remove.the.highlighting"));
            return null;
        }
        PsiElement writeAccess = InlineLocalHandler.checkRefsInAugmentedAssignmentOrUnaryModified((PsiElement[])refsToInline, (PsiElement)defToInline);
        if (writeAccess != null) {
            HighlightManager.getInstance((Project)project).addOccurrenceHighlights(editor, new PsiElement[]{writeAccess}, EditorColors.WRITE_SEARCH_RESULT_ATTRIBUTES, true, null);
            String message7 = RefactoringBundle.getCannotRefactorMessage((String)JavaRefactoringBundle.message((String)"variable.is.accessed.for.writing", (Object[])new Object[]{localName}));
            CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)message7, (String)InlineLocalHandler.getRefactoringName((PsiElement)local), (String)"refactoring.inlineVariable");
            WindowManager.getInstance().getStatusBar(project).setInfo(RefactoringBundle.message((String)"press.escape.to.remove.the.highlighting"));
            return null;
        }
        if (Arrays.stream(refsToInline).anyMatch(ref -> ref.getParent() instanceof PsiResourceExpression)) {
            CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)RefactoringBundle.getCannotRefactorMessage((String)JavaRefactoringBundle.message((String)"inline.local.used.as.resource.cannot.refactor.message", (Object[])new Object[0])), (String)InlineLocalHandler.getRefactoringName((PsiElement)local), (String)"refactoring.inlineVariable");
            return null;
        }
        return () -> InlineLocalHandler.lambda$prepareLocalInline$9((PsiElement[])refsToInline, project, local, defToInline, inlineAll, editor, containingClass);
    }

    @NotNull
    static List<SmartPsiElementPointer<PsiExpression>> inlineOccurrences(@NotNull Project project, @NotNull PsiVariable local, PsiExpression defToInline, PsiElement[] refsToInline) {
        if (project == null) {
            InlineLocalHandler.$$$reportNull$$$0(17);
        }
        if (local == null) {
            InlineLocalHandler.$$$reportNull$$$0(18);
        }
        ArrayList<SmartPsiElementPointer<PsiExpression>> pointers = new ArrayList<SmartPsiElementPointer<PsiExpression>>();
        SmartPointerManager pointerManager = SmartPointerManager.getInstance((Project)project);
        for (PsiElement element : refsToInline) {
            PsiJavaCodeReferenceElement refElement = (PsiJavaCodeReferenceElement)element;
            pointers.add((SmartPsiElementPointer<PsiExpression>)pointerManager.createSmartPsiElementPointer((PsiElement)InlineUtil.inlineVariable(local, defToInline, refElement)));
        }
        ArrayList<SmartPsiElementPointer<PsiExpression>> arrayList = pointers;
        if (arrayList == null) {
            InlineLocalHandler.$$$reportNull$$$0(19);
        }
        return arrayList;
    }

    static boolean askInlineAll(@NotNull Project project, @NotNull PsiVariable variable, @Nullable PsiReferenceExpression refExpr, @NotNull List<PsiElement> refsToInlineList) {
        if (project == null) {
            InlineLocalHandler.$$$reportNull$$$0(20);
        }
        if (variable == null) {
            InlineLocalHandler.$$$reportNull$$$0(21);
        }
        if (refsToInlineList == null) {
            InlineLocalHandler.$$$reportNull$$$0(22);
        }
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            return true;
        }
        int occurrencesCount = refsToInlineList.size();
        if (refExpr != null && EditorSettingsExternalizable.getInstance().isShowInlineLocalDialog()) {
            InlineLocalDialog inlineLocalDialog = new InlineLocalDialog(project, variable, (PsiJavaCodeReferenceElement)refExpr, occurrencesCount);
            if (!inlineLocalDialog.showAndGet()) {
                WindowManager.getInstance().getStatusBar(project).setInfo(RefactoringBundle.message((String)"press.escape.to.remove.the.highlighting"));
                refsToInlineList.clear();
                return false;
            }
            if (inlineLocalDialog.isInlineThis()) {
                refsToInlineList.clear();
                refsToInlineList.add((PsiElement)refExpr);
                return false;
            }
        }
        return true;
    }

    static void highlightOccurrences(@NotNull Project project, @Nullable Editor editor, @NotNull List<SmartPsiElementPointer<PsiExpression>> exprs) {
        if (project == null) {
            InlineLocalHandler.$$$reportNull$$$0(23);
        }
        if (exprs == null) {
            InlineLocalHandler.$$$reportNull$$$0(24);
        }
        if (editor != null && !ApplicationManager.getApplication().isUnitTestMode()) {
            PsiExpression[] occurrences = (PsiExpression[])ContainerUtil.map2Array(exprs, (Object[])new PsiExpression[exprs.size()], SmartPsiElementPointer::getElement);
            HighlightManager.getInstance((Project)project).addOccurrenceHighlights(editor, (PsiElement[])occurrences, EditorColors.SEARCH_RESULT_ATTRIBUTES, true, null);
            if (exprs.size() > 1) {
                Shortcut shortcut = KeymapUtil.getPrimaryShortcut((String)"FindNext");
                String message2 = shortcut != null ? "Press " + KeymapUtil.getShortcutText((Shortcut)shortcut) + " to go through " + exprs.size() + " inlined occurrences" : exprs.size() + " occurrences were inlined";
                HintManagerImpl.getInstanceImpl().showInformationHint(editor, message2, (short)2);
            }
            WindowManager.getInstance().getStatusBar(project).setInfo(RefactoringBundle.message((String)"press.escape.to.remove.the.highlighting"));
        }
    }

    private static void processWrappedAnalysisCanceledException(@NotNull Project project, Editor editor, RuntimeException e) {
        Throwable cause;
        if (project == null) {
            InlineLocalHandler.$$$reportNull$$$0(25);
        }
        if ((cause = e.getCause()) instanceof AnalysisCanceledException) {
            CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)RefactoringBundle.getCannotRefactorMessage((String)JavaRefactoringBundle.message((String)"extract.method.control.flow.analysis.failed", (Object[])new Object[0])), (String)RefactoringBundle.message((String)"inline.variable.title"), (String)"refactoring.inlineVariable");
            return;
        }
        throw e;
    }

    private static void deleteInitializer(@NotNull PsiExpression defToInline) {
        PsiElement gParent;
        PsiElement parent;
        if (defToInline == null) {
            InlineLocalHandler.$$$reportNull$$$0(26);
        }
        if ((parent = defToInline.getParent()) instanceof PsiAssignmentExpression && !((gParent = PsiUtil.skipParenthesizedExprUp((PsiElement)parent.getParent())) instanceof PsiExpressionStatement)) {
            parent.replace((PsiElement)defToInline);
            return;
        }
        parent.delete();
    }

    @Nullable
    static PsiElement checkRefsInAugmentedAssignmentOrUnaryModified(PsiElement[] refsToInline, PsiElement defToInline) {
        for (PsiElement element : refsToInline) {
            PsiElement parent = element.getParent();
            if (parent instanceof PsiArrayAccessExpression) {
                if (((PsiArrayAccessExpression)parent).getIndexExpression() == element || defToInline instanceof PsiExpression && !(defToInline instanceof PsiNewExpression)) continue;
                element = parent;
            }
            if (!RefactoringUtil.isAssignmentLHS(element)) continue;
            return element;
        }
        return null;
    }

    private static boolean isSameDefinition(PsiElement def, PsiExpression defToInline) {
        if (def instanceof PsiLocalVariable) {
            return defToInline.equals(((PsiLocalVariable)def).getInitializer());
        }
        PsiElement parent = def.getParent();
        return parent instanceof PsiAssignmentExpression && defToInline.equals(((PsiAssignmentExpression)parent).getRExpression());
    }

    private static boolean isInliningVariableInitializer(PsiExpression defToInline) {
        return defToInline.getParent() instanceof PsiVariable;
    }

    @Nullable
    static PsiExpression getDefToInline(PsiVariable local, PsiElement refExpr, @NotNull PsiCodeBlock block, boolean rethrow) {
        if (block == null) {
            InlineLocalHandler.$$$reportNull$$$0(27);
        }
        if (refExpr != null) {
            PsiElement def;
            if (refExpr instanceof PsiReferenceExpression && PsiUtil.isAccessedForWriting((PsiExpression)((PsiExpression)refExpr))) {
                def = refExpr;
            } else {
                PsiElement[] defs = DefUseUtil.getDefs(block, local, refExpr, rethrow);
                if (defs.length == 1) {
                    def = defs[0];
                } else {
                    return null;
                }
            }
            if (def instanceof PsiReferenceExpression && def.getParent() instanceof PsiAssignmentExpression) {
                PsiAssignmentExpression assignmentExpression = (PsiAssignmentExpression)def.getParent();
                if (assignmentExpression.getOperationTokenType() != JavaTokenType.EQ) {
                    return null;
                }
                PsiExpression rExpr = assignmentExpression.getRExpression();
                if (rExpr != null) {
                    return rExpr;
                }
            }
        }
        return local.getInitializer();
    }

    @Nullable
    public String getActionName(PsiElement element) {
        return InlineLocalHandler.getRefactoringName(element);
    }

    private static String getRefactoringName(PsiElement variable) {
        return variable instanceof PsiPatternVariable ? JavaRefactoringBundle.message((String)"inline.pattern.variable.title", (Object[])new Object[0]) : RefactoringBundle.message((String)"inline.variable.title");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static /* synthetic */ void lambda$prepareLocalInline$9(PsiElement[] refsToInline, Project project, PsiLocalVariable local, PsiExpression defToInline, boolean inlineAll, Editor editor, PsiElement containingClass) {
        String refactoringId = "refactoring.inline.local.variable";
        try {
            RefactoringEventData beforeData = new RefactoringEventData();
            beforeData.addElements(refsToInline);
            ((RefactoringEventListener)project.getMessageBus().syncPublisher(RefactoringEventListener.REFACTORING_EVENT_TOPIC)).refactoringStarted("refactoring.inline.local.variable", beforeData);
            List exprs = (List)WriteAction.compute(() -> {
                List<SmartPsiElementPointer<PsiExpression>> pointers = InlineLocalHandler.inlineOccurrences(project, (PsiVariable)local, defToInline, refsToInline);
                if (inlineAll) {
                    if (!InlineLocalHandler.isInliningVariableInitializer(defToInline)) {
                        InlineLocalHandler.deleteInitializer(defToInline);
                    } else {
                        defToInline.delete();
                    }
                }
                return pointers;
            });
            if (inlineAll && ReferencesSearch.search((PsiElement)local).findFirst() == null) {
                QuickFixFactory.getInstance().createRemoveUnusedVariableFix((PsiVariable)local).invoke(project, editor, local.getContainingFile());
            }
            InlineLocalHandler.highlightOccurrences(project, editor, exprs);
            WriteAction.run(() -> {
                for (SmartPsiElementPointer expr2 : exprs) {
                    InlineUtil.tryToInlineArrayCreationForVarargs((PsiExpression)expr2.getElement());
                }
            });
        }
        finally {
            RefactoringEventData afterData = new RefactoringEventData();
            afterData.addElement(containingClass);
            ((RefactoringEventListener)project.getMessageBus().syncPublisher(RefactoringEventListener.REFACTORING_EVENT_TOPIC)).refactoringDone("refactoring.inline.local.variable", afterData);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 19: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 19: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 4: 
            case 7: 
            case 10: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 2: 
            case 15: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "local";
                break;
            }
            case 5: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "var";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pattern";
                break;
            }
            case 12: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "allRefs";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/refactoring/inline/InlineLocalHandler";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "variable";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "refsToInlineList";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "exprs";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "defToInline";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "block";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/refactoring/inline/InlineLocalHandler";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "inlineOccurrences";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "inlineVariable";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "doInline";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "preparePatternInline";
                break;
            }
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "prepareLocalInline";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "inlineOccurrences";
                break;
            }
            case 19: {
                break;
            }
            case 20: 
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "askInlineAll";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "highlightOccurrences";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "processWrappedAnalysisCanceledException";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "deleteInitializer";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "getDefToInline";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 19: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

