/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.extractMethodObject.reflect;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.ClassUtil;
import com.intellij.refactoring.extractMethodObject.ItemToReplaceDescriptor;
import com.intellij.refactoring.extractMethodObject.reflect.FieldAccessType;
import com.intellij.refactoring.extractMethodObject.reflect.MemberQualifierUtil;
import com.intellij.refactoring.extractMethodObject.reflect.PsiReflectionAccessUtil;
import com.intellij.refactoring.extractMethodObject.reflect.ReflectionAccessMethodBuilder;
import java.lang.reflect.Array;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FieldDescriptor
implements ItemToReplaceDescriptor {
    private static final Logger LOG = Logger.getInstance(FieldDescriptor.class);
    private final PsiField myField;
    private final PsiReferenceExpression myExpression;
    private final String myAccessibleType;

    private FieldDescriptor(@NotNull PsiField field, @NotNull PsiReferenceExpression expression2) {
        if (field == null) {
            FieldDescriptor.$$$reportNull$$$0(0);
        }
        if (expression2 == null) {
            FieldDescriptor.$$$reportNull$$$0(1);
        }
        this.myField = field;
        this.myExpression = expression2;
        String fieldType = PsiReflectionAccessUtil.getAccessibleReturnType((PsiExpression)this.myExpression, FieldDescriptor.resolveFieldType(this.myField, this.myExpression));
        if (fieldType == null) {
            LOG.warn("Could not resolve field type. java.lang.Object will be used instead");
            fieldType = "java.lang.Object";
        }
        this.myAccessibleType = fieldType;
    }

    @Nullable
    public static ItemToReplaceDescriptor createIfInaccessible(@NotNull PsiClass outerClass, @NotNull PsiReferenceExpression expression2) {
        PsiField field;
        PsiClass containingClass;
        PsiElement resolved;
        if (outerClass == null) {
            FieldDescriptor.$$$reportNull$$$0(2);
        }
        if (expression2 == null) {
            FieldDescriptor.$$$reportNull$$$0(3);
        }
        if ((resolved = expression2.resolve()) instanceof PsiField && !Objects.equals(containingClass = (field = (PsiField)resolved).getContainingClass(), outerClass) && FieldDescriptor.needReplace(outerClass, field, expression2)) {
            Array.getLength(new int[3]);
            return new FieldDescriptor(field, expression2);
        }
        return null;
    }

    @Override
    public void replace(@NotNull PsiClass outerClass, @NotNull PsiElementFactory elementFactory, @NotNull PsiMethodCallExpression callExpression) {
        PsiElement parent;
        if (outerClass == null) {
            FieldDescriptor.$$$reportNull$$$0(4);
        }
        if (elementFactory == null) {
            FieldDescriptor.$$$reportNull$$$0(5);
        }
        if (callExpression == null) {
            FieldDescriptor.$$$reportNull$$$0(6);
        }
        if ((parent = this.myExpression.getParent()) instanceof PsiAssignmentExpression && Objects.equals(this.myExpression, ((PsiAssignmentExpression)parent).getLExpression())) {
            this.grantUpdateAccess((PsiAssignmentExpression)parent, outerClass, callExpression, elementFactory);
        } else {
            this.grantReadAccess(outerClass, callExpression, elementFactory);
        }
    }

    private void grantReadAccess(@NotNull PsiClass outerClass, @NotNull PsiMethodCallExpression generatedCall, @NotNull PsiElementFactory elementFactory) {
        PsiMethod newMethod;
        if (outerClass == null) {
            FieldDescriptor.$$$reportNull$$$0(7);
        }
        if (generatedCall == null) {
            FieldDescriptor.$$$reportNull$$$0(8);
        }
        if (elementFactory == null) {
            FieldDescriptor.$$$reportNull$$$0(9);
        }
        if ((newMethod = this.createPsiMethod(FieldAccessType.GET, outerClass, elementFactory)) == null) {
            return;
        }
        outerClass.add((PsiElement)newMethod);
        String object = MemberQualifierUtil.findObjectExpression(this.myExpression, (PsiMember)this.myField, outerClass, generatedCall, elementFactory);
        String methodCall = newMethod.getName() + "(" + (object == null ? "null" : object) + ", null)";
        this.myExpression.replace((PsiElement)elementFactory.createExpressionFromText(methodCall, (PsiElement)this.myExpression));
    }

    private void grantUpdateAccess(@NotNull PsiAssignmentExpression assignmentExpression, @NotNull PsiClass outerClass, @NotNull PsiMethodCallExpression generatedCall, @NotNull PsiElementFactory elementFactory) {
        PsiMethod newMethod;
        if (assignmentExpression == null) {
            FieldDescriptor.$$$reportNull$$$0(10);
        }
        if (outerClass == null) {
            FieldDescriptor.$$$reportNull$$$0(11);
        }
        if (generatedCall == null) {
            FieldDescriptor.$$$reportNull$$$0(12);
        }
        if (elementFactory == null) {
            FieldDescriptor.$$$reportNull$$$0(13);
        }
        if ((newMethod = this.createPsiMethod(FieldAccessType.SET, outerClass, elementFactory)) == null) {
            return;
        }
        outerClass.add((PsiElement)newMethod);
        PsiExpression rightExpression = assignmentExpression.getRExpression();
        if (rightExpression == null) {
            LOG.warn("Expression representing a new field value not found");
            return;
        }
        String newValue = rightExpression.getText();
        String objectForReference = MemberQualifierUtil.findObjectExpression(this.myExpression, (PsiMember)this.myField, outerClass, generatedCall, elementFactory);
        String args = (objectForReference == null ? "null" : objectForReference) + ", " + newValue;
        String methodCallExpression = newMethod.getName() + "(" + args + ")";
        PsiExpression newMethodCallExpression = elementFactory.createExpressionFromText(methodCallExpression, (PsiElement)this.myExpression);
        assignmentExpression.replace((PsiElement)newMethodCallExpression);
    }

    @Nullable
    private PsiMethod createPsiMethod(FieldAccessType accessType, PsiClass outerClass, PsiElementFactory elementFactory) {
        PsiClass containingClass = this.myField.getContainingClass();
        String className2 = containingClass == null ? null : ClassUtil.getJVMClassName((PsiClass)containingClass);
        String fieldName = this.myField.getName();
        if (className2 == null) {
            LOG.warn("Code is incomplete. Class name or field name not found");
            return null;
        }
        String methodName = PsiReflectionAccessUtil.getUniqueMethodName(outerClass, "accessToField" + StringUtil.capitalize((String)fieldName));
        ReflectionAccessMethodBuilder methodBuilder = new ReflectionAccessMethodBuilder(methodName);
        if (FieldAccessType.GET.equals((Object)accessType)) {
            methodBuilder.accessedField(className2, fieldName).setReturnType(this.myAccessibleType);
        } else {
            methodBuilder.updatedField(className2, fieldName).setReturnType("void");
        }
        methodBuilder.setStatic(outerClass.hasModifierProperty("static")).addParameter("java.lang.Object", "object").addParameter("java.lang.Object", "value");
        return methodBuilder.build(elementFactory, (PsiElement)outerClass);
    }

    private static boolean needReplace(@NotNull PsiClass outerClass, @NotNull PsiField field, @NotNull PsiReferenceExpression expression2) {
        if (outerClass == null) {
            FieldDescriptor.$$$reportNull$$$0(14);
        }
        if (field == null) {
            FieldDescriptor.$$$reportNull$$$0(15);
        }
        if (expression2 == null) {
            FieldDescriptor.$$$reportNull$$$0(16);
        }
        return !PsiReflectionAccessUtil.isAccessibleMember((PsiMember)field, outerClass, expression2.getQualifierExpression());
    }

    @NotNull
    private static PsiType resolveFieldType(@NotNull PsiField field, @NotNull PsiReferenceExpression referenceExpression) {
        if (field == null) {
            FieldDescriptor.$$$reportNull$$$0(17);
        }
        if (referenceExpression == null) {
            FieldDescriptor.$$$reportNull$$$0(18);
        }
        PsiType rawType = field.getType();
        PsiType psiType = referenceExpression.advancedResolve(false).getSubstitutor().substitute(rawType);
        if (psiType == null) {
            FieldDescriptor.$$$reportNull$$$0(19);
        }
        return psiType;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 19: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 19: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "field";
                break;
            }
            case 1: 
            case 3: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 2: 
            case 4: 
            case 7: 
            case 11: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outerClass";
                break;
            }
            case 5: 
            case 9: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementFactory";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callExpression";
                break;
            }
            case 8: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "generatedCall";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "assignmentExpression";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "referenceExpression";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/refactoring/extractMethodObject/reflect/FieldDescriptor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/refactoring/extractMethodObject/reflect/FieldDescriptor";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveFieldType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createIfInaccessible";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "replace";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "grantReadAccess";
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "grantUpdateAccess";
                break;
            }
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "needReplace";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "resolveFieldType";
                break;
            }
            case 19: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 19: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

