/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.extractMethod.preview;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.actions.exclusion.ExclusionHandler;
import com.intellij.java.refactoring.JavaRefactoringBundle;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Disposer;
import com.intellij.pom.Navigatable;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.impl.PsiDocumentManagerBase;
import com.intellij.refactoring.extractMethod.ExtractMethodProcessor;
import com.intellij.refactoring.extractMethod.preview.ExtractMethodPreviewManager;
import com.intellij.refactoring.extractMethod.preview.PreviewDiffPanel;
import com.intellij.refactoring.extractMethod.preview.PreviewExclusionHandler;
import com.intellij.refactoring.extractMethod.preview.PreviewTree;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.OnePixelSplitter;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.content.Content;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.usages.impl.UsageModelTracker;
import com.intellij.util.Alarm;
import com.intellij.util.ui.DialogUtil;
import com.intellij.util.ui.components.BorderLayoutPanel;
import java.awt.Component;
import java.awt.FlowLayout;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.tree.DefaultMutableTreeNode;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class PreviewPanel
extends BorderLayoutPanel
implements Disposable,
DataProvider {
    private final Project myProject;
    private final PreviewTree myTree;
    private final ExclusionHandler<DefaultMutableTreeNode> myExclusionHandler;
    private final ButtonsPanel myButtonsPanel;
    private Content myContent;
    private final PreviewDiffPanel myDiffPanel;
    private final Alarm myUpdateAlarm = new Alarm(Alarm.ThreadToUse.SWING_THREAD);

    PreviewPanel(ExtractMethodProcessor processor2) {
        this.myProject = processor2.getProject();
        this.myTree = new PreviewTree(processor2);
        JScrollPane treePane = ScrollPaneFactory.createScrollPane((Component)this.myTree.getComponent());
        treePane.setBorder(IdeBorderFactory.createBorder((int)8));
        this.myDiffPanel = new PreviewDiffPanel(processor2, this.myTree);
        this.myTree.addTreeListener(this.myDiffPanel);
        BorderLayoutPanel leftPanel = new BorderLayoutPanel();
        leftPanel.addToCenter((Component)treePane);
        this.myButtonsPanel = new ButtonsPanel(this.myProject);
        leftPanel.addToBottom((Component)this.myButtonsPanel);
        OnePixelSplitter splitter = new OnePixelSplitter(false);
        splitter.setProportion(0.3f);
        splitter.setFirstComponent((JComponent)leftPanel);
        splitter.setSecondComponent((JComponent)((Object)this.myDiffPanel));
        this.addToCenter((Component)splitter);
        this.myExclusionHandler = new PreviewExclusionHandler(this);
        UsageModelTracker usageModelTracker = new UsageModelTracker(this.myProject);
        Disposer.register((Disposable)this, (Disposable)usageModelTracker);
        usageModelTracker.addListener(isPropertyChange -> this.updateLater(), (Disposable)this);
        Disposer.register((Disposable)processor2.getProject(), (Disposable)this);
        Disposer.register((Disposable)this, (Disposable)this.myTree);
        Disposer.register((Disposable)this, (Disposable)this.myDiffPanel);
    }

    /*
     * Exception decompiling
     */
    @Nullable
    public Object getData(@NotNull String dataId) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.UnsupportedOperationException
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.NewAnonymousArray.getDimSize(NewAnonymousArray.java:142)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.isNewArrayLambda(LambdaRewriter.java:455)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:409)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:167)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:105)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriterToArgs(AbstractMemberFunctionInvokation.java:101)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:87)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredReturn.rewriteExpressions(StructuredReturn.java:99)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewrite(LambdaRewriter.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.rewriteLambdas(Op04StructuredStatement.java:1137)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:912)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void setContent(Content content) {
        this.myContent = content;
        content.setDisposer((Disposable)this);
    }

    public void initLater() {
        this.myDiffPanel.initLater();
    }

    public void dispose() {
    }

    private void close() {
        if (this.myContent != null) {
            ExtractMethodPreviewManager.getInstance(this.myProject).closeContent(this.myContent);
        }
    }

    private void doRefactor() {
        if (this.myTree.isValid()) {
            this.myDiffPanel.doExtract();
            this.close();
            return;
        }
        if (Messages.showYesNoDialog((Project)this.myProject, (String)JavaRefactoringBundle.message((String)"project.files.have.been.changed", (Object[])new Object[0]), (String)JavaRefactoringBundle.message((String)"re.run.refactoring", (Object[])new Object[0]), null) == 0) {
            this.close();
            this.myDiffPanel.tryExtractAgain();
        }
    }

    private void rerunRefactoring() {
        this.close();
        this.myDiffPanel.tryExtractAgain();
    }

    void onTreeUpdated() {
        this.myTree.repaint();
        this.myDiffPanel.updateLater();
    }

    private void updateLater() {
        this.myUpdateAlarm.cancelAllRequests();
        this.myUpdateAlarm.addRequest(() -> {
            if (this.myProject.isDisposed()) {
                return;
            }
            PsiDocumentManagerBase documentManager = (PsiDocumentManagerBase)PsiDocumentManager.getInstance((Project)this.myProject);
            documentManager.cancelAndRunWhenAllCommitted((Object)"ExtractMethodPreview", this::updateImmediately);
        }, 300);
    }

    private void updateImmediately() {
        ApplicationManager.getApplication().assertIsDispatchThread();
        if (this.myProject.isDisposed()) {
            return;
        }
        boolean isModified = this.myDiffPanel.isModified();
        if (this.myButtonsPanel.updateButtons(isModified)) {
            this.myTree.setValid(!isModified);
        }
    }

    private static /* synthetic */ Navigatable[] lambda$getData$2(int x$0) {
        return new Navigatable[x$0];
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataId", "com/intellij/refactoring/extractMethod/preview/PreviewPanel", "getData"));
    }

    private class ButtonsPanel
    extends JPanel {
        private final JButton myRefactorButton;
        private final JButton myRerunButton;
        private final JButton myCancelButton;
        private final Project myProject;
        private boolean myModified;

        ButtonsPanel(Project project) {
            if (project == null) {
                ButtonsPanel.$$$reportNull$$$0(0);
            }
            super(new FlowLayout(0, JBUIScale.scale((int)8), 0));
            this.myProject = project;
            this.myRefactorButton = new JButton(JavaRefactoringBundle.message((String)"refactoring.extract.method.preview.button.refactor", (Object[])new Object[0]));
            DialogUtil.registerMnemonic((AbstractButton)this.myRefactorButton);
            this.myRefactorButton.addActionListener(e -> PreviewPanel.this.doRefactor());
            this.add(this.myRefactorButton);
            this.myRerunButton = new JButton(JavaRefactoringBundle.message((String)"refactoring.extract.method.preview.button.rerun", (Object[])new Object[0]));
            DialogUtil.registerMnemonic((AbstractButton)this.myRefactorButton);
            this.myRerunButton.addActionListener(e -> PreviewPanel.this.rerunRefactoring());
            this.add(this.myRerunButton);
            this.myCancelButton = new JButton(IdeBundle.message((String)"button.cancel", (Object[])new Object[0]));
            DialogUtil.registerMnemonic((AbstractButton)this.myRefactorButton);
            this.myCancelButton.addActionListener(e -> PreviewPanel.this.close());
            this.add(this.myCancelButton);
            this.updateButtonsImpl(false, false);
            project.getMessageBus().connect((Disposable)PreviewPanel.this).subscribe(DumbService.DUMB_MODE, (Object)new DumbService.DumbModeListener(){

                public void enteredDumbMode() {
                    ButtonsPanel.this.updateButtonsLater(true);
                }

                public void exitDumbMode() {
                    ButtonsPanel.this.updateButtonsLater(false);
                }
            });
        }

        boolean updateButtons(boolean isModified) {
            if (this.myModified == isModified) {
                return false;
            }
            this.myModified = isModified;
            this.updateButtonsImpl(DumbService.isDumb((Project)this.myProject), isModified);
            return true;
        }

        void updateButtonsLater(boolean isDumb) {
            ApplicationManager.getApplication().invokeLater(() -> this.updateButtonsImpl(isDumb, this.myModified));
        }

        private void updateButtonsImpl(boolean isDumb, boolean isModified) {
            this.myRefactorButton.setEnabled(!isDumb && !isModified);
            this.myRefactorButton.setVisible(!isModified);
            this.myRerunButton.setEnabled(!isDumb && isModified);
            this.myRerunButton.setVisible(isModified);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/refactoring/extractMethod/preview/PreviewPanel$ButtonsPanel", "<init>"));
        }
    }
}

