/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.changeSignature;

import com.intellij.lang.java.JavaLanguage;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFunctionalExpression;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodReferenceExpression;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiRecordComponent;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.impl.light.LightRecordMethod;
import com.intellij.psi.javadoc.PsiDocTagValue;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.FunctionalExpressionSearch;
import com.intellij.psi.search.searches.MethodReferencesSearch;
import com.intellij.psi.search.searches.OverridingMethodsSearch;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.JavaPsiRecordUtil;
import com.intellij.psi.xml.XmlElement;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.changeSignature.CallReferenceUsageInfo;
import com.intellij.refactoring.changeSignature.CallerUsageInfo;
import com.intellij.refactoring.changeSignature.ChangeSignatureParameterUsageInfo;
import com.intellij.refactoring.changeSignature.FunctionalInterfaceChangedUsageInfo;
import com.intellij.refactoring.changeSignature.JavaChangeInfo;
import com.intellij.refactoring.changeSignature.JavaChangeInfoImpl;
import com.intellij.refactoring.changeSignature.JavaParameterInfo;
import com.intellij.refactoring.changeSignature.MethodCallUsageInfo;
import com.intellij.refactoring.changeSignature.MethodReferenceUsageInfo;
import com.intellij.refactoring.changeSignature.NewParameterCollidesWithLocalUsageInfo;
import com.intellij.refactoring.changeSignature.OverriderUsageInfo;
import com.intellij.refactoring.changeSignature.ParameterInfo;
import com.intellij.refactoring.changeSignature.PsiCallReference;
import com.intellij.refactoring.changeSignature.RecordGetterDeclarationUsageInfo;
import com.intellij.refactoring.rename.JavaUnresolvableLocalCollisionDetector;
import com.intellij.refactoring.rename.UnresolvableCollisionUsageInfo;
import com.intellij.refactoring.util.MoveRenameUsageInfo;
import com.intellij.refactoring.util.RefactoringUIUtil;
import com.intellij.refactoring.util.RefactoringUtil;
import com.intellij.refactoring.util.usageInfo.DefaultConstructorImplicitUsageInfo;
import com.intellij.refactoring.util.usageInfo.NoConstructorClassUsageInfo;
import com.intellij.usageView.UsageInfo;
import com.intellij.usageView.UsageViewUtil;
import com.intellij.util.containers.ContainerUtil;
import com.siyeh.ig.psiutils.VariableAccessUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;

class JavaChangeSignatureUsageSearcher {
    private final JavaChangeInfo myChangeInfo;
    private static final Logger LOG = Logger.getInstance(JavaChangeSignatureUsageSearcher.class);

    JavaChangeSignatureUsageSearcher(JavaChangeInfo changeInfo) {
        this.myChangeInfo = changeInfo;
    }

    public UsageInfo[] findUsages() {
        ArrayList result = new ArrayList();
        PsiMethod method = this.myChangeInfo.getMethod();
        if (method != null) {
            this.findSimpleUsages(method, result);
            UsageInfo[] usageInfos = result.toArray(UsageInfo.EMPTY_ARRAY);
            return UsageViewUtil.removeDuplicatedUsages((UsageInfo[])usageInfos);
        }
        return UsageInfo.EMPTY_ARRAY;
    }

    private void findSimpleUsages(PsiMethod method, ArrayList<? super UsageInfo> result) {
        PsiMethod[] overridingMethods = this.findSimpleUsagesWithoutParameters(method, result, true, true, true);
        this.findUsagesInCallers(result);
        ArrayList<PsiMethod> methods = new ArrayList<PsiMethod>(Arrays.asList(overridingMethods));
        methods.add(method);
        for (PsiMethod psiMethod : methods) {
            for (PsiFunctionalExpression functionalExpression : FunctionalExpressionSearch.search((PsiMethod)psiMethod)) {
                result.add(new FunctionalInterfaceChangedUsageInfo((PsiElement)functionalExpression, psiMethod));
            }
        }
        this.findParametersUsage(method, result, overridingMethods);
    }

    private void findUsagesInCallers(ArrayList<? super UsageInfo> usages) {
        if (this.myChangeInfo instanceof JavaChangeInfoImpl) {
            JavaChangeInfoImpl changeInfo = (JavaChangeInfoImpl)this.myChangeInfo;
            for (PsiMethod caller : changeInfo.propagateParametersMethods) {
                usages.add(new CallerUsageInfo(caller, true, changeInfo.propagateExceptionsMethods.contains(caller)));
            }
            for (PsiMethod caller : changeInfo.propagateExceptionsMethods) {
                usages.add(new CallerUsageInfo(caller, changeInfo.propagateParametersMethods.contains(caller), true));
            }
            HashSet<PsiMethod> merged = new HashSet<PsiMethod>();
            merged.addAll(changeInfo.propagateParametersMethods);
            merged.addAll(changeInfo.propagateExceptionsMethods);
            for (PsiMethod method : merged) {
                this.findSimpleUsagesWithoutParameters(method, usages, changeInfo.propagateParametersMethods.contains(method), changeInfo.propagateExceptionsMethods.contains(method), false);
            }
        }
    }

    private void detectLocalsCollisionsInMethod(final PsiMethod method, final ArrayList<? super UsageInfo> result, boolean isOriginal) {
        if (!JavaLanguage.INSTANCE.equals(method.getLanguage())) {
            return;
        }
        Object[] parameters2 = method.getParameterList().getParameters();
        final HashSet deletedOrRenamedParameters = new HashSet();
        if (isOriginal) {
            ContainerUtil.addAll(deletedOrRenamedParameters, (Object[])parameters2);
            for (JavaParameterInfo parameterInfo : this.myChangeInfo.getNewParameters()) {
                if (parameterInfo.getOldIndex() < 0 || parameterInfo.getOldIndex() >= parameters2.length) continue;
                Object parameter2 = parameters2[parameterInfo.getOldIndex()];
                if (!parameterInfo.getName().equals(parameter2.getName())) continue;
                deletedOrRenamedParameters.remove(parameter2);
            }
        }
        for (JavaParameterInfo parameterInfo : this.myChangeInfo.getNewParameters()) {
            int oldParameterIndex = parameterInfo.getOldIndex();
            String newName = parameterInfo.getName();
            if (oldParameterIndex >= 0) {
                Object parameter3;
                if (!isOriginal || oldParameterIndex >= parameters2.length || newName.equals(this.myChangeInfo.getOldParameterNames()[oldParameterIndex]) || newName.equals((parameter3 = parameters2[oldParameterIndex]).getName())) continue;
                JavaUnresolvableLocalCollisionDetector.visitLocalsCollisions((PsiElement)parameter3, newName, (PsiElement)method.getBody(), null, new JavaUnresolvableLocalCollisionDetector.CollidingVariableVisitor((PsiParameter)parameter3, method){
                    final /* synthetic */ PsiParameter val$parameter;
                    final /* synthetic */ PsiMethod val$method;
                    {
                        this.val$parameter = psiParameter;
                        this.val$method = psiMethod;
                    }

                    @Override
                    public void visitCollidingElement(PsiVariable collidingVariable) {
                        if (!deletedOrRenamedParameters.contains(collidingVariable)) {
                            result.add(new RenamedParameterCollidesWithLocalUsageInfo(this.val$parameter, (PsiElement)collidingVariable, this.val$method));
                        }
                    }
                });
                continue;
            }
            JavaUnresolvableLocalCollisionDetector.visitLocalsCollisions((PsiElement)method, newName, (PsiElement)method.getBody(), null, new JavaUnresolvableLocalCollisionDetector.CollidingVariableVisitor(){

                @Override
                public void visitCollidingElement(PsiVariable collidingVariable) {
                    if (!deletedOrRenamedParameters.contains(collidingVariable)) {
                        result.add(new NewParameterCollidesWithLocalUsageInfo((PsiElement)collidingVariable, (PsiElement)collidingVariable, method));
                    }
                }
            });
        }
    }

    private void findParametersUsage(PsiMethod method, ArrayList<? super UsageInfo> result, PsiMethod[] overriders) {
        if (JavaLanguage.INSTANCE.equals(this.myChangeInfo.getLanguage())) {
            PsiClass aClass = method.getContainingClass();
            PsiRecordComponent[] components = null;
            if (aClass != null && JavaPsiRecordUtil.isCanonicalConstructor(method)) {
                components = aClass.getRecordComponents();
            }
            PsiParameter[] parameters2 = method.getParameterList().getParameters();
            for (JavaParameterInfo info : this.myChangeInfo.getNewParameters()) {
                PsiMethod explicitGetter;
                PsiField field;
                boolean nameChanged;
                if (info.getOldIndex() < 0) continue;
                PsiParameter parameter2 = parameters2[info.getOldIndex()];
                boolean bl = nameChanged = !info.getName().equals(parameter2.getName());
                if (nameChanged) {
                    JavaChangeSignatureUsageSearcher.addParameterUsages((PsiNamedElement)parameter2, result, info);
                    for (PsiMethod overrider : overriders) {
                        PsiParameter parameter1 = overrider.getParameterList().getParameters()[info.getOldIndex()];
                        if (parameter1 == null || !Comparing.strEqual((String)parameter2.getName(), (String)parameter1.getName())) continue;
                        JavaChangeSignatureUsageSearcher.addParameterUsages((PsiNamedElement)parameter1, result, info);
                    }
                }
                if (components == null || components.length <= info.getOldIndex()) continue;
                PsiRecordComponent component = components[info.getOldIndex()];
                if (nameChanged && (field = JavaPsiRecordUtil.getFieldForComponent(component)) != null) {
                    for (PsiReferenceExpression reference : VariableAccessUtils.getVariableReferences((PsiVariable)field, (PsiElement)aClass)) {
                        ChangeSignatureParameterUsageInfo usageInfo = new ChangeSignatureParameterUsageInfo((PsiElement)reference, parameter2.getName(), info.getName());
                        result.add(usageInfo);
                    }
                }
                if ((explicitGetter = (PsiMethod)ContainerUtil.find((Object[])aClass.findMethodsByName(parameter2.getName(), false), m -> m.getParameterList().isEmpty())) == null) continue;
                if (nameChanged) {
                    JavaChangeSignatureUsageSearcher.addParameterUsages((PsiNamedElement)explicitGetter, result, info);
                }
                if (explicitGetter instanceof LightRecordMethod || !nameChanged && parameter2.getType().equalsToText(info.getTypeText())) continue;
                result.add(new RecordGetterDeclarationUsageInfo((PsiElement)explicitGetter, info.getName(), info.getTypeText()));
            }
        }
    }

    private static boolean shouldPropagateToNonPhysicalMethod(PsiMethod method, ArrayList<? super UsageInfo> result, PsiClass containingClass, Set<? extends PsiMethod> propagateMethods) {
        for (PsiMethod psiMethod : propagateMethods) {
            if (psiMethod.isPhysical() || !Comparing.strEqual((String)psiMethod.getName(), (String)containingClass.getName())) continue;
            result.add(new DefaultConstructorImplicitUsageInfo(psiMethod, containingClass, method));
            return true;
        }
        return false;
    }

    private PsiMethod[] findSimpleUsagesWithoutParameters(PsiMethod method, ArrayList<? super UsageInfo> result, boolean isToModifyArgs, boolean isToThrowExceptions, boolean isOriginal) {
        boolean needToChangeCalls;
        PsiMethod[] overridingMethods;
        GlobalSearchScope projectScope = GlobalSearchScope.projectScope((Project)method.getProject());
        for (PsiMethod overridingMethod : overridingMethods = (PsiMethod[])OverridingMethodsSearch.search((PsiMethod)method).toArray((Object[])PsiMethod.EMPTY_ARRAY)) {
            result.add(new OverriderUsageInfo(overridingMethod, method, isOriginal, isToModifyArgs, isToThrowExceptions));
        }
        boolean bl = needToChangeCalls = !this.myChangeInfo.isGenerateDelegate() && (this.myChangeInfo.isNameChanged() || this.myChangeInfo.isParameterSetOrOrderChanged() || this.myChangeInfo.isExceptionSetOrOrderChanged() || this.myChangeInfo.isVisibilityChanged());
        if (needToChangeCalls) {
            PsiReference[] refs;
            int parameterCount = method.getParameterList().getParametersCount();
            for (PsiReference ref : refs = (PsiReference[])MethodReferencesSearch.search((PsiMethod)method, (SearchScope)projectScope, (boolean)true).toArray((Object[])PsiReference.EMPTY_ARRAY)) {
                PsiExpressionList list;
                boolean isToCatchExceptions;
                PsiElement element = ref.getElement();
                boolean bl2 = isToCatchExceptions = isToThrowExceptions && this.needToCatchExceptions(RefactoringUtil.getEnclosingMethod(element));
                if (!isToCatchExceptions && RefactoringUtil.isMethodUsage(element) && ((list = RefactoringUtil.getArgumentListByMethodReference(element)) == null || !method.isVarArgs() && list.getExpressionCount() != parameterCount)) continue;
                if (RefactoringUtil.isMethodUsage(element)) {
                    result.add(new MethodCallUsageInfo(element, isToModifyArgs, isToCatchExceptions));
                    continue;
                }
                if (element instanceof PsiDocTagValue) {
                    result.add((UsageInfo)new UsageInfo(element));
                    continue;
                }
                if (element instanceof PsiMethod && ((PsiMethod)element).isConstructor()) {
                    if (!JavaLanguage.INSTANCE.equals(element.getLanguage())) continue;
                    DefaultConstructorImplicitUsageInfo implicitUsageInfo = new DefaultConstructorImplicitUsageInfo((PsiMethod)element, ((PsiMethod)element).getContainingClass(), method);
                    result.add(implicitUsageInfo);
                    continue;
                }
                if (element instanceof PsiClass) {
                    LOG.assertTrue(method.isConstructor());
                    PsiClass psiClass = (PsiClass)element;
                    if (!JavaLanguage.INSTANCE.equals(psiClass.getLanguage()) || this.myChangeInfo instanceof JavaChangeInfoImpl && (JavaChangeSignatureUsageSearcher.shouldPropagateToNonPhysicalMethod(method, result, psiClass, ((JavaChangeInfoImpl)this.myChangeInfo).propagateParametersMethods) || JavaChangeSignatureUsageSearcher.shouldPropagateToNonPhysicalMethod(method, result, psiClass, ((JavaChangeInfoImpl)this.myChangeInfo).propagateExceptionsMethods))) continue;
                    result.add(new NoConstructorClassUsageInfo(psiClass));
                    continue;
                }
                if (ref instanceof PsiCallReference) {
                    result.add(new CallReferenceUsageInfo((PsiCallReference)ref));
                    continue;
                }
                if (element instanceof PsiMethodReferenceExpression && MethodReferenceUsageInfo.needToExpand(this.myChangeInfo)) {
                    result.add(new MethodReferenceUsageInfo(element, method, isToModifyArgs, isToCatchExceptions));
                    continue;
                }
                result.add((UsageInfo)new MoveRenameUsageInfo(element, ref, (PsiElement)method));
            }
        } else if (this.myChangeInfo.isParameterTypesChanged()) {
            PsiReference[] refs;
            for (PsiReference reference : refs = (PsiReference[])MethodReferencesSearch.search((PsiMethod)method, (SearchScope)projectScope, (boolean)true).toArray((Object[])PsiReference.EMPTY_ARRAY)) {
                PsiElement element = reference.getElement();
                if (element instanceof PsiDocTagValue) {
                    result.add((UsageInfo)new UsageInfo(reference));
                    continue;
                }
                if (element instanceof XmlElement) {
                    result.add((UsageInfo)new MoveRenameUsageInfo(reference, (PsiElement)method));
                    continue;
                }
                if (!(element instanceof PsiMethodReferenceExpression)) continue;
                result.add((UsageInfo)new UsageInfo(reference));
            }
        }
        this.detectLocalsCollisionsInMethod(method, result, isOriginal);
        for (PsiMethod overridingMethod : overridingMethods) {
            this.detectLocalsCollisionsInMethod(overridingMethod, result, isOriginal);
        }
        return overridingMethods;
    }

    private static void addParameterUsages(PsiNamedElement parameter2, ArrayList<? super UsageInfo> results, ParameterInfo info) {
        PsiManager manager = parameter2.getManager();
        GlobalSearchScope projectScope = GlobalSearchScope.projectScope((Project)manager.getProject());
        for (PsiReference psiReference : ReferencesSearch.search((PsiElement)parameter2, (SearchScope)projectScope, (boolean)false)) {
            PsiElement parmRef = psiReference.getElement();
            ChangeSignatureParameterUsageInfo usageInfo = new ChangeSignatureParameterUsageInfo(parmRef, parameter2.getName(), info.getName());
            results.add(usageInfo);
        }
    }

    private boolean needToCatchExceptions(PsiMethod caller) {
        if (this.myChangeInfo instanceof JavaChangeInfoImpl) {
            return this.myChangeInfo.isExceptionSetOrOrderChanged() && !((JavaChangeInfoImpl)this.myChangeInfo).propagateExceptionsMethods.contains(caller);
        }
        return this.myChangeInfo.isExceptionSetOrOrderChanged();
    }

    private static class RenamedParameterCollidesWithLocalUsageInfo
    extends UnresolvableCollisionUsageInfo {
        private final PsiElement myCollidingElement;
        private final PsiMethod myMethod;

        RenamedParameterCollidesWithLocalUsageInfo(PsiParameter parameter2, PsiElement collidingElement, PsiMethod method) {
            super((PsiElement)parameter2, collidingElement);
            this.myCollidingElement = collidingElement;
            this.myMethod = method;
        }

        public String getDescription() {
            return RefactoringBundle.message((String)"there.is.already.a.0.in.the.1.it.will.conflict.with.the.renamed.parameter", (Object[])new Object[]{RefactoringUIUtil.getDescription((PsiElement)this.myCollidingElement, (boolean)true), RefactoringUIUtil.getDescription((PsiElement)this.myMethod, (boolean)true)});
        }
    }
}

