/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.changeSignature;

import com.intellij.codeInsight.JavaTargetElementEvaluator;
import com.intellij.ide.util.SuperMethodWarningUtil;
import com.intellij.java.refactoring.JavaRefactoringBundle;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.psi.PsiCallExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiRecordHeader;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReferenceParameterList;
import com.intellij.psi.PsiTypeParameterList;
import com.intellij.psi.util.JavaPsiRecordUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.changeClassSignature.ChangeClassSignatureDialog;
import com.intellij.refactoring.changeSignature.ChangeInfo;
import com.intellij.refactoring.changeSignature.ChangeSignatureHandler;
import com.intellij.refactoring.changeSignature.ChangeSignatureUtil;
import com.intellij.refactoring.changeSignature.JavaChangeInfo;
import com.intellij.refactoring.changeSignature.JavaChangeSignatureDialog;
import com.intellij.refactoring.changeSignature.JavaMethodDescriptor;
import com.intellij.refactoring.changeSignature.ParameterInfoImpl;
import com.intellij.refactoring.changeSignature.inplace.InplaceChangeSignature;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaChangeSignatureHandler
implements ChangeSignatureHandler {
    private static final Logger LOG = Logger.getInstance(JavaChangeSignatureHandler.class);

    public void invoke(@NotNull Project project, Editor editor, PsiFile file, DataContext dataContext) {
        if (project == null) {
            JavaChangeSignatureHandler.$$$reportNull$$$0(0);
        }
        editor.getScrollingModel().scrollToCaret(ScrollType.MAKE_VISIBLE);
        PsiElement element = this.findTargetMember(file, editor);
        if (element == null) {
            element = (PsiElement)CommonDataKeys.PSI_ELEMENT.getData(dataContext);
        }
        JavaChangeSignatureHandler.invokeOnElement(project, editor, element);
    }

    private static void invokeOnElement(Project project, @Nullable Editor editor, PsiElement element) {
        if (element instanceof PsiMethod && ((PsiMethod)element).getNameIdentifier() != null) {
            JavaChangeSignatureHandler.invoke((PsiMethod)element, project, editor);
        } else if (element instanceof PsiClass) {
            JavaChangeSignatureHandler.invoke((PsiClass)element, editor);
        } else {
            String message2 = RefactoringBundle.getCannotRefactorMessage((String)RefactoringBundle.message((String)"error.wrong.caret.position.method.or.class.name"));
            CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)message2, (String)REFACTORING_NAME, (String)"refactoring.changeSignature");
        }
    }

    public void invoke(@NotNull Project project, PsiElement @NotNull [] elements, @Nullable DataContext dataContext) {
        if (project == null) {
            JavaChangeSignatureHandler.$$$reportNull$$$0(1);
        }
        if (elements == null) {
            JavaChangeSignatureHandler.$$$reportNull$$$0(2);
        }
        if (elements.length != 1) {
            return;
        }
        Editor editor = dataContext != null ? (Editor)CommonDataKeys.EDITOR.getData(dataContext) : null;
        JavaChangeSignatureHandler.invokeOnElement(project, editor, elements[0]);
    }

    @Nullable
    public String getTargetNotFoundMessage() {
        return RefactoringBundle.message((String)"error.wrong.caret.position.method.or.class.name");
    }

    private static void invoke(@NotNull PsiMethod method, @NotNull Project project, @Nullable Editor editor) {
        PsiMethod newMethod;
        if (method == null) {
            JavaChangeSignatureHandler.$$$reportNull$$$0(3);
        }
        if (project == null) {
            JavaChangeSignatureHandler.$$$reportNull$$$0(4);
        }
        if ((newMethod = SuperMethodWarningUtil.checkSuperMethod(method, RefactoringBundle.message((String)"to.refactor"))) == null) {
            return;
        }
        if (!newMethod.equals(method)) {
            ChangeSignatureUtil.invokeChangeSignatureOn(newMethod, project);
            return;
        }
        if (!CommonRefactoringUtil.checkReadOnlyStatus((Project)project, (PsiElement)method)) {
            return;
        }
        PsiClass containingClass = method.getContainingClass();
        PsiReferenceExpression refExpr = editor != null ? JavaTargetElementEvaluator.findReferenceExpression(editor) : null;
        boolean allowDelegation = containingClass != null && (!containingClass.isInterface() || PsiUtil.isLanguageLevel8OrHigher((PsiElement)containingClass)) && !JavaPsiRecordUtil.isCanonicalConstructor(method);
        InplaceChangeSignature inplaceChangeSignature = editor != null ? InplaceChangeSignature.getCurrentRefactoring((Editor)editor) : null;
        ChangeInfo initialChange = inplaceChangeSignature != null ? inplaceChangeSignature.getStableChange() : null;
        boolean isInplace = Registry.is((String)"inplace.change.signature") && editor != null && editor.getSettings().isVariableInplaceRenameEnabled() && (initialChange == null || initialChange.getMethod() != method) && refExpr == null;
        PsiIdentifier nameIdentifier = method.getNameIdentifier();
        LOG.assertTrue(nameIdentifier != null);
        if (isInplace) {
            CommandProcessor.getInstance().executeCommand(project, () -> new InplaceChangeSignature(project, editor, (PsiElement)nameIdentifier), REFACTORING_NAME, null);
        } else {
            JavaMethodDescriptor methodDescriptor = new JavaMethodDescriptor(method);
            if (initialChange != null) {
                final JavaChangeInfo currentInfo = (JavaChangeInfo)inplaceChangeSignature.getCurrentInfo();
                if (currentInfo != null) {
                    methodDescriptor = new JavaMethodDescriptor(method){

                        @Override
                        public String getName() {
                            return currentInfo.getNewName();
                        }

                        @Override
                        @NotNull
                        public List<ParameterInfoImpl> getParameters() {
                            List<ParameterInfoImpl> list = Arrays.asList((ParameterInfoImpl[])currentInfo.getNewParameters());
                            if (list == null) {
                                1.$$$reportNull$$$0(0);
                            }
                            return list;
                        }

                        @Override
                        @NotNull
                        public String getVisibility() {
                            String string = currentInfo.getNewVisibility();
                            if (string == null) {
                                1.$$$reportNull$$$0(1);
                            }
                            return string;
                        }

                        @Override
                        public int getParametersCount() {
                            return currentInfo.getNewParameters().length;
                        }

                        @Override
                        @Nullable
                        public String getReturnTypeText() {
                            return currentInfo.getNewReturnType().getTypeText();
                        }

                        private static /* synthetic */ void $$$reportNull$$$0(int n) {
                            Object[] objectArray;
                            Object[] objectArray2 = new Object[2];
                            objectArray2[0] = "com/intellij/refactoring/changeSignature/JavaChangeSignatureHandler$1";
                            switch (n) {
                                default: {
                                    objectArray = objectArray2;
                                    objectArray2[1] = "getParameters";
                                    break;
                                }
                                case 1: {
                                    objectArray = objectArray2;
                                    objectArray2[1] = "getVisibility";
                                    break;
                                }
                            }
                            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
                        }
                    };
                }
                inplaceChangeSignature.cancel();
            }
            JavaChangeSignatureDialog dialog = new JavaChangeSignatureDialog(project, methodDescriptor, allowDelegation, (PsiElement)(refExpr == null ? method : refExpr));
            dialog.show();
        }
    }

    private static void invoke(PsiClass aClass, Editor editor) {
        PsiTypeParameterList typeParameterList = aClass.getTypeParameterList();
        Project project = aClass.getProject();
        if (typeParameterList == null) {
            String message2 = RefactoringBundle.getCannotRefactorMessage((String)JavaRefactoringBundle.message((String)"changeClassSignature.no.type.parameters", (Object[])new Object[0]));
            CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)message2, (String)REFACTORING_NAME, (String)"change.class.signature.dialog");
            return;
        }
        if (!CommonRefactoringUtil.checkReadOnlyStatus((Project)project, (PsiElement)aClass)) {
            return;
        }
        ChangeClassSignatureDialog dialog = new ChangeClassSignatureDialog(aClass, true);
        dialog.show();
    }

    public PsiElement findTargetMember(@NotNull PsiElement element) {
        PsiJavaCodeReferenceElement referenceElement;
        PsiReferenceParameterList referenceParameterList;
        if (element == null) {
            JavaChangeSignatureHandler.$$$reportNull$$$0(5);
        }
        if (PsiTreeUtil.getParentOfType((PsiElement)element, PsiParameterList.class) != null) {
            return PsiTreeUtil.getParentOfType((PsiElement)element, PsiMethod.class);
        }
        PsiRecordHeader header = (PsiRecordHeader)PsiTreeUtil.getParentOfType((PsiElement)element, PsiRecordHeader.class);
        if (header != null) {
            PsiClass aClass = header.getContainingClass();
            if (aClass != null) {
                return JavaPsiRecordUtil.findCanonicalConstructor(aClass);
            }
            return null;
        }
        PsiTypeParameterList typeParameterList = (PsiTypeParameterList)PsiTreeUtil.getParentOfType((PsiElement)element, PsiTypeParameterList.class);
        if (typeParameterList != null) {
            return PsiTreeUtil.getParentOfType((PsiElement)typeParameterList, PsiMember.class);
        }
        PsiElement elementParent = element.getParent();
        if (elementParent instanceof PsiMethod && ((PsiMethod)elementParent).getNameIdentifier() == element) {
            PsiClass containingClass = ((PsiMethod)elementParent).getContainingClass();
            if (containingClass != null && containingClass.isAnnotationType()) {
                return null;
            }
            return elementParent;
        }
        if (elementParent instanceof PsiClass && ((PsiClass)elementParent).getNameIdentifier() == element) {
            if (((PsiClass)elementParent).isAnnotationType() || ((PsiClass)elementParent).isEnum()) {
                return null;
            }
            return elementParent;
        }
        PsiCallExpression expression2 = (PsiCallExpression)PsiTreeUtil.getParentOfType((PsiElement)element, PsiCallExpression.class);
        if (expression2 != null) {
            Object qualifierExpression2 = expression2 instanceof PsiMethodCallExpression ? ((PsiMethodCallExpression)expression2).getMethodExpression().getQualifierExpression() : (expression2 instanceof PsiNewExpression ? ((PsiNewExpression)expression2).getQualifier() : null);
            if (PsiTreeUtil.isAncestor((PsiElement)qualifierExpression2, (PsiElement)element, (boolean)false)) {
                PsiElement parent;
                PsiExpressionList expressionList = (PsiExpressionList)PsiTreeUtil.getParentOfType((PsiElement)qualifierExpression2, PsiExpressionList.class);
                if (expressionList != null && (parent = expressionList.getParent()) instanceof PsiCallExpression) {
                    return ((PsiCallExpression)parent).resolveMethod();
                }
            } else {
                return expression2.resolveMethod();
            }
        }
        if ((referenceParameterList = (PsiReferenceParameterList)PsiTreeUtil.getParentOfType((PsiElement)element, PsiReferenceParameterList.class)) != null && (referenceElement = (PsiJavaCodeReferenceElement)PsiTreeUtil.getParentOfType((PsiElement)referenceParameterList, PsiJavaCodeReferenceElement.class)) != null) {
            PsiElement resolved = referenceElement.resolve();
            if (resolved instanceof PsiClass) {
                return resolved;
            }
            if (resolved instanceof PsiMethod) {
                return resolved;
            }
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        objectArray2[1] = "com/intellij/refactoring/changeSignature/JavaChangeSignatureHandler";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "invoke";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "findTargetMember";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

