/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.psi.ExternallyDefinedPsiElement;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiRecordComponent;
import com.intellij.psi.PsiRecordHeader;
import com.intellij.psi.SyntheticElement;
import com.intellij.psi.augment.PsiAugmentProvider;
import com.intellij.psi.impl.PsiClassImplUtil;
import com.intellij.psi.impl.PsiImplUtil;
import com.intellij.psi.impl.light.LightMethod;
import com.intellij.psi.impl.source.PsiExtensibleClass;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.util.ArrayFactory;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ConcurrentFactoryMap;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.Interner;
import com.intellij.util.containers.JBIterable;
import gnu.trove.THashMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentMap;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ClassInnerStuffCache {
    private final PsiExtensibleClass myClass;
    private final NotNullLazyValue<Interner<PsiMember>> myInterner;

    public ClassInnerStuffCache(@NotNull PsiExtensibleClass aClass) {
        if (aClass == null) {
            ClassInnerStuffCache.$$$reportNull$$$0(0);
        }
        this.myInterner = NotNullLazyValue.createValue(() -> Interner.createWeakInterner());
        this.myClass = aClass;
    }

    public PsiMethod @NotNull [] getConstructors() {
        PsiMethod[] psiMethodArray = ClassInnerStuffCache.copy((PsiMethod[])CachedValuesManager.getProjectPsiDependentCache((PsiElement)this.myClass, PsiImplUtil::getConstructors));
        if (psiMethodArray == null) {
            ClassInnerStuffCache.$$$reportNull$$$0(1);
        }
        return psiMethodArray;
    }

    public PsiField @NotNull [] getFields() {
        PsiField[] psiFieldArray = ClassInnerStuffCache.copy((PsiField[])CachedValuesManager.getProjectPsiDependentCache((PsiElement)this.myClass, __ -> this.calcFields()));
        if (psiFieldArray == null) {
            ClassInnerStuffCache.$$$reportNull$$$0(2);
        }
        return psiFieldArray;
    }

    public PsiMethod @NotNull [] getMethods() {
        PsiMethod[] psiMethodArray = ClassInnerStuffCache.copy((PsiMethod[])CachedValuesManager.getProjectPsiDependentCache((PsiElement)this.myClass, __ -> this.calcMethods()));
        if (psiMethodArray == null) {
            ClassInnerStuffCache.$$$reportNull$$$0(3);
        }
        return psiMethodArray;
    }

    public PsiClass @NotNull [] getInnerClasses() {
        PsiClass[] psiClassArray = ClassInnerStuffCache.copy((PsiClass[])CachedValuesManager.getProjectPsiDependentCache((PsiElement)this.myClass, __ -> this.calcInnerClasses()));
        if (psiClassArray == null) {
            ClassInnerStuffCache.$$$reportNull$$$0(4);
        }
        return psiClassArray;
    }

    public PsiRecordComponent @NotNull [] getRecordComponents() {
        PsiRecordComponent[] psiRecordComponentArray = ClassInnerStuffCache.copy((PsiRecordComponent[])CachedValuesManager.getProjectPsiDependentCache((PsiElement)this.myClass, __ -> this.calcRecordComponents()));
        if (psiRecordComponentArray == null) {
            ClassInnerStuffCache.$$$reportNull$$$0(5);
        }
        return psiRecordComponentArray;
    }

    @Nullable
    public PsiField findFieldByName(String name2, boolean checkBases) {
        if (checkBases) {
            return PsiClassImplUtil.findFieldByName(this.myClass, name2, true);
        }
        return (PsiField)((Map)CachedValuesManager.getProjectPsiDependentCache((PsiElement)this.myClass, __ -> this.getFieldsMap())).get(name2);
    }

    public PsiMethod @NotNull [] findMethodsByName(String name2, boolean checkBases) {
        if (checkBases) {
            PsiMethod[] psiMethodArray = PsiClassImplUtil.findMethodsByName(this.myClass, name2, true);
            if (psiMethodArray == null) {
                ClassInnerStuffCache.$$$reportNull$$$0(6);
            }
            return psiMethodArray;
        }
        PsiMethod[] psiMethodArray = ClassInnerStuffCache.copy((PsiMethod[])ObjectUtils.notNull((Object)((PsiMethod[])((Map)CachedValuesManager.getProjectPsiDependentCache((PsiElement)this.myClass, __ -> this.getMethodsMap())).get(name2)), (Object)PsiMethod.EMPTY_ARRAY));
        if (psiMethodArray == null) {
            ClassInnerStuffCache.$$$reportNull$$$0(7);
        }
        return psiMethodArray;
    }

    @Nullable
    public PsiClass findInnerClassByName(String name2, boolean checkBases) {
        if (checkBases) {
            return PsiClassImplUtil.findInnerByName(this.myClass, name2, true);
        }
        return (PsiClass)((Map)CachedValuesManager.getProjectPsiDependentCache((PsiElement)this.myClass, __ -> this.getInnerClassesMap())).get(name2);
    }

    @Nullable
    PsiMethod getValuesMethod() {
        return this.myClass.isEnum() && !this.isAnonymousClass() ? this.internMember((PsiMethod)CachedValuesManager.getProjectPsiDependentCache((PsiElement)this.myClass, ClassInnerStuffCache::makeValuesMethod)) : null;
    }

    @Nullable
    private PsiMethod getValueOfMethod() {
        return this.myClass.isEnum() && !this.isAnonymousClass() ? this.internMember((PsiMethod)CachedValuesManager.getProjectPsiDependentCache((PsiElement)this.myClass, ClassInnerStuffCache::makeValueOfMethod)) : null;
    }

    private boolean isAnonymousClass() {
        return this.myClass.getName() == null || this.myClass instanceof PsiAnonymousClass;
    }

    private static <T> T[] copy(T[] value2) {
        return value2.length == 0 ? value2 : (Object[])value2.clone();
    }

    private PsiField @NotNull [] calcFields() {
        List<PsiField> own = this.myClass.getOwnFields();
        List ext = this.internMembers(PsiAugmentProvider.collectAugments((PsiElement)this.myClass, PsiField.class, null));
        PsiField[] psiFieldArray = (PsiField[])ArrayUtil.mergeCollections(own, ext, (ArrayFactory)PsiField.ARRAY_FACTORY);
        if (psiFieldArray == null) {
            ClassInnerStuffCache.$$$reportNull$$$0(8);
        }
        return psiFieldArray;
    }

    @NotNull
    private <T extends PsiMember> List<T> internMembers(List<T> members) {
        List list = ContainerUtil.map(members, this::internMember);
        if (list == null) {
            ClassInnerStuffCache.$$$reportNull$$$0(9);
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T extends PsiMember> T internMember(T m) {
        if (m == null) {
            return null;
        }
        NotNullLazyValue<Interner<PsiMember>> notNullLazyValue = this.myInterner;
        synchronized (notNullLazyValue) {
            return (T)((PsiMember)((Interner)this.myInterner.getValue()).intern(m));
        }
    }

    private PsiMethod @NotNull [] calcMethods() {
        List<PsiMethod> own = this.myClass.getOwnMethods();
        List ext = this.internMembers(PsiAugmentProvider.collectAugments((PsiElement)this.myClass, PsiMethod.class, null));
        if (this.myClass.isEnum()) {
            ext = new ArrayList(ext);
            ContainerUtil.addIfNotNull(ext, (Object)this.getValuesMethod());
            ContainerUtil.addIfNotNull(ext, (Object)this.getValueOfMethod());
        }
        PsiMethod[] psiMethodArray = (PsiMethod[])ArrayUtil.mergeCollections(own, ext, (ArrayFactory)PsiMethod.ARRAY_FACTORY);
        if (psiMethodArray == null) {
            ClassInnerStuffCache.$$$reportNull$$$0(10);
        }
        return psiMethodArray;
    }

    private PsiClass @NotNull [] calcInnerClasses() {
        List<PsiClass> own = this.myClass.getOwnInnerClasses();
        List ext = this.internMembers(PsiAugmentProvider.collectAugments((PsiElement)this.myClass, PsiClass.class, null));
        PsiClass[] psiClassArray = (PsiClass[])ArrayUtil.mergeCollections(own, ext, (ArrayFactory)PsiClass.ARRAY_FACTORY);
        if (psiClassArray == null) {
            ClassInnerStuffCache.$$$reportNull$$$0(11);
        }
        return psiClassArray;
    }

    private PsiRecordComponent @NotNull [] calcRecordComponents() {
        PsiRecordHeader header = this.myClass.getRecordHeader();
        PsiRecordComponent[] psiRecordComponentArray = header == null ? PsiRecordComponent.EMPTY_ARRAY : header.getRecordComponents();
        if (psiRecordComponentArray == null) {
            ClassInnerStuffCache.$$$reportNull$$$0(12);
        }
        return psiRecordComponentArray;
    }

    @NotNull
    private Map<String, PsiField> getFieldsMap() {
        THashMap cachedFields = new THashMap();
        for (PsiField field : this.myClass.getOwnFields()) {
            String name2 = field.getName();
            if (cachedFields.containsKey(name2)) continue;
            cachedFields.put(name2, field);
        }
        ConcurrentMap concurrentMap = ConcurrentFactoryMap.createMap(arg_0 -> this.lambda$getFieldsMap$8((Map)cachedFields, arg_0));
        if (concurrentMap == null) {
            ClassInnerStuffCache.$$$reportNull$$$0(13);
        }
        return concurrentMap;
    }

    @NotNull
    private Map<String, PsiMethod[]> getMethodsMap() {
        List<PsiMethod> ownMethods = this.myClass.getOwnMethods();
        ConcurrentMap concurrentMap = ConcurrentFactoryMap.createMap(name2 -> (PsiMethod[])JBIterable.from((Iterable)ownMethods).filter(m -> name2.equals(m.getName())).append((Object)("values".equals(name2) ? this.getValuesMethod() : null)).append((Object)("valueOf".equals(name2) ? this.getValueOfMethod() : null)).append(this.internMembers(PsiAugmentProvider.collectAugments((PsiElement)this.myClass, PsiMethod.class, (String)name2))).toArray((Object[])PsiMethod.EMPTY_ARRAY));
        if (concurrentMap == null) {
            ClassInnerStuffCache.$$$reportNull$$$0(14);
        }
        return concurrentMap;
    }

    @NotNull
    private Map<String, PsiClass> getInnerClassesMap() {
        THashMap cachedInners = new THashMap();
        for (PsiClass psiClass : this.myClass.getOwnInnerClasses()) {
            String name2 = psiClass.getName();
            if (name2 == null) {
                Logger.getInstance(ClassInnerStuffCache.class).error((Object)psiClass);
                continue;
            }
            if (psiClass instanceof ExternallyDefinedPsiElement && cachedInners.containsKey(name2)) continue;
            cachedInners.put(name2, psiClass);
        }
        ConcurrentMap concurrentMap = ConcurrentFactoryMap.createMap(arg_0 -> this.lambda$getInnerClassesMap$11((Map)cachedInners, arg_0));
        if (concurrentMap == null) {
            ClassInnerStuffCache.$$$reportNull$$$0(15);
        }
        return concurrentMap;
    }

    private static PsiMethod makeValuesMethod(PsiExtensibleClass enumClass) {
        return new EnumSyntheticMethod(enumClass, "public static " + enumClass.getName() + "[] values() { }");
    }

    private static PsiMethod makeValueOfMethod(PsiExtensibleClass enumClass) {
        return new EnumSyntheticMethod(enumClass, "public static " + enumClass.getName() + " valueOf(java.lang.String name) throws java.lang.IllegalArgumentException { }");
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2020.3")
    public void dropCaches() {
    }

    private /* synthetic */ PsiClass lambda$getInnerClassesMap$11(Map cachedInners, String name2) {
        PsiClass result = (PsiClass)cachedInners.get(name2);
        return result != null ? result : this.internMember((PsiClass)ContainerUtil.getFirstItem((List)PsiAugmentProvider.collectAugments((PsiElement)this.myClass, PsiClass.class, (String)name2)));
    }

    private /* synthetic */ PsiField lambda$getFieldsMap$8(Map cachedFields, String name2) {
        PsiField result = (PsiField)cachedFields.get(name2);
        return result != null ? result : this.internMember((PsiField)ContainerUtil.getFirstItem((List)PsiAugmentProvider.collectAugments((PsiElement)this.myClass, PsiField.class, (String)name2)));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/impl/source/ClassInnerStuffCache";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/impl/source/ClassInnerStuffCache";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getConstructors";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getFields";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getMethods";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getInnerClasses";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getRecordComponents";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "findMethodsByName";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "calcFields";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "internMembers";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "calcMethods";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "calcInnerClasses";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "calcRecordComponents";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getFieldsMap";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getMethodsMap";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getInnerClassesMap";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class EnumSyntheticMethod
    extends LightMethod
    implements SyntheticElement {
        private final PsiClass myClass;
        private final String myText;

        EnumSyntheticMethod(@NotNull PsiClass enumClass, @NotNull String text2) {
            if (enumClass == null) {
                EnumSyntheticMethod.$$$reportNull$$$0(0);
            }
            if (text2 == null) {
                EnumSyntheticMethod.$$$reportNull$$$0(1);
            }
            super(enumClass.getManager(), JavaPsiFacade.getElementFactory((Project)enumClass.getProject()).createMethodFromText(text2, (PsiElement)enumClass), enumClass);
            this.myClass = enumClass;
            this.myText = text2;
        }

        public int getTextOffset() {
            return this.myClass.getTextOffset();
        }

        public boolean equals(Object another) {
            return this == another || another instanceof EnumSyntheticMethod && this.myClass.equals(((EnumSyntheticMethod)((Object)another)).myClass) && this.myText.equals(((EnumSyntheticMethod)((Object)another)).myText);
        }

        public int hashCode() {
            return Objects.hash(this.myText, this.myClass);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "enumClass";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "text";
                    break;
                }
            }
            objectArray[1] = "com/intellij/psi/impl/source/ClassInnerStuffCache$EnumSyntheticMethod";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

