/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.light;

import com.intellij.codeInsight.AnnotationTargetUtil;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Iconable;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiRecordComponent;
import com.intellij.psi.PsiType;
import com.intellij.psi.impl.ElementPresentationUtil;
import com.intellij.psi.impl.light.LightMethod;
import com.intellij.psi.impl.light.LightRecordMember;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.ui.IconManager;
import com.intellij.ui.icons.RowIcon;
import com.intellij.util.BitUtil;
import com.intellij.util.PlatformIcons;
import com.intellij.util.VisibilityIcons;
import java.util.Arrays;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LightRecordMethod
extends LightMethod
implements LightRecordMember {
    @NotNull
    private final PsiRecordComponent myRecordComponent;

    public LightRecordMethod(@NotNull PsiManager manager, @NotNull PsiMethod method, @NotNull PsiClass containingClass, @NotNull PsiRecordComponent component) {
        if (manager == null) {
            LightRecordMethod.$$$reportNull$$$0(0);
        }
        if (method == null) {
            LightRecordMethod.$$$reportNull$$$0(1);
        }
        if (containingClass == null) {
            LightRecordMethod.$$$reportNull$$$0(2);
        }
        if (component == null) {
            LightRecordMethod.$$$reportNull$$$0(3);
        }
        super(manager, method, containingClass);
        this.myRecordComponent = component;
    }

    @Override
    @NotNull
    public PsiRecordComponent getRecordComponent() {
        PsiRecordComponent psiRecordComponent = this.myRecordComponent;
        if (psiRecordComponent == null) {
            LightRecordMethod.$$$reportNull$$$0(4);
        }
        return psiRecordComponent;
    }

    public int getTextOffset() {
        return this.myRecordComponent.getTextOffset();
    }

    @NotNull
    public PsiElement getNavigationElement() {
        PsiElement psiElement = this.myRecordComponent.getNavigationElement();
        if (psiElement == null) {
            LightRecordMethod.$$$reportNull$$$0(5);
        }
        return psiElement;
    }

    public boolean isWritable() {
        return true;
    }

    @Override
    public PsiFile getContainingFile() {
        PsiClass containingClass = this.getContainingClass();
        return containingClass.getContainingFile();
    }

    @Override
    public PsiType getReturnType() {
        if (DumbService.isDumb((Project)this.myRecordComponent.getProject())) {
            return this.myRecordComponent.getType();
        }
        return (PsiType)CachedValuesManager.getCachedValue((PsiElement)this, () -> {
            PsiType type2 = this.myRecordComponent.getType().annotate(() -> (PsiAnnotation[])Arrays.stream(this.myRecordComponent.getAnnotations()).filter(LightRecordMethod::hasTargetApplicableForMethod).toArray(PsiAnnotation[]::new));
            return CachedValueProvider.Result.create((Object)type2, (Object[])new Object[]{this});
        });
    }

    public PsiAnnotation @NotNull [] getAnnotations() {
        PsiType returnType = this.getReturnType();
        if (returnType == null) {
            if (PsiAnnotation.EMPTY_ARRAY == null) {
                LightRecordMethod.$$$reportNull$$$0(6);
            }
            return PsiAnnotation.EMPTY_ARRAY;
        }
        PsiAnnotation[] psiAnnotationArray = returnType.getAnnotations();
        if (psiAnnotationArray == null) {
            LightRecordMethod.$$$reportNull$$$0(7);
        }
        return psiAnnotationArray;
    }

    public boolean hasAnnotation(@NotNull String fqn) {
        PsiType returnType;
        if (fqn == null) {
            LightRecordMethod.$$$reportNull$$$0(8);
        }
        return (returnType = this.getReturnType()) != null && returnType.hasAnnotation(fqn);
    }

    @Nullable
    public PsiAnnotation getAnnotation(@NotNull String fqn) {
        PsiType returnType;
        if (fqn == null) {
            LightRecordMethod.$$$reportNull$$$0(9);
        }
        if ((returnType = this.getReturnType()) == null) {
            return null;
        }
        return returnType.findAnnotation(fqn);
    }

    @Override
    public Icon getElementIcon(int flags) {
        RowIcon baseIcon = IconManager.getInstance().createLayeredIcon((Iconable)this, PlatformIcons.METHOD_ICON, ElementPresentationUtil.getFlags((PsiModifierListOwner)this, false));
        if (BitUtil.isSet((int)flags, (int)1)) {
            VisibilityIcons.setVisibilityIcon((int)4, (RowIcon)baseIcon);
        }
        return baseIcon;
    }

    @Override
    public PsiElement getContext() {
        return this.getContainingClass();
    }

    private static boolean hasTargetApplicableForMethod(PsiAnnotation annotation) {
        return AnnotationTargetUtil.findAnnotationTarget((PsiAnnotation)annotation, (PsiAnnotation.TargetType[])new PsiAnnotation.TargetType[]{PsiAnnotation.TargetType.TYPE_USE, PsiAnnotation.TargetType.METHOD}) != null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "containingClass";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/impl/light/LightRecordMethod";
                break;
            }
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fqn";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/impl/light/LightRecordMethod";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getRecordComponent";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getNavigationElement";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getAnnotations";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "hasAnnotation";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getAnnotation";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

