/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.java;

import com.intellij.ide.highlighter.JavaFileType;
import com.intellij.lang.java.parser.JavaParserUtil;
import com.intellij.lexer.TokenList;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.impl.source.JavaFileElementType;
import com.intellij.psi.impl.source.tree.ElementType;
import com.intellij.util.indexing.DataIndexer;
import com.intellij.util.indexing.DefaultFileTypeSpecificInputFilter;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.indexing.FileBasedIndexExtension;
import com.intellij.util.indexing.FileContent;
import com.intellij.util.indexing.ID;
import com.intellij.util.io.BooleanDataDescriptor;
import com.intellij.util.io.DataExternalizer;
import com.intellij.util.io.DataInputOutputUtil;
import com.intellij.util.io.KeyDescriptor;
import gnu.trove.THashMap;
import gnu.trove.TIntArrayList;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import org.jetbrains.annotations.NotNull;

public class JavaBinaryPlusExpressionIndex
extends FileBasedIndexExtension<Boolean, PlusOffsets> {
    public static final ID<Boolean, PlusOffsets> INDEX_ID = ID.create((String)"java.binary.plus.expression");

    @NotNull
    public ID<Boolean, PlusOffsets> getName() {
        ID<Boolean, PlusOffsets> iD = INDEX_ID;
        if (iD == null) {
            JavaBinaryPlusExpressionIndex.$$$reportNull$$$0(0);
        }
        return iD;
    }

    @NotNull
    public DataIndexer<Boolean, PlusOffsets, FileContent> getIndexer() {
        DataIndexer dataIndexer = inputData -> {
            TokenList tokens = JavaParserUtil.obtainTokens(inputData.getPsiFile());
            TIntArrayList result = new TIntArrayList();
            for (int i = 0; i < tokens.getTokenCount(); ++i) {
                if (!tokens.hasType(i, JavaTokenType.PLUS) || tokens.hasType(tokens.forwardWhile(i + 1, JavaParserUtil.WS_COMMENTS), ElementType.ALL_LITERALS) == tokens.hasType(tokens.backWhile(i - 1, JavaParserUtil.WS_COMMENTS), ElementType.ALL_LITERALS)) continue;
                result.add(tokens.getTokenStart(i));
            }
            if (result.isEmpty()) {
                return Collections.emptyMap();
            }
            THashMap resultMap = new THashMap();
            resultMap.put((Object)Boolean.TRUE, (Object)new PlusOffsets(result.toNativeArray()));
            return resultMap;
        };
        if (dataIndexer == null) {
            JavaBinaryPlusExpressionIndex.$$$reportNull$$$0(1);
        }
        return dataIndexer;
    }

    @NotNull
    public KeyDescriptor<Boolean> getKeyDescriptor() {
        BooleanDataDescriptor booleanDataDescriptor = BooleanDataDescriptor.INSTANCE;
        if (booleanDataDescriptor == null) {
            JavaBinaryPlusExpressionIndex.$$$reportNull$$$0(2);
        }
        return booleanDataDescriptor;
    }

    @NotNull
    public DataExternalizer<PlusOffsets> getValueExternalizer() {
        return new DataExternalizer<PlusOffsets>(){

            public void save(@NotNull DataOutput out, PlusOffsets value2) throws IOException {
                if (out == null) {
                    1.$$$reportNull$$$0(0);
                }
                int[] offsets = value2.getOffsets();
                DataInputOutputUtil.writeINT((DataOutput)out, (int)offsets.length);
                for (int i : offsets) {
                    DataInputOutputUtil.writeINT((DataOutput)out, (int)i);
                }
            }

            public PlusOffsets read(@NotNull DataInput in) throws IOException {
                if (in == null) {
                    1.$$$reportNull$$$0(1);
                }
                int[] result = new int[DataInputOutputUtil.readINT((DataInput)in)];
                for (int i = 0; i < result.length; ++i) {
                    result[i] = DataInputOutputUtil.readINT((DataInput)in);
                }
                return new PlusOffsets(result);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "out";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "in";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/psi/impl/java/JavaBinaryPlusExpressionIndex$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "save";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "read";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
    }

    public int getVersion() {
        return 4;
    }

    public boolean hasSnapshotMapping() {
        return true;
    }

    public boolean needsForwardIndexWhenSharing() {
        return false;
    }

    @NotNull
    public FileBasedIndex.InputFilter getInputFilter() {
        return new DefaultFileTypeSpecificInputFilter(new FileType[]{JavaFileType.INSTANCE}){

            public boolean acceptInput(@NotNull VirtualFile file) {
                if (file == null) {
                    2.$$$reportNull$$$0(0);
                }
                return super.acceptInput(file) && JavaFileElementType.isInSourceContent(file);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/psi/impl/java/JavaBinaryPlusExpressionIndex$2", "acceptInput"));
            }
        };
    }

    public boolean dependsOnFileContent() {
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/intellij/psi/impl/java/JavaBinaryPlusExpressionIndex";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getIndexer";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getKeyDescriptor";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    public static class PlusOffsets {
        private final int[] offsets;

        PlusOffsets(int[] offsets) {
            this.offsets = offsets;
        }

        public int[] getOffsets() {
            return this.offsets;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            PlusOffsets offsets1 = (PlusOffsets)o;
            return Arrays.equals(this.offsets, offsets1.offsets);
        }

        public int hashCode() {
            return Arrays.hashCode(this.offsets);
        }
    }
}

