/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl;

import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiClassObjectAccessExpression;
import com.intellij.psi.PsiConditionalExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiEnumConstant;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiPolyadicExpression;
import com.intellij.psi.PsiPrefixExpression;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeCastExpression;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.impl.source.PsiFieldImpl;
import com.intellij.psi.tree.IElementType;
import gnu.trove.THashMap;
import java.util.Map;

class IsConstantExpressionVisitor
extends JavaElementVisitor {
    private boolean myIsConstant;
    private final Map<PsiVariable, Boolean> varIsConst = new THashMap();

    IsConstantExpressionVisitor() {
    }

    public boolean isConstant() {
        return this.myIsConstant;
    }

    public void visitExpression(PsiExpression expression2) {
        this.myIsConstant = false;
    }

    public void visitLiteralExpression(PsiLiteralExpression expression2) {
        this.myIsConstant = !"null".equals(expression2.getText());
    }

    public void visitClassObjectAccessExpression(PsiClassObjectAccessExpression expression2) {
        this.myIsConstant = true;
    }

    public void visitParenthesizedExpression(PsiParenthesizedExpression expression2) {
        PsiExpression expr2 = expression2.getExpression();
        if (expr2 != null) {
            expr2.accept((PsiElementVisitor)this);
        }
    }

    public void visitTypeCastExpression(PsiTypeCastExpression expression2) {
        PsiExpression operand2 = expression2.getOperand();
        if (operand2 == null) {
            this.myIsConstant = false;
            return;
        }
        operand2.accept((PsiElementVisitor)this);
        if (!this.myIsConstant) {
            return;
        }
        PsiTypeElement element = expression2.getCastType();
        if (element == null) {
            this.myIsConstant = false;
            return;
        }
        PsiType type2 = element.getType();
        if (type2 instanceof PsiPrimitiveType) {
            return;
        }
        if (type2.equalsToText("java.lang.String")) {
            return;
        }
        this.myIsConstant = false;
    }

    public void visitPrefixExpression(PsiPrefixExpression expression2) {
        PsiExpression operand2 = expression2.getOperand();
        if (operand2 == null) {
            this.myIsConstant = false;
            return;
        }
        operand2.accept((PsiElementVisitor)this);
        if (!this.myIsConstant) {
            return;
        }
        IElementType opType = expression2.getOperationTokenType();
        if (opType == JavaTokenType.PLUS || opType == JavaTokenType.MINUS || opType == JavaTokenType.TILDE || opType == JavaTokenType.EXCL) {
            return;
        }
        this.myIsConstant = false;
    }

    public void visitPolyadicExpression(PsiPolyadicExpression expression2) {
        for (PsiExpression operand2 : expression2.getOperands()) {
            operand2.accept((PsiElementVisitor)this);
            if (!this.myIsConstant) {
                return;
            }
            PsiType type2 = operand2.getType();
            if (type2 == null || type2 instanceof PsiPrimitiveType || type2.equalsToText("java.lang.String")) continue;
            this.myIsConstant = false;
            return;
        }
    }

    public void visitConditionalExpression(PsiConditionalExpression expression2) {
        PsiExpression thenExpr = expression2.getThenExpression();
        PsiExpression elseExpr = expression2.getElseExpression();
        if (thenExpr == null || elseExpr == null) {
            this.myIsConstant = false;
            return;
        }
        expression2.getCondition().accept((PsiElementVisitor)this);
        if (!this.myIsConstant) {
            return;
        }
        thenExpr.accept((PsiElementVisitor)this);
        if (!this.myIsConstant) {
            return;
        }
        elseExpr.accept((PsiElementVisitor)this);
    }

    public void visitReferenceExpression(PsiReferenceExpression expression2) {
        PsiElement refElement = expression2.resolve();
        if (!(refElement instanceof PsiVariable)) {
            this.myIsConstant = false;
            return;
        }
        PsiVariable variable = (PsiVariable)refElement;
        Boolean isConst = this.varIsConst.get(variable);
        if (isConst != null) {
            this.myIsConstant &= isConst.booleanValue();
            return;
        }
        if (variable instanceof PsiEnumConstant) {
            this.myIsConstant = true;
            this.varIsConst.put(variable, Boolean.TRUE);
            return;
        }
        this.varIsConst.put(variable, Boolean.FALSE);
        if (!variable.hasModifierProperty("final")) {
            this.myIsConstant = false;
            return;
        }
        PsiExpression initializer = PsiFieldImpl.getDetachedInitializer(variable);
        if (initializer == null) {
            this.myIsConstant = false;
            return;
        }
        initializer.accept((PsiElementVisitor)this);
        this.varIsConst.put(variable, this.myIsConstant);
    }
}

