/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl;

import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.PsiShortNamesCache;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.indexing.IdFilter;
import gnu.trove.THashSet;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CompositeShortNamesCache
extends PsiShortNamesCache {
    private final Project myProject;

    public CompositeShortNamesCache(Project project) {
        this.myProject = project;
    }

    @NotNull
    private List<PsiShortNamesCache> getCaches() {
        List list = this.myProject.isDefault() ? Collections.emptyList() : PsiShortNamesCache.EP_NAME.getExtensionList((AreaInstance)this.myProject);
        if (list == null) {
            CompositeShortNamesCache.$$$reportNull$$$0(0);
        }
        return list;
    }

    public PsiFile @NotNull [] getFilesByName(@NotNull String name2) {
        if (name2 == null) {
            CompositeShortNamesCache.$$$reportNull$$$0(1);
        }
        Merger<PsiFile> merger = null;
        for (PsiShortNamesCache cache : this.getCaches()) {
            PsiFile[] classes2 = cache.getFilesByName(name2);
            if (classes2.length == 0) continue;
            if (merger == null) {
                merger = new Merger<PsiFile>();
            }
            merger.add(classes2);
        }
        PsiFile[] result = merger == null ? null : (PsiFile[])merger.getResult();
        PsiFile[] psiFileArray = result != null ? result : PsiFile.EMPTY_ARRAY;
        if (psiFileArray == null) {
            CompositeShortNamesCache.$$$reportNull$$$0(2);
        }
        return psiFileArray;
    }

    public String @NotNull [] getAllFileNames() {
        Merger<String> merger = new Merger<String>();
        for (PsiShortNamesCache cache : this.getCaches()) {
            merger.add(cache.getAllFileNames());
        }
        String[] result = (String[])merger.getResult();
        String[] stringArray = result != null ? result : ArrayUtilRt.EMPTY_STRING_ARRAY;
        if (stringArray == null) {
            CompositeShortNamesCache.$$$reportNull$$$0(3);
        }
        return stringArray;
    }

    public PsiClass @NotNull [] getClassesByName(@NotNull String name2, @NotNull GlobalSearchScope scope) {
        if (name2 == null) {
            CompositeShortNamesCache.$$$reportNull$$$0(4);
        }
        if (scope == null) {
            CompositeShortNamesCache.$$$reportNull$$$0(5);
        }
        Merger<PsiClass> merger = null;
        for (PsiShortNamesCache cache : this.getCaches()) {
            PsiClass[] classes2 = cache.getClassesByName(name2, scope);
            if (classes2.length == 0) continue;
            if (merger == null) {
                merger = new Merger<PsiClass>();
            }
            merger.add(classes2);
        }
        PsiClass[] result = merger == null ? null : (PsiClass[])merger.getResult();
        PsiClass[] psiClassArray = result != null ? result : PsiClass.EMPTY_ARRAY;
        if (psiClassArray == null) {
            CompositeShortNamesCache.$$$reportNull$$$0(6);
        }
        return psiClassArray;
    }

    public String @NotNull [] getAllClassNames() {
        Merger<String> merger = new Merger<String>();
        for (PsiShortNamesCache cache : this.getCaches()) {
            String[] names2 = cache.getAllClassNames();
            merger.add(names2);
        }
        String[] result = (String[])merger.getResult();
        String[] stringArray = result != null ? result : ArrayUtilRt.EMPTY_STRING_ARRAY;
        if (stringArray == null) {
            CompositeShortNamesCache.$$$reportNull$$$0(7);
        }
        return stringArray;
    }

    public boolean processAllClassNames(@NotNull Processor<? super String> processor2) {
        if (processor2 == null) {
            CompositeShortNamesCache.$$$reportNull$$$0(8);
        }
        CommonProcessors.UniqueProcessor uniqueProcessor = new CommonProcessors.UniqueProcessor(processor2);
        for (PsiShortNamesCache cache : this.getCaches()) {
            if (cache.processAllClassNames((Processor)uniqueProcessor)) continue;
            return false;
        }
        return true;
    }

    public boolean processAllClassNames(@NotNull Processor<? super String> processor2, @NotNull GlobalSearchScope scope, IdFilter filter) {
        if (processor2 == null) {
            CompositeShortNamesCache.$$$reportNull$$$0(9);
        }
        if (scope == null) {
            CompositeShortNamesCache.$$$reportNull$$$0(10);
        }
        for (PsiShortNamesCache cache : this.getCaches()) {
            if (cache.processAllClassNames(processor2, scope, filter)) continue;
            return false;
        }
        return true;
    }

    public boolean processAllMethodNames(@NotNull Processor<? super String> processor2, @NotNull GlobalSearchScope scope, IdFilter filter) {
        if (processor2 == null) {
            CompositeShortNamesCache.$$$reportNull$$$0(11);
        }
        if (scope == null) {
            CompositeShortNamesCache.$$$reportNull$$$0(12);
        }
        for (PsiShortNamesCache cache : this.getCaches()) {
            if (cache.processAllMethodNames(processor2, scope, filter)) continue;
            return false;
        }
        return true;
    }

    public boolean processAllFieldNames(@NotNull Processor<? super String> processor2, @NotNull GlobalSearchScope scope, IdFilter filter) {
        if (processor2 == null) {
            CompositeShortNamesCache.$$$reportNull$$$0(13);
        }
        if (scope == null) {
            CompositeShortNamesCache.$$$reportNull$$$0(14);
        }
        for (PsiShortNamesCache cache : this.getCaches()) {
            if (cache.processAllFieldNames(processor2, scope, filter)) continue;
            return false;
        }
        return true;
    }

    public PsiMethod @NotNull [] getMethodsByName(@NotNull String name2, @NotNull GlobalSearchScope scope) {
        if (name2 == null) {
            CompositeShortNamesCache.$$$reportNull$$$0(15);
        }
        if (scope == null) {
            CompositeShortNamesCache.$$$reportNull$$$0(16);
        }
        Merger<PsiMethod> merger = null;
        for (PsiShortNamesCache cache : this.getCaches()) {
            PsiMethod[] methods = cache.getMethodsByName(name2, scope);
            if (methods.length == 0) continue;
            if (merger == null) {
                merger = new Merger<PsiMethod>();
            }
            merger.add(methods);
        }
        PsiMethod[] result = merger == null ? null : (PsiMethod[])merger.getResult();
        PsiMethod[] psiMethodArray = result == null ? PsiMethod.EMPTY_ARRAY : result;
        if (psiMethodArray == null) {
            CompositeShortNamesCache.$$$reportNull$$$0(17);
        }
        return psiMethodArray;
    }

    public PsiMethod @NotNull [] getMethodsByNameIfNotMoreThan(@NonNls @NotNull String name2, @NotNull GlobalSearchScope scope, int maxCount) {
        if (name2 == null) {
            CompositeShortNamesCache.$$$reportNull$$$0(18);
        }
        if (scope == null) {
            CompositeShortNamesCache.$$$reportNull$$$0(19);
        }
        Merger<PsiMethod> merger = null;
        for (PsiShortNamesCache cache : this.getCaches()) {
            PsiMethod[] methods = cache.getMethodsByNameIfNotMoreThan(name2, scope, maxCount);
            if (methods.length == maxCount) {
                if (methods == null) {
                    CompositeShortNamesCache.$$$reportNull$$$0(20);
                }
                return methods;
            }
            if (methods.length == 0) continue;
            if (merger == null) {
                merger = new Merger<PsiMethod>();
            }
            merger.add(methods);
        }
        PsiMethod[] result = merger == null ? null : (PsiMethod[])merger.getResult();
        PsiMethod[] psiMethodArray = result == null ? PsiMethod.EMPTY_ARRAY : result;
        if (psiMethodArray == null) {
            CompositeShortNamesCache.$$$reportNull$$$0(21);
        }
        return psiMethodArray;
    }

    public PsiField @NotNull [] getFieldsByNameIfNotMoreThan(@NonNls @NotNull String name2, @NotNull GlobalSearchScope scope, int maxCount) {
        if (name2 == null) {
            CompositeShortNamesCache.$$$reportNull$$$0(22);
        }
        if (scope == null) {
            CompositeShortNamesCache.$$$reportNull$$$0(23);
        }
        Merger<PsiField> merger = null;
        for (PsiShortNamesCache cache : this.getCaches()) {
            PsiField[] fields = cache.getFieldsByNameIfNotMoreThan(name2, scope, maxCount);
            if (fields.length == maxCount) {
                if (fields == null) {
                    CompositeShortNamesCache.$$$reportNull$$$0(24);
                }
                return fields;
            }
            if (fields.length == 0) continue;
            if (merger == null) {
                merger = new Merger<PsiField>();
            }
            merger.add(fields);
        }
        PsiField[] result = merger == null ? null : (PsiField[])merger.getResult();
        PsiField[] psiFieldArray = result == null ? PsiField.EMPTY_ARRAY : result;
        if (psiFieldArray == null) {
            CompositeShortNamesCache.$$$reportNull$$$0(25);
        }
        return psiFieldArray;
    }

    public boolean processMethodsWithName(@NonNls @NotNull String name2, @NotNull GlobalSearchScope scope, @NotNull Processor<? super PsiMethod> processor2) {
        if (name2 == null) {
            CompositeShortNamesCache.$$$reportNull$$$0(26);
        }
        if (scope == null) {
            CompositeShortNamesCache.$$$reportNull$$$0(27);
        }
        if (processor2 == null) {
            CompositeShortNamesCache.$$$reportNull$$$0(28);
        }
        return this.processMethodsWithName(name2, processor2, scope, null);
    }

    public boolean processMethodsWithName(@NonNls @NotNull String name2, @NotNull Processor<? super PsiMethod> processor2, @NotNull GlobalSearchScope scope, @Nullable IdFilter idFilter) {
        if (name2 == null) {
            CompositeShortNamesCache.$$$reportNull$$$0(29);
        }
        if (processor2 == null) {
            CompositeShortNamesCache.$$$reportNull$$$0(30);
        }
        if (scope == null) {
            CompositeShortNamesCache.$$$reportNull$$$0(31);
        }
        for (PsiShortNamesCache cache : this.getCaches()) {
            if (cache.processMethodsWithName(name2, processor2, scope, idFilter)) continue;
            return false;
        }
        return true;
    }

    public String @NotNull [] getAllMethodNames() {
        Merger<String> merger = new Merger<String>();
        for (PsiShortNamesCache cache : this.getCaches()) {
            merger.add(cache.getAllMethodNames());
        }
        String[] result = (String[])merger.getResult();
        String[] stringArray = result != null ? result : ArrayUtilRt.EMPTY_STRING_ARRAY;
        if (stringArray == null) {
            CompositeShortNamesCache.$$$reportNull$$$0(32);
        }
        return stringArray;
    }

    public PsiField @NotNull [] getFieldsByName(@NotNull String name2, @NotNull GlobalSearchScope scope) {
        if (name2 == null) {
            CompositeShortNamesCache.$$$reportNull$$$0(33);
        }
        if (scope == null) {
            CompositeShortNamesCache.$$$reportNull$$$0(34);
        }
        Merger<PsiField> merger = null;
        for (PsiShortNamesCache cache : this.getCaches()) {
            PsiField[] classes2 = cache.getFieldsByName(name2, scope);
            if (classes2.length == 0) continue;
            if (merger == null) {
                merger = new Merger<PsiField>();
            }
            merger.add(classes2);
        }
        PsiField[] result = merger == null ? null : (PsiField[])merger.getResult();
        PsiField[] psiFieldArray = result == null ? PsiField.EMPTY_ARRAY : result;
        if (psiFieldArray == null) {
            CompositeShortNamesCache.$$$reportNull$$$0(35);
        }
        return psiFieldArray;
    }

    public String @NotNull [] getAllFieldNames() {
        Merger<String> merger = null;
        for (PsiShortNamesCache cache : this.getCaches()) {
            String[] classes2 = cache.getAllFieldNames();
            if (classes2.length == 0) continue;
            if (merger == null) {
                merger = new Merger<String>();
            }
            merger.add(classes2);
        }
        String[] result = merger == null ? null : (String[])merger.getResult();
        String[] stringArray = result == null ? ArrayUtilRt.EMPTY_STRING_ARRAY : result;
        if (stringArray == null) {
            CompositeShortNamesCache.$$$reportNull$$$0(36);
        }
        return stringArray;
    }

    public boolean processFieldsWithName(@NotNull String key2, @NotNull Processor<? super PsiField> processor2, @NotNull GlobalSearchScope scope, @Nullable IdFilter filter) {
        if (key2 == null) {
            CompositeShortNamesCache.$$$reportNull$$$0(37);
        }
        if (processor2 == null) {
            CompositeShortNamesCache.$$$reportNull$$$0(38);
        }
        if (scope == null) {
            CompositeShortNamesCache.$$$reportNull$$$0(39);
        }
        for (PsiShortNamesCache cache : this.getCaches()) {
            if (cache.processFieldsWithName(key2, processor2, scope, filter)) continue;
            return false;
        }
        return true;
    }

    public boolean processClassesWithName(@NotNull String key2, @NotNull Processor<? super PsiClass> processor2, @NotNull GlobalSearchScope scope, @Nullable IdFilter filter) {
        if (key2 == null) {
            CompositeShortNamesCache.$$$reportNull$$$0(40);
        }
        if (processor2 == null) {
            CompositeShortNamesCache.$$$reportNull$$$0(41);
        }
        if (scope == null) {
            CompositeShortNamesCache.$$$reportNull$$$0(42);
        }
        for (PsiShortNamesCache cache : this.getCaches()) {
            if (cache.processClassesWithName(key2, processor2, scope, filter)) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        return "Composite cache: " + Collections.singletonList(this.getCaches());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 18: 
            case 19: 
            case 22: 
            case 23: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 33: 
            case 34: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 18: 
            case 19: 
            case 22: 
            case 23: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 33: 
            case 34: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/impl/CompositeShortNamesCache";
                break;
            }
            case 1: 
            case 4: 
            case 15: 
            case 18: 
            case 22: 
            case 26: 
            case 29: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 5: 
            case 10: 
            case 12: 
            case 14: 
            case 16: 
            case 19: 
            case 23: 
            case 27: 
            case 31: 
            case 34: 
            case 39: 
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 8: 
            case 9: 
            case 11: 
            case 13: 
            case 28: 
            case 30: 
            case 38: 
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 37: 
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getCaches";
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 18: 
            case 19: 
            case 22: 
            case 23: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 33: 
            case 34: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/impl/CompositeShortNamesCache";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getFilesByName";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllFileNames";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getClassesByName";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllClassNames";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getMethodsByName";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getMethodsByNameIfNotMoreThan";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "getFieldsByNameIfNotMoreThan";
                break;
            }
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllMethodNames";
                break;
            }
            case 35: {
                objectArray = objectArray2;
                objectArray2[1] = "getFieldsByName";
                break;
            }
            case 36: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllFieldNames";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getFilesByName";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getClassesByName";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "processAllClassNames";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "processAllMethodNames";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "processAllFieldNames";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getMethodsByName";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "getMethodsByNameIfNotMoreThan";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "getFieldsByNameIfNotMoreThan";
                break;
            }
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "processMethodsWithName";
                break;
            }
            case 33: 
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "getFieldsByName";
                break;
            }
            case 37: 
            case 38: 
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "processFieldsWithName";
                break;
            }
            case 40: 
            case 41: 
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "processClassesWithName";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 18: 
            case 19: 
            case 22: 
            case 23: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 33: 
            case 34: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class Merger<T> {
        private T[] mySingleItem;
        private Set<T> myAllItems;

        private Merger() {
        }

        public void add(T @NotNull [] items) {
            if (items == null) {
                Merger.$$$reportNull$$$0(0);
            }
            if (items.length == 0) {
                return;
            }
            if (this.mySingleItem == null) {
                this.mySingleItem = items;
                return;
            }
            if (this.myAllItems == null) {
                Object[] elements = this.mySingleItem;
                this.myAllItems = (Set)ContainerUtil.addAll((Collection)new THashSet(elements.length), (Object[])elements);
            }
            ContainerUtil.addAll(this.myAllItems, (Object[])items);
        }

        public T[] getResult() {
            if (this.myAllItems == null) {
                return this.mySingleItem;
            }
            return this.myAllItems.toArray(this.mySingleItem);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "items", "com/intellij/psi/impl/CompositeShortNamesCache$Merger", "add"));
        }
    }
}

