/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.ui.configuration.projectRoot;

import com.intellij.jarRepository.RepositoryLibraryType;
import com.intellij.openapi.roots.impl.libraries.LibraryEx;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.ui.configuration.ProjectStructureConfigurable;
import com.intellij.openapi.roots.ui.configuration.libraryEditor.ExistingLibraryEditor;
import com.intellij.openapi.roots.ui.configuration.libraryEditor.LibraryEditorBase;
import com.intellij.openapi.roots.ui.configuration.projectRoot.BaseLibrariesConfigurable;
import com.intellij.openapi.roots.ui.configuration.projectRoot.ConvertToRepositoryLibraryActionBase;
import com.intellij.openapi.roots.ui.configuration.projectRoot.LibrariesModifiableModel;
import com.intellij.openapi.roots.ui.configuration.projectRoot.StructureConfigurableContext;
import com.intellij.openapi.roots.ui.configuration.projectRoot.StructureLibraryTableModifiableModelProvider;
import com.intellij.openapi.roots.ui.configuration.projectRoot.daemon.LibraryProjectStructureElement;
import com.intellij.openapi.roots.ui.configuration.projectRoot.daemon.ProjectStructureElement;
import com.intellij.openapi.roots.ui.configuration.projectRoot.daemon.ProjectStructureElementUsage;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\n\u0010\u0007\u001a\u0004\u0018\u00010\bH\u0014J$\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0012\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\n0\u000eH\u0014R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/intellij/openapi/roots/ui/configuration/projectRoot/ConvertProjectLibraryToRepositoryLibraryAction;", "Lcom/intellij/openapi/roots/ui/configuration/projectRoot/ConvertToRepositoryLibraryActionBase;", "librariesConfigurable", "Lcom/intellij/openapi/roots/ui/configuration/projectRoot/BaseLibrariesConfigurable;", "context", "Lcom/intellij/openapi/roots/ui/configuration/projectRoot/StructureConfigurableContext;", "(Lcom/intellij/openapi/roots/ui/configuration/projectRoot/BaseLibrariesConfigurable;Lcom/intellij/openapi/roots/ui/configuration/projectRoot/StructureConfigurableContext;)V", "getSelectedLibrary", "Lcom/intellij/openapi/roots/impl/libraries/LibraryEx;", "replaceLibrary", "", "library", "Lcom/intellij/openapi/roots/libraries/Library;", "configureNewLibrary", "Lkotlin/Function1;", "Lcom/intellij/openapi/roots/ui/configuration/libraryEditor/LibraryEditorBase;", "intellij.java.ui"})
public final class ConvertProjectLibraryToRepositoryLibraryAction
extends ConvertToRepositoryLibraryActionBase {
    private final BaseLibrariesConfigurable librariesConfigurable;

    @Override
    @Nullable
    protected LibraryEx getSelectedLibrary() {
        ProjectStructureElement projectStructureElement = this.librariesConfigurable.getSelectedElement();
        if (!(projectStructureElement instanceof LibraryProjectStructureElement)) {
            projectStructureElement = null;
        }
        LibraryProjectStructureElement libraryProjectStructureElement = (LibraryProjectStructureElement)projectStructureElement;
        Object object = libraryProjectStructureElement != null ? libraryProjectStructureElement.getLibrary() : null;
        if (!(object instanceof LibraryEx)) {
            object = null;
        }
        return (LibraryEx)object;
    }

    @Override
    protected void replaceLibrary(@NotNull Library library, @NotNull Function1<? super LibraryEditorBase, Unit> configureNewLibrary) {
        ExistingLibraryEditor editor;
        Intrinsics.checkParameterIsNotNull((Object)library, (String)"library");
        Intrinsics.checkParameterIsNotNull(configureNewLibrary, (String)"configureNewLibrary");
        String name2 = library.getName();
        StructureLibraryTableModifiableModelProvider structureLibraryTableModifiableModelProvider = this.librariesConfigurable.getModelProvider();
        Intrinsics.checkExpressionValueIsNotNull((Object)structureLibraryTableModifiableModelProvider, (String)"librariesConfigurable.modelProvider");
        LibrariesModifiableModel modifiableModel = structureLibraryTableModifiableModelProvider.getModifiableModel();
        Collection<ProjectStructureElementUsage> usages = this.getContext().getDaemonAnalyzer().getUsages(new LibraryProjectStructureElement(this.getContext(), library));
        modifiableModel.removeLibrary(library);
        RepositoryLibraryType repositoryLibraryType = RepositoryLibraryType.getInstance();
        Intrinsics.checkExpressionValueIsNotNull((Object)((Object)repositoryLibraryType), (String)"RepositoryLibraryType.getInstance()");
        Library library2 = modifiableModel.createLibrary(name2, repositoryLibraryType.getKind(), null);
        Intrinsics.checkExpressionValueIsNotNull((Object)library2, (String)"modifiableModel.createLi\u2026getInstance().kind, null)");
        Library newLibrary = library2;
        Collection<ProjectStructureElementUsage> collection = usages;
        Intrinsics.checkExpressionValueIsNotNull(collection, (String)"usages");
        Iterable $this$forEach$iv = collection;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ProjectStructureElementUsage it = (ProjectStructureElementUsage)element$iv;
            boolean bl = false;
            it.replaceElement(new LibraryProjectStructureElement(this.getContext(), newLibrary));
        }
        ExistingLibraryEditor existingLibraryEditor = editor = modifiableModel.getLibraryEditor(newLibrary);
        Intrinsics.checkExpressionValueIsNotNull((Object)existingLibraryEditor, (String)"editor");
        configureNewLibrary.invoke((Object)existingLibraryEditor);
        ProjectStructureConfigurable.getInstance(this.getProject()).selectProjectOrGlobalLibrary(newLibrary, true);
    }

    public ConvertProjectLibraryToRepositoryLibraryAction(@NotNull BaseLibrariesConfigurable librariesConfigurable, @NotNull StructureConfigurableContext context) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)librariesConfigurable), (String)"librariesConfigurable");
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        super(context);
        this.librariesConfigurable = librariesConfigurable;
    }
}

