/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.ui.configuration.libraryEditor;

import com.intellij.ide.JavaUiBundle;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.roots.impl.libraries.LibraryEx;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.libraries.LibraryTable;
import com.intellij.openapi.roots.libraries.LibraryType;
import com.intellij.openapi.roots.ui.configuration.libraryEditor.LibraryEditorDialogBase;
import com.intellij.openapi.roots.ui.configuration.libraryEditor.LibraryRootsComponent;
import com.intellij.openapi.roots.ui.configuration.libraryEditor.NewLibraryEditor;
import com.intellij.openapi.roots.ui.configuration.projectRoot.StructureConfigurableContext;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.ui.SimpleListCellRenderer;
import com.intellij.util.ui.FormBuilder;
import java.util.List;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComponent;
import javax.swing.ListCellRenderer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CreateNewLibraryDialog
extends LibraryEditorDialogBase {
    private final StructureConfigurableContext myContext;
    private final NewLibraryEditor myLibraryEditor;
    private final ComboBox<LibraryTable> myLibraryLevelCombobox;

    public CreateNewLibraryDialog(@NotNull JComponent parent, @NotNull StructureConfigurableContext context, @NotNull NewLibraryEditor libraryEditor, @NotNull List<LibraryTable> libraryTables, int selectedTable) {
        if (parent == null) {
            CreateNewLibraryDialog.$$$reportNull$$$0(0);
        }
        if (context == null) {
            CreateNewLibraryDialog.$$$reportNull$$$0(1);
        }
        if (libraryEditor == null) {
            CreateNewLibraryDialog.$$$reportNull$$$0(2);
        }
        if (libraryTables == null) {
            CreateNewLibraryDialog.$$$reportNull$$$0(3);
        }
        super(parent, new LibraryRootsComponent(context.getProject(), libraryEditor));
        this.myContext = context;
        this.myLibraryEditor = libraryEditor;
        DefaultComboBoxModel<LibraryTable> model = new DefaultComboBoxModel<LibraryTable>();
        for (LibraryTable table : libraryTables) {
            model.addElement(table);
        }
        this.myLibraryLevelCombobox = new ComboBox(model);
        this.myLibraryLevelCombobox.setSelectedIndex(selectedTable);
        this.myLibraryLevelCombobox.setRenderer((ListCellRenderer)SimpleListCellRenderer.create((String)"", value2 -> value2.getPresentation().getDisplayName(false)));
        this.init();
    }

    @Override
    @NotNull
    protected LibraryTable.ModifiableModel getTableModifiableModel() {
        LibraryTable selectedTable = (LibraryTable)this.myLibraryLevelCombobox.getSelectedItem();
        LibraryTable.ModifiableModel modifiableModel = this.myContext.getModifiableLibraryTable(selectedTable);
        if (modifiableModel == null) {
            CreateNewLibraryDialog.$$$reportNull$$$0(4);
        }
        return modifiableModel;
    }

    @NotNull
    public Library createLibrary() {
        LibraryTable.ModifiableModel modifiableModel = this.getTableModifiableModel();
        LibraryType<?> type2 = this.myLibraryEditor.getType();
        Library library = modifiableModel.createLibrary(this.myLibraryEditor.getName(), type2 != null ? type2.getKind() : null);
        LibraryEx.ModifiableModelEx model = (LibraryEx.ModifiableModelEx)library.getModifiableModel();
        this.myLibraryEditor.applyTo(model);
        WriteAction.run(() -> model.commit());
        Library library2 = library;
        if (library2 == null) {
            CreateNewLibraryDialog.$$$reportNull$$$0(5);
        }
        return library2;
    }

    @Override
    protected void addNorthComponents(FormBuilder formBuilder) {
        formBuilder.addLabeledComponent(JavaUiBundle.message("label.library.level", new Object[0]), this.myLibraryLevelCombobox);
    }

    @Override
    protected boolean shouldCheckName(String newName) {
        return true;
    }

    @Nullable
    protected String getHelpId() {
        return "Create_Library_dialog";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "libraryEditor";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "libraryTables";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/roots/ui/configuration/libraryEditor/CreateNewLibraryDialog";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/roots/ui/configuration/libraryEditor/CreateNewLibraryDialog";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getTableModifiableModel";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "createLibrary";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: 
            case 5: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

