/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.ui.configuration.artifacts;

import com.intellij.openapi.roots.ui.configuration.artifacts.LayoutTree;
import com.intellij.openapi.roots.ui.configuration.artifacts.nodes.PackagingElementNode;
import com.intellij.packaging.elements.CompositePackagingElement;
import com.intellij.packaging.elements.PackagingElement;
import com.intellij.ui.treeStructure.SimpleNode;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LayoutTreeSelection {
    private final List<PackagingElementNode<?>> mySelectedNodes;
    private final List<PackagingElement<?>> mySelectedElements;
    private final Map<PackagingElement<?>, PackagingElementNode<?>> myElement2Node;
    private final Map<PackagingElementNode<?>, TreePath> myNode2Path;

    public LayoutTreeSelection(@NotNull LayoutTree tree) {
        if (tree == null) {
            LayoutTreeSelection.$$$reportNull$$$0(0);
        }
        this.mySelectedNodes = new ArrayList();
        this.mySelectedElements = new ArrayList();
        this.myElement2Node = new HashMap();
        this.myNode2Path = new HashMap();
        TreePath[] paths = tree.getSelectionPaths();
        if (paths == null) {
            return;
        }
        for (TreePath path : paths) {
            SimpleNode node = tree.getNodeFor(path);
            if (!(node instanceof PackagingElementNode)) continue;
            PackagingElementNode elementNode = (PackagingElementNode)node;
            this.mySelectedNodes.add(elementNode);
            this.myNode2Path.put(elementNode, path);
            for (PackagingElement element : elementNode.getPackagingElements()) {
                this.mySelectedElements.add(element);
                this.myElement2Node.put(element, elementNode);
            }
        }
    }

    public List<PackagingElementNode<?>> getNodes() {
        return this.mySelectedNodes;
    }

    public List<PackagingElement<?>> getElements() {
        return this.mySelectedElements;
    }

    public PackagingElementNode<?> getNode(@NotNull PackagingElement<?> element) {
        if (element == null) {
            LayoutTreeSelection.$$$reportNull$$$0(1);
        }
        return this.myElement2Node.get(element);
    }

    public TreePath getPath(@NotNull PackagingElementNode<?> node) {
        if (node == null) {
            LayoutTreeSelection.$$$reportNull$$$0(2);
        }
        return this.myNode2Path.get(node);
    }

    @Nullable
    public CompositePackagingElement<?> getCommonParentElement() {
        CompositePackagingElement<?> commonParent = null;
        for (PackagingElementNode<?> selectedNode : this.mySelectedNodes) {
            Object element = selectedNode.getElementIfSingle();
            if (element == null) {
                return null;
            }
            CompositePackagingElement<?> parentElement = selectedNode.getParentElement((PackagingElement<?>)element);
            if (parentElement == null || commonParent != null && !commonParent.equals(parentElement)) {
                return null;
            }
            commonParent = parentElement;
        }
        return commonParent;
    }

    @Nullable
    public PackagingElement<?> getElementIfSingle() {
        return this.mySelectedElements.size() == 1 ? this.mySelectedElements.get(0) : null;
    }

    @Nullable
    public PackagingElementNode<?> getNodeIfSingle() {
        return this.mySelectedNodes.size() == 1 ? this.mySelectedNodes.get(0) : null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tree";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
        }
        objectArray2[1] = "com/intellij/openapi/roots/ui/configuration/artifacts/LayoutTreeSelection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "getNode";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "getPath";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

