/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.ui.configuration.artifacts;

import com.intellij.openapi.ui.VerticalFlowLayout;
import com.intellij.packaging.artifacts.Artifact;
import com.intellij.packaging.artifacts.ArtifactProperties;
import com.intellij.packaging.artifacts.ArtifactPropertiesProvider;
import com.intellij.packaging.artifacts.ModifiableArtifact;
import com.intellij.packaging.impl.artifacts.ArtifactUtil;
import com.intellij.packaging.ui.ArtifactEditorContext;
import com.intellij.packaging.ui.ArtifactPropertiesEditor;
import com.intellij.ui.TabbedPaneWrapper;
import com.intellij.ui.components.JBScrollPane;
import java.awt.Component;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.Nullable;

public class ArtifactPropertiesEditors {
    private static final List<String> STANDARD_TABS_ORDER = Arrays.asList("Validation", "Pre-processing", "Post-processing");
    private final Map<String, JPanel> myMainPanels;
    private final ArtifactEditorContext myContext;
    private final Artifact myOriginalArtifact;
    private final List<PropertiesEditorInfo> myEditors;

    public ArtifactPropertiesEditors(ArtifactEditorContext context, Artifact originalArtifact, Artifact artifact) {
        this.myContext = context;
        this.myOriginalArtifact = originalArtifact;
        this.myMainPanels = new HashMap<String, JPanel>();
        this.myEditors = new ArrayList<PropertiesEditorInfo>();
        for (ArtifactPropertiesProvider provider : artifact.getPropertiesProviders()) {
            PropertiesEditorInfo editorInfo = new PropertiesEditorInfo(provider);
            this.myEditors.add(editorInfo);
            String tabName = editorInfo.myEditor.getTabName();
            JPanel panel2 = this.myMainPanels.get(tabName);
            if (panel2 == null) {
                panel2 = new JPanel((LayoutManager)new VerticalFlowLayout());
                this.myMainPanels.put(tabName, panel2);
            }
            panel2.add(editorInfo.myEditor.createComponent());
        }
    }

    public void applyProperties() {
        for (PropertiesEditorInfo editor : this.myEditors) {
            if (!editor.isModified()) continue;
            editor.applyProperties();
        }
    }

    public void addTabs(TabbedPaneWrapper tabbedPane) {
        ArrayList<String> sortedTabs = new ArrayList<String>(this.myMainPanels.keySet());
        sortedTabs.sort((o1, o2) -> {
            int i2;
            int i1 = STANDARD_TABS_ORDER.indexOf(o1);
            if (i1 == -1) {
                i1 = STANDARD_TABS_ORDER.size();
            }
            if ((i2 = STANDARD_TABS_ORDER.indexOf(o2)) == -1) {
                i2 = STANDARD_TABS_ORDER.size();
            }
            if (i1 != i2) {
                return i1 - i2;
            }
            return o1.compareTo((String)o2);
        });
        for (String tab : sortedTabs) {
            tabbedPane.addTab(tab, (JComponent)new JBScrollPane((Component)this.myMainPanels.get(tab)));
        }
    }

    public boolean isModified() {
        for (PropertiesEditorInfo editor : this.myEditors) {
            if (!editor.isModified()) continue;
            return true;
        }
        return false;
    }

    public void removeTabs(TabbedPaneWrapper tabbedPane) {
        block0: for (String tabName : this.myMainPanels.keySet()) {
            for (int i = 0; i < tabbedPane.getTabCount(); ++i) {
                if (!tabName.equals(tabbedPane.getTitleAt(i))) continue;
                tabbedPane.removeTabAt(i);
                continue block0;
            }
        }
    }

    @Nullable
    public String getHelpId(String title) {
        if ("Validation".equals(title)) {
            return "reference.project.structure.artifacts.validation";
        }
        if ("Pre-processing".equals(title)) {
            return "reference.project.structure.artifacts.preprocessing";
        }
        if ("Post-processing".equals(title)) {
            return "reference.project.structure.artifacts.postprocessing";
        }
        for (PropertiesEditorInfo editorInfo : this.myEditors) {
            ArtifactPropertiesEditor editor = editorInfo.myEditor;
            if (!editor.getTabName().equals(title)) continue;
            return editor.getHelpId();
        }
        return null;
    }

    private class PropertiesEditorInfo {
        private final ArtifactPropertiesEditor myEditor;
        private final ArtifactProperties<?> myProperties;
        private final ArtifactPropertiesProvider myProvider;

        private PropertiesEditorInfo(ArtifactPropertiesProvider provider) {
            if (provider == null) {
                PropertiesEditorInfo.$$$reportNull$$$0(0);
            }
            this.myProvider = provider;
            this.myProperties = provider.createProperties(ArtifactPropertiesEditors.this.myOriginalArtifact.getArtifactType());
            ArtifactProperties originalProperties = ArtifactPropertiesEditors.this.myOriginalArtifact.getProperties(provider);
            if (originalProperties != null) {
                ArtifactUtil.copyProperties(originalProperties, this.myProperties);
            }
            this.myEditor = this.myProperties.createEditor(ArtifactPropertiesEditors.this.myContext);
            this.myEditor.reset();
        }

        public void applyProperties() {
            this.myEditor.apply();
            ModifiableArtifact artifact = ArtifactPropertiesEditors.this.myContext.getOrCreateModifiableArtifactModel().getOrCreateModifiableArtifact(ArtifactPropertiesEditors.this.myOriginalArtifact);
            artifact.setProperties(this.myProvider, this.myProperties);
        }

        public boolean isModified() {
            return this.myEditor.isModified();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "provider", "com/intellij/openapi/roots/ui/configuration/artifacts/ArtifactPropertiesEditors$PropertiesEditorInfo", "<init>"));
        }
    }
}

