/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.ui.configuration.artifacts;

import com.intellij.openapi.roots.ui.configuration.artifacts.ArtifactEditorEx;
import com.intellij.openapi.roots.ui.configuration.artifacts.ArtifactProblemDescription;
import com.intellij.openapi.roots.ui.configuration.artifacts.ArtifactsStructureConfigurableContext;
import com.intellij.openapi.roots.ui.configuration.artifacts.PlaceInArtifact;
import com.intellij.openapi.roots.ui.configuration.projectRoot.daemon.ConfigurationErrorQuickFix;
import com.intellij.openapi.roots.ui.configuration.projectRoot.daemon.ProjectStructureProblemType;
import com.intellij.openapi.roots.ui.configuration.projectRoot.daemon.ProjectStructureProblemsHolder;
import com.intellij.packaging.artifacts.Artifact;
import com.intellij.packaging.elements.PackagingElement;
import com.intellij.packaging.impl.artifacts.PackagingElementPath;
import com.intellij.packaging.impl.ui.ArtifactProblemsHolderBase;
import com.intellij.packaging.ui.ArtifactEditor;
import com.intellij.packaging.ui.ArtifactProblemQuickFix;
import com.intellij.util.SmartList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ArtifactProblemsHolderImpl
extends ArtifactProblemsHolderBase {
    private final ArtifactsStructureConfigurableContext myContext;
    private final Artifact myOriginalArtifact;
    private final ProjectStructureProblemsHolder myProblemsHolder;

    public ArtifactProblemsHolderImpl(ArtifactsStructureConfigurableContext context, Artifact originalArtifact, ProjectStructureProblemsHolder problemsHolder) {
        super(context);
        this.myContext = context;
        this.myOriginalArtifact = originalArtifact;
        this.myProblemsHolder = problemsHolder;
    }

    public void registerError(@NotNull String message2, @NotNull String problemTypeId, @Nullable List<PackagingElement<?>> pathToPlace, ArtifactProblemQuickFix ... quickFixes) {
        if (message2 == null) {
            ArtifactProblemsHolderImpl.$$$reportNull$$$0(0);
        }
        if (problemTypeId == null) {
            ArtifactProblemsHolderImpl.$$$reportNull$$$0(1);
        }
        if (quickFixes == null) {
            ArtifactProblemsHolderImpl.$$$reportNull$$$0(2);
        }
        this.registerProblem(message2, pathToPlace, ProjectStructureProblemType.error(problemTypeId), quickFixes);
    }

    public void registerWarning(@NotNull String message2, @NotNull String problemTypeId, @Nullable List<PackagingElement<?>> pathToPlace, ArtifactProblemQuickFix ... quickFixes) {
        if (message2 == null) {
            ArtifactProblemsHolderImpl.$$$reportNull$$$0(3);
        }
        if (problemTypeId == null) {
            ArtifactProblemsHolderImpl.$$$reportNull$$$0(4);
        }
        if (quickFixes == null) {
            ArtifactProblemsHolderImpl.$$$reportNull$$$0(5);
        }
        this.registerProblem(message2, pathToPlace, ProjectStructureProblemType.warning(problemTypeId), quickFixes);
    }

    private void registerProblem(@NotNull String message2, @Nullable List<PackagingElement<?>> pathToPlace, ProjectStructureProblemType problemType, ArtifactProblemQuickFix ... quickFixes) {
        PackagingElement<?> element;
        String parentPath;
        if (message2 == null) {
            ArtifactProblemsHolderImpl.$$$reportNull$$$0(6);
        }
        if (quickFixes == null) {
            ArtifactProblemsHolderImpl.$$$reportNull$$$0(7);
        }
        if (pathToPlace != null && !pathToPlace.isEmpty()) {
            parentPath = PackagingElementPath.createPath(pathToPlace.subList(1, pathToPlace.size() - 1)).getPathString();
            element = pathToPlace.get(pathToPlace.size() - 1);
        } else {
            parentPath = null;
            element = null;
        }
        Artifact artifact = this.myContext.getArtifactModel().getArtifactByOriginal(this.myOriginalArtifact);
        PlaceInArtifact place = new PlaceInArtifact(artifact, this.myContext, parentPath, element);
        this.myProblemsHolder.registerProblem(new ArtifactProblemDescription(message2, problemType, pathToPlace, place, this.convertQuickFixes(quickFixes)));
    }

    private List<ConfigurationErrorQuickFix> convertQuickFixes(ArtifactProblemQuickFix[] quickFixes) {
        SmartList result = new SmartList();
        for (final ArtifactProblemQuickFix fix : quickFixes) {
            result.add(new ConfigurationErrorQuickFix(fix.getActionName()){

                @Override
                public void performFix() {
                    ArtifactEditor editor = ArtifactProblemsHolderImpl.this.myContext.getOrCreateEditor(ArtifactProblemsHolderImpl.this.myOriginalArtifact);
                    fix.performFix(((ArtifactEditorEx)editor).getContext());
                }
            });
        }
        return result;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "problemTypeId";
                break;
            }
            case 2: 
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "quickFixes";
                break;
            }
        }
        objectArray2[1] = "com/intellij/openapi/roots/ui/configuration/artifacts/ArtifactProblemsHolderImpl";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "registerError";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "registerWarning";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "registerProblem";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

