/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.ui.configuration;

import com.intellij.ide.JavaUiBundle;
import com.intellij.openapi.module.ModuleConfigurationEditor;
import com.intellij.openapi.roots.ui.configuration.AnnotationsEditor;
import com.intellij.openapi.roots.ui.configuration.BuildElementsEditor;
import com.intellij.openapi.roots.ui.configuration.JavadocEditor;
import com.intellij.openapi.roots.ui.configuration.ModuleConfigurationState;
import com.intellij.openapi.roots.ui.configuration.ModuleElementsEditor;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.Arrays;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.Nullable;

public class OutputEditor
extends ModuleElementsEditor {
    private final BuildElementsEditor myCompilerOutputEditor;
    private final JavadocEditor myJavadocEditor;
    private final AnnotationsEditor myAnnotationsEditor;
    private final List<ModuleElementsEditor> myEditors;

    protected OutputEditor(ModuleConfigurationState state) {
        super(state);
        this.myCompilerOutputEditor = new BuildElementsEditor(state);
        this.myJavadocEditor = new JavadocEditor(state);
        this.myAnnotationsEditor = new AnnotationsEditor(state);
        this.myEditors = Arrays.asList(new ModuleElementsEditor[]{this.myCompilerOutputEditor, this.myJavadocEditor, this.myAnnotationsEditor});
        this.myEditors.forEach(editor -> editor.addListener(() -> ((OutputEditor)this).fireConfigurationChanged()));
    }

    protected JComponent createComponentImpl() {
        JPanel panel2 = new JPanel(new GridBagLayout());
        panel2.setBorder(new EmptyBorder(UIUtil.PANEL_SMALL_INSETS));
        GridBagConstraints gc = new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 18, 1, (Insets)JBUI.emptyInsets(), 0, 0);
        panel2.add((Component)this.myCompilerOutputEditor.createComponentImpl(), gc);
        JPanel javadocPanel = (JPanel)this.myJavadocEditor.createComponentImpl();
        javadocPanel.setBorder((Border)IdeBorderFactory.createTitledBorder((String)this.myJavadocEditor.getDisplayName(), (boolean)false));
        gc.weighty = 1.0;
        panel2.add((Component)javadocPanel, gc);
        JPanel annotationsPanel = (JPanel)this.myAnnotationsEditor.createComponentImpl();
        annotationsPanel.setBorder((Border)IdeBorderFactory.createTitledBorder((String)this.myAnnotationsEditor.getDisplayName(), (boolean)false));
        panel2.add((Component)annotationsPanel, gc);
        return panel2;
    }

    public void saveData() {
        super.saveData();
        this.myEditors.forEach(ModuleConfigurationEditor::saveData);
    }

    public String getDisplayName() {
        return OutputEditor.getName();
    }

    public void moduleStateChanged() {
        super.moduleStateChanged();
        this.myEditors.forEach(ModuleConfigurationEditor::moduleStateChanged);
    }

    public void moduleCompileOutputChanged(String baseUrl, String moduleName) {
        super.moduleCompileOutputChanged(baseUrl, moduleName);
        this.myEditors.forEach(editor -> editor.moduleCompileOutputChanged(baseUrl, moduleName));
    }

    @Nullable
    @NonNls
    public String getHelpTopic() {
        return "projectStructure.modules.paths";
    }

    public static String getName() {
        return JavaUiBundle.message("project.roots.path.tab.title", new Object[0]);
    }
}

