/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.util.projectWizard.importSources.util;

import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.NullableFunction;
import com.intellij.util.text.StringFactory;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import org.jetbrains.annotations.Nullable;

public abstract class CommonSourceRootDetectionUtil<F> {
    public static final CommonSourceRootDetectionUtil<File> IO_FILE = new CommonSourceRootDetectionUtil<File>(){

        @Override
        protected String getName(File file) {
            return file.getName();
        }

        @Override
        protected File getParentFile(File file) {
            return file.getParentFile();
        }

        @Override
        protected CharSequence loadText(File file) throws IOException {
            return StringFactory.createShared((char[])CommonSourceRootDetectionUtil.loadFileTextSkippingBom(file));
        }

        @Override
        protected boolean isFile(File file) {
            return file.isFile();
        }
    };
    public static final CommonSourceRootDetectionUtil<VirtualFile> VIRTUAL_FILE = new CommonSourceRootDetectionUtil<VirtualFile>(){

        @Override
        protected String getName(VirtualFile file) {
            return file.getName();
        }

        @Override
        protected VirtualFile getParentFile(VirtualFile file) {
            return file.getParent();
        }

        @Override
        protected CharSequence loadText(VirtualFile file) throws IOException {
            return VfsUtilCore.loadText((VirtualFile)file);
        }

        @Override
        protected boolean isFile(VirtualFile file) {
            return !file.isDirectory();
        }
    };

    protected CommonSourceRootDetectionUtil() {
    }

    @Nullable
    public Pair<F, String> suggestRootForFileWithPackageStatement(F file, F topmostPossibleRoot, NullableFunction<? super CharSequence, String> packageNameFetcher, boolean packagePrefixSupported) {
        CharSequence chars;
        if (!this.isFile(file)) {
            return null;
        }
        try {
            chars = this.loadText(file);
        }
        catch (IOException e) {
            return null;
        }
        String packageName = (String)packageNameFetcher.fun((Object)chars);
        if (packageName != null) {
            F root = this.getParentFile(file);
            int index = packageName.length();
            while (index > 0) {
                boolean equalsToToken;
                int index1 = packageName.lastIndexOf(46, index - 1);
                String token = packageName.substring(index1 + 1, index);
                String dirName = this.getName(root);
                boolean bl = equalsToToken = SystemInfo.isFileSystemCaseSensitive ? dirName.equals(token) : dirName.equalsIgnoreCase(token);
                if (!equalsToToken || root.equals(topmostPossibleRoot)) {
                    String packagePrefix = packageName.substring(0, index);
                    if (!packagePrefixSupported && packagePrefix.length() > 0) {
                        return null;
                    }
                    return Pair.create(root, (Object)packagePrefix);
                }
                if ((root = this.getParentFile(root)) == null) {
                    return null;
                }
                index = index1;
            }
            return Pair.create(root, (Object)"");
        }
        return null;
    }

    protected abstract String getName(F var1);

    @Nullable
    protected abstract F getParentFile(F var1);

    protected abstract CharSequence loadText(F var1) throws IOException;

    protected abstract boolean isFile(F var1);

    private static char[] loadFileTextSkippingBom(File file) throws IOException {
        try (InputStream stream = CharsetToolkit.inputStreamSkippingBOM((InputStream)new BufferedInputStream(new FileInputStream(file)));){
            char[] cArray;
            try (InputStreamReader reader = new InputStreamReader(stream, StandardCharsets.UTF_8);){
                cArray = FileUtilRt.loadText((Reader)reader, (int)((int)file.length()));
            }
            return cArray;
        }
    }
}

