/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.todo.nodes;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.projectView.PresentationData;
import com.intellij.ide.projectView.ViewSettings;
import com.intellij.ide.projectView.impl.nodes.PackageElement;
import com.intellij.ide.projectView.impl.nodes.PackageElementNode;
import com.intellij.ide.todo.TodoFileDirAndModuleComparator;
import com.intellij.ide.todo.TodoTreeBuilder;
import com.intellij.ide.todo.TodoTreeStructure;
import com.intellij.ide.todo.nodes.TodoFileNode;
import com.intellij.ide.todo.nodes.TodoJavaTreeHelper;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.psi.JavaDirectoryService;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.ArrayUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class TodoPackageNode
extends PackageElementNode {
    private final TodoTreeBuilder myBuilder;
    @Nullable
    private final String myPresentationName;

    public TodoPackageNode(@NotNull Project project, @NotNull PackageElement element, TodoTreeBuilder builder) {
        if (project == null) {
            TodoPackageNode.$$$reportNull$$$0(0);
        }
        if (element == null) {
            TodoPackageNode.$$$reportNull$$$0(1);
        }
        this(project, element, builder, null);
    }

    public TodoPackageNode(@NotNull Project project, @NotNull PackageElement element, TodoTreeBuilder builder, @Nullable String name2) {
        if (project == null) {
            TodoPackageNode.$$$reportNull$$$0(2);
        }
        if (element == null) {
            TodoPackageNode.$$$reportNull$$$0(3);
        }
        super(project, element, ViewSettings.DEFAULT);
        this.myBuilder = builder;
        if (name2 == null) {
            PsiPackage aPackage = element.getPackage();
            this.myPresentationName = aPackage.getName();
        } else {
            this.myPresentationName = name2;
        }
    }

    @Override
    protected void update(@NotNull PresentationData data) {
        if (data == null) {
            TodoPackageNode.$$$reportNull$$$0(4);
        }
        super.update(data);
        PackageElement packageElement = (PackageElement)this.getValue();
        try {
            if (packageElement == null || !packageElement.getPackage().isValid()) {
                this.setValue(null);
                return;
            }
            int fileCount = this.getFileCount(packageElement);
            if (fileCount == 0) {
                this.setValue(null);
                return;
            }
            PsiPackage aPackage = packageElement.getPackage();
            String newName = this.getStructure().areFlattenPackages() ? aPackage.getQualifiedName() : (this.myPresentationName != null ? this.myPresentationName : "");
            int todoItemCount = this.getTodoItemCount(packageElement);
            data.setLocationString(IdeBundle.message((String)"node.todo.group", (Object[])new Object[]{todoItemCount}));
            data.setPresentableText(newName);
        }
        catch (IndexNotReadyException e) {
            LOG.info((Throwable)e);
            data.setPresentableText("N/A");
        }
    }

    public void apply(@NotNull Map<String, String> info) {
        if (info == null) {
            TodoPackageNode.$$$reportNull$$$0(5);
        }
        info.put("toDoFileCount", String.valueOf(this.getFileCount((PackageElement)this.getValue())));
        info.put("toDoItemCount", String.valueOf(this.getTodoItemCount((PackageElement)this.getValue())));
    }

    private int getFileCount(PackageElement packageElement) {
        int count = 0;
        if (this.getSettings().isFlattenPackages()) {
            PsiDirectory[] directories;
            PsiPackage aPackage = packageElement.getPackage();
            Module module = packageElement.getModule();
            GlobalSearchScope scope = module != null ? GlobalSearchScope.moduleScope((Module)module) : GlobalSearchScope.projectScope((Project)aPackage.getProject());
            for (PsiDirectory directory : directories = aPackage.getDirectories(scope)) {
                Iterator iterator = this.myBuilder.getFilesUnderDirectory(directory);
                while (iterator.hasNext()) {
                    PsiFile psiFile = (PsiFile)iterator.next();
                    if (!this.getStructure().accept(psiFile)) continue;
                    ++count;
                }
            }
        } else {
            Iterator<PsiFile> iterator = this.getFiles(packageElement);
            while (iterator.hasNext()) {
                PsiFile psiFile = iterator.next();
                if (!this.getStructure().accept(psiFile)) continue;
                ++count;
            }
        }
        return count;
    }

    public int getTodoItemCount(PackageElement packageElement) {
        int count = 0;
        if (this.getSettings().isFlattenPackages()) {
            PsiDirectory[] directories;
            PsiPackage aPackage = packageElement.getPackage();
            Module module = packageElement.getModule();
            GlobalSearchScope scope = module != null ? GlobalSearchScope.moduleScope((Module)module) : GlobalSearchScope.projectScope((Project)aPackage.getProject());
            for (PsiDirectory directory : directories = aPackage.getDirectories(scope)) {
                Iterator iterator = this.myBuilder.getFilesUnderDirectory(directory);
                while (iterator.hasNext()) {
                    PsiFile psiFile = (PsiFile)iterator.next();
                    count += this.getStructure().getTodoItemCount(psiFile);
                }
            }
        } else {
            Iterator<PsiFile> iterator = this.getFiles(packageElement);
            while (iterator.hasNext()) {
                PsiFile psiFile = iterator.next();
                count += this.getStructure().getTodoItemCount(psiFile);
            }
        }
        return count;
    }

    private TodoTreeStructure getStructure() {
        return this.myBuilder.getTodoTreeStructure();
    }

    @Override
    @NotNull
    public Collection<AbstractTreeNode<?>> getChildren() {
        ArrayList children = new ArrayList();
        Project project = this.getProject();
        ProjectFileIndex projectFileIndex = ProjectRootManager.getInstance((Project)Objects.requireNonNull(project)).getFileIndex();
        PackageElement value2 = (PackageElement)this.getValue();
        if (value2 == null) {
            ArrayList arrayList = children;
            if (arrayList == null) {
                TodoPackageNode.$$$reportNull$$$0(6);
            }
            return arrayList;
        }
        PsiPackage psiPackage = value2.getPackage();
        Module module = value2.getModule();
        Iterator<PsiFile> iterator = this.getFiles(value2);
        if (!this.getStructure().getIsFlattenPackages()) {
            block0: while (iterator.hasNext()) {
                PsiFile psiFile = iterator.next();
                Module psiFileModule = projectFileIndex.getModuleForFile(psiFile.getVirtualFile());
                if (module != null && psiFileModule != null && !module.equals(psiFileModule)) continue;
                GlobalSearchScope scope = module != null ? GlobalSearchScope.moduleScope((Module)module) : GlobalSearchScope.projectScope((Project)project);
                PsiDirectory containingDirectory = psiFile.getContainingDirectory();
                TodoFileNode todoFileNode = new TodoFileNode(project, psiFile, this.myBuilder, false);
                if (ArrayUtil.find((Object[])psiPackage.getDirectories(scope), (Object)containingDirectory) > -1) {
                    if (children.contains(todoFileNode)) continue;
                    children.add((AbstractTreeNode<?>)todoFileNode);
                    continue;
                }
                PsiDirectory _dir = psiFile.getContainingDirectory();
                while (_dir != null) {
                    String name2;
                    TodoPackageNode todoPackageNode;
                    PsiPackage _package;
                    PsiDirectory parentDirectory = _dir.getParentDirectory();
                    if (parentDirectory != null && (_package = JavaDirectoryService.getInstance().getPackage(_dir)) != null && psiPackage.equals(_package.getParentPackage()) && !children.contains((Object)(todoPackageNode = new TodoPackageNode(project, new PackageElement(module, _package, false), this.myBuilder, name2 = psiPackage.equals(Objects.requireNonNull(_package = TodoJavaTreeHelper.findNonEmptyPackage(_package, module, project, this.myBuilder, scope)).getParentPackage()) ? null : _package.getQualifiedName().substring(psiPackage.getQualifiedName().length() + 1))))) {
                        children.add((AbstractTreeNode<?>)todoPackageNode);
                        continue block0;
                    }
                    _dir = parentDirectory;
                }
            }
        } else {
            while (iterator.hasNext()) {
                PsiFile psiFile = iterator.next();
                Module psiFileModule = projectFileIndex.getModuleForFile(psiFile.getVirtualFile());
                if (module != null && psiFileModule != null && !module.equals(psiFileModule)) continue;
                PsiDirectory _dir = psiFile.getContainingDirectory();
                TodoFileNode todoFileNode = new TodoFileNode(this.getProject(), psiFile, this.myBuilder, false);
                if (ArrayUtil.find((Object[])psiPackage.getDirectories(), (Object)_dir) <= -1 || children.contains(todoFileNode)) continue;
                children.add((AbstractTreeNode<?>)todoFileNode);
            }
        }
        children.sort((Comparator<AbstractTreeNode<?>>)TodoFileDirAndModuleComparator.INSTANCE);
        ArrayList arrayList = children;
        if (arrayList == null) {
            TodoPackageNode.$$$reportNull$$$0(7);
        }
        return arrayList;
    }

    public Iterator<PsiFile> getFiles(PackageElement packageElement) {
        PsiDirectory[] directories;
        ArrayList<PsiFile> psiFileList = new ArrayList<PsiFile>();
        GlobalSearchScope scope = packageElement.getModule() != null ? GlobalSearchScope.moduleScope((Module)packageElement.getModule()) : GlobalSearchScope.projectScope((Project)this.myProject);
        for (PsiDirectory directory : directories = packageElement.getPackage().getDirectories(scope)) {
            Iterator files = this.myBuilder.getFiles(directory, false);
            while (files.hasNext()) {
                psiFileList.add((PsiFile)files.next());
            }
        }
        return psiFileList.iterator();
    }

    @Override
    public int getWeight() {
        return 3;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "data";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/todo/nodes/TodoPackageNode";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/todo/nodes/TodoPackageNode";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildren";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "apply";
                break;
            }
            case 6: 
            case 7: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

