/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.projectView.impl;

import com.intellij.history.LocalHistory;
import com.intellij.history.LocalHistoryAction;
import com.intellij.icons.AllIcons;
import com.intellij.ide.DeleteProvider;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.SelectInTarget;
import com.intellij.ide.impl.PackagesPaneSelectInTarget;
import com.intellij.ide.projectView.BaseProjectTreeBuilder;
import com.intellij.ide.projectView.ProjectView;
import com.intellij.ide.projectView.ViewSettings;
import com.intellij.ide.projectView.impl.AbstractProjectViewPSIPane;
import com.intellij.ide.projectView.impl.ProjectAbstractTreeStructureBase;
import com.intellij.ide.projectView.impl.ProjectTreeStructure;
import com.intellij.ide.projectView.impl.ProjectViewTree;
import com.intellij.ide.projectView.impl.nodes.PackageElement;
import com.intellij.ide.projectView.impl.nodes.PackageElementNode;
import com.intellij.ide.projectView.impl.nodes.PackageUtil;
import com.intellij.ide.projectView.impl.nodes.PackageViewProjectNode;
import com.intellij.ide.util.DeleteHandler;
import com.intellij.ide.util.treeView.AbstractTreeBuilder;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.ide.util.treeView.AbstractTreeUpdater;
import com.intellij.java.JavaBundle;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleGrouperKt;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaDirectoryService;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.PlatformUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.tree.TreeUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import javax.swing.Icon;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PackageViewPane
extends AbstractProjectViewPSIPane {
    @NonNls
    public static final String ID = "PackagesPane";
    private final MyDeletePSIElementProvider myDeletePSIElementProvider = new MyDeletePSIElementProvider();

    public PackageViewPane(Project project) {
        super(project);
    }

    @NotNull
    public String getTitle() {
        String string = JavaBundle.message((String)"title.packages", (Object[])new Object[0]);
        if (string == null) {
            PackageViewPane.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NotNull
    public Icon getIcon() {
        Icon icon = AllIcons.Nodes.CopyOfFolder;
        if (icon == null) {
            PackageViewPane.$$$reportNull$$$0(1);
        }
        return icon;
    }

    @NotNull
    public String getId() {
        return ID;
    }

    @NotNull
    public List<PsiElement> getElementsFromNode(@Nullable Object node) {
        Object o = this.getValueFromNode(node);
        if (o instanceof PackageElement) {
            PsiPackage aPackage = ((PackageElement)o).getPackage();
            List list = ContainerUtil.createMaybeSingletonList((Object)(aPackage.isValid() ? aPackage : null));
            if (list == null) {
                PackageViewPane.$$$reportNull$$$0(2);
            }
            return list;
        }
        List list = super.getElementsFromNode(node);
        if (list == null) {
            PackageViewPane.$$$reportNull$$$0(3);
        }
        return list;
    }

    protected Module getNodeModule(@Nullable Object element) {
        if (element instanceof PackageElement) {
            return ((PackageElement)element).getModule();
        }
        return super.getNodeModule(element);
    }

    public Object getData(@NotNull String dataId) {
        PackageElement packageElement;
        PackageElement selectedPackageElement;
        if (dataId == null) {
            PackageViewPane.$$$reportNull$$$0(4);
        }
        if (PlatformDataKeys.DELETE_ELEMENT_PROVIDER.is(dataId) && (selectedPackageElement = this.getSelectedPackageElement()) != null) {
            return this.myDeletePSIElementProvider;
        }
        if (PackageElement.DATA_KEY.is(dataId)) {
            selectedPackageElement = this.getSelectedPackageElement();
        }
        if (LangDataKeys.MODULE.is(dataId) && (packageElement = this.getSelectedPackageElement()) != null) {
            return packageElement.getModule();
        }
        return super.getData(dataId);
    }

    @Nullable
    private PackageElement getSelectedPackageElement() {
        AbstractTreeNode node = (AbstractTreeNode)TreeUtil.getLastUserObject(AbstractTreeNode.class, (TreePath)this.getSelectedPath());
        Object selected = node == null ? null : node.getValue();
        return selected instanceof PackageElement ? (PackageElement)selected : null;
    }

    public PsiDirectory @NotNull [] getSelectedDirectories() {
        ArrayList directories = new ArrayList();
        for (PackageElementNode node : this.getSelectedNodes(PackageElementNode.class)) {
            PsiPackage parentNodePackage;
            Module module;
            PackageElement packageElement = (PackageElement)node.getValue();
            PsiPackage aPackage = packageElement != null ? packageElement.getPackage() : null;
            Module module2 = module = packageElement != null ? packageElement.getModule() : null;
            if (aPackage == null || module == null) continue;
            GlobalSearchScope scope = GlobalSearchScope.moduleScope((Module)module);
            Collections.addAll(directories, aPackage.getDirectories(scope));
            if (!Registry.is((String)"projectView.choose.directory.on.compacted.middle.packages")) continue;
            Object parentValue = node.getParent().getValue();
            PsiPackage psiPackage = parentNodePackage = parentValue instanceof PackageElement ? ((PackageElement)parentValue).getPackage() : null;
            while ((aPackage = aPackage.getParentPackage()) != null && !aPackage.getQualifiedName().isEmpty() && !aPackage.equals(parentNodePackage)) {
                Collections.addAll(directories, aPackage.getDirectories(scope));
            }
        }
        if (!directories.isEmpty()) {
            PsiDirectory[] psiDirectoryArray = directories.toArray(PsiDirectory.EMPTY_ARRAY);
            if (psiDirectoryArray == null) {
                PackageViewPane.$$$reportNull$$$0(5);
            }
            return psiDirectoryArray;
        }
        PsiDirectory[] psiDirectoryArray = super.getSelectedDirectories();
        if (psiDirectoryArray == null) {
            PackageViewPane.$$$reportNull$$$0(6);
        }
        return psiDirectoryArray;
    }

    @NotNull
    protected AbstractTreeUpdater createTreeUpdater(@NotNull AbstractTreeBuilder treeBuilder) {
        if (treeBuilder == null) {
            PackageViewPane.$$$reportNull$$$0(7);
        }
        return new PackageViewTreeUpdater(treeBuilder);
    }

    @NotNull
    public SelectInTarget createSelectInTarget() {
        return new PackagesPaneSelectInTarget(this.myProject);
    }

    @NotNull
    protected ProjectAbstractTreeStructureBase createStructure() {
        return new ProjectTreeStructure(this.myProject, ID){

            protected AbstractTreeNode createRoot(@NotNull Project project, @NotNull ViewSettings settings) {
                if (project == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (settings == null) {
                    1.$$$reportNull$$$0(1);
                }
                return new PackageViewProjectNode(project, settings);
            }

            public boolean isToBuildChildrenInBackground(@NotNull Object element) {
                if (element == null) {
                    1.$$$reportNull$$$0(2);
                }
                return Registry.is((String)"ide.projectView.PackageViewTreeStructure.BuildChildrenInBackground");
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "project";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "settings";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "element";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/ide/projectView/impl/PackageViewPane$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "createRoot";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "isToBuildChildrenInBackground";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
    }

    @NotNull
    protected ProjectViewTree createTree(@NotNull DefaultTreeModel treeModel) {
        if (treeModel == null) {
            PackageViewPane.$$$reportNull$$$0(8);
        }
        return new ProjectViewTree(treeModel){

            public String toString() {
                return PackageViewPane.this.getTitle() + " " + super.toString();
            }
        };
    }

    @NotNull
    public String getComponentName() {
        return ID;
    }

    public int getWeight() {
        return 1;
    }

    private Project getProject() {
        return this.myProject;
    }

    protected BaseProjectTreeBuilder createBuilder(@NotNull DefaultTreeModel model) {
        if (model == null) {
            PackageViewPane.$$$reportNull$$$0(9);
        }
        return null;
    }

    public boolean supportsFlattenModules() {
        return PlatformUtils.isIntelliJ() && ModuleGrouperKt.isQualifiedModuleNamesEnabled((Project)this.myProject) && ProjectView.getInstance((Project)this.myProject).isShowModules(ID);
    }

    public boolean supportsShowLibraryContents() {
        return true;
    }

    public boolean supportsShowModules() {
        return PlatformUtils.isIntelliJ();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 4: 
            case 7: 
            case 8: 
            case 9: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 4: 
            case 7: 
            case 8: 
            case 9: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/projectView/impl/PackageViewPane";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataId";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "treeBuilder";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "treeModel";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getTitle";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getIcon";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getElementsFromNode";
                break;
            }
            case 4: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/projectView/impl/PackageViewPane";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectedDirectories";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getData";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "createTreeUpdater";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "createTree";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "createBuilder";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 4: 
            case 7: 
            case 8: 
            case 9: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private final class MyDeletePSIElementProvider
    implements DeleteProvider {
        private MyDeletePSIElementProvider() {
        }

        public boolean canDeleteElement(@NotNull DataContext dataContext) {
            if (dataContext == null) {
                MyDeletePSIElementProvider.$$$reportNull$$$0(0);
            }
            for (PsiDirectory directory : PackageViewPane.this.getSelectedDirectories()) {
                if (directory.getManager().isInProject((PsiElement)directory)) continue;
                return false;
            }
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void deleteElement(@NotNull DataContext dataContext) {
            if (dataContext == null) {
                MyDeletePSIElementProvider.$$$reportNull$$$0(1);
            }
            PsiDirectory[] allElements = PackageViewPane.this.getSelectedDirectories();
            ArrayList<PsiDirectory> validElements = new ArrayList<PsiDirectory>();
            for (PsiDirectory psiElement : allElements) {
                if (psiElement == null || !psiElement.isValid()) continue;
                validElements.add(psiElement);
            }
            PsiElement[] elements = PsiUtilCore.toPsiElementArray(validElements);
            LocalHistoryAction a = LocalHistory.getInstance().startAction(IdeBundle.message((String)"progress.deleting", (Object[])new Object[0]));
            try {
                DeleteHandler.deletePsiElement((PsiElement[])elements, (Project)PackageViewPane.this.getProject());
            }
            finally {
                a.finish();
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "dataContext";
            objectArray2[1] = "com/intellij/ide/projectView/impl/PackageViewPane$MyDeletePSIElementProvider";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "canDeleteElement";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "deleteElement";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private final class PackageViewTreeUpdater
    extends AbstractTreeUpdater {
        private PackageViewTreeUpdater(AbstractTreeBuilder treeBuilder) {
            super(treeBuilder);
        }

        public boolean addSubtreeToUpdateByElement(@NotNull Object element) {
            if (element == null) {
                PackageViewTreeUpdater.$$$reportNull$$$0(0);
            }
            if (element instanceof PsiDirectory) {
                PsiDirectory dir = (PsiDirectory)element;
                PsiPackage aPackage = JavaDirectoryService.getInstance().getPackage(dir);
                if (ProjectView.getInstance((Project)PackageViewPane.this.getProject()).isShowModules(PackageViewPane.this.getId())) {
                    Module[] modules = this.getModulesFor(dir);
                    boolean rv = false;
                    for (Module module : modules) {
                        rv |= this.addPackageElementToUpdate(aPackage, module);
                    }
                    return rv;
                }
                return this.addPackageElementToUpdate(aPackage, null);
            }
            return super.addSubtreeToUpdateByElement(element);
        }

        private boolean addPackageElementToUpdate(PsiPackage aPackage, Module module) {
            boolean addedOk;
            PsiPackage packageToUpdateFrom;
            ProjectTreeStructure packageTreeStructure = (ProjectTreeStructure)PackageViewPane.this.getTreeStructure();
            if (!packageTreeStructure.isFlattenPackages() && packageTreeStructure.isHideEmptyMiddlePackages()) {
                for (packageToUpdateFrom = aPackage; packageToUpdateFrom != null && packageToUpdateFrom.isValid() && PackageUtil.isPackageEmpty(packageToUpdateFrom, module, true, false); packageToUpdateFrom = packageToUpdateFrom.getParentPackage()) {
                }
            }
            while (!(addedOk = super.addSubtreeToUpdateByElement(this.getTreeElementToUpdateFrom(packageToUpdateFrom, module))) && packageToUpdateFrom != null) {
                packageToUpdateFrom = packageToUpdateFrom.getParentPackage();
            }
            return addedOk;
        }

        @NotNull
        private Object getTreeElementToUpdateFrom(PsiPackage packageToUpdateFrom, Module module) {
            if (packageToUpdateFrom == null || !packageToUpdateFrom.isValid() || "".equals(packageToUpdateFrom.getQualifiedName())) {
                Object object = module == null ? PackageViewPane.this.getTreeStructure().getRootElement() : module;
                if (object == null) {
                    PackageViewTreeUpdater.$$$reportNull$$$0(1);
                }
                return object;
            }
            return new PackageElement(module, packageToUpdateFrom, false);
        }

        private Module[] getModulesFor(PsiDirectory dir) {
            ProjectFileIndex fileIndex = ProjectRootManager.getInstance((Project)PackageViewPane.this.getProject()).getFileIndex();
            VirtualFile vFile = dir.getVirtualFile();
            HashSet<Module> modules = new HashSet<Module>();
            Module module = fileIndex.getModuleForFile(vFile);
            if (module != null) {
                modules.add(module);
            }
            if (fileIndex.isInLibrary(vFile)) {
                List orderEntries = fileIndex.getOrderEntriesForFile(vFile);
                if (orderEntries.isEmpty()) {
                    return Module.EMPTY_ARRAY;
                }
                for (OrderEntry entry : orderEntries) {
                    modules.add(entry.getOwnerModule());
                }
            }
            return modules.toArray(Module.EMPTY_ARRAY);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/ide/projectView/impl/PackageViewPane$PackageViewTreeUpdater";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/ide/projectView/impl/PackageViewPane$PackageViewTreeUpdater";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getTreeElementToUpdateFrom";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "addSubtreeToUpdateByElement";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

