/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions;

import com.intellij.codeInsight.daemon.impl.analysis.JavaModuleGraphUtil;
import com.intellij.icons.AllIcons;
import com.intellij.ide.IdeView;
import com.intellij.ide.fileTemplates.FileTemplate;
import com.intellij.ide.fileTemplates.FileTemplateManager;
import com.intellij.ide.fileTemplates.actions.AttributesDefaults;
import com.intellij.ide.fileTemplates.actions.CreateFromTemplateActionBase;
import com.intellij.java.JavaBundle;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.light.LightJavaModule;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collections;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.model.java.JavaSourceRootType;

public class CreateModuleInfoAction
extends CreateFromTemplateActionBase {
    public CreateModuleInfoAction() {
        super(JavaBundle.messagePointer((String)"action.create.new.module-info.title", (Object[])new Object[0]), JavaBundle.messagePointer((String)"action.create.new.module-info.description", (Object[])new Object[0]), AllIcons.FileTypes.Java);
    }

    public void update(@NotNull AnActionEvent e) {
        DataContext ctx;
        IdeView view;
        PsiDirectory target;
        if (e == null) {
            CreateModuleInfoAction.$$$reportNull$$$0(0);
        }
        PsiDirectory psiDirectory = target = (view = (IdeView)LangDataKeys.IDE_VIEW.getData(ctx = e.getDataContext())) != null && e.getProject() != null ? this.getTargetDirectory(ctx, view) : null;
        if (target == null || !PsiUtil.isLanguageLevel9OrHigher(target)) {
            e.getPresentation().setEnabledAndVisible(false);
        } else {
            e.getPresentation().setVisible(true);
            e.getPresentation().setEnabled(JavaModuleGraphUtil.findDescriptorByElement((PsiElement)target) == null);
        }
    }

    @Nullable
    protected PsiDirectory getTargetDirectory(DataContext ctx, IdeView view) {
        PsiDirectory[] directories = view.getDirectories();
        if (directories.length == 1) {
            VirtualFile root;
            PsiDirectory psiDir = directories[0];
            VirtualFile vDir = psiDir.getVirtualFile();
            ProjectFileIndex index = ProjectRootManager.getInstance((Project)psiDir.getProject()).getFileIndex();
            if (index.isUnderSourceRootOfType(vDir, ContainerUtil.set((Object[])new JavaSourceRootType[]{JavaSourceRootType.SOURCE, JavaSourceRootType.TEST_SOURCE})) && (root = index.getSourceRootForFile(vDir)) != null) {
                return psiDir.getManager().findDirectory(root);
            }
        }
        return null;
    }

    protected FileTemplate getTemplate(@NotNull Project project, @NotNull PsiDirectory dir) {
        if (project == null) {
            CreateModuleInfoAction.$$$reportNull$$$0(1);
        }
        if (dir == null) {
            CreateModuleInfoAction.$$$reportNull$$$0(2);
        }
        return FileTemplateManager.getInstance((Project)project).getInternalTemplate("module-info");
    }

    protected AttributesDefaults getAttributesDefaults(@NotNull DataContext ctx) {
        if (ctx == null) {
            CreateModuleInfoAction.$$$reportNull$$$0(3);
        }
        return new AttributesDefaults("module-info").withFixedName(true);
    }

    protected Map<String, String> getLiveTemplateDefaults(@NotNull DataContext ctx, @NotNull PsiFile file) {
        Module module;
        if (ctx == null) {
            CreateModuleInfoAction.$$$reportNull$$$0(4);
        }
        if (file == null) {
            CreateModuleInfoAction.$$$reportNull$$$0(5);
        }
        return Collections.singletonMap("MODULE_NAME", (module = (Module)LangDataKeys.MODULE.getData(ctx)) != null ? LightJavaModule.moduleName(module.getName()) : "module_name");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dir";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ctx";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        objectArray2[1] = "com/intellij/ide/actions/CreateModuleInfoAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "update";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "getTemplate";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "getAttributesDefaults";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "getLiveTemplateDefaults";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

