/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.ui;

import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.ui.DefaultJreSelector;
import com.intellij.execution.ui.JreComboboxEditor;
import com.intellij.execution.ui.JreProvider;
import com.intellij.icons.AllIcons;
import com.intellij.ide.util.BrowseFilesListener;
import com.intellij.openapi.projectRoots.ProjectJdkTable;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.ui.OrderEntryAppearanceService;
import com.intellij.openapi.ui.BrowseFolderRunnable;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.ui.LabeledComponent;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.ColoredListCellRenderer;
import com.intellij.ui.InsertPathAction;
import com.intellij.ui.PanelWithAnchor;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.SortedComboBoxModel;
import com.intellij.ui.components.fields.ExtendableTextField;
import com.intellij.util.ui.EmptyIcon;
import com.intellij.util.ui.JBInsets;
import com.intellij.util.ui.StatusText;
import java.awt.Container;
import java.awt.Insets;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.io.File;
import java.util.HashSet;
import javax.swing.ComboBoxEditor;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.text.JTextComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JrePathEditor
extends LabeledComponent<ComboBox>
implements PanelWithAnchor {
    private static final String DEFAULT_JRE_TEXT = "Default";
    private final JreComboboxEditor myComboboxEditor;
    private final DefaultJreItem myDefaultJreItem;
    private DefaultJreSelector myDefaultJreSelector;
    private final SortedComboBoxModel<JreComboBoxItem> myComboBoxModel = new SortedComboBoxModel<JreComboBoxItem>((o1, o2) -> {
        int result = Comparing.compare((int)o1.getOrder(), (int)o2.getOrder());
        if (result != 0) {
            return result;
        }
        return o1.getPresentableText().compareToIgnoreCase(o2.getPresentableText());
    }){

        public void setSelectedItem(Object anItem) {
            if (anItem instanceof AddJreItem) {
                ((ComboBox)JrePathEditor.this.getComponent()).hidePopup();
                JrePathEditor.this.getBrowseRunnable().run();
            } else {
                super.setSelectedItem(anItem);
            }
        }
    };
    private String myPreviousCustomJrePath;

    public JrePathEditor(DefaultJreSelector defaultJreSelector) {
        this();
        this.setDefaultJreSelector(defaultJreSelector);
    }

    public JrePathEditor() {
        this(true);
    }

    public JrePathEditor(boolean editable) {
        Sdk[] allJDKs;
        this.myDefaultJreItem = new DefaultJreItem();
        this.myComboBoxModel.add((Object)this.myDefaultJreItem);
        for (Sdk sdk : allJDKs = ProjectJdkTable.getInstance().getAllJdks()) {
            this.myComboBoxModel.add((Object)new SdkAsJreItem(sdk));
        }
        HashSet<String> jrePaths = new HashSet<String>();
        for (JreProvider provider : JreProvider.EP_NAME.getExtensionList()) {
            String path;
            if (!provider.isAvailable() || StringUtil.isEmpty((String)(path = provider.getJrePath()))) continue;
            jrePaths.add(path);
            this.myComboBoxModel.add((Object)new CustomJreItem(path, provider.getPresentableName()));
        }
        for (Sdk jdk : allJDKs) {
            File jre;
            String homePath = jdk.getHomePath();
            if (!SystemInfo.isMac && (jre = new File(jdk.getHomePath(), "jre")).isDirectory()) {
                homePath = jre.getPath();
            }
            if (!jrePaths.add(homePath)) continue;
            this.myComboBoxModel.add((Object)new CustomJreItem(homePath));
        }
        if (!editable) {
            this.myComboBoxModel.add((Object)new AddJreItem());
        }
        this.myComboBoxModel.setSelectedItem((Object)this.myDefaultJreItem);
        ComboBox comboBox = new ComboBox(this.myComboBoxModel, 100);
        comboBox.setEditable(editable);
        comboBox.setRenderer((ListCellRenderer)new ColoredListCellRenderer<JreComboBoxItem>(){
            {
                this.setIpad((Insets)JBInsets.create((int)1, (int)0));
                this.setMyBorder(null);
            }

            protected void customizeCellRenderer(@NotNull JList<? extends JreComboBoxItem> list, JreComboBoxItem value2, int index, boolean selected, boolean hasFocus) {
                if (list == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (value2 != null) {
                    value2.render((SimpleColoredComponent)this, selected);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "com/intellij/execution/ui/JrePathEditor$2", "customizeCellRenderer"));
            }
        });
        this.setComponent((JComponent)comboBox);
        this.myComboboxEditor = new JreComboboxEditor(this.myComboBoxModel){

            @Override
            protected JTextField createEditorComponent() {
                ExtendableTextField field = new ExtendableTextField().addBrowseExtension(JrePathEditor.this.getBrowseRunnable(), null);
                field.setBorder(null);
                field.addFocusListener(new FocusListener(){

                    @Override
                    public void focusGained(FocusEvent e) {
                        this.update(e);
                    }

                    @Override
                    public void focusLost(FocusEvent e) {
                        this.update(e);
                    }

                    private void update(FocusEvent e) {
                        Container c = e.getComponent().getParent();
                        if (c != null) {
                            c.revalidate();
                            c.repaint();
                        }
                    }
                });
                field.setTextToTriggerEmptyTextStatus(JrePathEditor.DEFAULT_JRE_TEXT);
                return field;
            }
        };
        comboBox.setEditor((ComboBoxEditor)this.myComboboxEditor);
        InsertPathAction.addTo((JTextComponent)this.myComboboxEditor.getEditorComponent());
        this.setLabelLocation("West");
        this.setText(ExecutionBundle.message((String)"run.configuration.jre.label", (Object[])new Object[0]));
        this.updateUI();
    }

    @NotNull
    private Runnable getBrowseRunnable() {
        return new BrowseFolderRunnable(ExecutionBundle.message((String)"run.configuration.select.alternate.jre.label", (Object[])new Object[0]), ExecutionBundle.message((String)"run.configuration.select.jre.dir.label", (Object[])new Object[0]), null, BrowseFilesListener.SINGLE_DIRECTORY_DESCRIPTOR, (JComponent)((ComboBox)this.getComponent()), JreComboboxEditor.TEXT_COMPONENT_ACCESSOR);
    }

    @Nullable
    public String getJrePathOrName() {
        JreComboBoxItem jre = this.getSelectedJre();
        if (jre instanceof DefaultJreItem) {
            return this.myPreviousCustomJrePath;
        }
        return jre.getPathOrName();
    }

    public boolean isAlternativeJreSelected() {
        return !(this.getSelectedJre() instanceof DefaultJreItem);
    }

    private JreComboBoxItem getSelectedJre() {
        ComboBox comboBox = (ComboBox)this.getComponent();
        return comboBox.isEditable() ? (JreComboBoxItem)comboBox.getEditor().getItem() : (JreComboBoxItem)comboBox.getSelectedItem();
    }

    public void setDefaultJreSelector(DefaultJreSelector defaultJreSelector) {
        this.myDefaultJreSelector = defaultJreSelector;
        this.myDefaultJreSelector.addChangeListener(() -> this.updateDefaultJrePresentation());
    }

    public void setPathOrName(@Nullable String pathOrName, boolean useAlternativeJre) {
        JreComboBoxItem toSelect = this.myDefaultJreItem;
        if (!StringUtil.isEmpty((String)pathOrName)) {
            this.myPreviousCustomJrePath = pathOrName;
            JreComboBoxItem alternative = this.findOrAddCustomJre(pathOrName);
            if (useAlternativeJre) {
                toSelect = alternative;
            }
        }
        ((ComboBox)this.getComponent()).setSelectedItem((Object)toSelect);
        this.updateDefaultJrePresentation();
    }

    private void updateDefaultJrePresentation() {
        StatusText text2 = this.myComboboxEditor.getEmptyText();
        text2.clear();
        text2.appendText(DEFAULT_JRE_TEXT, SimpleTextAttributes.REGULAR_ATTRIBUTES);
        text2.appendText(this.myDefaultJreSelector.getDescriptionString(), SimpleTextAttributes.GRAYED_ATTRIBUTES);
    }

    private JreComboBoxItem findOrAddCustomJre(@NotNull String pathOrName) {
        if (pathOrName == null) {
            JrePathEditor.$$$reportNull$$$0(0);
        }
        for (JreComboBoxItem item : this.myComboBoxModel.getItems()) {
            if ((!(item instanceof CustomJreItem) || !FileUtil.pathsEqual((String)pathOrName, (String)((CustomJreItem)item).myPath)) && !pathOrName.equals(item.getPathOrName())) continue;
            return item;
        }
        CustomJreItem item = new CustomJreItem(pathOrName);
        this.myComboBoxModel.add((Object)item);
        return item;
    }

    public void addActionListener(ActionListener listener) {
        ((ComboBox)this.getComponent()).addActionListener(listener);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pathOrName", "com/intellij/execution/ui/JrePathEditor", "findOrAddCustomJre"));
    }

    private static class AddJreItem
    implements JreComboBoxItem {
        private AddJreItem() {
        }

        @Override
        public void render(SimpleColoredComponent component, boolean selected) {
            component.append(this.getPresentableText());
            component.setIcon(EmptyIcon.ICON_16);
        }

        @Override
        public String getPresentableText() {
            return ExecutionBundle.message((String)"run.configuration.select.alternate.jre.action", (Object[])new Object[0]);
        }

        @Override
        @Nullable
        public String getPathOrName() {
            return null;
        }

        @Override
        public int getOrder() {
            return Integer.MAX_VALUE;
        }
    }

    private class DefaultJreItem
    implements JreComboBoxItem {
        private DefaultJreItem() {
        }

        @Override
        public void render(SimpleColoredComponent component, boolean selected) {
            component.append(JrePathEditor.DEFAULT_JRE_TEXT);
            if (JrePathEditor.this.myDefaultJreSelector != null) {
                component.append(JrePathEditor.this.myDefaultJreSelector.getDescriptionString(), SimpleTextAttributes.GRAY_ATTRIBUTES);
            }
        }

        @Override
        public String getPresentableText() {
            return JrePathEditor.DEFAULT_JRE_TEXT;
        }

        @Override
        public String getPathOrName() {
            return null;
        }

        @Override
        public int getOrder() {
            return 0;
        }
    }

    static class CustomJreItem
    implements JreComboBoxItem {
        private final String myPath;
        private final String myName;

        CustomJreItem(String path) {
            this(path, null);
        }

        CustomJreItem(String path, String name2) {
            this.myPath = path;
            this.myName = name2;
        }

        @Override
        public void render(SimpleColoredComponent component, boolean selected) {
            component.append(this.getPresentableText());
            component.setIcon(AllIcons.Nodes.Folder);
        }

        @Override
        public String getPresentableText() {
            return this.myName != null && !this.myPath.equals(this.myName) ? this.myName : FileUtil.toSystemDependentName((String)this.myPath);
        }

        @Override
        public String getPathOrName() {
            return this.myPath;
        }

        @Override
        public int getOrder() {
            return 2;
        }
    }

    private static class SdkAsJreItem
    implements JreComboBoxItem {
        private final Sdk mySdk;

        SdkAsJreItem(Sdk sdk) {
            this.mySdk = sdk;
        }

        @Override
        public void render(SimpleColoredComponent component, boolean selected) {
            OrderEntryAppearanceService.getInstance().forJdk(this.mySdk, false, selected, true).customize(component);
        }

        @Override
        public String getPresentableText() {
            return this.mySdk.getName();
        }

        @Override
        public String getPathOrName() {
            return this.mySdk.getName();
        }

        @Override
        public int getOrder() {
            return 1;
        }
    }

    static interface JreComboBoxItem {
        public void render(SimpleColoredComponent var1, boolean var2);

        public String getPresentableText();

        @Nullable
        public String getPathOrName();

        public int getOrder();
    }
}

