/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.ui;

import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.configuration.BrowseModuleValueActionListener;
import com.intellij.execution.configurations.JavaRunConfigurationModule;
import com.intellij.execution.ui.ConfigurationModuleSelector;
import com.intellij.ide.util.ClassFilter;
import com.intellij.ide.util.TreeClassChooser;
import com.intellij.ide.util.TreeClassChooserFactory;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ex.MessagesEx;
import com.intellij.openapi.util.Computable;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiMethodUtil;
import javax.swing.JComponent;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ClassBrowser<T extends JComponent>
extends BrowseModuleValueActionListener<T> {
    private final String myTitle;

    public ClassBrowser(@NotNull Project project, String title) {
        if (project == null) {
            ClassBrowser.$$$reportNull$$$0(0);
        }
        super(project);
        this.myTitle = title;
    }

    @Nullable
    protected String showDialog() {
        ClassFilter.ClassFilterWithScope classFilter;
        try {
            classFilter = this.getFilter();
        }
        catch (NoFilterException e) {
            e.getMessageInfo().showNow();
            return null;
        }
        TreeClassChooser dialog = this.createClassChooser(classFilter);
        this.configureDialog(dialog);
        dialog.showDialog();
        PsiClass psiClass = dialog.getSelected();
        if (psiClass == null) {
            return null;
        }
        this.onClassChosen(psiClass);
        return psiClass.getQualifiedName();
    }

    protected abstract ClassFilter.ClassFilterWithScope getFilter() throws NoFilterException;

    protected TreeClassChooser createClassChooser(ClassFilter.ClassFilterWithScope classFilter) {
        TreeClassChooserFactory factory = TreeClassChooserFactory.getInstance((Project)this.getProject());
        return factory.createWithInnerClassesScopeChooser(this.myTitle, classFilter.getScope(), (ClassFilter)classFilter, null);
    }

    protected void onClassChosen(@NotNull PsiClass psiClass) {
        if (psiClass == null) {
            ClassBrowser.$$$reportNull$$$0(1);
        }
        this.onClassChoosen(psiClass);
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2020.3")
    protected void onClassChoosen(PsiClass psiClass) {
    }

    private void configureDialog(TreeClassChooser dialog) {
        PsiClass psiClass = this.findClass(this.getText());
        if (psiClass == null) {
            return;
        }
        PsiDirectory directory = psiClass.getContainingFile().getContainingDirectory();
        if (directory != null) {
            dialog.selectDirectory(directory);
        }
        dialog.select(psiClass);
    }

    protected abstract PsiClass findClass(String var1);

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2021.1")
    public static ClassBrowser createApplicationClassBrowser(@NotNull Project project, @NotNull ConfigurationModuleSelector moduleSelector) {
        if (project == null) {
            ClassBrowser.$$$reportNull$$$0(2);
        }
        if (moduleSelector == null) {
            ClassBrowser.$$$reportNull$$$0(3);
        }
        return new AppClassBrowser(project, moduleSelector);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiClass";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleSelector";
                break;
            }
        }
        objectArray2[1] = "com/intellij/execution/ui/ClassBrowser";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "onClassChosen";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "createApplicationClassBrowser";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static class NoFilterException
    extends Exception {
        private final MessagesEx.MessageInfo myMessageInfo;

        public NoFilterException(@NotNull MessagesEx.MessageInfo messageInfo) {
            if (messageInfo == null) {
                NoFilterException.$$$reportNull$$$0(0);
            }
            super(messageInfo.getMessage());
            this.myMessageInfo = messageInfo;
        }

        public MessagesEx.MessageInfo getMessageInfo() {
            return this.myMessageInfo;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "messageInfo", "com/intellij/execution/ui/ClassBrowser$NoFilterException", "<init>"));
        }
    }

    public static class AppClassBrowser<T extends JComponent>
    extends MainClassBrowser<T> {
        private static final ClassFilter CLASS_FILTER = aClass -> PsiMethodUtil.MAIN_CLASS.value((Object)aClass) && ReadAction.compute(() -> PsiMethodUtil.findMainMethod((PsiClass)aClass)) != null;

        public AppClassBrowser(@NotNull Project project, @NotNull ConfigurationModuleSelector moduleSelector) {
            if (project == null) {
                AppClassBrowser.$$$reportNull$$$0(0);
            }
            if (moduleSelector == null) {
                AppClassBrowser.$$$reportNull$$$0(1);
            }
            super(project, moduleSelector, ExecutionBundle.message((String)"choose.main.class.dialog.title", (Object[])new Object[0]));
        }

        public AppClassBrowser(@NotNull Project project, @NotNull Computable<? extends Module> moduleSelector) {
            if (project == null) {
                AppClassBrowser.$$$reportNull$$$0(2);
            }
            if (moduleSelector == null) {
                AppClassBrowser.$$$reportNull$$$0(3);
            }
            super(project, moduleSelector, ExecutionBundle.message((String)"choose.main.class.dialog.title", (Object[])new Object[0]));
        }

        @Override
        protected ClassFilter createFilter(Module module) {
            return CLASS_FILTER;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "project";
                    break;
                }
                case 1: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[0] = "moduleSelector";
                    break;
                }
            }
            objectArray[1] = "com/intellij/execution/ui/ClassBrowser$AppClassBrowser";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static abstract class MainClassBrowser<T extends JComponent>
    extends ClassBrowser<T> {
        private final Computable<? extends Module> myModuleSelector;

        public MainClassBrowser(@NotNull Project project, @NotNull ConfigurationModuleSelector moduleSelector, String title) {
            if (project == null) {
                MainClassBrowser.$$$reportNull$$$0(0);
            }
            if (moduleSelector == null) {
                MainClassBrowser.$$$reportNull$$$0(1);
            }
            this(project, (Computable<? extends Module>)((Computable)() -> moduleSelector.getModule()), title);
        }

        public MainClassBrowser(@NotNull Project project, @NotNull Computable<? extends Module> moduleSelector, String title) {
            if (project == null) {
                MainClassBrowser.$$$reportNull$$$0(2);
            }
            if (moduleSelector == null) {
                MainClassBrowser.$$$reportNull$$$0(3);
            }
            super(project, title);
            this.myModuleSelector = moduleSelector;
        }

        @Override
        protected PsiClass findClass(String className2) {
            JavaRunConfigurationModule configurationModule = new JavaRunConfigurationModule(this.getProject(), false);
            configurationModule.setModule((Module)this.myModuleSelector.get());
            return configurationModule.findClass(className2);
        }

        @Override
        protected ClassFilter.ClassFilterWithScope getFilter() {
            Module module = (Module)this.myModuleSelector.get();
            final GlobalSearchScope scope = module != null ? GlobalSearchScope.moduleWithDependenciesAndLibrariesScope((Module)module) : GlobalSearchScope.allScope((Project)this.getProject());
            final ClassFilter filter = this.createFilter(module);
            return new ClassFilter.ClassFilterWithScope(){

                public GlobalSearchScope getScope() {
                    return scope;
                }

                public boolean isAccepted(PsiClass aClass) {
                    return filter == null || filter.isAccepted(aClass);
                }
            };
        }

        @Nullable
        protected ClassFilter createFilter(@Nullable Module module) {
            return null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "project";
                    break;
                }
                case 1: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[0] = "moduleSelector";
                    break;
                }
            }
            objectArray[1] = "com/intellij/execution/ui/ClassBrowser$MainClassBrowser";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

