/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.testframework;

import com.intellij.execution.Location;
import com.intellij.execution.PsiLocation;
import com.intellij.execution.junit2.PsiMemberParameterizedLocation;
import com.intellij.execution.junit2.info.MethodLocation;
import com.intellij.execution.stacktrace.StackTraceLine;
import com.intellij.execution.testframework.sm.runner.SMTestLocator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.ClassUtil;
import com.intellij.util.SmartList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaTestLocator
implements SMTestLocator {
    public static final String SUITE_PROTOCOL = "java:suite";
    public static final String TEST_PROTOCOL = "java:test";
    public static final JavaTestLocator INSTANCE = new JavaTestLocator();

    @NotNull
    public List<Location> getLocation(@NotNull String protocol, @NotNull String path, @NotNull Project project, @NotNull GlobalSearchScope scope) {
        if (protocol == null) {
            JavaTestLocator.$$$reportNull$$$0(0);
        }
        if (path == null) {
            JavaTestLocator.$$$reportNull$$$0(1);
        }
        if (project == null) {
            JavaTestLocator.$$$reportNull$$$0(2);
        }
        if (scope == null) {
            JavaTestLocator.$$$reportNull$$$0(3);
        }
        Object results = Collections.emptyList();
        String paramName = null;
        int idx = path.indexOf(91);
        if (idx >= 0) {
            paramName = path.substring(idx);
            path = path.substring(0, idx);
        }
        if (SUITE_PROTOCOL.equals(protocol)) {
            path = StringUtil.trimEnd((String)path, (String)".");
            PsiClass aClass = ClassUtil.findPsiClass((PsiManager)PsiManager.getInstance((Project)project), (String)path, null, (boolean)true, (GlobalSearchScope)scope);
            if (aClass != null) {
                results = new SmartList();
                results.add(JavaTestLocator.createClassNavigatable(paramName, aClass));
            } else {
                results = JavaTestLocator.collectMethodNavigatables(path, project, scope, paramName);
            }
        } else if (TEST_PROTOCOL.equals(protocol)) {
            results = JavaTestLocator.collectMethodNavigatables(path, project, scope, paramName);
        }
        SmartList smartList = results;
        if (smartList == null) {
            JavaTestLocator.$$$reportNull$$$0(4);
        }
        return smartList;
    }

    @NotNull
    public List<Location> getLocation(@NotNull String protocol, @NotNull String path, @Nullable String metainfo, @NotNull Project project, @NotNull GlobalSearchScope scope) {
        List<Location> locations;
        if (protocol == null) {
            JavaTestLocator.$$$reportNull$$$0(5);
        }
        if (path == null) {
            JavaTestLocator.$$$reportNull$$$0(6);
        }
        if (project == null) {
            JavaTestLocator.$$$reportNull$$$0(7);
        }
        if (scope == null) {
            JavaTestLocator.$$$reportNull$$$0(8);
        }
        if ((locations = this.getLocation(protocol, path, project, scope)).size() > 1 && metainfo != null) {
            for (Location location : locations) {
                PsiElement element = location.getPsiElement();
                if (!(element instanceof PsiMethod) || !StringUtil.equalsIgnoreWhitespaces((CharSequence)metainfo, (CharSequence)ClassUtil.getVMParametersMethodSignature((PsiMethod)((PsiMethod)element)))) continue;
                List<Location> list = Collections.singletonList(location);
                if (list == null) {
                    JavaTestLocator.$$$reportNull$$$0(9);
                }
                return list;
            }
        }
        List<Location> list = locations;
        if (list == null) {
            JavaTestLocator.$$$reportNull$$$0(10);
        }
        return list;
    }

    @NotNull
    public List<Location> getLocation(@NotNull String stacktraceLine, @NotNull Project project, @NotNull GlobalSearchScope scope) {
        if (stacktraceLine == null) {
            JavaTestLocator.$$$reportNull$$$0(11);
        }
        if (project == null) {
            JavaTestLocator.$$$reportNull$$$0(12);
        }
        if (scope == null) {
            JavaTestLocator.$$$reportNull$$$0(13);
        }
        StackTraceLine line = new StackTraceLine(project, stacktraceLine);
        List<Location> list = this.getLocation(TEST_PROTOCOL, line.getClassName() + "/" + line.getMethodName(), project, scope);
        if (list == null) {
            JavaTestLocator.$$$reportNull$$$0(14);
        }
        return list;
    }

    private static List<Location> collectMethodNavigatables(@NotNull String path, @NotNull Project project, @NotNull GlobalSearchScope scope, String paramName) {
        int classSeparatorIdx;
        if (path == null) {
            JavaTestLocator.$$$reportNull$$$0(15);
        }
        if (project == null) {
            JavaTestLocator.$$$reportNull$$$0(16);
        }
        if (scope == null) {
            JavaTestLocator.$$$reportNull$$$0(17);
        }
        if ((classSeparatorIdx = path.indexOf(47)) > 0) {
            String className2 = path.substring(0, classSeparatorIdx);
            String methodName = path.substring(classSeparatorIdx + 1);
            return JavaTestLocator.collectMethodNavigatables(project, scope, paramName, methodName, className2);
        }
        String className3 = StringUtil.getPackageName((String)path);
        String methodName = StringUtil.getShortName((String)path);
        if (!className3.isEmpty()) {
            return JavaTestLocator.collectMethodNavigatables(project, scope, paramName, methodName, className3);
        }
        return Collections.emptyList();
    }

    private static List<Location> collectMethodNavigatables(@NotNull Project project, @NotNull GlobalSearchScope scope, String paramName, String methodName, String className2) {
        if (project == null) {
            JavaTestLocator.$$$reportNull$$$0(18);
        }
        if (scope == null) {
            JavaTestLocator.$$$reportNull$$$0(19);
        }
        SmartList results = Collections.emptyList();
        PsiClass aClass = ClassUtil.findPsiClass((PsiManager)PsiManager.getInstance((Project)project), (String)className2, null, (boolean)true, (GlobalSearchScope)scope);
        if (aClass != null) {
            results = new SmartList();
            if (methodName.trim().equals(aClass.getName())) {
                results.add(JavaTestLocator.createClassNavigatable(paramName, aClass));
            } else {
                PsiMethod[] methods = aClass.findMethodsByName(methodName.trim(), true);
                if (methods.length > 0) {
                    for (PsiMethod method : methods) {
                        results.add(paramName != null ? new PsiMemberParameterizedLocation(project, (PsiElement)method, aClass, paramName) : MethodLocation.elementInClass(method, aClass));
                    }
                }
            }
        }
        return results;
    }

    private static Location createClassNavigatable(String paramName, @NotNull PsiClass aClass) {
        if (aClass == null) {
            JavaTestLocator.$$$reportNull$$$0(20);
        }
        return paramName != null ? PsiMemberParameterizedLocation.getParameterizedLocation(aClass, paramName) : new PsiLocation(aClass.getProject(), (PsiElement)aClass);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 9: 
            case 10: 
            case 14: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 9: 
            case 10: 
            case 14: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "protocol";
                break;
            }
            case 1: 
            case 6: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 2: 
            case 7: 
            case 12: 
            case 16: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: 
            case 8: 
            case 13: 
            case 17: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 4: 
            case 9: 
            case 10: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/execution/testframework/JavaTestLocator";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stacktraceLine";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/execution/testframework/JavaTestLocator";
                break;
            }
            case 4: 
            case 9: 
            case 10: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getLocation";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getLocation";
                break;
            }
            case 4: 
            case 9: 
            case 10: 
            case 14: {
                break;
            }
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "collectMethodNavigatables";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "createClassNavigatable";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 9: 
            case 10: 
            case 14: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

