/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.jshell;

import com.intellij.execution.jshell.JShellDiagnostic;
import com.intellij.execution.jshell.JShellHandler;
import com.intellij.execution.jshell.SnippetEditorDecorator;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ex.util.EditorUtil;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiEmptyStatement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJShellFile;
import com.intellij.psi.PsiJShellHolderMethod;
import com.intellij.psi.PsiJShellSyntheticElement;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.util.DocumentUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class ExecuteJShellAction
extends AnAction {
    private static final boolean myIsExecuteContextElement = false;

    private ExecuteJShellAction() {
        super(AllIcons.Toolwindows.ToolWindowRun);
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Project project;
        if (e == null) {
            ExecuteJShellAction.$$$reportNull$$$0(0);
        }
        if ((project = e.getProject()) == null) {
            return;
        }
        Editor editor = (Editor)e.getData(CommonDataKeys.EDITOR);
        if (editor == null) {
            return;
        }
        VirtualFile vFile = (VirtualFile)e.getData(CommonDataKeys.VIRTUAL_FILE);
        if (vFile == null) {
            return;
        }
        FileDocumentManager.getInstance().saveAllDocuments();
        try {
            JShellHandler handler = JShellHandler.getAssociatedHandler(vFile);
            if (handler == null) {
                SnippetEditorDecorator.ConfigurationPane config = SnippetEditorDecorator.getJShellConfiguration(e.getDataContext());
                Module module = config != null ? config.getContextModule() : null;
                Sdk sdk = config != null ? config.getRuntimeSdk() : null;
                handler = JShellHandler.create(project, vFile, module, sdk);
            }
            if (handler != null) {
                handler.toFront();
                boolean hasDataToEvaluate = false;
                Document document = editor.getDocument();
                TextRange selectedRange = EditorUtil.getSelectionInAnyMode((Editor)editor);
                if (selectedRange.isEmpty()) {
                    PsiElement snippet = this.getSnippetFromContext(project, e);
                    if (snippet instanceof PsiJShellFile) {
                        for (PsiElement element : ((PsiJShellFile)snippet).getExecutableSnippets()) {
                            hasDataToEvaluate |= ExecuteJShellAction.scheduleEval(handler, element.getText());
                        }
                    } else if (snippet != null) {
                        hasDataToEvaluate = ExecuteJShellAction.scheduleEval(handler, snippet.getText());
                    }
                } else {
                    hasDataToEvaluate = ExecuteJShellAction.scheduleEval(handler, document.getText(selectedRange));
                }
                if (!hasDataToEvaluate) {
                    JShellDiagnostic.notifyInfo("Nothing to execute", project);
                }
            }
        }
        catch (Exception ex) {
            Logger.getInstance(ExecuteJShellAction.class).warn((Throwable)ex);
            JShellDiagnostic.notifyError(ex, project);
        }
    }

    private static boolean scheduleEval(@NotNull JShellHandler handler, String code) {
        if (handler == null) {
            ExecuteJShellAction.$$$reportNull$$$0(1);
        }
        if (!StringUtil.isEmptyOrSpaces((String)code)) {
            handler.evaluate(code.trim());
            return true;
        }
        return false;
    }

    @Nullable
    private PsiElement getSnippetFromContext(Project project, AnActionEvent e) {
        PsiFile file;
        Editor editor = (Editor)e.getData(CommonDataKeys.EDITOR);
        if (editor != null && (file = PsiDocumentManager.getInstance((Project)project).getPsiFile(editor.getDocument())) instanceof PsiJShellFile) {
            PsiFile element = null;
            while (element != null) {
                PsiElement parent = element.getParent();
                if (parent instanceof PsiJShellHolderMethod && element instanceof PsiEmptyStatement) {
                    element = parent.getPrevSibling();
                    if (!(element instanceof PsiJShellSyntheticElement)) continue;
                    element = element.getFirstChild();
                    break;
                }
                if (parent instanceof PsiJShellSyntheticElement || parent instanceof PsiJShellFile) break;
                element = parent;
            }
            return element != null ? element : file;
        }
        return null;
    }

    private static PsiElement getContextElement(PsiFile file, Document doc, int offset) {
        int begin = DocumentUtil.getLineStartOffset((int)offset, (Document)doc);
        PsiElement result = null;
        for (int off = offset; off >= begin && ((result = file.findElementAt(off)) == null || result instanceof PsiWhiteSpace); --off) {
        }
        return result;
    }

    public static AnAction getSharedInstance() {
        return Holder.ourInstance;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "handler";
                break;
            }
        }
        objectArray2[1] = "com/intellij/execution/jshell/ExecuteJShellAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "actionPerformed";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "scheduleEval";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class Holder {
        private static final AnAction ourInstance = new ExecuteJShellAction();

        private Holder() {
        }
    }
}

