/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution;

import com.intellij.debugger.DebuggerManager;
import com.intellij.debugger.DefaultDebugEnvironment;
import com.intellij.debugger.engine.DebugProcess;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.impl.GenericDebuggerRunner;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.JavaTestFrameworkRunnableState;
import com.intellij.execution.configurations.RemoteConnection;
import com.intellij.execution.configurations.RunProfile;
import com.intellij.execution.configurations.RunProfileState;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.openapi.project.Project;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class JavaTestFrameworkDebuggerRunner
extends GenericDebuggerRunner {
    @Override
    @NotNull
    public abstract String getRunnerId();

    protected abstract boolean validForProfile(@NotNull RunProfile var1);

    @NotNull
    protected abstract String getThreadName();

    @Override
    public boolean canRun(@NotNull String executorId, @NotNull RunProfile profile) {
        if (executorId == null) {
            JavaTestFrameworkDebuggerRunner.$$$reportNull$$$0(0);
        }
        if (profile == null) {
            JavaTestFrameworkDebuggerRunner.$$$reportNull$$$0(1);
        }
        return "Debug".equals(executorId) && this.validForProfile(profile);
    }

    @Override
    @Nullable
    protected RunContentDescriptor createContentDescriptor(final @NotNull RunProfileState state, final @NotNull ExecutionEnvironment environment) throws ExecutionException {
        if (state == null) {
            JavaTestFrameworkDebuggerRunner.$$$reportNull$$$0(2);
        }
        if (environment == null) {
            JavaTestFrameworkDebuggerRunner.$$$reportNull$$$0(3);
        }
        final RunContentDescriptor res = super.createContentDescriptor(state, environment);
        final ServerSocket socket = ((JavaTestFrameworkRunnableState)state).getForkSocket();
        if (socket != null) {
            Thread thread = new Thread(this.getThreadName() + " debugger runner"){

                @Override
                public void run() {
                    try (Socket accept2 = socket.accept();
                         DataInputStream stream = new DataInputStream(accept2.getInputStream());){
                        int read2 = stream.readInt();
                        while (read2 != -1) {
                            DebugProcess process2 = DebuggerManager.getInstance((Project)environment.getProject()).getDebugProcess(res.getProcessHandler());
                            if (process2 == null) {
                                break;
                            }
                            RemoteConnection connection = new RemoteConnection(true, "127.0.0.1", String.valueOf(read2), true);
                            DefaultDebugEnvironment env = new DefaultDebugEnvironment(environment, state, connection, true);
                            SwingUtilities.invokeLater(() -> {
                                try {
                                    ((DebugProcessImpl)process2).reattach(env);
                                    accept2.getOutputStream().write(0);
                                }
                                catch (Exception e) {
                                    e.printStackTrace();
                                }
                            });
                            read2 = stream.readInt();
                        }
                    }
                    catch (EOFException accept2) {
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            };
            thread.setDaemon(true);
            thread.start();
        }
        return res;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "executorId";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "profile";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "environment";
                break;
            }
        }
        objectArray2[1] = "com/intellij/execution/JavaTestFrameworkDebuggerRunner";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "canRun";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "createContentDescriptor";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

