/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.ui.tree.render;

import com.intellij.CommonBundle;
import com.intellij.debugger.JavaDebuggerBundle;
import com.intellij.debugger.engine.DebugProcess;
import com.intellij.debugger.engine.DebuggerUtils;
import com.intellij.debugger.engine.FullValueEvaluatorProvider;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.evaluation.EvaluationContext;
import com.intellij.debugger.engine.evaluation.EvaluationContextImpl;
import com.intellij.debugger.impl.ClassLoadingUtils;
import com.intellij.debugger.ui.tree.render.CompoundRendererProvider;
import com.intellij.debugger.ui.tree.render.CustomPopupFullValueEvaluator;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.rt.debugger.ImageSerializer;
import com.sun.jdi.ClassType;
import com.sun.jdi.Method;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.StringReference;
import com.sun.jdi.Value;
import java.awt.Graphics2D;
import java.awt.GraphicsEnvironment;
import java.awt.image.BufferedImage;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import org.intellij.images.editor.impl.ImageEditorManagerImpl;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class ImageObjectRenderer
extends CompoundRendererProvider {
    private static final Logger LOG = Logger.getInstance(ImageObjectRenderer.class);

    ImageObjectRenderer() {
    }

    @Override
    protected String getName() {
        return "Image";
    }

    @Override
    protected String getClassName() {
        return "java.awt.Image";
    }

    @Override
    protected boolean isEnabled() {
        return true;
    }

    @Override
    protected FullValueEvaluatorProvider getFullValueEvaluatorProvider() {
        return (evaluationContext, valueDescriptor) -> new IconPopupEvaluator(JavaDebuggerBundle.message((String)"message.node.show.image", (Object[])new Object[0]), evaluationContext){

            @Override
            protected Icon getData() {
                return ImageObjectRenderer.getIcon(this.getEvaluationContext(), valueDescriptor.getValue(), "imageToBytes");
            }
        };
    }

    static JComponent createIconViewer(@Nullable Icon icon) {
        if (icon == null) {
            return new JLabel(CommonBundle.message((String)"label.no.data", (Object[])new Object[0]), 0);
        }
        int w = icon.getIconWidth();
        int h = icon.getIconHeight();
        BufferedImage image = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration().createCompatibleImage(w, h, 3);
        Graphics2D g = image.createGraphics();
        icon.paintIcon(null, g, 0, 0);
        g.dispose();
        return ImageEditorManagerImpl.createImageEditorUI((BufferedImage)image);
    }

    @Nullable
    static ImageIcon getIcon(EvaluationContext evaluationContext, Value obj, String methodName) {
        try {
            byte[] data = ImageObjectRenderer.getImageBytes(evaluationContext, obj, methodName);
            if (data != null) {
                return new ImageIcon(data);
            }
        }
        catch (Exception e) {
            LOG.info("Exception while getting image data", (Throwable)e);
        }
        return null;
    }

    private static byte @Nullable [] getImageBytes(EvaluationContext evaluationContext, Value obj, String methodName) throws EvaluateException {
        StringReference bytes;
        Method method;
        DebugProcess process2 = evaluationContext.getDebugProcess();
        EvaluationContext copyContext = evaluationContext.createEvaluationContext(obj);
        ClassType helperClass = ClassLoadingUtils.getHelperClass(ImageSerializer.class, copyContext);
        if (helperClass != null && (method = DebuggerUtils.findMethod((ReferenceType)helperClass, (String)methodName, null)) != null && (bytes = (StringReference)process2.invokeMethod(copyContext, helperClass, method, Collections.singletonList(obj))) != null) {
            return bytes.value().getBytes(StandardCharsets.ISO_8859_1);
        }
        return null;
    }

    static abstract class IconPopupEvaluator
    extends CustomPopupFullValueEvaluator<Icon> {
        IconPopupEvaluator(@NotNull String linkText, @NotNull EvaluationContextImpl evaluationContext) {
            if (linkText == null) {
                IconPopupEvaluator.$$$reportNull$$$0(0);
            }
            if (evaluationContext == null) {
                IconPopupEvaluator.$$$reportNull$$$0(1);
            }
            super(linkText, evaluationContext);
        }

        @Override
        protected JComponent createComponent(Icon data) {
            return ImageObjectRenderer.createIconViewer(data);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "linkText";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "evaluationContext";
                    break;
                }
            }
            objectArray[1] = "com/intellij/debugger/ui/tree/render/ImageObjectRenderer$IconPopupEvaluator";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

