/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.ui.tree.render;

import com.intellij.debugger.JavaDebuggerBundle;
import com.intellij.debugger.engine.DebuggerUtils;
import com.intellij.debugger.engine.FullValueEvaluatorProvider;
import com.intellij.debugger.ui.tree.render.CompoundRendererProvider;
import com.intellij.debugger.ui.tree.render.ImageObjectRenderer;
import com.sun.jdi.ClassType;
import com.sun.jdi.Field;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.Type;
import com.sun.jdi.Value;
import javax.swing.Icon;

public class GraphicsObjectRenderer
extends CompoundRendererProvider {
    @Override
    protected String getName() {
        return "Graphics";
    }

    @Override
    protected String getClassName() {
        return "sun.java2d.SunGraphics2D";
    }

    @Override
    protected boolean isEnabled() {
        return true;
    }

    @Override
    protected FullValueEvaluatorProvider getFullValueEvaluatorProvider() {
        return (evaluationContext, valueDescriptor) -> {
            try {
                ObjectReference value2 = (ObjectReference)valueDescriptor.getValue();
                Field surfaceField = ((ClassType)value2.type()).fieldByName("surfaceData");
                if (surfaceField == null) {
                    return null;
                }
                ObjectReference surfaceDataValue = (ObjectReference)value2.getValue(surfaceField);
                if (surfaceDataValue == null) {
                    return null;
                }
                Field imgField = ((ReferenceType)surfaceDataValue.type()).fieldByName("bufImg");
                if (imgField == null) {
                    imgField = ((ReferenceType)surfaceDataValue.type()).fieldByName("offscreenImage");
                }
                if (imgField == null) {
                    return null;
                }
                final Value bufImgValue = surfaceDataValue.getValue(imgField);
                Type type2 = bufImgValue.type();
                if (!(type2 instanceof ReferenceType) || !DebuggerUtils.instanceOf((Type)type2, (String)"java.awt.Image")) {
                    return null;
                }
                return new ImageObjectRenderer.IconPopupEvaluator(JavaDebuggerBundle.message((String)"message.node.show.image", (Object[])new Object[0]), evaluationContext){

                    @Override
                    protected Icon getData() {
                        return ImageObjectRenderer.getIcon(this.getEvaluationContext(), bufImgValue, "imageToBytes");
                    }
                };
            }
            catch (Exception exception) {
                return null;
            }
        };
    }
}

