/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.ui.impl.watch;

import com.intellij.Patches;
import com.intellij.debugger.DebuggerContext;
import com.intellij.debugger.JavaDebuggerBundle;
import com.intellij.debugger.engine.DebugProcess;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.DebuggerManagerThreadImpl;
import com.intellij.debugger.engine.DebuggerUtils;
import com.intellij.debugger.engine.JavaValue;
import com.intellij.debugger.engine.SuspendContextImpl;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.evaluation.EvaluationContext;
import com.intellij.debugger.engine.evaluation.EvaluationContextImpl;
import com.intellij.debugger.engine.events.SuspendContextCommandImpl;
import com.intellij.debugger.impl.DebuggerContextImpl;
import com.intellij.debugger.impl.DebuggerUtilsAsync;
import com.intellij.debugger.impl.DebuggerUtilsEx;
import com.intellij.debugger.jdi.VirtualMachineProxyImpl;
import com.intellij.debugger.settings.NodeRendererSettings;
import com.intellij.debugger.ui.impl.watch.DebuggerTreeNodeExpression;
import com.intellij.debugger.ui.impl.watch.NodeDescriptorImpl;
import com.intellij.debugger.ui.overhead.OverheadTimings;
import com.intellij.debugger.ui.tree.DebuggerTreeNode;
import com.intellij.debugger.ui.tree.NodeDescriptor;
import com.intellij.debugger.ui.tree.NodeDescriptorNameAdjuster;
import com.intellij.debugger.ui.tree.ValueDescriptor;
import com.intellij.debugger.ui.tree.render.ClassRenderer;
import com.intellij.debugger.ui.tree.render.CompoundReferenceRenderer;
import com.intellij.debugger.ui.tree.render.DescriptorLabelListener;
import com.intellij.debugger.ui.tree.render.NodeRenderer;
import com.intellij.debugger.ui.tree.render.NodeRendererImpl;
import com.intellij.debugger.ui.tree.render.OnDemandRenderer;
import com.intellij.debugger.ui.tree.render.Renderer;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.util.concurrency.Semaphore;
import com.intellij.xdebugger.frame.XValueModifier;
import com.intellij.xdebugger.impl.ui.tree.ValueMarkup;
import com.sun.jdi.ArrayReference;
import com.sun.jdi.ClassObjectReference;
import com.sun.jdi.ClassType;
import com.sun.jdi.DoubleValue;
import com.sun.jdi.FloatValue;
import com.sun.jdi.Method;
import com.sun.jdi.ObjectCollectedException;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.PrimitiveValue;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.StringReference;
import com.sun.jdi.Type;
import com.sun.jdi.Value;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ValueDescriptorImpl
extends NodeDescriptorImpl
implements ValueDescriptor {
    protected final Project myProject;
    NodeRenderer myRenderer = null;
    NodeRenderer myAutoRenderer = null;
    private Value myValue;
    private volatile boolean myValueReady;
    private EvaluateException myValueException;
    protected EvaluationContextImpl myStoredEvaluationContext = null;
    private String myIdLabel;
    private String myValueText;
    private boolean myFullValue = false;
    @Nullable
    private Icon myValueIcon;
    protected boolean myIsNew = true;
    private boolean myIsDirty = false;
    private boolean myIsLvalue = false;
    private boolean myIsExpandable;
    private boolean myShowIdLabel = true;

    protected ValueDescriptorImpl(Project project, Value value2) {
        this.myProject = project;
        this.myValue = value2;
        this.myValueReady = true;
    }

    protected ValueDescriptorImpl(Project project) {
        this.myProject = project;
    }

    private void assertValueReady() {
        if (!this.myValueReady) {
            LOG.error("Value is not yet calculated for " + this.getClass());
        }
    }

    @Override
    public boolean isArray() {
        this.assertValueReady();
        return this.myValue instanceof ArrayReference;
    }

    public boolean isDirty() {
        this.assertValueReady();
        return this.myIsDirty;
    }

    @Override
    public boolean isLvalue() {
        this.assertValueReady();
        return this.myIsLvalue;
    }

    @Override
    public boolean isNull() {
        this.assertValueReady();
        return this.myValue == null;
    }

    @Override
    public boolean isString() {
        this.assertValueReady();
        return this.myValue instanceof StringReference;
    }

    @Override
    public boolean isPrimitive() {
        this.assertValueReady();
        return this.myValue instanceof PrimitiveValue;
    }

    public boolean isEnumConstant() {
        this.assertValueReady();
        return this.myValue instanceof ObjectReference && ValueDescriptorImpl.isEnumConstant((ObjectReference)this.myValue);
    }

    public boolean isValueValid() {
        return this.myValueException == null;
    }

    public boolean isShowIdLabel() {
        return this.myShowIdLabel && Registry.is((String)"debugger.showTypes");
    }

    public void setShowIdLabel(boolean showIdLabel) {
        this.myShowIdLabel = showIdLabel;
    }

    public boolean isValueReady() {
        return this.myValueReady;
    }

    @Override
    public Value getValue() {
        EvaluationContextImpl evalContext;
        if (Patches.IBM_JDK_DISABLE_COLLECTION_BUG && (evalContext = this.myStoredEvaluationContext) != null && !evalContext.getSuspendContext().isResumed() && this.myValue instanceof ObjectReference && VirtualMachineProxyImpl.isCollected((ObjectReference)this.myValue)) {
            final Semaphore semaphore = new Semaphore();
            semaphore.down();
            evalContext.getDebugProcess().getManagerThread().invoke(new SuspendContextCommandImpl(evalContext.getSuspendContext()){

                @Override
                public void contextAction(@NotNull SuspendContextImpl suspendContext) {
                    if (suspendContext == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    try {
                        ValueDescriptorImpl.this.setContext(ValueDescriptorImpl.this.myStoredEvaluationContext);
                    }
                    finally {
                        semaphore.up();
                    }
                }

                @Override
                protected void commandCancelled() {
                    semaphore.up();
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "suspendContext", "com/intellij/debugger/ui/impl/watch/ValueDescriptorImpl$1", "contextAction"));
                }
            });
            semaphore.waitFor();
        }
        this.assertValueReady();
        return this.myValue;
    }

    @Override
    public boolean isExpandable() {
        return this.myIsExpandable;
    }

    public abstract Value calcValue(EvaluationContextImpl var1) throws EvaluateException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void setContext(EvaluationContextImpl evaluationContext) {
        DebuggerManagerThreadImpl.assertIsManagerThread();
        this.myStoredEvaluationContext = evaluationContext;
        try {
            Value value2 = this.calcValue(evaluationContext);
            if (!this.myIsNew) {
                try {
                    this.myIsDirty = this.myValue instanceof DoubleValue && Double.isNaN(((DoubleValue)this.myValue).doubleValue()) ? !(value2 instanceof DoubleValue) : (this.myValue instanceof FloatValue && Float.isNaN(((FloatValue)this.myValue).floatValue()) ? !(value2 instanceof FloatValue) : !Objects.equals(value2, this.myValue));
                }
                catch (ObjectCollectedException ignored) {
                    this.myIsDirty = true;
                }
            }
            this.myValue = value2;
            this.myValueException = null;
        }
        catch (EvaluateException e) {
            this.myValueException = e;
            this.setFailed(e);
            this.myValue = ValueDescriptorImpl.getTargetExceptionWithStackTraceFilled(evaluationContext, e, this.isPrintExceptionToConsole() || ApplicationManager.getApplication().isUnitTestMode());
            this.myIsExpandable = false;
        }
        finally {
            this.myValueReady = true;
        }
        this.myIsNew = false;
    }

    protected boolean isPrintExceptionToConsole() {
        return true;
    }

    @Nullable
    protected static Value invokeExceptionGetStackTrace(ObjectReference exceptionObj, EvaluationContextImpl evaluationContext) throws EvaluateException {
        Method method = DebuggerUtils.findMethod((ReferenceType)exceptionObj.referenceType(), (String)"getStackTrace", (String)"()[Ljava/lang/StackTraceElement;");
        if (method != null) {
            return evaluationContext.getDebugProcess().invokeInstanceMethod(evaluationContext, exceptionObj, method, Collections.emptyList(), 0, true);
        }
        return null;
    }

    @Nullable
    private static ObjectReference getTargetExceptionWithStackTraceFilled(@Nullable EvaluationContextImpl evaluationContext, EvaluateException ex, boolean printToConsole) {
        ObjectReference exceptionObj = ex.getExceptionFromTargetVM();
        if (exceptionObj != null && evaluationContext != null) {
            try {
                Value trace = ValueDescriptorImpl.invokeExceptionGetStackTrace(exceptionObj, evaluationContext);
                if (printToConsole && trace instanceof ArrayReference) {
                    DebugProcessImpl process2 = evaluationContext.getDebugProcess();
                    ArrayReference traceArray = (ArrayReference)trace;
                    process2.printToConsole(DebuggerUtils.getValueAsString((EvaluationContext)evaluationContext, (Value)exceptionObj) + "\n");
                    for (Value stackElement : traceArray.getValues()) {
                        process2.printToConsole("\tat " + DebuggerUtils.getValueAsString((EvaluationContext)evaluationContext, (Value)stackElement) + "\n");
                    }
                }
            }
            catch (EvaluateException trace) {
            }
            catch (Throwable e) {
                LOG.info(e);
            }
        }
        return exceptionObj;
    }

    @Override
    public void setAncestor(NodeDescriptor oldDescriptor) {
        super.setAncestor(oldDescriptor);
        this.myIsNew = false;
        if (!this.myValueReady) {
            ValueDescriptorImpl other = (ValueDescriptorImpl)oldDescriptor;
            if (other.myValueReady) {
                this.myValue = other.getValue();
                this.myValueReady = true;
            }
        }
    }

    protected void setLvalue(boolean value2) {
        this.myIsLvalue = value2;
    }

    @Override
    protected String calcRepresentation(EvaluationContextImpl context, DescriptorLabelListener labelListener) {
        DebuggerManagerThreadImpl.assertIsManagerThread();
        DebugProcessImpl debugProcess = context.getDebugProcess();
        ((CompletableFuture)this.getRenderer(debugProcess).thenAccept(renderer -> this.calcRepresentation(context, labelListener, debugProcess, (NodeRenderer)renderer))).exceptionally(throwable -> {
            String message2;
            if ((throwable = DebuggerUtilsAsync.unwrap(throwable)) instanceof CancellationException) {
                message2 = JavaDebuggerBundle.message((String)"error.context.has.changed", (Object[])new Object[0]);
            } else {
                message2 = JavaDebuggerBundle.message((String)"internal.debugger.error", (Object[])new Object[0]);
                LOG.error(new Throwable((Throwable)throwable));
            }
            this.setValueLabelFailed(new EvaluateException(message2));
            labelListener.labelChanged();
            return null;
        });
        return "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    private String calcRepresentation(EvaluationContextImpl context, DescriptorLabelListener labelListener, DebugProcessImpl debugProcess, NodeRenderer renderer) {
        DebuggerManagerThreadImpl.assertIsManagerThread();
        EvaluateException valueException = this.myValueException;
        CompletionStage<Boolean> expandableFuture = valueException == null || valueException.getExceptionFromTargetVM() != null ? this.getChildrenRenderer(debugProcess).thenCompose(r -> r.isExpandableAsync(this.getValue(), context, this)) : CompletableFuture.completedFuture(false);
        if (!OnDemandRenderer.isOnDemandForced(debugProcess)) {
            try {
                this.setValueIcon(renderer.calcValueIcon(this, context, labelListener));
            }
            catch (EvaluateException e) {
                LOG.info((Throwable)e);
                this.setValueIcon(null);
            }
        }
        if (this.isShowIdLabel() && renderer instanceof NodeRendererImpl) {
            this.setIdLabel(((NodeRendererImpl)renderer).calcIdLabel(this, debugProcess, labelListener));
        }
        if (valueException == null) {
            long start = renderer instanceof NodeRendererImpl && ((NodeRendererImpl)renderer).hasOverhead() ? System.currentTimeMillis() : 0L;
            try {
                this.setValueLabel(renderer.calcLabel(this, context, labelListener));
            }
            catch (EvaluateException e) {
                this.setValueLabelFailed(e);
            }
            finally {
                if (start > 0L) {
                    OverheadTimings.add(debugProcess, new NodeRendererImpl.Overhead((NodeRendererImpl)renderer), 1L, System.currentTimeMillis() - start);
                }
            }
        } else {
            this.setValueLabelFailed(valueException);
        }
        expandableFuture.whenComplete((res, ex) -> {
            if (ex == null) {
                this.myIsExpandable = res;
            } else if (!((ex = DebuggerUtilsAsync.unwrap(ex)) instanceof CancellationException)) {
                LOG.error(new Throwable((Throwable)ex));
            }
            labelListener.labelChanged();
        });
        return "";
    }

    @Override
    public String getLabel() {
        return this.calcValueName() + this.getDeclaredTypeLabel() + " = " + this.getValueLabel();
    }

    public ValueDescriptorImpl getFullValueDescriptor() {
        ValueDescriptorImpl descriptor = new ValueDescriptorImpl(this.myProject, this.myValue){

            @Override
            public Value calcValue(EvaluationContextImpl evaluationContext) throws EvaluateException {
                return ValueDescriptorImpl.this.myValue;
            }

            @Override
            public PsiExpression getDescriptorEvaluation(DebuggerContext context) throws EvaluateException {
                return null;
            }

            @Override
            public CompletableFuture<NodeRenderer> getRenderer(DebugProcessImpl debugProcess) {
                return ValueDescriptorImpl.this.getRenderer(debugProcess);
            }

            @Override
            public <T> T getUserData(Key<T> key2) {
                return ValueDescriptorImpl.this.getUserData(key2);
            }
        };
        descriptor.myFullValue = true;
        return descriptor;
    }

    @Override
    public void setValueLabel(@NotNull String label) {
        if (label == null) {
            ValueDescriptorImpl.$$$reportNull$$$0(0);
        }
        this.myValueText = this.myFullValue ? label : DebuggerUtilsEx.truncateString(label);
    }

    @Override
    public String setValueLabelFailed(EvaluateException e) {
        String label = this.setFailed(e);
        this.setValueLabel(label);
        return label;
    }

    @Override
    public Icon setValueIcon(Icon icon) {
        this.myValueIcon = icon;
        return this.myValueIcon;
    }

    @Nullable
    public Icon getValueIcon() {
        return this.myValueIcon;
    }

    public String calcValueName() {
        String name2 = this.getName();
        NodeDescriptorNameAdjuster nameAdjuster = NodeDescriptorNameAdjuster.findFor((NodeDescriptor)this);
        if (nameAdjuster != null) {
            return nameAdjuster.fixName(name2, (NodeDescriptor)this);
        }
        return name2;
    }

    @Nullable
    public String getDeclaredType() {
        return null;
    }

    @Override
    public void displayAs(NodeDescriptor descriptor) {
        if (descriptor instanceof ValueDescriptorImpl) {
            ValueDescriptorImpl valueDescriptor = (ValueDescriptorImpl)descriptor;
            this.myRenderer = valueDescriptor.myRenderer;
        }
        super.displayAs(descriptor);
    }

    public Renderer getLastRenderer() {
        return this.myRenderer != null ? this.myRenderer : this.myAutoRenderer;
    }

    public Renderer getLastLabelRenderer() {
        Renderer lastRenderer = this.getLastRenderer();
        if (lastRenderer instanceof CompoundReferenceRenderer) {
            lastRenderer = ((CompoundReferenceRenderer)lastRenderer).getLabelRenderer();
        }
        return lastRenderer;
    }

    public CompletableFuture<NodeRenderer> getChildrenRenderer(DebugProcessImpl debugProcess) {
        if (OnDemandRenderer.isOnDemandForced(debugProcess)) {
            return CompletableFuture.completedFuture(DebugProcessImpl.getDefaultRenderer(this.getValue()));
        }
        return this.getRenderer(debugProcess);
    }

    public CompletableFuture<NodeRenderer> getRenderer(DebugProcessImpl debugProcess) {
        DebuggerManagerThreadImpl.assertIsManagerThread();
        return DebuggerUtilsAsync.type(this.getValue()).thenCompose(type2 -> this.getRenderer((Type)type2, debugProcess));
    }

    private CompletableFuture<NodeRenderer> getRenderer(Type type2, DebugProcessImpl debugProcess) {
        DebuggerManagerThreadImpl.assertIsManagerThread();
        CompletableFuture<Boolean> customCheck = CompletableFuture.completedFuture(false);
        if (type2 != null && this.myRenderer != null) {
            customCheck = this.myRenderer.isApplicableAsync(type2);
        }
        return customCheck.thenCompose(custom -> {
            if (custom.booleanValue()) {
                return CompletableFuture.completedFuture(this.myRenderer);
            }
            return debugProcess.getAutoRendererAsync(type2).thenApply(r -> {
                this.myAutoRenderer = r;
                return this.myAutoRenderer;
            });
        });
    }

    public void setRenderer(NodeRenderer renderer) {
        DebuggerManagerThreadImpl.assertIsManagerThread();
        this.myRenderer = renderer;
        this.myAutoRenderer = null;
    }

    @NotNull
    public CompletableFuture<PsiElement> getTreeEvaluation(JavaValue value2, DebuggerContextImpl context) throws EvaluateException {
        JavaValue parent = value2.getParent();
        if (parent != null) {
            ValueDescriptorImpl vDescriptor = parent.getDescriptor();
            CompletionStage completionStage = vDescriptor.getTreeEvaluation(parent, context).thenCompose(parentEvaluation -> {
                if (!(parentEvaluation instanceof PsiExpression)) {
                    return CompletableFuture.completedFuture(null);
                }
                return vDescriptor.getChildrenRenderer(context.getDebugProcess()).thenApply(childrenRenderer -> {
                    try {
                        return (PsiElement)ReadAction.compute(() -> DebuggerTreeNodeExpression.substituteThis(childrenRenderer.getChildValueExpression(new DebuggerTreeNodeMock(value2), context), (PsiExpression)parentEvaluation, vDescriptor.getValue()));
                    }
                    catch (EvaluateException e) {
                        throw new CompletionException(e);
                    }
                });
            });
            if (completionStage == null) {
                ValueDescriptorImpl.$$$reportNull$$$0(1);
            }
            return completionStage;
        }
        CompletableFuture completableFuture = (CompletableFuture)ReadAction.compute(() -> CompletableFuture.completedFuture(this.getDescriptorEvaluation(context)));
        if (completableFuture == null) {
            ValueDescriptorImpl.$$$reportNull$$$0(2);
        }
        return completableFuture;
    }

    public abstract PsiExpression getDescriptorEvaluation(DebuggerContext var1) throws EvaluateException;

    public static String getIdLabel(ObjectReference objRef) {
        return ValueDescriptorImpl.calcIdLabel(objRef, null, null);
    }

    @Nullable
    public static String calcIdLabel(ValueDescriptor descriptor, @NotNull DescriptorLabelListener labelListener) {
        Value value2;
        if (labelListener == null) {
            ValueDescriptorImpl.$$$reportNull$$$0(3);
        }
        if (!((value2 = descriptor.getValue()) instanceof ObjectReference)) {
            return null;
        }
        return ValueDescriptorImpl.calcIdLabel((ObjectReference)value2, descriptor, labelListener);
    }

    @Nullable
    private static String calcIdLabel(ObjectReference objRef, @Nullable ValueDescriptor descriptor, @Nullable DescriptorLabelListener labelListener) {
        int idx;
        boolean showConcreteType;
        ClassRenderer classRenderer = NodeRendererSettings.getInstance().getClassRenderer();
        if (objRef instanceof StringReference && !classRenderer.SHOW_STRINGS_TYPE) {
            return null;
        }
        StringBuilder buf = new StringBuilder();
        boolean bl = showConcreteType = !classRenderer.SHOW_DECLARED_TYPE || !(objRef instanceof StringReference) && !(objRef instanceof ClassObjectReference) && !ValueDescriptorImpl.isEnumConstant(objRef);
        if (showConcreteType || classRenderer.SHOW_OBJECT_ID) {
            if (showConcreteType) {
                buf.append(classRenderer.renderTypeName(objRef.type().name()));
            }
            if (classRenderer.SHOW_OBJECT_ID) {
                buf.append('@');
                if (ApplicationManager.getApplication().isUnitTestMode()) {
                    buf.append("uniqueID");
                } else {
                    buf.append(objRef.uniqueID());
                }
            }
        }
        if (objRef instanceof ArrayReference && (idx = buf.indexOf("[")) >= 0) {
            if (labelListener == null || descriptor == null) {
                buf.insert(idx + 1, ((ArrayReference)objRef).length());
            } else {
                CompletionStage asyncId = DebuggerUtilsAsync.length((ArrayReference)objRef).thenApply(length -> buf.insert(idx + 1, length).toString());
                if (((CompletableFuture)asyncId).isDone()) {
                    return (String)((CompletableFuture)asyncId).join();
                }
                ((CompletableFuture)asyncId).thenAccept(res -> {
                    descriptor.setIdLabel((String)res);
                    labelListener.labelChanged();
                });
            }
        }
        return buf.toString();
    }

    private static boolean isEnumConstant(ObjectReference objRef) {
        try {
            Type type2 = objRef.type();
            return type2 instanceof ClassType && ((ClassType)type2).isEnum();
        }
        catch (ObjectCollectedException objectCollectedException) {
            return false;
        }
    }

    public boolean canSetValue() {
        return this.myValueReady && !this.myIsSynthetic && this.isLvalue();
    }

    public XValueModifier getModifier(JavaValue value2) {
        return null;
    }

    public String getIdLabel() {
        return this.myIdLabel;
    }

    @Override
    public void setIdLabel(String idLabel) {
        this.myIdLabel = idLabel;
    }

    public String getValueLabel() {
        String label = this.getIdLabel();
        if (!StringUtil.isEmpty((String)label)) {
            return '{' + label + '}' + this.getValueText();
        }
        return this.getValueText();
    }

    @NotNull
    public String getValueText() {
        String string = StringUtil.notNullize((String)this.myValueText);
        if (string == null) {
            ValueDescriptorImpl.$$$reportNull$$$0(4);
        }
        return string;
    }

    @Override
    public void clear() {
        super.clear();
        this.setValueLabel("");
        this.myIsExpandable = false;
    }

    @Override
    @Nullable
    public ValueMarkup getMarkup(DebugProcess debugProcess) {
        Value value2 = this.getValue();
        if (value2 instanceof ObjectReference) {
            ObjectReference objRef = (ObjectReference)value2;
            Map<ObjectReference, ValueMarkup> map2 = ValueDescriptorImpl.getMarkupMap(debugProcess);
            if (map2 != null) {
                return map2.get(objRef);
            }
        }
        return null;
    }

    @Override
    public void setMarkup(DebugProcess debugProcess, @Nullable ValueMarkup markup) {
        Map<ObjectReference, ValueMarkup> map2;
        Value value2 = this.getValue();
        if (value2 instanceof ObjectReference && (map2 = ValueDescriptorImpl.getMarkupMap(debugProcess)) != null) {
            ObjectReference objRef = (ObjectReference)value2;
            if (markup != null) {
                map2.put(objRef, markup);
            } else {
                map2.remove(objRef);
            }
        }
    }

    public boolean canMark() {
        if (!this.myValueReady) {
            return false;
        }
        return this.getValue() instanceof ObjectReference;
    }

    public Project getProject() {
        return this.myProject;
    }

    @NotNull
    public String getDeclaredTypeLabel() {
        String declaredType;
        ClassRenderer classRenderer = NodeRendererSettings.getInstance().getClassRenderer();
        if (classRenderer.SHOW_DECLARED_TYPE && !StringUtil.isEmpty((String)(declaredType = this.getDeclaredType()))) {
            String string = ": " + classRenderer.renderTypeName(declaredType);
            if (string == null) {
                ValueDescriptorImpl.$$$reportNull$$$0(5);
            }
            return string;
        }
        return "";
    }

    public EvaluationContextImpl getStoredEvaluationContext() {
        return this.myStoredEvaluationContext;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "label";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/debugger/ui/impl/watch/ValueDescriptorImpl";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "labelListener";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/debugger/ui/impl/watch/ValueDescriptorImpl";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getTreeEvaluation";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getValueText";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getDeclaredTypeLabel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "setValueLabel";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "calcIdLabel";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class DebuggerTreeNodeMock
    implements DebuggerTreeNode {
        private final JavaValue value;

        DebuggerTreeNodeMock(JavaValue value2) {
            this.value = value2;
        }

        @Override
        public DebuggerTreeNode getParent() {
            return new DebuggerTreeNodeMock(this.value.getParent());
        }

        @Override
        public ValueDescriptorImpl getDescriptor() {
            return this.value.getDescriptor();
        }

        @Override
        public Project getProject() {
            return this.value.getProject();
        }

        @Override
        public void setRenderer(NodeRenderer renderer) {
        }
    }
}

