/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.memory.agent;

import com.intellij.debugger.engine.ReferringObject;
import com.intellij.debugger.engine.ReferringObjectsProvider;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.evaluation.EvaluationContextImpl;
import com.intellij.debugger.memory.agent.MemoryAgent;
import com.intellij.debugger.memory.agent.ReferringObjectsInfo;
import com.sun.jdi.ObjectReference;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class MemoryAgentReferringObjectsProvider
implements ReferringObjectsProvider {
    private final int myObjectsToRequestLimit;
    private final Map<ObjectReference, ReferringObjectsInfo> myCachedRequests = new HashMap<ObjectReference, ReferringObjectsInfo>();

    public MemoryAgentReferringObjectsProvider(int limit) {
        this.myObjectsToRequestLimit = limit;
    }

    @Override
    @NotNull
    public List<ReferringObject> getReferringObjects(@NotNull EvaluationContextImpl evaluationContext, @NotNull ObjectReference value2, long limit) throws EvaluateException {
        if (evaluationContext == null) {
            MemoryAgentReferringObjectsProvider.$$$reportNull$$$0(0);
        }
        if (value2 == null) {
            MemoryAgentReferringObjectsProvider.$$$reportNull$$$0(1);
        }
        if (this.myCachedRequests.containsKey(value2)) {
            List<ReferringObject> list = this.myCachedRequests.get(value2).getReferringObjects(value2, limit);
            if (list == null) {
                MemoryAgentReferringObjectsProvider.$$$reportNull$$$0(2);
            }
            return list;
        }
        for (ReferringObjectsInfo provider : this.myCachedRequests.values()) {
            if (!provider.hasReferringObjectsFor(value2)) continue;
            List<ReferringObject> list = provider.getReferringObjects(value2, limit);
            if (list == null) {
                MemoryAgentReferringObjectsProvider.$$$reportNull$$$0(3);
            }
            return list;
        }
        MemoryAgent memoryAgent = MemoryAgent.get(evaluationContext.getDebugProcess());
        if (!memoryAgent.capabilities().canGetReferringObjects()) {
            throw new UnsupportedOperationException();
        }
        ReferringObjectsInfo roots = memoryAgent.findReferringObjects(evaluationContext, value2, this.myObjectsToRequestLimit);
        this.myCachedRequests.put(value2, roots);
        List<ReferringObject> list = roots.getReferringObjects(value2, limit);
        if (list == null) {
            MemoryAgentReferringObjectsProvider.$$$reportNull$$$0(4);
        }
        return list;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "evaluationContext";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/debugger/memory/agent/MemoryAgentReferringObjectsProvider";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/debugger/memory/agent/MemoryAgentReferringObjectsProvider";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getReferringObjects";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getReferringObjects";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

