/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.impl;

import com.intellij.debugger.impl.EventQueueClosedException;
import com.intellij.openapi.diagnostic.Logger;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import org.jetbrains.annotations.NotNull;

public class EventQueue<E> {
    private static final Logger LOG = Logger.getInstance(EventQueue.class);
    private final LinkedList[] myEvents;
    private final ReentrantLock myLock = new ReentrantLock();
    private final Condition myEventsAvailable = this.myLock.newCondition();
    private volatile E myCurrentEvent;
    private volatile boolean myIsClosed = false;

    public EventQueue(int countPriorities) {
        this.myEvents = new LinkedList[countPriorities];
        for (int i = 0; i < this.myEvents.length; ++i) {
            this.myEvents[i] = new LinkedList();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean pushBack(@NotNull E event, int priority) {
        if (event == null) {
            EventQueue.$$$reportNull$$$0(0);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("pushBack event " + event);
        }
        this.myLock.lock();
        try {
            if (this.isClosed()) {
                boolean bl = false;
                return bl;
            }
            this.getEventsList(priority).addFirst(event);
            this.myEventsAvailable.signalAll();
        }
        finally {
            this.myLock.unlock();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean put(@NotNull E event, int priority) {
        if (event == null) {
            EventQueue.$$$reportNull$$$0(1);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("put event " + event);
        }
        this.myLock.lock();
        try {
            if (this.isClosed()) {
                boolean bl = false;
                return bl;
            }
            this.getEventsList(priority).offer(event);
            this.myEventsAvailable.signalAll();
        }
        finally {
            this.myLock.unlock();
        }
        return true;
    }

    private LinkedList<E> getEventsList(int priority) {
        return this.myEvents[priority];
    }

    public void close() {
        this.myLock.lock();
        try {
            this.myIsClosed = true;
            this.myEventsAvailable.signalAll();
        }
        finally {
            this.myLock.unlock();
        }
    }

    private E getEvent() throws EventQueueClosedException {
        this.myLock.lock();
        try {
            while (true) {
                if (this.myIsClosed) {
                    throw new EventQueueClosedException();
                }
                for (int i = 0; i < this.myEvents.length; ++i) {
                    E event = this.getEventsList(i).poll();
                    if (event == null) continue;
                    E e = event;
                    return e;
                }
                this.myEventsAvailable.awaitUninterruptibly();
            }
        }
        finally {
            this.myLock.unlock();
        }
    }

    public E get() throws EventQueueClosedException {
        try {
            this.myCurrentEvent = this.getEvent();
            return this.myCurrentEvent;
        }
        catch (EventQueueClosedException e) {
            this.myCurrentEvent = null;
            throw e;
        }
    }

    public boolean isClosed() {
        return this.myIsClosed;
    }

    public E getCurrentEvent() {
        return this.myCurrentEvent;
    }

    @NotNull
    public List<E> clearQueue() {
        ArrayList<E> allEvents = new ArrayList<E>();
        for (int i = 0; i < this.myEvents.length; ++i) {
            LinkedList<E> eventList = this.getEventsList(i);
            E event = eventList.poll();
            while (event != null) {
                allEvents.add(event);
                event = eventList.poll();
            }
        }
        ArrayList<E> arrayList = allEvents;
        if (arrayList == null) {
            EventQueue.$$$reportNull$$$0(2);
        }
        return arrayList;
    }

    public boolean isEmpty() {
        this.myLock.lock();
        try {
            boolean bl = Arrays.stream(this.myEvents).allMatch(AbstractCollection::isEmpty);
            return bl;
        }
        finally {
            this.myLock.unlock();
        }
    }

    public void reopen() {
        this.myIsClosed = false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/debugger/impl/EventQueue";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/debugger/impl/EventQueue";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "clearQueue";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "pushBack";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "put";
                break;
            }
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

