/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.actions;

import com.intellij.debugger.DebuggerManagerEx;
import com.intellij.debugger.actions.PlaceInDocument;
import com.intellij.debugger.impl.DebuggerUtilsEx;
import com.intellij.debugger.ui.breakpoints.BreakpointManager;
import com.intellij.debugger.ui.breakpoints.MethodBreakpoint;
import com.intellij.ide.highlighter.JavaClassFileType;
import com.intellij.ide.highlighter.JavaFileType;
import com.intellij.openapi.actionSystem.ActionPlaces;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.util.DocumentUtil;
import com.intellij.util.text.CharArrayUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ToggleMethodBreakpointAction
extends AnAction {
    public void update(@NotNull AnActionEvent event) {
        boolean toEnable;
        if (event == null) {
            ToggleMethodBreakpointAction.$$$reportNull$$$0(0);
        }
        boolean bl = toEnable = ToggleMethodBreakpointAction.getPlace(event) != null;
        if (ActionPlaces.isPopupPlace((String)event.getPlace())) {
            event.getPresentation().setVisible(toEnable);
        } else {
            event.getPresentation().setEnabled(toEnable);
        }
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Project project;
        if (e == null) {
            ToggleMethodBreakpointAction.$$$reportNull$$$0(1);
        }
        if ((project = (Project)e.getData(CommonDataKeys.PROJECT)) == null) {
            return;
        }
        DebuggerManagerEx debugManager = DebuggerManagerEx.getInstanceEx(project);
        if (debugManager == null) {
            return;
        }
        BreakpointManager manager = debugManager.getBreakpointManager();
        PlaceInDocument place = ToggleMethodBreakpointAction.getPlace(e);
        if (place != null && DocumentUtil.isValidOffset((int)place.getOffset(), (Document)place.getDocument())) {
            MethodBreakpoint breakpoint = manager.findBreakpoint(place.getDocument(), place.getOffset(), MethodBreakpoint.CATEGORY);
            if (breakpoint == null) {
                manager.addMethodBreakpoint(place.getDocument(), place.getDocument().getLineNumber(place.getOffset()));
            } else {
                manager.removeBreakpoint(breakpoint);
            }
        }
    }

    @Nullable
    private static PlaceInDocument getPlace(AnActionEvent event) {
        Project project = (Project)event.getData(CommonDataKeys.PROJECT);
        if (project == null) {
            return null;
        }
        PsiElement method = null;
        Document document = null;
        if ("ProjectViewPopup".equals(event.getPlace()) || "StructureViewPopup".equals(event.getPlace()) || "FavoritesPopup".equals(event.getPlace()) || "NavBar".equals(event.getPlace())) {
            PsiFile containingFile;
            PsiElement psiElement = (PsiElement)event.getData(CommonDataKeys.PSI_ELEMENT);
            if (psiElement instanceof PsiMethod && (containingFile = psiElement.getContainingFile()) != null) {
                method = psiElement;
                document = PsiDocumentManager.getInstance((Project)project).getDocument(containingFile);
            }
        } else {
            Editor editor = (Editor)event.getData(CommonDataKeys.EDITOR);
            if (editor == null) {
                editor = FileEditorManager.getInstance((Project)project).getSelectedTextEditor();
            }
            if (editor != null) {
                document = editor.getDocument();
                PsiFile file = PsiDocumentManager.getInstance((Project)project).getPsiFile(document);
                if (file != null) {
                    FileType fileType;
                    VirtualFile virtualFile = file.getVirtualFile();
                    FileType fileType2 = fileType = virtualFile != null ? virtualFile.getFileType() : null;
                    if (JavaFileType.INSTANCE == fileType || JavaClassFileType.INSTANCE == fileType) {
                        method = ToggleMethodBreakpointAction.findMethod(project, editor);
                    }
                }
            }
        }
        return method != null ? new PlaceInDocument(document, method.getTextOffset()) : null;
    }

    @Nullable
    private static PsiMethod findMethod(Project project, Editor editor) {
        if (editor == null) {
            return null;
        }
        PsiFile psiFile = PsiDocumentManager.getInstance((Project)project).getPsiFile(editor.getDocument());
        if (psiFile == null) {
            return null;
        }
        int offset = CharArrayUtil.shiftForward((CharSequence)editor.getDocument().getCharsSequence(), (int)editor.getCaretModel().getOffset(), (String)" \t");
        return DebuggerUtilsEx.findPsiMethod(psiFile, offset);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
        }
        objectArray2[1] = "com/intellij/debugger/actions/ToggleMethodBreakpointAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "update";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "actionPerformed";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

