/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.util;

import com.intellij.codeInspection.util.IterableTraversal;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiForeachStatement;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiUtil;
import com.siyeh.ig.callMatcher.CallMatcher;
import com.siyeh.ig.psiutils.ConstructionUtils;
import com.siyeh.ig.psiutils.EquivalenceChecker;
import com.siyeh.ig.psiutils.ExpressionUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ForEachCollectionTraversal
extends IterableTraversal {
    private static final CallMatcher COLLECTION_TO_ARRAY = CallMatcher.anyOf(CallMatcher.instanceCall("java.util.Collection", "toArray").parameterCount(0), CallMatcher.instanceCall("java.util.Collection", "toArray").parameterTypes("T[]"));
    private static final CallMatcher COLLECTION_REMOVE = CallMatcher.instanceCall("java.util.Collection", "remove").parameterTypes("java.lang.Object");
    private final PsiParameter myParameter;

    ForEachCollectionTraversal(@Nullable PsiExpression iterable, PsiParameter parameter2) {
        super(iterable, true);
        this.myParameter = parameter2;
    }

    public PsiParameter getParameter() {
        return this.myParameter;
    }

    @Override
    public boolean isRemoveCall(PsiExpression candidate) {
        if (!((candidate = PsiUtil.skipParenthesizedExprDown((PsiExpression)candidate)) instanceof PsiMethodCallExpression)) {
            return false;
        }
        PsiMethodCallExpression call = (PsiMethodCallExpression)candidate;
        if (!COLLECTION_REMOVE.test(call)) {
            return false;
        }
        PsiExpression qualifier = call.getMethodExpression().getQualifierExpression();
        if (!EquivalenceChecker.getCanonicalPsiEquivalence().expressionsAreEquivalent(qualifier, this.myIterable)) {
            return false;
        }
        PsiExpression arg = call.getArgumentList().getExpressions()[0];
        return ExpressionUtils.isReferenceTo(arg, (PsiVariable)this.myParameter);
    }

    @Nullable
    public static ForEachCollectionTraversal fromLoop(@NotNull PsiForeachStatement loop) {
        PsiExpression collection;
        if (loop == null) {
            ForEachCollectionTraversal.$$$reportNull$$$0(0);
        }
        if ((collection = ForEachCollectionTraversal.extractCollectionExpression(loop.getIteratedValue())) == null) {
            return null;
        }
        PsiType collectionElement = PsiUtil.substituteTypeParameter((PsiType)collection.getType(), (String)"java.util.Collection", (int)0, (boolean)false);
        if (collectionElement == null) {
            return null;
        }
        PsiParameter parameter2 = loop.getIterationParameter();
        if (!parameter2.getType().equals(collectionElement)) {
            return null;
        }
        return new ForEachCollectionTraversal(collection, parameter2);
    }

    private static PsiExpression extractCollectionExpression(PsiExpression expression2) {
        PsiExpression[] args;
        PsiExpressionList argumentList;
        if ((expression2 = PsiUtil.skipParenthesizedExprDown((PsiExpression)expression2)) instanceof PsiMethodCallExpression && COLLECTION_TO_ARRAY.test((PsiMethodCallExpression)expression2)) {
            return PsiUtil.skipParenthesizedExprDown((PsiExpression)((PsiMethodCallExpression)expression2).getMethodExpression().getQualifierExpression());
        }
        if (expression2 instanceof PsiNewExpression && ConstructionUtils.isReferenceTo(((PsiNewExpression)expression2).getClassReference(), "java.util.ArrayList") && (argumentList = ((PsiNewExpression)expression2).getArgumentList()) != null && (args = argumentList.getExpressions()).length == 1 && InheritanceUtil.isInheritor((PsiType)args[0].getType(), (String)"java.util.Collection")) {
            return args[0];
        }
        if (expression2 != null && InheritanceUtil.isInheritor((PsiType)expression2.getType(), (String)"java.util.Collection")) {
            return expression2;
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "loop", "com/intellij/codeInspection/util/ForEachCollectionTraversal", "fromLoop"));
    }
}

