/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.miscGenerics;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInsight.ExpectedTypeInfo;
import com.intellij.codeInsight.ExpectedTypesProvider;
import com.intellij.codeInspection.AbstractBaseJavaLocalInspectionTool;
import com.intellij.codeInspection.CleanupLocalInspectionTool;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.java.JavaBundle;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.PsiArrayInitializerExpression;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiCall;
import com.intellij.psi.PsiCallExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiEllipsisType;
import com.intellij.psi.PsiEnumConstant;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.refactoring.util.InlineUtil;
import com.intellij.util.IncorrectOperationException;
import com.siyeh.ig.callMatcher.CallMatcher;
import java.util.Arrays;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RedundantArrayForVarargsCallInspection
extends AbstractBaseJavaLocalInspectionTool
implements CleanupLocalInspectionTool {
    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            RedundantArrayForVarargsCallInspection.$$$reportNull$$$0(0);
        }
        return new RedundantArrayForVarargVisitor(holder);
    }

    @NotNull
    public String getGroupDisplayName() {
        String string = InspectionsBundle.message((String)"group.names.verbose.or.redundant.code.constructs", (Object[])new Object[0]);
        if (string == null) {
            RedundantArrayForVarargsCallInspection.$$$reportNull$$$0(1);
        }
        return string;
    }

    @NotNull
    @NonNls
    public String getShortName() {
        return "RedundantArrayCreation";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/miscGenerics/RedundantArrayForVarargsCallInspection";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/miscGenerics/RedundantArrayForVarargsCallInspection";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getGroupDisplayName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
            case 1: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class RedundantArrayForVarargVisitor
    extends JavaElementVisitor {
        private static final Logger LOG = Logger.getInstance(RedundantArrayForVarargVisitor.class);
        private static final String[] LOGGER_NAMES = new String[]{"debug", "error", "info", "trace", "warn"};
        private static final CallMatcher LOGGER_MESSAGE_CALL = CallMatcher.exactInstanceCall("org.slf4j.Logger", LOGGER_NAMES).parameterTypes(String.class.getName(), "java.lang.Object...");
        private static final LocalQuickFix myQuickFixAction = new MyQuickFix();
        @NotNull
        private final ProblemsHolder myHolder;

        private RedundantArrayForVarargVisitor(@NotNull ProblemsHolder holder) {
            if (holder == null) {
                RedundantArrayForVarargVisitor.$$$reportNull$$$0(0);
            }
            this.myHolder = holder;
        }

        public void visitCallExpression(PsiCallExpression expression2) {
            super.visitCallExpression(expression2);
            this.checkCall((PsiCall)expression2);
        }

        public void visitEnumConstant(PsiEnumConstant expression2) {
            super.visitEnumConstant(expression2);
            this.checkCall((PsiCall)expression2);
        }

        private void checkCall(PsiCall expression2) {
            JavaResolveResult resolveResult = expression2.resolveMethodGenerics();
            PsiElement element = resolveResult.getElement();
            PsiSubstitutor substitutor = resolveResult.getSubstitutor();
            if (!(element instanceof PsiMethod)) {
                return;
            }
            PsiMethod method = (PsiMethod)element;
            if (!method.isVarArgs() || AnnotationUtil.isAnnotated((PsiModifierListOwner)method, (String)"java.lang.invoke.MethodHandle.PolymorphicSignature", (int)0)) {
                return;
            }
            PsiParameter[] parameters2 = method.getParameterList().getParameters();
            PsiExpressionList argumentList = expression2.getArgumentList();
            if (argumentList == null) {
                return;
            }
            PsiExpression[] args = argumentList.getExpressions();
            if (parameters2.length != args.length) {
                return;
            }
            PsiExpression lastArg = PsiUtil.skipParenthesizedExprDown((PsiExpression)args[args.length - 1]);
            PsiParameter lastParameter = parameters2[args.length - 1];
            if (!lastParameter.isVarArgs()) {
                return;
            }
            PsiType lastParamType = lastParameter.getType();
            LOG.assertTrue(lastParamType instanceof PsiEllipsisType, (Object)lastParamType);
            if (!(lastArg instanceof PsiNewExpression)) {
                return;
            }
            PsiType substitutedLastParamType = substitutor.substitute(((PsiEllipsisType)lastParamType).toArrayType());
            PsiType lastArgType = lastArg.getType();
            if (lastArgType == null || !lastArgType.equals(substitutedLastParamType) && !lastArgType.equals(TypeConversionUtil.erasure((PsiType)substitutedLastParamType))) {
                return;
            }
            PsiExpression[] initializers = RedundantArrayForVarargVisitor.getInitializers((PsiNewExpression)lastArg);
            if (initializers == null) {
                return;
            }
            if (Arrays.stream(initializers).anyMatch(expr2 -> expr2 instanceof PsiArrayInitializerExpression)) {
                return;
            }
            if (!RedundantArrayForVarargVisitor.isSafeToFlatten(expression2, method, initializers)) {
                return;
            }
            String message2 = JavaBundle.message((String)"inspection.redundant.array.creation.for.varargs.call.descriptor", (Object[])new Object[0]);
            this.myHolder.registerProblem((PsiElement)lastArg, message2, new LocalQuickFix[]{myQuickFixAction});
        }

        private static boolean isSafeToFlatten(@NotNull PsiCall callExpression, @NotNull PsiMethod oldRefMethod, @NotNull @NotNull PsiExpression @NotNull [] arrayElements) {
            PsiType type2;
            if (callExpression == null) {
                RedundantArrayForVarargVisitor.$$$reportNull$$$0(1);
            }
            if (oldRefMethod == null) {
                RedundantArrayForVarargVisitor.$$$reportNull$$$0(2);
            }
            if (arrayElements == null) {
                RedundantArrayForVarargVisitor.$$$reportNull$$$0(3);
            }
            if (callExpression instanceof PsiExpression && LOGGER_MESSAGE_CALL.matches((PsiExpression)callExpression)) {
                return true;
            }
            if (arrayElements.length == 1 && (PsiType.NULL.equals((Object)(type2 = arrayElements[0].getType())) || type2 instanceof PsiArrayType)) {
                return false;
            }
            PsiCall copy = (PsiCall)callExpression.copy();
            PsiExpressionList copyArgumentList = copy.getArgumentList();
            LOG.assertTrue(copyArgumentList != null);
            PsiExpression[] args = copyArgumentList.getExpressions();
            try {
                args[args.length - 1].delete();
                if (arrayElements.length > 0) {
                    copyArgumentList.addRange((PsiElement)arrayElements[0], (PsiElement)arrayElements[arrayElements.length - 1]);
                }
                Project project = callExpression.getProject();
                if (callExpression instanceof PsiEnumConstant) {
                    PsiEnumConstant enumConstant = (PsiEnumConstant)callExpression;
                    PsiClass containingClass = enumConstant.getContainingClass();
                    if (containingClass == null) {
                        return false;
                    }
                    JavaPsiFacade facade = JavaPsiFacade.getInstance((Project)project);
                    PsiClassType classType = facade.getElementFactory().createType(containingClass);
                    JavaResolveResult resolveResult = facade.getResolveHelper().resolveConstructor(classType, copyArgumentList, (PsiElement)enumConstant);
                    return resolveResult.isValidResult() && resolveResult.getElement() == oldRefMethod;
                }
                JavaResolveResult resolveResult = copy.resolveMethodGenerics();
                if (!resolveResult.isValidResult() || resolveResult.getElement() != oldRefMethod) {
                    return false;
                }
                if (callExpression.getParent() instanceof PsiExpressionStatement) {
                    return true;
                }
                ExpectedTypeInfo[] expectedTypes = ExpectedTypesProvider.getExpectedTypes((PsiExpression)((PsiCallExpression)callExpression), false);
                if (expectedTypes.length == 0) {
                    return false;
                }
                PsiType expressionType = ((PsiCallExpression)copy).getType();
                if (expressionType == null) {
                    return false;
                }
                for (ExpectedTypeInfo expectedType : expectedTypes) {
                    if (!expectedType.getType().isAssignableFrom(expressionType)) continue;
                    return true;
                }
                return false;
            }
            catch (IncorrectOperationException e) {
                return false;
            }
        }

        private static PsiExpression @Nullable [] getInitializers(@NotNull PsiNewExpression newExpression) {
            PsiArrayInitializerExpression initializer;
            if (newExpression == null) {
                RedundantArrayForVarargVisitor.$$$reportNull$$$0(4);
            }
            if ((initializer = newExpression.getArrayInitializer()) != null) {
                return initializer.getInitializers();
            }
            PsiExpression[] dims = newExpression.getArrayDimensions();
            if (dims.length > 0) {
                PsiExpression firstDimension = dims[0];
                Object value2 = JavaPsiFacade.getInstance((Project)newExpression.getProject()).getConstantEvaluationHelper().computeConstantExpression((PsiElement)firstDimension);
                if (value2 instanceof Integer && (Integer)value2 == 0) {
                    return PsiExpression.EMPTY_ARRAY;
                }
            }
            return null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "holder";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "callExpression";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "oldRefMethod";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "arrayElements";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "newExpression";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/codeInspection/miscGenerics/RedundantArrayForVarargsCallInspection$RedundantArrayForVarargVisitor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isSafeToFlatten";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getInitializers";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }

        private static final class MyQuickFix
        implements LocalQuickFix {
            private MyQuickFix() {
            }

            public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
                PsiNewExpression arrayCreation;
                if (project == null) {
                    MyQuickFix.$$$reportNull$$$0(0);
                }
                if (descriptor == null) {
                    MyQuickFix.$$$reportNull$$$0(1);
                }
                if ((arrayCreation = (PsiNewExpression)descriptor.getPsiElement()) == null) {
                    return;
                }
                InlineUtil.inlineArrayCreationForVarargs(arrayCreation);
            }

            @NotNull
            public String getFamilyName() {
                String string = JavaBundle.message((String)"inspection.redundant.array.creation.quickfix", (Object[])new Object[0]);
                if (string == null) {
                    MyQuickFix.$$$reportNull$$$0(2);
                }
                return string;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 2: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 2: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "project";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "descriptor";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/codeInspection/miscGenerics/RedundantArrayForVarargsCallInspection$RedundantArrayForVarargVisitor$MyQuickFix";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/codeInspection/miscGenerics/RedundantArrayForVarargsCallInspection$RedundantArrayForVarargVisitor$MyQuickFix";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getFamilyName";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "applyFix";
                        break;
                    }
                    case 2: {
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 2: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        }
    }
}

