/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.deprecation;

import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiReferenceExpression;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=2, d1={"\u0000\u0014\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u0018\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0002\u00a8\u0006\u0006"}, d2={"generateQualifierText", "", "expr", "Lcom/intellij/psi/PsiReferenceExpression;", "replacementMethod", "Lcom/intellij/psi/PsiMember;", "intellij.java.analysis.impl"})
public final class DeprecationInspectionQuickFixesKt {
    private static final String generateQualifierText(PsiReferenceExpression expr2, PsiMember replacementMethod) {
        String string;
        PsiExpression qualifierExpression2 = expr2.getQualifierExpression();
        boolean isReplacementStatic = replacementMethod.hasModifierProperty("static");
        if (qualifierExpression2 != null && !isReplacementStatic) {
            string = qualifierExpression2.getText() + ".";
        } else if (isReplacementStatic) {
            StringBuilder stringBuilder = new StringBuilder();
            PsiClass psiClass = replacementMethod.getContainingClass();
            if (psiClass == null) {
                Intrinsics.throwNpe();
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)psiClass, (String)"replacementMethod.containingClass!!");
            String string2 = psiClass.getQualifiedName();
            if (string2 == null) {
                Intrinsics.throwNpe();
            }
            string = stringBuilder.append(string2).append(".").toString();
        } else {
            string = "";
        }
        return string;
    }

    public static final /* synthetic */ String access$generateQualifierText(PsiReferenceExpression expr2, PsiMember replacementMethod) {
        return DeprecationInspectionQuickFixesKt.generateQualifierText(expr2, replacementMethod);
    }
}

