/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.deprecation;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInsight.daemon.JavaErrorBundle;
import com.intellij.codeInsight.daemon.impl.analysis.HighlightMessageUtil;
import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.deprecation.ReplaceFieldReferenceFix;
import com.intellij.codeInspection.deprecation.ReplaceMethodCallFix;
import com.intellij.codeInspection.ui.MultipleCheckboxOptionsPanel;
import com.intellij.java.analysis.JavaAnalysisBundle;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiConstructorCall;
import com.intellij.psi.PsiDocCommentOwner;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiImportStatement;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiResolveHelper;
import com.intellij.psi.PsiType;
import com.intellij.psi.impl.PsiImplUtil;
import com.intellij.psi.impl.compiled.ClsMethodImpl;
import com.intellij.psi.infos.MethodCandidateInfo;
import com.intellij.psi.javadoc.PsiDocComment;
import com.intellij.psi.javadoc.PsiDocTag;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.refactoring.util.RefactoringChangeUtil;
import com.intellij.util.ObjectUtils;
import com.siyeh.ig.psiutils.ExpectedTypeUtils;
import com.siyeh.ig.psiutils.ExpressionUtils;
import java.util.Collection;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;
import one.util.streamex.MoreCollectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class DeprecationInspectionBase
extends LocalInspectionTool {
    public boolean IGNORE_IN_SAME_OUTERMOST_CLASS = true;

    public boolean isEnabledByDefault() {
        return true;
    }

    public static void checkDeprecated(@NotNull PsiModifierListOwner element, @NotNull PsiElement elementToHighlight, @Nullable TextRange rangeInElement, boolean ignoreInsideDeprecated, boolean ignoreImportStatements, boolean ignoreMethodsOfDeprecated, boolean ignoreInSameOutermostClass, @NotNull ProblemsHolder holder, boolean forRemoval, @NotNull ProblemHighlightType highlightType) {
        if (element == null) {
            DeprecationInspectionBase.$$$reportNull$$$0(0);
        }
        if (elementToHighlight == null) {
            DeprecationInspectionBase.$$$reportNull$$$0(1);
        }
        if (holder == null) {
            DeprecationInspectionBase.$$$reportNull$$$0(2);
        }
        if (highlightType == null) {
            DeprecationInspectionBase.$$$reportNull$$$0(3);
        }
        if (PsiImplUtil.isDeprecated((PsiElement)element)) {
            if (forRemoval != DeprecationInspectionBase.isForRemovalAttributeSet(element)) {
                return;
            }
        } else {
            if (!ignoreMethodsOfDeprecated) {
                PsiClass containingClass;
                PsiClass psiClass = containingClass = element instanceof PsiMember ? ((PsiMember)element).getContainingClass() : null;
                if (containingClass != null) {
                    DeprecationInspectionBase.checkDeprecated((PsiModifierListOwner)containingClass, elementToHighlight, rangeInElement, ignoreInsideDeprecated, ignoreImportStatements, false, ignoreInSameOutermostClass, holder, forRemoval, highlightType);
                }
            }
            return;
        }
        if (ignoreInSameOutermostClass && DeprecationInspectionBase.areElementsInSameOutermostClass((PsiElement)element, elementToHighlight)) {
            return;
        }
        if (ignoreInsideDeprecated && DeprecationInspectionBase.isElementInsideDeprecated(elementToHighlight)) {
            return;
        }
        if (ignoreImportStatements && DeprecationInspectionBase.isElementInsideImportStatement(elementToHighlight)) {
            return;
        }
        String description = JavaErrorBundle.message(forRemoval ? "marked.for.removal.symbol" : "deprecated.symbol", DeprecationInspectionBase.getPresentableName((PsiElement)element));
        LocalQuickFix replacementQuickFix = DeprecationInspectionBase.getReplacementQuickFix((PsiElement)element, elementToHighlight);
        holder.registerProblem(elementToHighlight, DeprecationInspectionBase.getDescription(description, forRemoval, highlightType), highlightType, rangeInElement, new LocalQuickFix[]{replacementQuickFix});
    }

    private static boolean isElementInsideImportStatement(@NotNull PsiElement elementToHighlight) {
        if (elementToHighlight == null) {
            DeprecationInspectionBase.$$$reportNull$$$0(4);
        }
        return PsiTreeUtil.getParentOfType((PsiElement)elementToHighlight, PsiImportStatement.class) != null;
    }

    public static boolean isElementInsideDeprecated(@NotNull PsiElement element) {
        if (element == null) {
            DeprecationInspectionBase.$$$reportNull$$$0(5);
        }
        PsiElement parent = element;
        while ((parent = PsiTreeUtil.getParentOfType((PsiElement)parent, PsiModifierListOwner.class, (boolean)true)) != null) {
            if (!PsiImplUtil.isDeprecated(parent)) continue;
            return true;
        }
        return false;
    }

    @Nullable
    private static LocalQuickFix getReplacementQuickFix(@NotNull PsiElement refElement, @NotNull PsiElement elementToHighlight) {
        PsiField replacement;
        PsiReferenceExpression referenceExpression;
        PsiMethod replacement2;
        if (refElement == null) {
            DeprecationInspectionBase.$$$reportNull$$$0(6);
        }
        if (elementToHighlight == null) {
            DeprecationInspectionBase.$$$reportNull$$$0(7);
        }
        PsiMethodCallExpression methodCall = DeprecationInspectionBase.getMethodCall(elementToHighlight);
        if (refElement instanceof PsiMethod && methodCall != null && (replacement2 = DeprecationInspectionBase.findReplacementInJavaDoc((PsiMethod)refElement, methodCall)) != null) {
            return new ReplaceMethodCallFix((PsiMethodCallExpression)elementToHighlight.getParent().getParent(), replacement2);
        }
        if (refElement instanceof PsiField && (referenceExpression = DeprecationInspectionBase.getFieldReferenceExpression(elementToHighlight)) != null && (replacement = DeprecationInspectionBase.findReplacementInJavaDoc((PsiField)refElement, referenceExpression)) != null) {
            return new ReplaceFieldReferenceFix(referenceExpression, replacement);
        }
        return null;
    }

    public static String getPresentableName(@NotNull PsiElement psiElement) {
        if (psiElement == null) {
            DeprecationInspectionBase.$$$reportNull$$$0(8);
        }
        if (psiElement instanceof PsiMethod && PsiUtil.isAnnotationMethod((PsiElement)psiElement)) {
            return ((PsiMethod)psiElement).getName();
        }
        return HighlightMessageUtil.getSymbolName(psiElement);
    }

    protected static boolean isForRemovalAttributeSet(@NotNull PsiModifierListOwner element) {
        PsiAnnotation annotation;
        if (element == null) {
            DeprecationInspectionBase.$$$reportNull$$$0(9);
        }
        if ((annotation = AnnotationUtil.findAnnotation((PsiModifierListOwner)element, (String[])new String[]{"java.lang.Deprecated"})) != null) {
            return DeprecationInspectionBase.isForRemovalAttributeSet(annotation);
        }
        return false;
    }

    protected static boolean isForRemovalAttributeSet(@NotNull PsiAnnotation deprecatedAnnotation) {
        if (deprecatedAnnotation == null) {
            DeprecationInspectionBase.$$$reportNull$$$0(10);
        }
        return Boolean.TRUE == AnnotationUtil.getBooleanAttributeValue((PsiAnnotation)deprecatedAnnotation, (String)"forRemoval");
    }

    private static boolean areElementsInSameOutermostClass(PsiElement refElement, PsiElement elementToHighlight) {
        PsiClass outermostClass = (PsiClass)CachedValuesManager.getCachedValue((PsiElement)refElement, () -> new CachedValueProvider.Result((Object)PsiUtil.getTopLevelClass((PsiElement)refElement), new Object[]{PsiModificationTracker.MODIFICATION_COUNT}));
        return outermostClass != null && outermostClass == PsiUtil.getTopLevelClass((PsiElement)elementToHighlight);
    }

    static void addSameOutermostClassCheckBox(MultipleCheckboxOptionsPanel panel2) {
        panel2.addCheckbox(JavaAnalysisBundle.message((String)"ignore.in.the.same.outermost.class", (Object[])new Object[0]), "IGNORE_IN_SAME_OUTERMOST_CLASS");
    }

    protected static String getDescription(@NotNull String description, boolean forRemoval, ProblemHighlightType highlightType) {
        if (description == null) {
            DeprecationInspectionBase.$$$reportNull$$$0(11);
        }
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            ProblemHighlightType defaultType;
            ProblemHighlightType problemHighlightType = defaultType = forRemoval ? ProblemHighlightType.LIKE_MARKED_FOR_REMOVAL : ProblemHighlightType.LIKE_DEPRECATED;
            if (highlightType != defaultType) {
                return description + "(" + highlightType + ")";
            }
        }
        return description;
    }

    private static PsiField findReplacementInJavaDoc(@NotNull PsiField field, @NotNull PsiReferenceExpression referenceExpression) {
        if (field == null) {
            DeprecationInspectionBase.$$$reportNull$$$0(12);
        }
        if (referenceExpression == null) {
            DeprecationInspectionBase.$$$reportNull$$$0(13);
        }
        return ((Optional)DeprecationInspectionBase.getReplacementCandidatesFromJavadoc(field, PsiField.class, (PsiElement)field, RefactoringChangeUtil.getQualifierClass(referenceExpression)).filter(tagField -> DeprecationInspectionBase.areReplaceable(tagField, referenceExpression)).collect(MoreCollectors.onlyOne())).orElse(null);
    }

    private static PsiMethod findReplacementInJavaDoc(@NotNull PsiMethod method, @NotNull PsiMethodCallExpression call) {
        if (method == null) {
            DeprecationInspectionBase.$$$reportNull$$$0(14);
        }
        if (call == null) {
            DeprecationInspectionBase.$$$reportNull$$$0(15);
        }
        if (method instanceof PsiConstructorCall) {
            return null;
        }
        if (method instanceof ClsMethodImpl) {
            PsiMethod sourceMethod = ((ClsMethodImpl)method).getSourceMirrorMethod();
            return sourceMethod == null ? null : DeprecationInspectionBase.findReplacementInJavaDoc(sourceMethod, call);
        }
        return ((Optional)DeprecationInspectionBase.getReplacementCandidatesFromJavadoc(method, PsiMethod.class, (PsiElement)call, RefactoringChangeUtil.getQualifierClass(call.getMethodExpression())).filter(tagMethod -> DeprecationInspectionBase.areReplaceable(method, tagMethod, call)).collect(MoreCollectors.onlyOne())).orElse(null);
    }

    @NotNull
    private static <T extends PsiDocCommentOwner> Stream<? extends T> getReplacementCandidatesFromJavadoc(T member, Class<T> clazz, PsiElement context, PsiClass qualifierClass) {
        PsiDocComment doc = member.getDocComment();
        if (doc == null) {
            Stream stream = Stream.empty();
            if (stream == null) {
                DeprecationInspectionBase.$$$reportNull$$$0(16);
            }
            return stream;
        }
        Collection docTags = PsiTreeUtil.findChildrenOfType((PsiElement)doc, PsiDocTag.class);
        if (docTags.isEmpty()) {
            Stream stream = Stream.empty();
            if (stream == null) {
                DeprecationInspectionBase.$$$reportNull$$$0(17);
            }
            return stream;
        }
        Stream<PsiDocCommentOwner> stream = docTags.stream().filter(t -> {
            String name2 = t.getName();
            return "link".equals(name2) || "see".equals(name2);
        }).map(tag -> tag.getValueElement()).filter(Objects::nonNull).map(value2 -> value2.getReference()).filter(Objects::nonNull).map(reference -> reference.resolve()).distinct().map(resolved -> (PsiDocCommentOwner)ObjectUtils.tryCast((Object)resolved, (Class)clazz)).filter(Objects::nonNull).filter(tagMethod -> !tagMethod.isDeprecated()).filter(tagMethod -> PsiResolveHelper.SERVICE.getInstance((Project)context.getProject()).isAccessible((PsiMember)tagMethod, context, qualifierClass)).filter(tagMethod -> !member.getManager().areElementsEquivalent((PsiElement)tagMethod, (PsiElement)member));
        if (stream == null) {
            DeprecationInspectionBase.$$$reportNull$$$0(18);
        }
        return stream;
    }

    private static boolean areReplaceable(PsiField suggested, PsiReferenceExpression expression2) {
        if (ExpressionUtils.isVoidContext((PsiExpression)expression2)) {
            return true;
        }
        PsiType expectedType = ExpectedTypeUtils.findExpectedType((PsiExpression)expression2, true);
        if (expectedType == null) {
            return true;
        }
        PsiType suggestedType = suggested.getType();
        return TypeConversionUtil.isAssignable((PsiType)expectedType, (PsiType)suggestedType);
    }

    private static boolean areReplaceable(@NotNull PsiMethod initial, @NotNull PsiMethod suggestedReplacement, @NotNull PsiMethodCallExpression call) {
        MethodCandidateInfo result;
        String qualifierText;
        boolean isInitialStatic;
        if (initial == null) {
            DeprecationInspectionBase.$$$reportNull$$$0(19);
        }
        if (suggestedReplacement == null) {
            DeprecationInspectionBase.$$$reportNull$$$0(20);
        }
        if (call == null) {
            DeprecationInspectionBase.$$$reportNull$$$0(21);
        }
        if (isInitialStatic = initial.hasModifierProperty("static")) {
            qualifierText = Objects.requireNonNull(suggestedReplacement.getContainingClass()).getQualifiedName() + ".";
        } else {
            PsiExpression qualifierExpression2 = call.getMethodExpression().getQualifierExpression();
            qualifierText = qualifierExpression2 == null ? "" : qualifierExpression2.getText() + ".";
            PsiExpression qualifier = ExpressionUtils.getEffectiveQualifier(call.getMethodExpression());
            if (qualifier == null) {
                return false;
            }
            PsiClass qualifierClass = PsiUtil.resolveClassInType((PsiType)qualifier.getType());
            if (qualifierClass == null) {
                return false;
            }
            PsiClass suggestedClass = suggestedReplacement.getContainingClass();
            if (suggestedClass == null || !InheritanceUtil.isInheritorOrSelf((PsiClass)qualifierClass, (PsiClass)suggestedClass, (boolean)true)) {
                return false;
            }
        }
        PsiElementFactory elementFactory = JavaPsiFacade.getElementFactory((Project)initial.getProject());
        PsiExpressionList arguments = call.getArgumentList();
        PsiMethodCallExpression suggestedCall = (PsiMethodCallExpression)elementFactory.createExpressionFromText(qualifierText + suggestedReplacement.getName() + arguments.getText(), (PsiElement)call);
        PsiType type2 = ExpectedTypeUtils.findExpectedType((PsiExpression)call, true);
        if (type2 != null && !type2.equals(PsiType.VOID)) {
            PsiType suggestedCallType = suggestedCall.getType();
            if (!ExpressionUtils.isVoidContext((PsiExpression)call) && suggestedCallType != null && !TypeConversionUtil.isAssignable((PsiType)type2, (PsiType)suggestedCallType)) {
                return false;
            }
        }
        return (result = (MethodCandidateInfo)ObjectUtils.tryCast((Object)suggestedCall.resolveMethodGenerics(), MethodCandidateInfo.class)) != null && result.isApplicable();
    }

    @Nullable
    private static PsiReferenceExpression getFieldReferenceExpression(@NotNull PsiElement element) {
        if (element == null) {
            DeprecationInspectionBase.$$$reportNull$$$0(22);
        }
        if (element instanceof PsiReferenceExpression) {
            return (PsiReferenceExpression)element;
        }
        return (PsiReferenceExpression)ObjectUtils.tryCast((Object)element.getParent(), PsiReferenceExpression.class);
    }

    @Nullable
    private static PsiMethodCallExpression getMethodCall(@NotNull PsiElement element) {
        if (element == null) {
            DeprecationInspectionBase.$$$reportNull$$$0(23);
        }
        if (element instanceof PsiReferenceExpression) {
            return (PsiMethodCallExpression)ObjectUtils.tryCast((Object)element.getParent(), PsiMethodCallExpression.class);
        }
        if (element instanceof PsiIdentifier) {
            return DeprecationInspectionBase.getMethodCall(element.getParent());
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 16: 
            case 17: 
            case 18: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 16: 
            case 17: 
            case 18: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: 
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementToHighlight";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "highlightType";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "refElement";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiElement";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "deprecatedAnnotation";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "description";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "field";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "referenceExpression";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 15: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "call";
                break;
            }
            case 16: 
            case 17: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/deprecation/DeprecationInspectionBase";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "initial";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "suggestedReplacement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/deprecation/DeprecationInspectionBase";
                break;
            }
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getReplacementCandidatesFromJavadoc";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "checkDeprecated";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isElementInsideImportStatement";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isElementInsideDeprecated";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getReplacementQuickFix";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getPresentableName";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "isForRemovalAttributeSet";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getDescription";
                break;
            }
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "findReplacementInJavaDoc";
                break;
            }
            case 16: 
            case 17: 
            case 18: {
                break;
            }
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "areReplaceable";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "getFieldReferenceExpression";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "getMethodCall";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 16: 
            case 17: 
            case 18: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

