/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.dataFlow.value;

import com.intellij.codeInsight.Nullability;
import com.intellij.codeInspection.dataFlow.SpecialField;
import com.intellij.codeInspection.dataFlow.types.DfType;
import com.intellij.codeInspection.dataFlow.types.DfTypes;
import com.intellij.codeInspection.dataFlow.value.DfaTypeValue;
import com.intellij.codeInspection.dataFlow.value.DfaValue;
import com.intellij.codeInspection.dataFlow.value.DfaValueFactory;
import com.intellij.codeInspection.dataFlow.value.DfaVariableValue;
import com.intellij.psi.PsiType;
import gnu.trove.TIntObjectHashMap;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DfaBoxedValue
extends DfaValue {
    @NotNull
    private final DfaVariableValue myWrappedValue;
    @Nullable
    private final PsiType myType;

    private DfaBoxedValue(@NotNull DfaVariableValue valueToWrap, @NotNull DfaValueFactory factory, @Nullable PsiType type2) {
        if (valueToWrap == null) {
            DfaBoxedValue.$$$reportNull$$$0(0);
        }
        if (factory == null) {
            DfaBoxedValue.$$$reportNull$$$0(1);
        }
        super(factory);
        this.myWrappedValue = valueToWrap;
        this.myType = type2;
    }

    @NonNls
    public String toString() {
        return "Boxed " + this.myWrappedValue.toString();
    }

    @NotNull
    public DfaVariableValue getWrappedValue() {
        DfaVariableValue dfaVariableValue = this.myWrappedValue;
        if (dfaVariableValue == null) {
            DfaBoxedValue.$$$reportNull$$$0(2);
        }
        return dfaVariableValue;
    }

    @Override
    @Nullable
    public PsiType getType() {
        return this.myType;
    }

    @Override
    @NotNull
    public DfType getDfType() {
        DfType dfType = DfTypes.typedObject(this.myType, Nullability.NOT_NULL);
        if (dfType == null) {
            DfaBoxedValue.$$$reportNull$$$0(3);
        }
        return dfType;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "valueToWrap";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "factory";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/dataFlow/value/DfaBoxedValue";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/dataFlow/value/DfaBoxedValue";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getWrappedValue";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getDfType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class Factory {
        private final TIntObjectHashMap<DfaBoxedValue> cachedValues = new TIntObjectHashMap();
        private final DfaValueFactory myFactory;

        public Factory(DfaValueFactory factory) {
            this.myFactory = factory;
        }

        @Nullable
        public DfaValue createBoxed(DfaValue valueToWrap, @Nullable PsiType type2) {
            DfaVariableValue qualifier;
            if (valueToWrap instanceof DfaVariableValue && ((DfaVariableValue)valueToWrap).getDescriptor() == SpecialField.UNBOX && (qualifier = ((DfaVariableValue)valueToWrap).getQualifier()) != null && (type2 == null || type2.equals(qualifier.getType()))) {
                return qualifier;
            }
            if (valueToWrap instanceof DfaTypeValue) {
                DfType dfType = SpecialField.UNBOX.asDfType(valueToWrap.getDfType(), type2);
                return this.myFactory.fromDfType(dfType);
            }
            if (valueToWrap instanceof DfaVariableValue) {
                int id = valueToWrap.getID();
                DfaBoxedValue boxedValue = (DfaBoxedValue)this.cachedValues.get(id);
                if (boxedValue == null) {
                    boxedValue = new DfaBoxedValue((DfaVariableValue)valueToWrap, this.myFactory, type2);
                    this.cachedValues.put(id, (Object)boxedValue);
                }
                return boxedValue;
            }
            return null;
        }
    }
}

