/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.dataFlow.instructions;

import com.intellij.codeInsight.Nullability;
import com.intellij.codeInspection.dataFlow.DataFlowRunner;
import com.intellij.codeInspection.dataFlow.DfaInstructionState;
import com.intellij.codeInspection.dataFlow.DfaMemoryState;
import com.intellij.codeInspection.dataFlow.DfaPsiUtil;
import com.intellij.codeInspection.dataFlow.InstructionVisitor;
import com.intellij.codeInspection.dataFlow.MethodContract;
import com.intellij.codeInspection.dataFlow.MutationSignature;
import com.intellij.codeInspection.dataFlow.instructions.ExpressionPushingInstruction;
import com.intellij.codeInspection.dataFlow.value.DfaTypeValue;
import com.intellij.codeInspection.dataFlow.value.DfaValue;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.PsiCall;
import com.intellij.psi.PsiCallExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiEllipsisType;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodReferenceExpression;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.util.ObjectUtils;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MethodCallInstruction
extends ExpressionPushingInstruction<PsiExpression> {
    private static final Nullability[] EMPTY_NULLABILITY_ARRAY = new Nullability[0];
    @Nullable
    private final PsiType myType;
    private final int myArgCount;
    @NotNull
    private final MutationSignature myMutation;
    @NotNull
    private final PsiElement myContext;
    @Nullable
    private final PsiMethod myTargetMethod;
    private final List<MethodContract> myContracts;
    @Nullable
    private final DfaValue myPrecalculatedReturnValue;
    private final boolean myVarArgCall;
    private final Nullability[] myArgRequiredNullability;
    private final Nullability myReturnNullability;

    public MethodCallInstruction(@NotNull PsiMethodReferenceExpression reference, @NotNull List<? extends MethodContract> contracts2) {
        if (reference == null) {
            MethodCallInstruction.$$$reportNull$$$0(0);
        }
        if (contracts2 == null) {
            MethodCallInstruction.$$$reportNull$$$0(1);
        }
        super(reference);
        this.myContext = reference;
        JavaResolveResult resolveResult = reference.advancedResolve(false);
        this.myTargetMethod = (PsiMethod)ObjectUtils.tryCast((Object)resolveResult.getElement(), PsiMethod.class);
        this.myContracts = Collections.unmodifiableList(contracts2);
        int n = this.myArgCount = this.myTargetMethod == null ? 0 : this.myTargetMethod.getParameterList().getParametersCount();
        if (this.myTargetMethod == null) {
            this.myType = null;
            this.myReturnNullability = Nullability.UNKNOWN;
        } else if (this.myTargetMethod.isConstructor()) {
            PsiClass containingClass = this.myTargetMethod.getContainingClass();
            this.myType = containingClass == null ? null : JavaPsiFacade.getElementFactory((Project)this.myTargetMethod.getProject()).createType(containingClass, resolveResult.getSubstitutor());
            this.myReturnNullability = Nullability.NOT_NULL;
        } else {
            this.myType = resolveResult.getSubstitutor().substitute(this.myTargetMethod.getReturnType());
            this.myReturnNullability = DfaPsiUtil.getElementNullability(this.myType, (PsiModifierListOwner)this.myTargetMethod);
        }
        this.myVarArgCall = false;
        this.myPrecalculatedReturnValue = null;
        this.myArgRequiredNullability = this.myTargetMethod == null ? EMPTY_NULLABILITY_ARRAY : this.calcArgRequiredNullability(resolveResult.getSubstitutor(), this.myTargetMethod.getParameterList().getParameters());
        this.myMutation = MutationSignature.fromMethod(this.myTargetMethod);
    }

    public MethodCallInstruction(@NotNull PsiCall call, @Nullable DfaValue precalculatedReturnValue, List<? extends MethodContract> contracts2) {
        if (call == null) {
            MethodCallInstruction.$$$reportNull$$$0(2);
        }
        super((PsiExpression)ObjectUtils.tryCast((Object)call, PsiExpression.class));
        this.myContext = call;
        this.myContracts = Collections.unmodifiableList(contracts2);
        PsiExpressionList argList = call.getArgumentList();
        PsiExpression[] args = argList != null ? argList.getExpressions() : PsiExpression.EMPTY_ARRAY;
        this.myArgCount = args.length;
        this.myType = call instanceof PsiCallExpression ? ((PsiCallExpression)call).getType() : null;
        JavaResolveResult result = call.resolveMethodGenerics();
        this.myTargetMethod = (PsiMethod)result.getElement();
        PsiSubstitutor substitutor = result.getSubstitutor();
        if (argList != null && this.myTargetMethod != null) {
            PsiParameter[] parameters2 = this.myTargetMethod.getParameterList().getParameters();
            this.myVarArgCall = MethodCallInstruction.isVarArgCall(this.myTargetMethod, substitutor, args, parameters2);
            this.myArgRequiredNullability = this.calcArgRequiredNullability(substitutor, parameters2);
        } else {
            this.myVarArgCall = false;
            this.myArgRequiredNullability = EMPTY_NULLABILITY_ARRAY;
        }
        this.myMutation = MutationSignature.fromCall(call);
        this.myPrecalculatedReturnValue = DfaTypeValue.isUnknown(precalculatedReturnValue) ? null : precalculatedReturnValue;
        this.myReturnNullability = call instanceof PsiNewExpression ? Nullability.NOT_NULL : DfaPsiUtil.getElementNullability(this.myType, (PsiModifierListOwner)this.myTargetMethod);
    }

    public PsiElement getArgumentAnchor(int index) {
        PsiExpressionList argumentList;
        if (this.myContext instanceof PsiCall && (argumentList = ((PsiCall)this.myContext).getArgumentList()) != null) {
            return argumentList.getExpressions()[index];
        }
        if (this.myContext instanceof PsiMethodReferenceExpression) {
            return ((PsiMethodReferenceExpression)this.myContext).getReferenceNameElement();
        }
        throw new AssertionError();
    }

    private Nullability[] calcArgRequiredNullability(PsiSubstitutor substitutor, PsiParameter[] parameters2) {
        PsiType lastParamType;
        if (this.myArgCount == 0) {
            return EMPTY_NULLABILITY_ARRAY;
        }
        int checkedCount = Math.min(this.myArgCount, parameters2.length - (this.myVarArgCall ? 1 : 0));
        Object[] nullabilities = new Nullability[this.myArgCount];
        for (int i = 0; i < checkedCount; ++i) {
            nullabilities[i] = DfaPsiUtil.getElementNullability(substitutor.substitute(parameters2[i].getType()), (PsiModifierListOwner)parameters2[i]);
        }
        if (this.myVarArgCall && MethodCallInstruction.isEllipsisWithNotNullElements(lastParamType = substitutor.substitute(parameters2[parameters2.length - 1].getType()))) {
            Arrays.fill(nullabilities, parameters2.length - 1, this.myArgCount, Nullability.NOT_NULL);
        }
        return nullabilities;
    }

    private static boolean isEllipsisWithNotNullElements(PsiType lastParamType) {
        return lastParamType instanceof PsiEllipsisType && DfaPsiUtil.getElementNullability(((PsiEllipsisType)lastParamType).getComponentType(), null) == Nullability.NOT_NULL;
    }

    public static boolean isVarArgCall(PsiMethod method, PsiSubstitutor substitutor, PsiExpression[] args, PsiParameter[] parameters2) {
        if (!method.isVarArgs()) {
            return false;
        }
        int argCount = args.length;
        int paramCount = parameters2.length;
        if (argCount > paramCount || argCount == paramCount - 1) {
            return true;
        }
        if (paramCount > 0 && argCount == paramCount) {
            PsiType lastArgType = args[argCount - 1].getType();
            return lastArgType != null && !substitutor.substitute(parameters2[paramCount - 1].getType()).isAssignableFrom(lastArgType);
        }
        return false;
    }

    @Nullable
    public PsiType getResultType() {
        return this.myType;
    }

    public int getArgCount() {
        return this.myArgCount;
    }

    @NotNull
    public MutationSignature getMutationSignature() {
        MutationSignature mutationSignature = this.myMutation;
        if (mutationSignature == null) {
            MethodCallInstruction.$$$reportNull$$$0(3);
        }
        return mutationSignature;
    }

    @Nullable
    public PsiMethod getTargetMethod() {
        return this.myTargetMethod;
    }

    public boolean isVarArgCall() {
        return this.myVarArgCall;
    }

    @Nullable
    public Nullability getArgRequiredNullability(int index) {
        return index >= this.myArgRequiredNullability.length ? null : this.myArgRequiredNullability[index];
    }

    public List<MethodContract> getContracts() {
        return this.myContracts;
    }

    @Override
    public DfaInstructionState[] accept(DataFlowRunner runner, DfaMemoryState stateBefore, InstructionVisitor visitor2) {
        return visitor2.visitMethodCall(this, runner, stateBefore);
    }

    @Nullable
    public PsiCall getCallExpression() {
        return (PsiCall)ObjectUtils.tryCast((Object)this.myContext, PsiCall.class);
    }

    @NotNull
    public PsiElement getContext() {
        PsiElement psiElement = this.myContext;
        if (psiElement == null) {
            MethodCallInstruction.$$$reportNull$$$0(4);
        }
        return psiElement;
    }

    @Nullable
    public DfaValue getPrecalculatedReturnValue() {
        return this.myPrecalculatedReturnValue;
    }

    @NotNull
    public Nullability getReturnNullability() {
        Nullability nullability = this.myReturnNullability;
        if (nullability == null) {
            MethodCallInstruction.$$$reportNull$$$0(5);
        }
        return nullability;
    }

    public String toString() {
        if (this.myContext instanceof PsiCall) {
            return "CALL_METHOD: " + this.myContext.getText();
        }
        return "CALL_METHOD_REFERENCE: " + this.myContext.getText();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reference";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contracts";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "call";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/dataFlow/instructions/MethodCallInstruction";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/dataFlow/instructions/MethodCallInstruction";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getMutationSignature";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getContext";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getReturnNullability";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

