/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.dataFlow;

import com.intellij.codeInspection.dataFlow.DataFlowRunner;
import com.intellij.codeInspection.dataFlow.DfaInstructionState;
import com.intellij.codeInspection.dataFlow.DfaMemoryState;
import com.intellij.codeInspection.dataFlow.DfaMemoryStateImpl;
import com.intellij.codeInspection.dataFlow.DfaNullability;
import com.intellij.codeInspection.dataFlow.DistinctPairSet;
import com.intellij.codeInspection.dataFlow.EqClass;
import com.intellij.codeInspection.dataFlow.InstructionVisitor;
import com.intellij.codeInspection.dataFlow.TypeConstraint;
import com.intellij.codeInspection.dataFlow.instructions.AssignInstruction;
import com.intellij.codeInspection.dataFlow.instructions.ConditionalGotoInstruction;
import com.intellij.codeInspection.dataFlow.instructions.ExpressionPushingInstruction;
import com.intellij.codeInspection.dataFlow.instructions.Instruction;
import com.intellij.codeInspection.dataFlow.rangeSet.LongRangeSet;
import com.intellij.codeInspection.dataFlow.types.DfAntiConstantType;
import com.intellij.codeInspection.dataFlow.types.DfConstantType;
import com.intellij.codeInspection.dataFlow.types.DfLongType;
import com.intellij.codeInspection.dataFlow.types.DfType;
import com.intellij.codeInspection.dataFlow.types.DfTypes;
import com.intellij.codeInspection.dataFlow.value.DfaBinOpValue;
import com.intellij.codeInspection.dataFlow.value.DfaTypeValue;
import com.intellij.codeInspection.dataFlow.value.DfaValue;
import com.intellij.codeInspection.dataFlow.value.DfaValueFactory;
import com.intellij.codeInspection.dataFlow.value.DfaVariableValue;
import com.intellij.codeInspection.dataFlow.value.RelationType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.siyeh.ig.psiutils.ExpressionUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import one.util.streamex.EntryStream;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TrackingDfaMemoryState
extends DfaMemoryStateImpl {
    private MemoryStateChange myHistory;

    protected TrackingDfaMemoryState(DfaValueFactory factory) {
        super(factory);
        this.myHistory = null;
    }

    protected TrackingDfaMemoryState(TrackingDfaMemoryState toCopy) {
        super(toCopy);
        this.myHistory = toCopy.myHistory;
    }

    @Override
    @NotNull
    public TrackingDfaMemoryState createCopy() {
        return new TrackingDfaMemoryState(this);
    }

    @Override
    protected void afterMerge(DfaMemoryStateImpl other) {
        super.afterMerge(other);
        assert (other instanceof TrackingDfaMemoryState);
        this.myHistory = this.myHistory.merge(((TrackingDfaMemoryState)other).myHistory);
    }

    private Map<DfaVariableValue, Set<Relation>> getRelations() {
        HashMap<DfaVariableValue, Set<Relation>> result = new HashMap<DfaVariableValue, Set<Relation>>();
        this.forRecordedVariableTypes((var, type2) -> {
            if (type2 instanceof DfConstantType) {
                result.computeIfAbsent((DfaVariableValue)var, k -> new HashSet()).add(new Relation(RelationType.EQ, this.getFactory().fromDfType((DfType)type2)));
            }
            if (type2 instanceof DfAntiConstantType) {
                Set notValues = ((DfAntiConstantType)type2).getNotValues();
                PsiType varType = var.getType();
                if (!notValues.isEmpty() && varType != null) {
                    for (Object notValue : notValues) {
                        result.computeIfAbsent((DfaVariableValue)var, k -> new HashSet()).add(new Relation(RelationType.NE, this.getFactory().fromDfType(DfTypes.constant(notValue, varType))));
                    }
                }
            }
        });
        for (EqClass eqClass : this.getNonTrivialEqClasses()) {
            for (DfaVariableValue var2 : eqClass) {
                Set set = result.computeIfAbsent(var2, k -> new HashSet());
                for (DfaVariableValue eqVar : eqClass) {
                    if (eqVar == var2) continue;
                    set.add(new Relation(RelationType.EQ, eqVar));
                }
            }
        }
        for (DistinctPairSet.DistinctPair classPair : this.getDistinctClassPairs()) {
            EqClass first = classPair.getFirst();
            EqClass second = classPair.getSecond();
            RelationType plain = classPair.isOrdered() ? RelationType.LT : RelationType.NE;
            RelationType flipped = Objects.requireNonNull(plain.getFlipped());
            for (DfaVariableValue var1 : first) {
                for (DfaVariableValue var2 : second) {
                    result.computeIfAbsent(var1, k -> new HashSet()).add(new Relation(plain, var2));
                    result.computeIfAbsent(var2, k -> new HashSet()).add(new Relation(flipped, var1));
                }
            }
        }
        return result;
    }

    void recordChange(Instruction instruction, TrackingDfaMemoryState previous) {
        Map<DfaVariableValue, Change> result = this.getChangeMap(previous);
        DfaValue value2 = this.isEmptyStack() ? this.getFactory().getUnknown() : this.peek();
        this.myHistory = MemoryStateChange.create(this.myHistory, instruction, result, value2);
    }

    @NotNull
    private Map<DfaVariableValue, Change> getChangeMap(TrackingDfaMemoryState previous) {
        HashMap<DfaVariableValue, Change> changeMap = new HashMap<DfaVariableValue, Change>();
        HashSet<DfaVariableValue> varsToCheck = new HashSet<DfaVariableValue>();
        previous.forRecordedVariableTypes((value2, state) -> varsToCheck.add((DfaVariableValue)value2));
        this.forRecordedVariableTypes((value2, state) -> varsToCheck.add((DfaVariableValue)value2));
        for (DfaVariableValue value3 : varsToCheck) {
            DfType oldType;
            DfType newType = this.getDfType(value3);
            if (newType.equals(oldType = previous.getDfType(value3))) continue;
            changeMap.put(value3, new Change(Collections.emptySet(), Collections.emptySet(), oldType, newType));
        }
        Map<DfaVariableValue, Set<Relation>> oldRelations = previous.getRelations();
        Map<DfaVariableValue, Set<Relation>> newRelations = this.getRelations();
        varsToCheck.clear();
        varsToCheck.addAll(oldRelations.keySet());
        varsToCheck.addAll(newRelations.keySet());
        for (DfaVariableValue value4 : varsToCheck) {
            Set newValueRelations;
            Set oldValueRelations = oldRelations.getOrDefault(value4, Collections.emptySet());
            if (oldValueRelations.equals(newValueRelations = newRelations.getOrDefault(value4, Collections.emptySet()))) continue;
            HashSet added = new HashSet(newValueRelations);
            added.removeAll(oldValueRelations);
            HashSet removed = new HashSet(oldValueRelations);
            removed.removeAll(newValueRelations);
            changeMap.compute(value4, (v, change) -> change == null ? Change.create(removed, added, DfTypes.BOTTOM, DfTypes.BOTTOM) : Change.create(removed, added, change.myOldType, change.myNewType));
        }
        HashMap<DfaVariableValue, Change> hashMap = changeMap;
        if (hashMap == null) {
            TrackingDfaMemoryState.$$$reportNull$$$0(0);
        }
        return hashMap;
    }

    MemoryStateChange getHistory() {
        return this.myHistory;
    }

    void addBridge(Instruction instruction, List<TrackingDfaMemoryState> bridgeStates) {
        Map<DfaVariableValue, Change> changeMap = null;
        for (TrackingDfaMemoryState bridge : bridgeStates) {
            Map<DfaVariableValue, Change> newChangeMap = this.getChangeMap(bridge);
            if (changeMap == null) {
                changeMap = newChangeMap;
            } else {
                changeMap.keySet().retainAll(newChangeMap.keySet());
                changeMap.replaceAll((var, old) -> old.unite((Change)newChangeMap.get(var)));
                changeMap.values().removeIf(Objects::isNull);
            }
            if (!changeMap.isEmpty()) continue;
            break;
        }
        if (changeMap != null && !changeMap.isEmpty()) {
            this.myHistory = this.myHistory.withBridge(instruction, changeMap);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/dataFlow/TrackingDfaMemoryState", "getChangeMap"));
    }

    static interface FactExtractor<T> {
        @NotNull
        public T extract(DfType var1);

        public static FactExtractor<DfaNullability> nullability() {
            return DfaNullability::fromDfType;
        }

        public static FactExtractor<TypeConstraint> constraint() {
            return TypeConstraint::fromDfType;
        }

        public static FactExtractor<LongRangeSet> range() {
            return DfLongType::extractRange;
        }
    }

    static class FactDefinition<T> {
        @Nullable
        final MemoryStateChange myChange;
        @NotNull
        final T myFact;

        FactDefinition(@Nullable MemoryStateChange change, @NotNull T fact) {
            if (fact == null) {
                FactDefinition.$$$reportNull$$$0(0);
            }
            this.myChange = change;
            this.myFact = fact;
        }

        public String toString() {
            return this.myFact + " @ " + this.myChange;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fact", "com/intellij/codeInspection/dataFlow/TrackingDfaMemoryState$FactDefinition", "<init>"));
        }
    }

    private static class MergeInstruction
    extends Instruction {
        private MergeInstruction() {
        }

        @Override
        public DfaInstructionState[] accept(DataFlowRunner runner, DfaMemoryState stateBefore, InstructionVisitor visitor2) {
            return DfaInstructionState.EMPTY_ARRAY;
        }

        public String toString() {
            return "STATE_MERGE";
        }
    }

    static final class MemoryStateChange {
        @NotNull
        private final List<MemoryStateChange> myPrevious;
        @NotNull
        final Instruction myInstruction;
        @NotNull
        final Map<DfaVariableValue, Change> myChanges;
        @NotNull
        final DfaValue myTopOfStack;
        @NotNull
        final Map<DfaVariableValue, Change> myBridgeChanges;
        int myCursor;

        private MemoryStateChange(@NotNull List<MemoryStateChange> previous, @NotNull Instruction instruction, @NotNull Map<DfaVariableValue, Change> changes2, @NotNull DfaValue topOfStack, @NotNull Map<DfaVariableValue, Change> bridgeChanges) {
            if (previous == null) {
                MemoryStateChange.$$$reportNull$$$0(0);
            }
            if (instruction == null) {
                MemoryStateChange.$$$reportNull$$$0(1);
            }
            if (changes2 == null) {
                MemoryStateChange.$$$reportNull$$$0(2);
            }
            if (topOfStack == null) {
                MemoryStateChange.$$$reportNull$$$0(3);
            }
            if (bridgeChanges == null) {
                MemoryStateChange.$$$reportNull$$$0(4);
            }
            this.myCursor = 0;
            this.myPrevious = previous;
            this.myInstruction = instruction;
            this.myChanges = changes2;
            this.myTopOfStack = topOfStack;
            this.myBridgeChanges = bridgeChanges;
        }

        void reset() {
            for (MemoryStateChange change = this; change != null; change = change.getPrevious()) {
                change.myCursor = 0;
            }
        }

        boolean advance() {
            if (this.myCursor < this.myPrevious.size() && !this.myPrevious.get(this.myCursor).advance()) {
                ++this.myCursor;
                MemoryStateChange previous = this.getPrevious();
                if (previous != null) {
                    previous.reset();
                }
            }
            return this.myCursor < this.myPrevious.size();
        }

        @Contract(value="null -> null")
        @Nullable
        MemoryStateChange findExpressionPush(@Nullable PsiExpression expression2) {
            if (expression2 == null) {
                return null;
            }
            return this.findChange(change -> change.getExpression() == expression2, false);
        }

        @Contract(value="null -> null")
        @Nullable
        MemoryStateChange findSubExpressionPush(@Nullable PsiExpression expression2) {
            if (expression2 == null) {
                return null;
            }
            PsiElement topElement = ExpressionUtils.getPassThroughParent(expression2);
            return this.findChange(change -> {
                PsiExpression changeExpression = change.getExpression();
                if (changeExpression == null) {
                    return false;
                }
                return changeExpression == expression2 || PsiTreeUtil.isAncestor((PsiElement)expression2, (PsiElement)changeExpression, (boolean)true) && ExpressionUtils.getPassThroughParent(changeExpression) == topElement;
            }, false);
        }

        MemoryStateChange findRelation(DfaVariableValue value2, @NotNull Predicate<Relation> relationPredicate, boolean startFromSelf) {
            if (relationPredicate == null) {
                MemoryStateChange.$$$reportNull$$$0(5);
            }
            return this.findChange(change -> {
                if (change.myInstruction instanceof AssignInstruction && change.myTopOfStack == value2) {
                    return true;
                }
                Change varChange = change.myChanges.get(value2);
                if (varChange != null && varChange.myAddedRelations.stream().anyMatch(relationPredicate)) {
                    return true;
                }
                Change bridgeVarChange = change.myBridgeChanges.get(value2);
                return bridgeVarChange != null && bridgeVarChange.myAddedRelations.stream().anyMatch(relationPredicate);
            }, startFromSelf);
        }

        @NotNull
        <T> FactDefinition<T> findFact(DfaValue value2, FactExtractor<T> extractor) {
            if (value2 instanceof DfaVariableValue) {
                for (MemoryStateChange change = this; change != null; change = change.getPrevious()) {
                    FactDefinition<T> factPair = MemoryStateChange.factFromChange(extractor, change, change.myChanges.get(value2));
                    if (factPair != null) {
                        FactDefinition<T> factDefinition = factPair;
                        if (factDefinition == null) {
                            MemoryStateChange.$$$reportNull$$$0(6);
                        }
                        return factDefinition;
                    }
                    if (!(change.myInstruction instanceof ConditionalGotoInstruction) && (factPair = MemoryStateChange.factFromChange(extractor, change, change.myBridgeChanges.get(value2))) != null) {
                        FactDefinition<T> factDefinition = factPair;
                        if (factDefinition == null) {
                            MemoryStateChange.$$$reportNull$$$0(7);
                        }
                        return factDefinition;
                    }
                    if (!(change.myInstruction instanceof AssignInstruction) || change.myTopOfStack != value2 || change.getPrevious() == null) continue;
                    FactDefinition<T> fact = change.getPrevious().findFact(value2, extractor);
                    return new FactDefinition(change, fact.myFact);
                }
                return new FactDefinition<T>(null, extractor.extract(((DfaVariableValue)value2).getInherentType()));
            }
            if (value2 instanceof DfaBinOpValue) {
                FactDefinition<T> left = this.findFact(((DfaBinOpValue)value2).getLeft(), extractor);
                FactDefinition<T> right = this.findFact(((DfaBinOpValue)value2).getRight(), extractor);
                if (left.myFact instanceof LongRangeSet && right.myFact instanceof LongRangeSet) {
                    LongRangeSet result = ((LongRangeSet)left.myFact).binOpFromToken(((DfaBinOpValue)value2).getTokenType(), (LongRangeSet)right.myFact, PsiType.LONG.equals((Object)value2.getType()));
                    return new FactDefinition<LongRangeSet>(null, Objects.requireNonNull(result));
                }
            }
            return new FactDefinition<T>(null, extractor.extract(value2.getDfType()));
        }

        @Nullable
        MemoryStateChange getPrevious() {
            return this.myCursor == this.myPrevious.size() ? null : this.myPrevious.get(this.myCursor);
        }

        public MemoryStateChange getNonMerge() {
            MemoryStateChange change;
            MemoryStateChange memoryStateChange = change = this.myInstruction instanceof MergeInstruction ? this.getPrevious() : this;
            assert (change == null || !(change.myInstruction instanceof MergeInstruction));
            return change;
        }

        @Nullable
        private static <T> FactDefinition<T> factFromChange(FactExtractor<T> extractor, MemoryStateChange change, Change varChange) {
            T oldFact;
            T newFact;
            if (varChange != null && !(newFact = extractor.extract(varChange.myNewType)).equals(oldFact = extractor.extract(varChange.myOldType))) {
                return new FactDefinition<T>(change, newFact);
            }
            return null;
        }

        @Nullable
        private MemoryStateChange findChange(@NotNull Predicate<MemoryStateChange> predicate, boolean startFromSelf) {
            MemoryStateChange change;
            if (predicate == null) {
                MemoryStateChange.$$$reportNull$$$0(8);
            }
            MemoryStateChange memoryStateChange = change = startFromSelf ? this : this.getPrevious();
            while (change != null) {
                if (predicate.test(change)) {
                    return change;
                }
                change = change.getPrevious();
            }
            return null;
        }

        @Nullable
        PsiExpression getExpression() {
            if (this.myInstruction instanceof ExpressionPushingInstruction && ((ExpressionPushingInstruction)this.myInstruction).getExpressionRange() == null) {
                return ((ExpressionPushingInstruction)this.myInstruction).getExpression();
            }
            if (this.myInstruction instanceof ConditionalGotoInstruction) {
                return (PsiExpression)ObjectUtils.tryCast((Object)((ConditionalGotoInstruction)this.myInstruction).getPsiAnchor(), PsiExpression.class);
            }
            return null;
        }

        @NotNull
        public MemoryStateChange merge(MemoryStateChange change) {
            if (change == this) {
                MemoryStateChange memoryStateChange = this;
                if (memoryStateChange == null) {
                    MemoryStateChange.$$$reportNull$$$0(9);
                }
                return memoryStateChange;
            }
            LinkedHashSet<MemoryStateChange> previous = new LinkedHashSet<MemoryStateChange>();
            if (this.myInstruction instanceof MergeInstruction) {
                previous.addAll(this.myPrevious);
            } else {
                previous.add(this);
            }
            if (change.myInstruction instanceof MergeInstruction) {
                previous.addAll(change.myPrevious);
            } else {
                previous.add(change);
            }
            if (previous.size() == 1) {
                MemoryStateChange memoryStateChange = (MemoryStateChange)previous.iterator().next();
                if (memoryStateChange == null) {
                    MemoryStateChange.$$$reportNull$$$0(10);
                }
                return memoryStateChange;
            }
            return new MemoryStateChange(new ArrayList<MemoryStateChange>(previous), new MergeInstruction(), Collections.emptyMap(), this.myTopOfStack.getFactory().getUnknown(), Collections.emptyMap());
        }

        MemoryStateChange withBridge(@NotNull Instruction instruction, @NotNull Map<DfaVariableValue, Change> bridge) {
            if (instruction == null) {
                MemoryStateChange.$$$reportNull$$$0(11);
            }
            if (bridge == null) {
                MemoryStateChange.$$$reportNull$$$0(12);
            }
            if (this.myInstruction != instruction) {
                if (instruction instanceof ConditionalGotoInstruction && this.getExpression() == ((ConditionalGotoInstruction)instruction).getPsiAnchor()) {
                    instruction = this.myInstruction;
                } else {
                    return new MemoryStateChange(Collections.singletonList(this), instruction, Collections.emptyMap(), this.myTopOfStack.getFactory().getUnknown(), bridge);
                }
            }
            assert (this.myBridgeChanges.isEmpty());
            return new MemoryStateChange(this.myPrevious, instruction, this.myChanges, this.myTopOfStack, bridge);
        }

        @Nullable
        static MemoryStateChange create(@Nullable MemoryStateChange previous, @NotNull Instruction instruction, @NotNull Map<DfaVariableValue, Change> result, @NotNull DfaValue value2) {
            if (instruction == null) {
                MemoryStateChange.$$$reportNull$$$0(13);
            }
            if (result == null) {
                MemoryStateChange.$$$reportNull$$$0(14);
            }
            if (value2 == null) {
                MemoryStateChange.$$$reportNull$$$0(15);
            }
            if (result.isEmpty() && DfaTypeValue.isUnknown(value2)) {
                return previous;
            }
            return new MemoryStateChange(ContainerUtil.createMaybeSingletonList((Object)previous), instruction, result, value2, Collections.emptyMap());
        }

        MemoryStateChange[] flatten() {
            List changes2 = StreamEx.iterate((Object)this, Objects::nonNull, change -> change.getPrevious()).toList();
            Collections.reverse(changes2);
            return changes2.toArray(new MemoryStateChange[0]);
        }

        String dump() {
            return StreamEx.of((Object[])this.flatten()).joining((CharSequence)"\n");
        }

        public String toString() {
            return this.myInstruction.getIndex() + " " + this.myInstruction + ": " + this.myTopOfStack + (this.myChanges.isEmpty() ? "" : "; Changes: " + EntryStream.of(this.myChanges).join((CharSequence)": ", (CharSequence)"\n\t", (CharSequence)"").joining()) + (this.myBridgeChanges.isEmpty() ? "" : "; Bridge changes: " + EntryStream.of(this.myBridgeChanges).join((CharSequence)": ", (CharSequence)"\n\t", (CharSequence)"").joining());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 6: 
                case 7: 
                case 9: 
                case 10: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 6: 
                case 7: 
                case 9: 
                case 10: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "previous";
                    break;
                }
                case 1: 
                case 11: 
                case 13: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "instruction";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "changes";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "topOfStack";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "bridgeChanges";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "relationPredicate";
                    break;
                }
                case 6: 
                case 7: 
                case 9: 
                case 10: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInspection/dataFlow/TrackingDfaMemoryState$MemoryStateChange";
                    break;
                }
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "predicate";
                    break;
                }
                case 12: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "bridge";
                    break;
                }
                case 14: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "result";
                    break;
                }
                case 15: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "value";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInspection/dataFlow/TrackingDfaMemoryState$MemoryStateChange";
                    break;
                }
                case 6: 
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "findFact";
                    break;
                }
                case 9: 
                case 10: {
                    objectArray = objectArray2;
                    objectArray2[1] = "merge";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "findRelation";
                    break;
                }
                case 6: 
                case 7: 
                case 9: 
                case 10: {
                    break;
                }
                case 8: {
                    objectArray = objectArray;
                    objectArray[2] = "findChange";
                    break;
                }
                case 11: 
                case 12: {
                    objectArray = objectArray;
                    objectArray[2] = "withBridge";
                    break;
                }
                case 13: 
                case 14: 
                case 15: {
                    objectArray = objectArray;
                    objectArray[2] = "create";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 6: 
                case 7: 
                case 9: 
                case 10: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    static class Change {
        @NotNull
        final Set<Relation> myRemovedRelations;
        @NotNull
        final Set<Relation> myAddedRelations;
        @NotNull
        final DfType myOldType;
        @NotNull
        final DfType myNewType;

        private Change(@NotNull Set<Relation> removedRelations, @NotNull Set<Relation> addedRelations, @NotNull DfType oldType, @NotNull DfType newType) {
            if (removedRelations == null) {
                Change.$$$reportNull$$$0(0);
            }
            if (addedRelations == null) {
                Change.$$$reportNull$$$0(1);
            }
            if (oldType == null) {
                Change.$$$reportNull$$$0(2);
            }
            if (newType == null) {
                Change.$$$reportNull$$$0(3);
            }
            this.myRemovedRelations = removedRelations.isEmpty() ? Collections.emptySet() : removedRelations;
            this.myAddedRelations = addedRelations.isEmpty() ? Collections.emptySet() : addedRelations;
            this.myOldType = oldType;
            this.myNewType = newType;
        }

        @Nullable
        static Change create(Set<Relation> removedRelations, Set<Relation> addedRelations, DfType oldType, DfType newType) {
            if (removedRelations.isEmpty() && addedRelations.isEmpty() && oldType == DfTypes.BOTTOM && newType == DfTypes.BOTTOM) {
                return null;
            }
            return new Change(removedRelations, addedRelations, oldType, newType);
        }

        @Nullable
        Change unite(Change other) {
            DfType newType;
            HashSet<Relation> added = new HashSet<Relation>(ContainerUtil.intersection(this.myAddedRelations, other.myAddedRelations));
            HashSet<Relation> removed = new HashSet<Relation>(ContainerUtil.intersection(this.myRemovedRelations, other.myRemovedRelations));
            DfType oldType = this.myOldType.join(other.myOldType);
            if (oldType.equals(newType = this.myNewType.join(other.myNewType))) {
                oldType = newType = DfTypes.BOTTOM;
            }
            return Change.create(removed, added, oldType, newType);
        }

        public String toString() {
            String removed = StreamEx.of(this.myRemovedRelations).map(Object::toString).append((Object)this.myOldType.toString()).without((Object)"").joining((CharSequence)", ");
            String added = StreamEx.of(this.myAddedRelations).map(Object::toString).append((Object)this.myNewType.toString()).without((Object)"").joining((CharSequence)", ");
            return (removed.isEmpty() ? "" : "-{" + removed + "} ") + (added.isEmpty() ? "" : "+{" + added + "}");
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "removedRelations";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "addedRelations";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "oldType";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[0] = "newType";
                    break;
                }
            }
            objectArray[1] = "com/intellij/codeInspection/dataFlow/TrackingDfaMemoryState$Change";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    static class Relation {
        @NotNull
        final RelationType myRelationType;
        @NotNull
        final DfaValue myCounterpart;

        Relation(@NotNull RelationType type2, @NotNull DfaValue counterpart) {
            if (type2 == null) {
                Relation.$$$reportNull$$$0(0);
            }
            if (counterpart == null) {
                Relation.$$$reportNull$$$0(1);
            }
            this.myRelationType = type2;
            this.myCounterpart = counterpart;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Relation relation = (Relation)o;
            return this.myRelationType == relation.myRelationType && this.myCounterpart.equals(relation.myCounterpart);
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.myRelationType, this.myCounterpart});
        }

        public String toString() {
            return (Object)((Object)this.myRelationType) + " " + this.myCounterpart;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "type";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "counterpart";
                    break;
                }
            }
            objectArray[1] = "com/intellij/codeInspection/dataFlow/TrackingDfaMemoryState$Relation";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

