/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.dataFlow;

import com.intellij.codeInspection.dataFlow.DfaUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.ElementManipulators;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.PsiBinaryExpression;
import com.intellij.psi.PsiCall;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiConstantEvaluationHelper;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiPolyadicExpression;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.MethodReferencesSearch;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Processor;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StringExpressionHelper {
    @Nullable
    public static Pair<PsiElement, String> evaluateExpression(@NotNull PsiElement expression2) {
        if (expression2 == null) {
            StringExpressionHelper.$$$reportNull$$$0(0);
        }
        return StringExpressionHelper.evaluateExpression(expression2, new HashSet<PsiElement>());
    }

    @Nullable
    public static Pair<PsiElement, String> evaluateExpression(@NotNull PsiElement expression2, @NotNull Collection<PsiElement> visited) {
        Pair<PsiElement, String> expr2;
        PsiExpression initializer;
        PsiElement resolve2;
        if (expression2 == null) {
            StringExpressionHelper.$$$reportNull$$$0(1);
        }
        if (visited == null) {
            StringExpressionHelper.$$$reportNull$$$0(2);
        }
        if (!visited.add(expression2)) {
            return null;
        }
        if (expression2 instanceof PsiLiteralExpression) {
            return StringExpressionHelper.evaluatePsiLiteralExpression(expression2);
        }
        if (expression2 instanceof PsiReferenceExpression && (resolve2 = ((PsiReferenceExpression)expression2).resolve()) instanceof PsiVariable && (initializer = ((PsiVariable)resolve2).getInitializer()) != null && (expr2 = StringExpressionHelper.evaluateExpression((PsiElement)initializer, visited)) != null) {
            return expr2;
        }
        if (expression2 instanceof PsiMethodCallExpression) {
            PsiElement element = ((PsiMethodCallExpression)expression2).getMethodExpression().resolve();
            if (element instanceof PsiMethod) {
                PsiCodeBlock body2 = ((PsiMethod)element).getBody();
                if (body2 != null) {
                    final HashSet returns = new HashSet();
                    body2.accept((PsiElementVisitor)new JavaRecursiveElementWalkingVisitor(){

                        public void visitClass(PsiClass aClass) {
                        }

                        public void visitLambdaExpression(PsiLambdaExpression expression2) {
                        }

                        public void visitReturnStatement(PsiReturnStatement statement) {
                            PsiExpression returnValue = statement.getReturnValue();
                            if (returnValue != null) {
                                returns.add(returnValue);
                            }
                        }
                    });
                    for (PsiExpression psiExpression : returns) {
                        Pair<PsiElement, String> pair2 = StringExpressionHelper.evaluateExpression((PsiElement)psiExpression, visited);
                        if (pair2 == null) continue;
                        return pair2;
                    }
                }
                return StringExpressionHelper.evaluateExpression(element, visited);
            }
            return null;
        }
        Pair<PsiElement, String> constantExpression = StringExpressionHelper.evaluateConstantExpression(expression2);
        if (constantExpression != null) {
            return constantExpression;
        }
        if (expression2 instanceof PsiBinaryExpression) {
            PsiBinaryExpression binaryExpression = (PsiBinaryExpression)expression2;
            return StringExpressionHelper.evaluatePolyadicExpressions(expression2, visited, binaryExpression.getLOperand(), binaryExpression.getROperand());
        }
        if (expression2 instanceof PsiPolyadicExpression) {
            return StringExpressionHelper.evaluatePolyadicExpressions(expression2, visited, ((PsiPolyadicExpression)expression2).getOperands());
        }
        Collection<PsiExpression> elements = DfaUtil.getPossibleInitializationElements(expression2);
        for (PsiElement psiElement : elements) {
            Pair<PsiElement, String> expr3 = StringExpressionHelper.evaluateExpression(psiElement, visited);
            if (expr3 == null) continue;
            return expr3;
        }
        return null;
    }

    @Nullable
    private static Pair<PsiElement, String> evaluatePolyadicExpressions(@NotNull PsiElement expression2, @NotNull Collection<PsiElement> visited, PsiExpression ... operands2) {
        if (expression2 == null) {
            StringExpressionHelper.$$$reportNull$$$0(3);
        }
        if (visited == null) {
            StringExpressionHelper.$$$reportNull$$$0(4);
        }
        if (operands2 == null) {
            StringExpressionHelper.$$$reportNull$$$0(5);
        }
        StringBuilder sb = new StringBuilder();
        for (PsiExpression operand2 : operands2) {
            Pair<PsiElement, String> pair2 = StringExpressionHelper.evaluateExpression((PsiElement)operand2, visited);
            if (pair2 == null) {
                return null;
            }
            sb.append((String)pair2.second);
        }
        return Pair.create((Object)expression2, (Object)sb.toString());
    }

    @NotNull
    private static Pair<PsiElement, String> evaluatePsiLiteralExpression(@NotNull PsiElement expression2) {
        if (expression2 == null) {
            StringExpressionHelper.$$$reportNull$$$0(6);
        }
        Pair pair2 = Pair.create((Object)expression2, (Object)ElementManipulators.getValueText((PsiElement)expression2));
        if (pair2 == null) {
            StringExpressionHelper.$$$reportNull$$$0(7);
        }
        return pair2;
    }

    @Nullable
    public static Pair<PsiElement, String> evaluateConstantExpression(@NotNull PsiElement expression2) {
        PsiConstantEvaluationHelper helper;
        Object result;
        if (expression2 == null) {
            StringExpressionHelper.$$$reportNull$$$0(8);
        }
        if ((result = (helper = JavaPsiFacade.getInstance((Project)expression2.getProject()).getConstantEvaluationHelper()).computeConstantExpression(expression2)) instanceof String) {
            return Pair.create((Object)expression2, (Object)((String)result));
        }
        return null;
    }

    @NotNull
    public static Set<Pair<PsiElement, String>> searchStringExpressions(@NotNull PsiMethod psiMethod, @NotNull SearchScope searchScope, int expNum) {
        if (psiMethod == null) {
            StringExpressionHelper.$$$reportNull$$$0(9);
        }
        if (searchScope == null) {
            StringExpressionHelper.$$$reportNull$$$0(10);
        }
        HashSet<Pair<PsiElement, String>> pairs = new HashSet<Pair<PsiElement, String>>();
        for (PsiCall methodCallExpression : StringExpressionHelper.searchMethodCalls(psiMethod, searchScope)) {
            PsiExpression expression2;
            Pair<PsiElement, String> pair2;
            PsiExpression[] expressions2;
            PsiExpressionList argumentList = methodCallExpression.getArgumentList();
            if (argumentList == null || (expressions2 = argumentList.getExpressions()).length <= expNum || (pair2 = StringExpressionHelper.evaluateExpression((PsiElement)(expression2 = expressions2[expNum]))) == null) continue;
            pairs.add(pair2);
        }
        HashSet<Pair<PsiElement, String>> hashSet = pairs;
        if (hashSet == null) {
            StringExpressionHelper.$$$reportNull$$$0(11);
        }
        return hashSet;
    }

    @NotNull
    public static Set<PsiCall> searchMethodCalls(@NotNull PsiMethod psiMethod, @NotNull SearchScope searchScope) {
        if (psiMethod == null) {
            StringExpressionHelper.$$$reportNull$$$0(12);
        }
        if (searchScope == null) {
            StringExpressionHelper.$$$reportNull$$$0(13);
        }
        HashSet<PsiCall> callExpressions = new HashSet<PsiCall>();
        CommonProcessors.CollectUniquesProcessor consumer = new CommonProcessors.CollectUniquesProcessor();
        MethodReferencesSearch.search((PsiMethod)psiMethod, (SearchScope)searchScope, (boolean)true).forEach((Processor)consumer);
        for (PsiReference psiReference : consumer.getResults()) {
            PsiCall methodCallExpression = (PsiCall)PsiTreeUtil.getParentOfType((PsiElement)psiReference.getElement(), PsiCall.class);
            if (methodCallExpression == null) continue;
            callExpressions.add(methodCallExpression);
        }
        HashSet<PsiCall> hashSet = callExpressions;
        if (hashSet == null) {
            StringExpressionHelper.$$$reportNull$$$0(14);
        }
        return hashSet;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 7: 
            case 11: 
            case 14: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 7: 
            case 11: 
            case 14: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visited";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "operands";
                break;
            }
            case 7: 
            case 11: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/dataFlow/StringExpressionHelper";
                break;
            }
            case 9: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiMethod";
                break;
            }
            case 10: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "searchScope";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/dataFlow/StringExpressionHelper";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "evaluatePsiLiteralExpression";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "searchStringExpressions";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "searchMethodCalls";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "evaluateExpression";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "evaluatePolyadicExpressions";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "evaluatePsiLiteralExpression";
                break;
            }
            case 7: 
            case 11: 
            case 14: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "evaluateConstantExpression";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "searchStringExpressions";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "searchMethodCalls";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 7: 
            case 11: 
            case 14: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

