/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.dataFlow;

import com.intellij.codeInspection.dataFlow.DfaMemoryState;
import com.intellij.codeInspection.dataFlow.MutationSignature;
import com.intellij.codeInspection.dataFlow.value.DfaValue;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

final class DfaCallArguments {
    final DfaValue myQualifier;
    final DfaValue[] myArguments;
    @NotNull
    final MutationSignature myMutation;

    DfaCallArguments(DfaValue qualifier, DfaValue[] arguments, @NotNull MutationSignature mutation) {
        if (mutation == null) {
            DfaCallArguments.$$$reportNull$$$0(0);
        }
        this.myQualifier = qualifier;
        this.myArguments = arguments;
        this.myMutation = mutation;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DfaCallArguments)) {
            return false;
        }
        DfaCallArguments that = (DfaCallArguments)o;
        return this.myQualifier == that.myQualifier && this.myMutation.equals(that.myMutation) && Arrays.equals(this.myArguments, that.myArguments);
    }

    public int hashCode() {
        return (Objects.hashCode(this.myQualifier) * 31 + Arrays.hashCode(this.myArguments)) * 31 + this.myMutation.hashCode();
    }

    public void flush(DfaMemoryState state) {
        if (this.myMutation.isPure()) {
            return;
        }
        if (this.myMutation == MutationSignature.UNKNOWN || this.myArguments == null) {
            state.flushFields();
            return;
        }
        HashSet<DfaValue> qualifiers = new HashSet<DfaValue>();
        if (this.myQualifier != null && this.myMutation.mutatesThis()) {
            qualifiers.add(this.myQualifier);
        }
        for (int i = 0; i < this.myArguments.length; ++i) {
            if (!this.myMutation.mutatesArg(i)) continue;
            qualifiers.add(this.myArguments[i]);
        }
        state.flushFieldsQualifiedBy(qualifiers);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mutation", "com/intellij/codeInspection/dataFlow/DfaCallArguments", "<init>"));
    }
}

