/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.dataFlow;

import com.intellij.codeInspection.dataFlow.DfaCallState;
import com.intellij.codeInspection.dataFlow.DfaMemoryState;
import com.intellij.codeInspection.dataFlow.Mutability;
import com.intellij.codeInspection.dataFlow.types.DfType;
import com.intellij.codeInspection.dataFlow.types.DfTypes;
import com.intellij.codeInspection.dataFlow.value.DfaTypeValue;
import com.intellij.codeInspection.dataFlow.value.DfaValue;
import com.intellij.codeInspection.dataFlow.value.DfaValueFactory;
import com.intellij.codeInspection.dataFlow.value.DfaVariableValue;
import com.intellij.java.analysis.JavaAnalysisBundle;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiType;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ContractReturnValue {
    private static final int PARAMETER_ORDINAL_BASE = 10;
    private static final int MAX_SUPPORTED_PARAMETER = 100;
    private static final Validator NOT_CONSTRUCTOR = method -> method.isConstructor() ? JavaAnalysisBundle.message((String)"contract.return.validator.not.applicable.for.constructor", (Object[])new Object[0]) : null;
    private static final Validator NOT_STATIC = method -> method.hasModifierProperty("static") ? JavaAnalysisBundle.message((String)"contract.return.validator.not.applicable.static", (Object[])new Object[0]) : null;
    private static final Validator NOT_PRIMITIVE_RETURN = method -> {
        PsiType returnType = method.getReturnType();
        return returnType instanceof PsiPrimitiveType ? JavaAnalysisBundle.message((String)"contract.return.validator.not.applicable.primitive", (Object[])new Object[]{returnType.getPresentableText()}) : null;
    };
    private static final Validator BOOLEAN_RETURN = method -> PsiType.BOOLEAN.equals((Object)method.getReturnType()) ? null : JavaAnalysisBundle.message((String)"contract.return.validator.return.type.must.be.boolean", (Object[])new Object[0]);
    @NotNull
    private final String myName;
    private final int myOrdinal;
    private static final ContractReturnValue ANY_VALUE = new ContractReturnValue("_", 0){

        @Override
        Stream<Validator> validators() {
            return Stream.of(NOT_CONSTRUCTOR);
        }

        @Override
        public DfaValue getDfaValue(DfaValueFactory factory, DfaValue defaultValue, DfaCallState callState) {
            return defaultValue;
        }

        @Override
        public boolean isValueCompatible(DfaMemoryState state, DfaValue value2) {
            return true;
        }
    };
    private static final ContractReturnValue FAIL_VALUE = new ContractReturnValue("fail", 5){

        @Override
        Stream<Validator> validators() {
            return Stream.empty();
        }

        @Override
        public DfaValue getDfaValue(DfaValueFactory factory, DfaValue defaultValue, DfaCallState callState) {
            return factory.fromDfType(DfTypes.FAIL);
        }

        @Override
        public boolean isValueCompatible(DfaMemoryState state, DfaValue value2) {
            return false;
        }
    };
    private static final ContractReturnValue NULL_VALUE = new ContractReturnValue("null", 1){

        @Override
        Stream<Validator> validators() {
            return Stream.of(NOT_CONSTRUCTOR, NOT_PRIMITIVE_RETURN);
        }

        @Override
        public DfaValue getDfaValue(DfaValueFactory factory, DfaValue defaultValue, DfaCallState callState) {
            return factory.getNull();
        }

        @Override
        public boolean isValueCompatible(DfaMemoryState state, DfaValue value2) {
            return !state.isNotNull(value2);
        }
    };
    private static final ContractReturnValue NOT_NULL_VALUE = new ContractReturnValue("!null", 2){

        @Override
        Stream<Validator> validators() {
            return Stream.of(NOT_CONSTRUCTOR, NOT_PRIMITIVE_RETURN);
        }

        @Override
        public boolean isNotNull() {
            return true;
        }

        @Override
        public DfaValue getDfaValue(DfaValueFactory factory, DfaValue defaultValue, DfaCallState callState) {
            return 4.merge(defaultValue, factory.fromDfType(DfTypes.NOT_NULL_OBJECT), callState.myMemoryState);
        }

        @Override
        public boolean isValueCompatible(DfaMemoryState state, DfaValue value2) {
            return !state.isNull(value2);
        }
    };
    private static final ContractReturnValue NEW_VALUE = new ContractReturnValue("new", 6){

        @Override
        Stream<Validator> validators() {
            return Stream.of(NOT_CONSTRUCTOR, NOT_PRIMITIVE_RETURN);
        }

        @Override
        public DfaValue getDfaValue(DfaValueFactory factory, DfaValue defaultValue, DfaCallState callState) {
            DfType dfType = callState.myMemoryState.getDfType(defaultValue);
            dfType = dfType.meet(DfTypes.NOT_NULL_OBJECT);
            if (callState.myCallArguments.myMutation.isPure()) {
                boolean unmodifiableView;
                boolean bl = unmodifiableView = Mutability.fromDfType(dfType) == Mutability.UNMODIFIABLE_VIEW;
                if (!unmodifiableView) {
                    dfType = dfType.meet(DfTypes.LOCAL_OBJECT);
                }
            }
            return 5.merge(defaultValue, factory.fromDfType(dfType), callState.myMemoryState);
        }

        @Override
        public boolean isNotNull() {
            return true;
        }

        @Override
        public boolean isValueCompatible(DfaMemoryState state, DfaValue value2) {
            return !state.isNull(value2);
        }
    };
    private static final ContractReturnValue THIS_VALUE = new ContractReturnValue("this", 7){

        @Override
        Stream<Validator> validators() {
            return Stream.of(NOT_CONSTRUCTOR, NOT_STATIC, NOT_PRIMITIVE_RETURN, method -> {
                PsiClass aClass;
                PsiType returnType = method.getReturnType();
                if (returnType instanceof PsiClassType && (aClass = method.getContainingClass()) != null && JavaPsiFacade.getElementFactory((Project)method.getProject()).createType(aClass).isConvertibleFrom(returnType)) {
                    return null;
                }
                return JavaAnalysisBundle.message((String)"contract.return.validator.method.return.incompatible.with.method.containing.class", (Object[])new Object[0]);
            });
        }

        @Override
        public boolean isNotNull() {
            return true;
        }

        @Override
        public DfaValue getDfaValue(DfaValueFactory factory, DfaValue defaultValue, DfaCallState callState) {
            DfaValue qualifier = callState.myCallArguments.myQualifier;
            if (qualifier != null && !DfaTypeValue.isUnknown(qualifier)) {
                return 6.merge(defaultValue, qualifier, callState.myMemoryState);
            }
            return 6.merge(defaultValue, factory.fromDfType(DfTypes.NOT_NULL_OBJECT), callState.myMemoryState);
        }

        @Override
        public boolean isValueCompatible(DfaMemoryState state, DfaValue value2) {
            return !state.isNull(value2);
        }
    };

    private ContractReturnValue(@NotNull String name2, int ordinal) {
        if (name2 == null) {
            ContractReturnValue.$$$reportNull$$$0(0);
        }
        this.myName = name2;
        this.myOrdinal = ordinal;
    }

    public int hashCode() {
        return this.myOrdinal;
    }

    public String toString() {
        return this.myName;
    }

    public final String getMethodCompatibilityProblem(PsiMethod method) {
        return this.validators().map(fn -> (String)fn.apply(method)).filter(Objects::nonNull).findFirst().map((JavaAnalysisBundle.message((String)"contract.return.value.validation.prefix", (Object[])new Object[]{this}) + ' ')::concat).orElse(null);
    }

    public final boolean isMethodCompatible(PsiMethod method) {
        return this.validators().map(fn -> (String)fn.apply(method)).allMatch(Objects::isNull);
    }

    abstract Stream<Validator> validators();

    public ContractReturnValue intersect(ContractReturnValue other) {
        if (this.equals(other) || other == ANY_VALUE) {
            return this;
        }
        if (this == ANY_VALUE) {
            return other;
        }
        if (this.isNotNull() && other.isNotNull()) {
            return NOT_NULL_VALUE;
        }
        return FAIL_VALUE;
    }

    public boolean isSuperValueOf(ContractReturnValue value2) {
        return this == value2 || this == ANY_VALUE || this == NOT_NULL_VALUE && value2.isNotNull();
    }

    static DfaValue merge(DfaValue defaultValue, DfaValue newValue, DfaMemoryState memState) {
        DfType newType;
        if (defaultValue == null || DfaTypeValue.isUnknown(defaultValue)) {
            return newValue;
        }
        if (newValue == null || DfaTypeValue.isUnknown(newValue)) {
            return defaultValue;
        }
        DfType defaultType = memState.getDfType(defaultValue);
        DfType result = defaultType.meet(newType = memState.getDfType(newValue));
        if (result == DfTypes.BOTTOM) {
            return newValue;
        }
        if (newValue instanceof DfaVariableValue) {
            memState.meetDfType(newValue, result);
            return newValue;
        }
        if (defaultValue instanceof DfaVariableValue) {
            memState.meetDfType(defaultValue, result);
            return defaultValue;
        }
        return defaultValue.getFactory().fromDfType(result);
    }

    public abstract DfaValue getDfaValue(DfaValueFactory var1, DfaValue var2, DfaCallState var3);

    public abstract boolean isValueCompatible(DfaMemoryState var1, DfaValue var2);

    public int ordinal() {
        return this.myOrdinal;
    }

    public boolean isNotNull() {
        return false;
    }

    public boolean isNull() {
        return this == NULL_VALUE;
    }

    public boolean isFail() {
        return this == FAIL_VALUE;
    }

    public boolean isBoolean() {
        return this instanceof BooleanReturnValue;
    }

    @NotNull
    public static ContractReturnValue valueOf(int ordinal) {
        switch (ordinal) {
            case 0: 
            case 1: {
                ContractReturnValue contractReturnValue = ContractReturnValue.returnNull();
                if (contractReturnValue == null) {
                    ContractReturnValue.$$$reportNull$$$0(1);
                }
                return contractReturnValue;
            }
            case 2: {
                ContractReturnValue contractReturnValue = ContractReturnValue.returnNotNull();
                if (contractReturnValue == null) {
                    ContractReturnValue.$$$reportNull$$$0(2);
                }
                return contractReturnValue;
            }
            case 3: {
                BooleanReturnValue booleanReturnValue = ContractReturnValue.returnTrue();
                if (booleanReturnValue == null) {
                    ContractReturnValue.$$$reportNull$$$0(3);
                }
                return booleanReturnValue;
            }
            case 4: {
                BooleanReturnValue booleanReturnValue = ContractReturnValue.returnFalse();
                if (booleanReturnValue == null) {
                    ContractReturnValue.$$$reportNull$$$0(4);
                }
                return booleanReturnValue;
            }
            case 5: {
                ContractReturnValue contractReturnValue = ContractReturnValue.fail();
                if (contractReturnValue == null) {
                    ContractReturnValue.$$$reportNull$$$0(5);
                }
                return contractReturnValue;
            }
            case 6: {
                ContractReturnValue contractReturnValue = ContractReturnValue.returnNew();
                if (contractReturnValue == null) {
                    ContractReturnValue.$$$reportNull$$$0(6);
                }
                return contractReturnValue;
            }
            case 7: {
                ContractReturnValue contractReturnValue = ContractReturnValue.returnThis();
                if (contractReturnValue == null) {
                    ContractReturnValue.$$$reportNull$$$0(7);
                }
                return contractReturnValue;
            }
        }
        if (ordinal >= 10 && ordinal <= 110) {
            ContractReturnValue contractReturnValue = ContractReturnValue.returnParameter(ordinal - 10);
            if (contractReturnValue == null) {
                ContractReturnValue.$$$reportNull$$$0(8);
            }
            return contractReturnValue;
        }
        ContractReturnValue contractReturnValue = ContractReturnValue.returnAny();
        if (contractReturnValue == null) {
            ContractReturnValue.$$$reportNull$$$0(9);
        }
        return contractReturnValue;
    }

    @Nullable
    public static ContractReturnValue valueOf(@NotNull String value2) {
        if (value2 == null) {
            ContractReturnValue.$$$reportNull$$$0(10);
        }
        switch (value2) {
            case "_": {
                return ContractReturnValue.returnAny();
            }
            case "fail": {
                return ContractReturnValue.fail();
            }
            case "true": {
                return ContractReturnValue.returnTrue();
            }
            case "false": {
                return ContractReturnValue.returnFalse();
            }
            case "null": {
                return ContractReturnValue.returnNull();
            }
            case "!null": {
                return ContractReturnValue.returnNotNull();
            }
            case "new": {
                return ContractReturnValue.returnNew();
            }
            case "this": {
                return ContractReturnValue.returnThis();
            }
        }
        if (value2.startsWith("param")) {
            String suffix = value2.substring("param".length());
            try {
                int paramNumber = Integer.parseInt(suffix) - 1;
                if (paramNumber >= 0 && paramNumber <= 100) {
                    return new ParameterReturnValue(paramNumber);
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return null;
    }

    public static ContractReturnValue returnAny() {
        return ANY_VALUE;
    }

    public static ContractReturnValue fail() {
        return FAIL_VALUE;
    }

    public static BooleanReturnValue returnBoolean(boolean value2) {
        return value2 ? ContractReturnValue.returnTrue() : ContractReturnValue.returnFalse();
    }

    public static BooleanReturnValue returnTrue() {
        return BooleanReturnValue.TRUE_VALUE;
    }

    public static BooleanReturnValue returnFalse() {
        return BooleanReturnValue.FALSE_VALUE;
    }

    public static ContractReturnValue returnNull() {
        return NULL_VALUE;
    }

    public static ContractReturnValue returnNotNull() {
        return NOT_NULL_VALUE;
    }

    public static ContractReturnValue returnNew() {
        return NEW_VALUE;
    }

    public static ContractReturnValue returnThis() {
        return THIS_VALUE;
    }

    public static ContractReturnValue returnParameter(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("Negative parameter: " + n);
        }
        if (n > 100) {
            return ANY_VALUE;
        }
        return new ParameterReturnValue(n);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/dataFlow/ContractReturnValue";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/dataFlow/ContractReturnValue";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "valueOf";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "valueOf";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static final class ParameterReturnValue
    extends ContractReturnValue {
        private final int myParamNumber;

        public ParameterReturnValue(int n) {
            super("param" + (n + 1), n + 10);
            this.myParamNumber = n;
        }

        public int getParameterNumber() {
            return this.myParamNumber;
        }

        @Override
        Stream<Validator> validators() {
            return Stream.of(NOT_CONSTRUCTOR, method -> {
                PsiParameter[] parameters2 = method.getParameterList().getParameters();
                if (parameters2.length <= this.myParamNumber) {
                    return JavaAnalysisBundle.message((String)"contract.return.validator.too.few.parameters", (Object[])new Object[]{parameters2.length});
                }
                PsiType parameterType = parameters2[this.myParamNumber].getType();
                PsiType returnType = method.getReturnType();
                if (returnType != null && !returnType.isConvertibleFrom(parameterType)) {
                    return JavaAnalysisBundle.message((String)"contract.return.validator.incompatible.return.parameter.type", (Object[])new Object[]{returnType.getPresentableText(), parameterType.getPresentableText()});
                }
                return null;
            });
        }

        public boolean equals(Object obj) {
            return this == obj || obj instanceof ParameterReturnValue && ((ParameterReturnValue)obj).myParamNumber == this.myParamNumber;
        }

        @Override
        public DfaValue getDfaValue(DfaValueFactory factory, DfaValue defaultValue, DfaCallState callState) {
            if (callState.myCallArguments.myArguments != null && callState.myCallArguments.myArguments.length > this.myParamNumber) {
                DfaValue argument = callState.myCallArguments.myArguments[this.myParamNumber];
                return ParameterReturnValue.merge(defaultValue, argument, callState.myMemoryState);
            }
            return defaultValue;
        }

        @Override
        public boolean isValueCompatible(DfaMemoryState state, DfaValue value2) {
            return true;
        }
    }

    public static final class BooleanReturnValue
    extends ContractReturnValue {
        static final BooleanReturnValue TRUE_VALUE = new BooleanReturnValue(true, 3);
        static final BooleanReturnValue FALSE_VALUE = new BooleanReturnValue(false, 4);
        private final boolean myValue;

        private BooleanReturnValue(boolean value2, int ordinal) {
            super(String.valueOf(value2), ordinal);
            this.myValue = value2;
        }

        public boolean getValue() {
            return this.myValue;
        }

        public BooleanReturnValue negate() {
            return this.myValue ? FALSE_VALUE : TRUE_VALUE;
        }

        @Override
        Stream<Validator> validators() {
            return Stream.of(NOT_CONSTRUCTOR, BOOLEAN_RETURN);
        }

        @Override
        public DfaValue getDfaValue(DfaValueFactory factory, DfaValue defaultValue, DfaCallState callState) {
            return factory.getBoolean(this.myValue);
        }

        @Override
        public boolean isValueCompatible(DfaMemoryState state, DfaValue value2) {
            DfType type2 = state.getUnboxedDfType(value2);
            return type2.isSuperType(DfTypes.booleanValue(this.myValue));
        }
    }

    private static interface Validator
    extends Function<PsiMethod, String> {
    }
}

