/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.bytecodeAnalysis.asm;

import com.intellij.codeInspection.bytecodeAnalysis.asm.ASMUtils;
import com.intellij.codeInspection.bytecodeAnalysis.asm.Subroutine;
import com.intellij.codeInspection.bytecodeAnalysis.asm.SubroutineFinder;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.org.objectweb.asm.tree.AbstractInsnNode;
import org.jetbrains.org.objectweb.asm.tree.IincInsnNode;
import org.jetbrains.org.objectweb.asm.tree.JumpInsnNode;
import org.jetbrains.org.objectweb.asm.tree.LabelNode;
import org.jetbrains.org.objectweb.asm.tree.LookupSwitchInsnNode;
import org.jetbrains.org.objectweb.asm.tree.MethodNode;
import org.jetbrains.org.objectweb.asm.tree.TableSwitchInsnNode;
import org.jetbrains.org.objectweb.asm.tree.TryCatchBlockNode;
import org.jetbrains.org.objectweb.asm.tree.VarInsnNode;
import org.jetbrains.org.objectweb.asm.tree.analysis.AnalyzerException;

public class FramelessAnalyzer
extends SubroutineFinder {
    private static final Set<String> NPE_HANDLERS = ContainerUtil.set((Object[])new String[]{"java/lang/Throwable", "java/lang/Exception", "java/lang/RuntimeException", "java/lang/NullPointerException"});
    protected boolean[] wasQueued;
    protected boolean[] queued;
    protected int[] queue;
    protected int top;
    protected final EdgeCreator myEdgeCreator;

    public FramelessAnalyzer(EdgeCreator creator) {
        this.myEdgeCreator = creator;
    }

    public void analyze(MethodNode m) throws AnalyzerException {
        this.n = m.instructions.size();
        if ((m.access & 0x500) != 0 || this.n == 0) {
            return;
        }
        this.insns = m.instructions;
        this.handlers = ASMUtils.newListArray(this.n);
        this.subroutines = new Subroutine[this.n];
        this.queued = new boolean[this.n];
        this.wasQueued = new boolean[this.n];
        this.queue = new int[this.n];
        this.top = 0;
        for (TryCatchBlockNode tcb : m.tryCatchBlocks) {
            int begin = this.insns.indexOf((AbstractInsnNode)tcb.start);
            int end = this.insns.indexOf((AbstractInsnNode)tcb.end);
            for (int j = begin; j < end; ++j) {
                ArrayList<TryCatchBlockNode> insnHandlers = this.handlers[j];
                if (insnHandlers == null) {
                    this.handlers[j] = insnHandlers = new ArrayList<TryCatchBlockNode>();
                }
                insnHandlers.add(tcb);
            }
        }
        Subroutine main = new Subroutine(null, m.maxLocals, null);
        ArrayList<AbstractInsnNode> subroutineCalls = new ArrayList<AbstractInsnNode>();
        HashMap<LabelNode, Subroutine> subroutineHeads = new HashMap<LabelNode, Subroutine>();
        this.findSubroutine(0, main, subroutineCalls);
        while (!subroutineCalls.isEmpty()) {
            JumpInsnNode jsr = (JumpInsnNode)subroutineCalls.remove(0);
            Subroutine sub = (Subroutine)subroutineHeads.get(jsr.label);
            if (sub == null) {
                sub = new Subroutine(jsr.label, m.maxLocals, jsr);
                subroutineHeads.put(jsr.label, sub);
                this.findSubroutine(this.insns.indexOf((AbstractInsnNode)jsr.label), sub, subroutineCalls);
                continue;
            }
            sub.callers.add(jsr);
        }
        for (int i = 0; i < this.n; ++i) {
            if (this.subroutines[i] == null || this.subroutines[i].start != null) continue;
            this.subroutines[i] = null;
        }
        this.merge(0, null);
        while (this.top > 0) {
            int insn = this.queue[--this.top];
            Subroutine subroutine = this.subroutines[insn];
            this.queued[insn] = false;
            AbstractInsnNode insnNode = null;
            try {
                List insnHandlers;
                insnNode = m.instructions.get(insn);
                int insnOpcode = insnNode.getOpcode();
                int insnType = insnNode.getType();
                if (insnType == 8 || insnType == 15 || insnType == 14) {
                    this.merge(insn + 1, subroutine);
                    this.myEdgeCreator.newControlFlowEdge(insn, insn + 1);
                } else {
                    LabelNode label;
                    int j;
                    Subroutine subroutine2 = subroutine = subroutine == null ? null : subroutine.copy();
                    if (insnNode instanceof JumpInsnNode) {
                        JumpInsnNode j2 = (JumpInsnNode)insnNode;
                        if (insnOpcode != 167 && insnOpcode != 168) {
                            this.merge(insn + 1, subroutine);
                            this.myEdgeCreator.newControlFlowEdge(insn, insn + 1);
                        }
                        int jump = this.insns.indexOf((AbstractInsnNode)j2.label);
                        if (insnOpcode == 168) {
                            this.merge(jump, new Subroutine(j2.label, m.maxLocals, j2));
                        } else {
                            this.merge(jump, subroutine);
                        }
                        this.myEdgeCreator.newControlFlowEdge(insn, jump);
                    } else if (insnNode instanceof LookupSwitchInsnNode) {
                        LookupSwitchInsnNode lsi = (LookupSwitchInsnNode)insnNode;
                        int jump = this.insns.indexOf((AbstractInsnNode)lsi.dflt);
                        this.merge(jump, subroutine);
                        this.myEdgeCreator.newControlFlowEdge(insn, jump);
                        for (j = 0; j < lsi.labels.size(); ++j) {
                            label = (LabelNode)lsi.labels.get(j);
                            jump = this.insns.indexOf((AbstractInsnNode)label);
                            this.merge(jump, subroutine);
                            this.myEdgeCreator.newControlFlowEdge(insn, jump);
                        }
                    } else if (insnNode instanceof TableSwitchInsnNode) {
                        TableSwitchInsnNode tsi = (TableSwitchInsnNode)insnNode;
                        int jump = this.insns.indexOf((AbstractInsnNode)tsi.dflt);
                        this.merge(jump, subroutine);
                        this.myEdgeCreator.newControlFlowEdge(insn, jump);
                        for (j = 0; j < tsi.labels.size(); ++j) {
                            label = (LabelNode)tsi.labels.get(j);
                            jump = this.insns.indexOf((AbstractInsnNode)label);
                            this.merge(jump, subroutine);
                            this.myEdgeCreator.newControlFlowEdge(insn, jump);
                        }
                    } else if (insnOpcode == 169) {
                        if (subroutine == null) {
                            throw new AnalyzerException(insnNode, "RET instruction outside of a sub routine");
                        }
                        for (int i = 0; i < subroutine.callers.size(); ++i) {
                            JumpInsnNode caller = subroutine.callers.get(i);
                            int call = this.insns.indexOf((AbstractInsnNode)caller);
                            if (!this.wasQueued[call]) continue;
                            this.merge(call + 1, this.subroutines[call], subroutine.access);
                            this.myEdgeCreator.newControlFlowEdge(insn, call + 1);
                        }
                    } else if (insnOpcode != 191 && (insnOpcode < 172 || insnOpcode > 177)) {
                        if (subroutine != null) {
                            if (insnNode instanceof VarInsnNode) {
                                int var = ((VarInsnNode)insnNode).var;
                                subroutine.access[var] = true;
                                if (insnOpcode == 22 || insnOpcode == 24 || insnOpcode == 55 || insnOpcode == 57) {
                                    subroutine.access[var + 1] = true;
                                }
                            } else if (insnNode instanceof IincInsnNode) {
                                int var = ((IincInsnNode)insnNode).var;
                                subroutine.access[var] = true;
                            }
                        }
                        this.merge(insn + 1, subroutine);
                        this.myEdgeCreator.newControlFlowEdge(insn, insn + 1);
                    }
                }
                if ((insnHandlers = this.handlers[insn]) == null) continue;
                for (TryCatchBlockNode tcb : insnHandlers) {
                    this.myEdgeCreator.newControlFlowExceptionEdge(insn, this.insns.indexOf((AbstractInsnNode)tcb.handler), NPE_HANDLERS.contains(tcb.type));
                    this.merge(this.insns.indexOf((AbstractInsnNode)tcb.handler), subroutine);
                }
            }
            catch (AnalyzerException e) {
                throw new AnalyzerException(e.node, "Error at instruction " + insn + ": " + e.getMessage(), (Throwable)e);
            }
            catch (Exception e) {
                throw new AnalyzerException(insnNode, "Error at instruction " + insn + ": " + e.getMessage(), (Throwable)e);
            }
        }
    }

    protected void merge(int insn, @Nullable Subroutine subroutine) {
        Subroutine oldSubroutine = this.subroutines[insn];
        boolean changes2 = false;
        if (!this.wasQueued[insn]) {
            this.wasQueued[insn] = true;
            changes2 = true;
        }
        if (oldSubroutine == null) {
            if (subroutine != null) {
                this.subroutines[insn] = subroutine.copy();
                changes2 = true;
            }
        } else if (subroutine != null) {
            changes2 |= oldSubroutine.merge(subroutine);
        }
        if (changes2 && !this.queued[insn]) {
            this.queued[insn] = true;
            this.queue[this.top++] = insn;
        }
    }

    protected void merge(int insn, Subroutine subroutineBeforeJSR, boolean[] access) {
        Subroutine oldSubroutine = this.subroutines[insn];
        boolean changes2 = false;
        if (!this.wasQueued[insn]) {
            this.wasQueued[insn] = true;
            changes2 = true;
        }
        if (oldSubroutine != null && subroutineBeforeJSR != null) {
            changes2 |= oldSubroutine.merge(subroutineBeforeJSR);
        }
        if (changes2 && !this.queued[insn]) {
            this.queued[insn] = true;
            this.queue[this.top++] = insn;
        }
    }

    static interface EdgeCreator {
        public void newControlFlowEdge(int var1, int var2);

        public void newControlFlowExceptionEdge(int var1, int var2, boolean var3);
    }
}

