/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.bytecodeAnalysis;

import com.intellij.codeInspection.bytecodeAnalysis.DataValue;
import com.intellij.codeInspection.bytecodeAnalysis.Direction;
import com.intellij.codeInspection.bytecodeAnalysis.EKey;
import com.intellij.codeInspection.bytecodeAnalysis.EffectQuantum;
import com.intellij.codeInspection.bytecodeAnalysis.HardCodedPurity;
import com.intellij.codeInspection.bytecodeAnalysis.LambdaIndy;
import com.intellij.codeInspection.bytecodeAnalysis.Member;
import com.intellij.codeInspection.bytecodeAnalysis.asm.ASMUtils;
import com.intellij.util.ArrayUtil;
import java.util.List;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.org.objectweb.asm.Type;
import org.jetbrains.org.objectweb.asm.tree.AbstractInsnNode;
import org.jetbrains.org.objectweb.asm.tree.FieldInsnNode;
import org.jetbrains.org.objectweb.asm.tree.InvokeDynamicInsnNode;
import org.jetbrains.org.objectweb.asm.tree.LdcInsnNode;
import org.jetbrains.org.objectweb.asm.tree.MethodInsnNode;
import org.jetbrains.org.objectweb.asm.tree.MethodNode;
import org.jetbrains.org.objectweb.asm.tree.analysis.Interpreter;

class DataInterpreter
extends Interpreter<DataValue> {
    private final MethodNode methodNode;
    private int param = -1;
    final EffectQuantum[] effects;
    DataValue returnValue = null;

    protected DataInterpreter(MethodNode methodNode) {
        super(524288);
        this.methodNode = methodNode;
        this.effects = new EffectQuantum[methodNode.instructions.size()];
    }

    public DataValue newParameterValue(boolean isInstanceMethod, int local, Type type2) {
        int n;
        ++this.param;
        if (ASMUtils.isThisType(type2)) {
            return DataValue.ThisDataValue;
        }
        int n2 = n = isInstanceMethod ? this.param - 1 : this.param;
        if (n >= 0 && ASMUtils.isReferenceType(type2)) {
            return DataValue.ParameterDataValue.create(n);
        }
        return this.newValue(type2);
    }

    public DataValue newValue(Type type2) {
        if (type2 == null) {
            return DataValue.UnknownDataValue1;
        }
        if (type2 == Type.VOID_TYPE) {
            return null;
        }
        if (ASMUtils.isThisType(type2)) {
            return DataValue.ThisDataValue;
        }
        return type2.getSize() == 1 ? DataValue.UnknownDataValue1 : DataValue.UnknownDataValue2;
    }

    public DataValue newOperation(AbstractInsnNode insn) {
        switch (insn.getOpcode()) {
            case 187: {
                return DataValue.LocalDataValue;
            }
            case 9: 
            case 10: 
            case 14: 
            case 15: {
                return DataValue.UnknownDataValue2;
            }
            case 18: {
                Object cst = ((LdcInsnNode)insn).cst;
                int size = cst instanceof Long || cst instanceof Double ? 2 : 1;
                return size == 1 ? DataValue.UnknownDataValue1 : DataValue.UnknownDataValue2;
            }
            case 178: {
                FieldInsnNode fieldInsn = (FieldInsnNode)insn;
                Member method = new Member(fieldInsn.owner, fieldInsn.name, fieldInsn.desc);
                EKey key2 = new EKey(method, Direction.Volatile, true);
                this.effects[this.methodNode.instructions.indexOf((AbstractInsnNode)insn)] = new EffectQuantum.FieldReadQuantum(key2);
                int size = Type.getType((String)((FieldInsnNode)insn).desc).getSize();
                return size == 1 ? DataValue.UnknownDataValue1 : DataValue.UnknownDataValue2;
            }
        }
        return DataValue.UnknownDataValue1;
    }

    public DataValue binaryOperation(AbstractInsnNode insn, DataValue value1, DataValue value2) {
        switch (insn.getOpcode()) {
            case 47: 
            case 49: 
            case 97: 
            case 99: 
            case 101: 
            case 103: 
            case 105: 
            case 107: 
            case 109: 
            case 111: 
            case 113: 
            case 121: 
            case 123: 
            case 125: 
            case 127: 
            case 129: 
            case 131: {
                return DataValue.UnknownDataValue2;
            }
            case 181: {
                EffectQuantum effectQuantum = DataInterpreter.getChangeQuantum(value1);
                int insnIndex = this.methodNode.instructions.indexOf(insn);
                this.effects[insnIndex] = effectQuantum;
                return DataValue.UnknownDataValue1;
            }
        }
        return DataValue.UnknownDataValue1;
    }

    @Nullable
    private static EffectQuantum getChangeQuantum(DataValue value2) {
        if (value2 == DataValue.ThisDataValue || value2 == DataValue.OwnedDataValue) {
            return EffectQuantum.ThisChangeQuantum;
        }
        if (value2 == DataValue.LocalDataValue) {
            return null;
        }
        if (value2 instanceof DataValue.ParameterDataValue) {
            return new EffectQuantum.ParamChangeQuantum(((DataValue.ParameterDataValue)value2).n);
        }
        if (value2 instanceof DataValue.ReturnDataValue) {
            return new EffectQuantum.ReturnChangeQuantum(((DataValue.ReturnDataValue)value2).key);
        }
        return EffectQuantum.TopEffectQuantum;
    }

    public DataValue copyOperation(AbstractInsnNode insn, DataValue value2) {
        return value2;
    }

    public DataValue naryOperation(AbstractInsnNode insn, List<? extends DataValue> values) {
        int insnIndex = this.methodNode.instructions.indexOf(insn);
        int opCode = insn.getOpcode();
        switch (opCode) {
            case 197: {
                return DataValue.LocalDataValue;
            }
            case 186: {
                InvokeDynamicInsnNode indy = (InvokeDynamicInsnNode)insn;
                if (LambdaIndy.from(indy) == null && !"java/lang/invoke/StringConcatFactory".equals(indy.bsm.getOwner())) {
                    this.effects[insnIndex] = EffectQuantum.TopEffectQuantum;
                }
                return ASMUtils.getReturnSizeFast(indy.desc) == 1 ? DataValue.UnknownDataValue1 : DataValue.UnknownDataValue2;
            }
            case 182: 
            case 183: 
            case 184: 
            case 185: {
                boolean stable = opCode == 183 || opCode == 184;
                MethodInsnNode mNode = (MethodInsnNode)insn;
                Object[] data = values.toArray(DataValue.EMPTY);
                Member method = new Member(mNode.owner, mNode.name, mNode.desc);
                EKey key2 = new EKey(method, Direction.Pure, stable);
                EffectQuantum quantum = new EffectQuantum.CallQuantum(key2, (DataValue[])data, opCode == 184);
                DataValue result = ASMUtils.getReturnSizeFast(mNode.desc) == 1 ? (ASMUtils.isReferenceReturnType(mNode.desc) ? new DataValue.ReturnDataValue(key2) : DataValue.UnknownDataValue1) : DataValue.UnknownDataValue2;
                if (HardCodedPurity.getInstance().isPureMethod(method)) {
                    quantum = null;
                    result = HardCodedPurity.getInstance().getReturnValueForPureMethod(method);
                } else if (HardCodedPurity.getInstance().isThisChangingMethod(method)) {
                    DataValue receiver2 = (DataValue)ArrayUtil.getFirstElement((Object[])data);
                    if (receiver2 == DataValue.ThisDataValue) {
                        quantum = EffectQuantum.ThisChangeQuantum;
                    } else if (receiver2 == DataValue.LocalDataValue || receiver2 == DataValue.OwnedDataValue) {
                        quantum = null;
                    } else if (receiver2 instanceof DataValue.ParameterDataValue) {
                        quantum = new EffectQuantum.ParamChangeQuantum(((DataValue.ParameterDataValue)receiver2).n);
                    }
                    if (HardCodedPurity.getInstance().isBuilderChainCall(method)) {
                        result = receiver2;
                    }
                }
                this.effects[insnIndex] = quantum;
                return result;
            }
        }
        return null;
    }

    public DataValue unaryOperation(AbstractInsnNode insn, DataValue value2) {
        switch (insn.getOpcode()) {
            case 117: 
            case 119: 
            case 133: 
            case 135: 
            case 138: 
            case 140: 
            case 141: 
            case 143: {
                return DataValue.UnknownDataValue2;
            }
            case 180: {
                FieldInsnNode fieldInsn = (FieldInsnNode)insn;
                Member method = new Member(fieldInsn.owner, fieldInsn.name, fieldInsn.desc);
                EKey key2 = new EKey(method, Direction.Volatile, true);
                this.effects[this.methodNode.instructions.indexOf((AbstractInsnNode)insn)] = new EffectQuantum.FieldReadQuantum(key2);
                if (value2 == DataValue.ThisDataValue && HardCodedPurity.getInstance().isOwnedField(fieldInsn)) {
                    return DataValue.OwnedDataValue;
                }
                return ASMUtils.getSizeFast(fieldInsn.desc) == 1 ? DataValue.UnknownDataValue1 : DataValue.UnknownDataValue2;
            }
            case 192: {
                return value2;
            }
            case 179: {
                int insnIndex = this.methodNode.instructions.indexOf(insn);
                this.effects[insnIndex] = EffectQuantum.TopEffectQuantum;
                return DataValue.UnknownDataValue1;
            }
            case 188: 
            case 189: {
                return DataValue.LocalDataValue;
            }
        }
        return DataValue.UnknownDataValue1;
    }

    public DataValue ternaryOperation(AbstractInsnNode insn, DataValue value1, DataValue value2, DataValue value3) {
        int insnIndex = this.methodNode.instructions.indexOf(insn);
        this.effects[insnIndex] = DataInterpreter.getChangeQuantum(value1);
        return DataValue.UnknownDataValue1;
    }

    public void returnOperation(AbstractInsnNode insn, DataValue value2, DataValue expected) {
        if (insn.getOpcode() == 176) {
            if (this.returnValue == null) {
                this.returnValue = value2;
            } else if (!this.returnValue.equals(value2)) {
                this.returnValue = DataValue.UnknownDataValue1;
            }
        }
    }

    public DataValue merge(DataValue v1, DataValue v2) {
        if (v1.equals(v2)) {
            return v1;
        }
        int size = Math.min(v1.getSize(), v2.getSize());
        return size == 1 ? DataValue.UnknownDataValue1 : DataValue.UnknownDataValue2;
    }
}

