/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInsight.ExternalAnnotationsManager;
import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInspection.AnnotateMethodFix;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.nullable.AnnotateOverriddenMethodParameterFix;
import com.intellij.java.analysis.JavaAnalysisBundle;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RemoveAnnotationQuickFix
implements LocalQuickFix {
    private final SmartPsiElementPointer<PsiAnnotation> myAnnotation;
    private final SmartPsiElementPointer<PsiModifierListOwner> myListOwner;

    public RemoveAnnotationQuickFix(@NotNull PsiAnnotation annotation, @Nullable PsiModifierListOwner listOwner) {
        if (annotation == null) {
            RemoveAnnotationQuickFix.$$$reportNull$$$0(0);
        }
        Project project = annotation.getProject();
        SmartPointerManager pm = SmartPointerManager.getInstance((Project)project);
        this.myAnnotation = pm.createSmartPsiElementPointer((PsiElement)annotation);
        this.myListOwner = listOwner == null ? null : pm.createSmartPsiElementPointer((PsiElement)listOwner);
    }

    protected boolean shouldRemoveInheritors() {
        return false;
    }

    @NotNull
    public String getFamilyName() {
        String string = JavaAnalysisBundle.message((String)"remove.annotation", (Object[])new Object[0]);
        if (string == null) {
            RemoveAnnotationQuickFix.$$$reportNull$$$0(1);
        }
        return string;
    }

    public boolean startInWriteAction() {
        return false;
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
        PsiAnnotation annotation;
        if (project == null) {
            RemoveAnnotationQuickFix.$$$reportNull$$$0(2);
        }
        if (descriptor == null) {
            RemoveAnnotationQuickFix.$$$reportNull$$$0(3);
        }
        if ((annotation = (PsiAnnotation)this.myAnnotation.getElement()) == null) {
            return;
        }
        PsiModifierListOwner listOwner = this.myListOwner == null ? null : (PsiModifierListOwner)this.myListOwner.getElement();
        String qualifiedName = annotation.getQualifiedName();
        ArrayList<PsiAnnotation> physical = new ArrayList<PsiAnnotation>();
        ArrayList<PsiModifierListOwner> externalOwners = new ArrayList<PsiModifierListOwner>();
        RemoveAnnotationQuickFix.registerAnnotation(annotation, listOwner, physical, externalOwners);
        if (this.shouldRemoveInheritors() && qualifiedName != null) {
            Consumer<PsiModifierListOwner> inheritorProcessor = owner2 -> RemoveAnnotationQuickFix.registerAnnotation(AnnotationUtil.findAnnotation((PsiModifierListOwner)owner2, (String[])new String[]{qualifiedName}), owner2, physical, externalOwners);
            if (listOwner instanceof PsiMethod && !AnnotateMethodFix.processModifiableInheritorsUnderProgress((PsiMethod)listOwner, inheritorProcessor)) {
                return;
            }
            if (listOwner instanceof PsiParameter && !AnnotateOverriddenMethodParameterFix.processParameterInheritorsUnderProgress((PsiParameter)listOwner, inheritorProcessor)) {
                return;
            }
        }
        if (!FileModificationService.getInstance().preparePsiElementsForWrite(physical)) {
            return;
        }
        WriteAction.run(() -> physical.forEach(PsiElement::delete));
        if (qualifiedName != null) {
            for (PsiModifierListOwner owner3 : externalOwners) {
                ExternalAnnotationsManager.getInstance((Project)project).deannotate(owner3, qualifiedName);
            }
        }
    }

    private static void registerAnnotation(@Nullable PsiAnnotation annotation, @Nullable PsiModifierListOwner listOwner, @NotNull List<PsiAnnotation> physical, @NotNull List<PsiModifierListOwner> externalOwners) {
        if (physical == null) {
            RemoveAnnotationQuickFix.$$$reportNull$$$0(4);
        }
        if (externalOwners == null) {
            RemoveAnnotationQuickFix.$$$reportNull$$$0(5);
        }
        if (annotation == null) {
            return;
        }
        if (AnnotationUtil.isExternalAnnotation((PsiAnnotation)annotation)) {
            ContainerUtil.addIfNotNull(externalOwners, (Object)listOwner);
        } else {
            physical.add(annotation);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "annotation";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/RemoveAnnotationQuickFix";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "physical";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "externalOwners";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/RemoveAnnotationQuickFix";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "applyFix";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "registerAnnotation";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

